"""Replace String with Text

Revision ID: c83d45f9a971
Revises: 7b24b1c8eba7
Create Date: 2024-09-10 11:07:45.618938

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "c83d45f9a971"
down_revision = "7b24b1c8eba7"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.alter_column(
            "requirements",
            existing_type=sa.VARCHAR(length=10000),
            type_=sa.Text(),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "termination_policy",
            existing_type=sa.VARCHAR(length=50),
            type_=sa.String(length=100),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "backend_data",
            existing_type=sa.VARCHAR(length=4000),
            type_=sa.Text(),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "offer", existing_type=sa.VARCHAR(length=4000), type_=sa.Text(), existing_nullable=True
        )
        batch_op.alter_column(
            "job_provisioning_data",
            existing_type=sa.VARCHAR(length=4000),
            type_=sa.Text(),
            existing_nullable=True,
        )

    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.alter_column(
            "job_spec_data",
            existing_type=sa.VARCHAR(length=4000),
            type_=sa.Text(),
            existing_nullable=False,
        )
        batch_op.alter_column(
            "job_provisioning_data",
            existing_type=sa.VARCHAR(length=4000),
            type_=sa.Text(),
            existing_nullable=True,
        )

    with op.batch_alter_table("repos", schema=None) as batch_op:
        batch_op.alter_column(
            "info", existing_type=sa.VARCHAR(length=2000), type_=sa.Text(), existing_nullable=False
        )

    with op.batch_alter_table("runs", schema=None) as batch_op:
        batch_op.alter_column(
            "run_spec",
            existing_type=sa.VARCHAR(length=4000),
            type_=sa.Text(),
            existing_nullable=False,
        )
        batch_op.alter_column(
            "service_spec",
            existing_type=sa.VARCHAR(length=4000),
            type_=sa.Text(),
            existing_nullable=True,
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("runs", schema=None) as batch_op:
        batch_op.alter_column(
            "service_spec",
            existing_type=sa.Text(),
            type_=sa.VARCHAR(length=4000),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "run_spec",
            existing_type=sa.Text(),
            type_=sa.VARCHAR(length=4000),
            existing_nullable=False,
        )

    with op.batch_alter_table("repos", schema=None) as batch_op:
        batch_op.alter_column(
            "info", existing_type=sa.Text(), type_=sa.VARCHAR(length=2000), existing_nullable=False
        )

    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.alter_column(
            "job_provisioning_data",
            existing_type=sa.Text(),
            type_=sa.VARCHAR(length=4000),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "job_spec_data",
            existing_type=sa.Text(),
            type_=sa.VARCHAR(length=4000),
            existing_nullable=False,
        )

    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.alter_column(
            "job_provisioning_data",
            existing_type=sa.Text(),
            type_=sa.VARCHAR(length=4000),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "offer", existing_type=sa.Text(), type_=sa.VARCHAR(length=4000), existing_nullable=True
        )
        batch_op.alter_column(
            "backend_data",
            existing_type=sa.Text(),
            type_=sa.VARCHAR(length=4000),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "termination_policy",
            existing_type=sa.String(length=100),
            type_=sa.VARCHAR(length=50),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "requirements",
            existing_type=sa.Text(),
            type_=sa.VARCHAR(length=10000),
            existing_nullable=True,
        )

    # ### end Alembic commands ###
