"""Add UserModel.active

Revision ID: d6b11105f659
Revises: 54a77e19c64c
Create Date: 2024-08-19 15:10:25.751199

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "d6b11105f659"
down_revision = "54a77e19c64c"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("users", schema=None) as batch_op:
        batch_op.add_column(sa.Column("active", sa.Boolean(), nullable=True))

    op.execute(sa.sql.text("UPDATE users SET active = TRUE"))

    with op.batch_alter_table("users", schema=None) as batch_op:
        batch_op.alter_column("active", nullable=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("users", schema=None) as batch_op:
        batch_op.drop_column("active")

    # ### end Alembic commands ###
