from typing import Literal

from prettyqt import core
from prettyqt.qt import QtWidgets
from prettyqt.utils import bidict


STANDARD_PIXMAP = dict(
    titlebar_min_button=QtWidgets.QStyle.SP_TitleBarMinButton,
    titlebar_menu_button=QtWidgets.QStyle.SP_TitleBarMenuButton,
    titlebar_max_button=QtWidgets.QStyle.SP_TitleBarMaxButton,
    titlebar_close_button=QtWidgets.QStyle.SP_TitleBarCloseButton,
    titlebar_normal_button=QtWidgets.QStyle.SP_TitleBarNormalButton,
    titlebar_shade_button=QtWidgets.QStyle.SP_TitleBarShadeButton,
    titlebar_unshade_button=QtWidgets.QStyle.SP_TitleBarUnshadeButton,
    titlebar_context_help_button=QtWidgets.QStyle.SP_TitleBarContextHelpButton,
    information=QtWidgets.QStyle.SP_MessageBoxInformation,
    warning=QtWidgets.QStyle.SP_MessageBoxWarning,
    critical=QtWidgets.QStyle.SP_MessageBoxCritical,
    question=QtWidgets.QStyle.SP_MessageBoxQuestion,
    desktop=QtWidgets.QStyle.SP_DesktopIcon,
    trash=QtWidgets.QStyle.SP_TrashIcon,
    computer=QtWidgets.QStyle.SP_ComputerIcon,
    drive_fd=QtWidgets.QStyle.SP_DriveFDIcon,
    drive_hd=QtWidgets.QStyle.SP_DriveHDIcon,
    drive_cd=QtWidgets.QStyle.SP_DriveCDIcon,
    drive_dvd=QtWidgets.QStyle.SP_DriveDVDIcon,
    drive_net=QtWidgets.QStyle.SP_DriveNetIcon,
    dir_home=QtWidgets.QStyle.SP_DirHomeIcon,
    dir_open=QtWidgets.QStyle.SP_DirOpenIcon,
    dir_closed=QtWidgets.QStyle.SP_DirClosedIcon,
    dir=QtWidgets.QStyle.SP_DirIcon,
    dir_link=QtWidgets.QStyle.SP_DirLinkIcon,
    dir_link_open=QtWidgets.QStyle.SP_DirLinkOpenIcon,
    file=QtWidgets.QStyle.SP_FileIcon,
    file_link=QtWidgets.QStyle.SP_FileLinkIcon,
    file_dialog_start=QtWidgets.QStyle.SP_FileDialogStart,
    file_dialog_end=QtWidgets.QStyle.SP_FileDialogEnd,
    file_dialog_to_parent=QtWidgets.QStyle.SP_FileDialogToParent,
    file_dialog_new_folder=QtWidgets.QStyle.SP_FileDialogNewFolder,
    file_dialog_detailed_view=QtWidgets.QStyle.SP_FileDialogDetailedView,
    file_dialog_info_view=QtWidgets.QStyle.SP_FileDialogInfoView,
    file_dialog_contents_view=QtWidgets.QStyle.SP_FileDialogContentsView,
    file_dialog_list_view=QtWidgets.QStyle.SP_FileDialogListView,
    file_dialog_back=QtWidgets.QStyle.SP_FileDialogBack,
    dockwidget_close_button=QtWidgets.QStyle.SP_DockWidgetCloseButton,
    toolbar_horizontal_extension=QtWidgets.QStyle.SP_ToolBarHorizontalExtensionButton,
    toolbar_vertical_extension=QtWidgets.QStyle.SP_ToolBarVerticalExtensionButton,
    dialog_ok=QtWidgets.QStyle.SP_DialogOkButton,
    dialog_cancel=QtWidgets.QStyle.SP_DialogCancelButton,
    dialog_help=QtWidgets.QStyle.SP_DialogHelpButton,
    dialog_open=QtWidgets.QStyle.SP_DialogOpenButton,
    dialog_save=QtWidgets.QStyle.SP_DialogSaveButton,
    dialog_close=QtWidgets.QStyle.SP_DialogCloseButton,
    dialog_apply=QtWidgets.QStyle.SP_DialogApplyButton,
    dialor_reset=QtWidgets.QStyle.SP_DialogResetButton,
    dialog_discard=QtWidgets.QStyle.SP_DialogDiscardButton,
    dialog_yes=QtWidgets.QStyle.SP_DialogYesButton,
    dialog_no=QtWidgets.QStyle.SP_DialogNoButton,
    arrow_up=QtWidgets.QStyle.SP_ArrowUp,
    arrow_down=QtWidgets.QStyle.SP_ArrowDown,
    arrow_left=QtWidgets.QStyle.SP_ArrowLeft,
    arrow_right=QtWidgets.QStyle.SP_ArrowRight,
    arrow_back=QtWidgets.QStyle.SP_ArrowBack,
    arrow_forward=QtWidgets.QStyle.SP_ArrowForward,
    command_link=QtWidgets.QStyle.SP_CommandLink,
    vista_shield=QtWidgets.QStyle.SP_VistaShield,
    browser_reload=QtWidgets.QStyle.SP_BrowserReload,
    browser_stop=QtWidgets.QStyle.SP_BrowserStop,
    media_play=QtWidgets.QStyle.SP_MediaPlay,
    media_stop=QtWidgets.QStyle.SP_MediaStop,
    media_pause=QtWidgets.QStyle.SP_MediaPause,
    media_skip_forward=QtWidgets.QStyle.SP_MediaSkipForward,
    media_skip_backward=QtWidgets.QStyle.SP_MediaSkipBackward,
    media_seek_forward=QtWidgets.QStyle.SP_MediaSeekForward,
    media_seek_backward=QtWidgets.QStyle.SP_MediaSeekBackward,
    media_volume=QtWidgets.QStyle.SP_MediaVolume,
    media_volume_muted=QtWidgets.QStyle.SP_MediaVolumeMuted,
    lineedit_clear=QtWidgets.QStyle.SP_LineEditClearButton,
    custom_base=QtWidgets.QStyle.SP_CustomBase,
)

StandardPixmapStr = Literal[
    "titlebar_min_button=",
    "titlebar_menu_button",
    "titlebar_max_button",
    "titlebar_close_button",
    "titlebar_normal_button",
    "titlebar_shade_button",
    "titlebar_unshade_button",
    "titlebar_context_help_button",
    "information",
    "warning",
    "critical",
    "question",
    "desktop",
    "trash",
    "computer",
    "drive_fd",
    "drive_hd",
    "drive_cd",
    "drive_dvd",
    "drive_net",
    "dir_home",
    "dir_open",
    "dir_closed",
    "dir",
    "dir_link",
    "dir_link_open",
    "file",
    "file_link",
    "file_dialog_start",
    "file_dialog_end",
    "file_dialog_to_parent",
    "file_dialog_new_folder",
    "file_dialog_detailed_view",
    "file_dialog_info_view",
    "file_dialog_contents_view",
    "file_dialog_list_view",
    "file_dialog_back",
    "dockwidget_close_button",
    "toolbar_horizontal_extension",
    "toolbar_vertical_extension",
    "dialog_ok",
    "dialog_cancel",
    "dialog_help",
    "dialog_open",
    "dialog_save",
    "dialog_close",
    "dialog_apply",
    "dialor_reset",
    "dialog_discard",
    "dialog_yes",
    "dialog_no",
    "arrow_up",
    "arrow_down",
    "arrow_left",
    "arrow_right",
    "arrow_back",
    "arrow_forward",
    "command_link",
    "vista_shield",
    "browser_reload",
    "browser_stop",
    "media_play",
    "media_stop",
    "media_pause",
    "media_skip_forward",
    "media_skip_backward",
    "media_seek_forward",
    "media_seek_backward",
    "media_volume",
    "media_volume_muted",
    "lineedit_clear",
    "custom_base",
]

if core.VersionNumber.get_qt_version() >= (5, 14, 0):
    STANDARD_PIXMAP["dialog_yes_to_all"] = QtWidgets.QStyle.SP_DialogYesToAllButton
    STANDARD_PIXMAP["dialog_no_to_all"] = QtWidgets.QStyle.SP_DialogNoToAllButton
    STANDARD_PIXMAP["dialog_save_all"] = QtWidgets.QStyle.SP_DialogSaveAllButton
    STANDARD_PIXMAP["dialog_abort"] = QtWidgets.QStyle.SP_DialogAbortButton
    STANDARD_PIXMAP["dialog_retry"] = QtWidgets.QStyle.SP_DialogRetryButton
    STANDARD_PIXMAP["dialog_ignore"] = QtWidgets.QStyle.SP_DialogIgnoreButton
    STANDARD_PIXMAP["restore_defaults"] = QtWidgets.QStyle.SP_RestoreDefaultsButton

COMPLEX_CONTROL = bidict(
    spinbox=QtWidgets.QStyle.CC_SpinBox,
    combobox=QtWidgets.QStyle.CC_ComboBox,
    scrollbar=QtWidgets.QStyle.CC_ScrollBar,
    slider=QtWidgets.QStyle.CC_Slider,
    toolbutton=QtWidgets.QStyle.CC_ToolButton,
    titlebar=QtWidgets.QStyle.CC_TitleBar,
    groupbox=QtWidgets.QStyle.CC_GroupBox,
    dial=QtWidgets.QStyle.CC_Dial,
    mdi_controls=QtWidgets.QStyle.CC_MdiControls,
    custom_base=QtWidgets.QStyle.CC_CustomBase,
)

ComplexControlStr = Literal[
    "spinbox",
    "combobox",
    "scrollbar",
    "slider",
    "toolbutton",
    "titlebar",
    "groupbox",
    "dial",
    "mdi_controls",
    "custom_base",
]

SIMPLE_CONTROLS = dict(
    none=QtWidgets.QStyle.SC_None,
    scrollbar_add_line=QtWidgets.QStyle.SC_ScrollBarAddLine,
    scrollbar_sub_line=QtWidgets.QStyle.SC_ScrollBarSubLine,
    scrollbar_add_page=QtWidgets.QStyle.SC_ScrollBarAddPage,
    scrollbar_sub_page=QtWidgets.QStyle.SC_ScrollBarSubPage,
    scrollbar_first=QtWidgets.QStyle.SC_ScrollBarFirst,
    scrollbar_last=QtWidgets.QStyle.SC_ScrollBarLast,
    scrollbar_slider=QtWidgets.QStyle.SC_ScrollBarSlider,
    scrollbar_groove=QtWidgets.QStyle.SC_ScrollBarGroove,
    spinbox_up=QtWidgets.QStyle.SC_SpinBoxUp,
    spinbox_down=QtWidgets.QStyle.SC_SpinBoxDown,
    spinbox_frame=QtWidgets.QStyle.SC_SpinBoxFrame,
    spinbox_edit_field=QtWidgets.QStyle.SC_SpinBoxEditField,
    combobox_edit_field=QtWidgets.QStyle.SC_ComboBoxEditField,
    combobox_arrow=QtWidgets.QStyle.SC_ComboBoxArrow,
    combobox_frame=QtWidgets.QStyle.SC_ComboBoxFrame,
    combobox_list_box_popup=QtWidgets.QStyle.SC_ComboBoxListBoxPopup,
    slider_groove=QtWidgets.QStyle.SC_SliderGroove,
    slider_handle=QtWidgets.QStyle.SC_SliderHandle,
    slider_tickmarks=QtWidgets.QStyle.SC_SliderTickmarks,
    toolbutton=QtWidgets.QStyle.SC_ToolButton,
    toolbutton_menu=QtWidgets.QStyle.SC_ToolButtonMenu,
    titlebar_sys_menu=QtWidgets.QStyle.SC_TitleBarSysMenu,
    titlebar_min_button=QtWidgets.QStyle.SC_TitleBarMinButton,
    titlebar_max_button=QtWidgets.QStyle.SC_TitleBarMaxButton,
    titlebar_close_button=QtWidgets.QStyle.SC_TitleBarCloseButton,
    titlebar_label=QtWidgets.QStyle.SC_TitleBarLabel,
    titlebar_normal_button=QtWidgets.QStyle.SC_TitleBarNormalButton,
    titlebar_shade_button=QtWidgets.QStyle.SC_TitleBarShadeButton,
    titlebar_unshade_button=QtWidgets.QStyle.SC_TitleBarUnshadeButton,
    titlebar_context_help_button=QtWidgets.QStyle.SC_TitleBarContextHelpButton,
    dial_handle=QtWidgets.QStyle.SC_DialHandle,
    dial_groove=QtWidgets.QStyle.SC_DialGroove,
    dial_tickmarks=QtWidgets.QStyle.SC_DialTickmarks,
    groupbox_frame=QtWidgets.QStyle.SC_GroupBoxFrame,
    groupbox_label=QtWidgets.QStyle.SC_GroupBoxLabel,
    groupbox_checkbox=QtWidgets.QStyle.SC_GroupBoxCheckBox,
    groupbox_contents=QtWidgets.QStyle.SC_GroupBoxContents,
    mdi_normal_button=QtWidgets.QStyle.SC_MdiNormalButton,
    mdi_min_button=QtWidgets.QStyle.SC_MdiMinButton,
    mdi_close_button=QtWidgets.QStyle.SC_MdiCloseButton,
    all=QtWidgets.QStyle.SC_All,
)


class Style(QtWidgets.QStyle):
    pass
