# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

import types

__config__ = pulumi.Config('rancher2')


class _ExportableConfig(types.ModuleType):
    @_builtins.property
    def access_key(self) -> Optional[str]:
        """
        API Key used to authenticate with the rancher server
        """
        return __config__.get('accessKey')

    @_builtins.property
    def api_url(self) -> Optional[str]:
        """
        The URL to the rancher API
        """
        return __config__.get('apiUrl')

    @_builtins.property
    def bootstrap(self) -> bool:
        """
        Bootstrap rancher server
        """
        return __config__.get_bool('bootstrap') or (_utilities.get_env_bool('RANCHER_BOOTSTRAP') or False)

    @_builtins.property
    def ca_certs(self) -> Optional[str]:
        """
        CA certificates used to sign rancher server tls certificates. Mandatory if self signed tls and insecure option false
        """
        return __config__.get('caCerts')

    @_builtins.property
    def insecure(self) -> bool:
        """
        Allow insecure connections to Rancher. Mandatory if self signed tls and not ca_certs provided
        """
        return __config__.get_bool('insecure') or (_utilities.get_env_bool('RANCHER_INSECURE') or False)

    @_builtins.property
    def retries(self) -> Optional[int]:
        """
        Rancher connection retries
        """
        return __config__.get_int('retries')

    @_builtins.property
    def secret_key(self) -> Optional[str]:
        """
        API secret used to authenticate with the rancher server
        """
        return __config__.get('secretKey')

    @_builtins.property
    def timeout(self) -> Optional[str]:
        """
        Rancher connection timeout (retry every 5s). Golang duration format, ex: "60s"
        """
        return __config__.get('timeout')

    @_builtins.property
    def token_key(self) -> Optional[str]:
        """
        API token used to authenticate with the rancher server
        """
        return __config__.get('tokenKey')

