"""
talib-pure: Pure Python TA-Lib library with focus on performance

Optimized with Numba JIT compilation for fast CPU computation.
"""
# TODO MACDFIX, MFI, MINUS_DI, MINUS_DM, MOM, PLUS_DI, PLUS_DM, PPO
# Import from API layer
from .api.overlap import SMA, EMA, DEMA, BBANDS, KAMA, MA, MAMA, SAR, SAREXT, T3, TEMA, TRIMA, WMA
from .api.statistics import STDDEV, TSF, VAR
from .api.volatility_indicators import NATR, TRANGE
from .api.volume_indicators import AD, OBV, ADOSC
from .api.momentum_indicators import ADX, ADXR, APO, AROON, AROONOSC, ATR, BOP, CCI, CMO, DX, MACD, MACDEXT, ROC, ROCP, ROCR, ROCR100, RSI, STOCH, STOCHF, STOCHRSI, TRIX, ULTOSC, WILLR
from .api.cycle_indicators import HT_DCPERIOD, HT_DCPHASE, HT_PHASOR, HT_SINE, HT_TRENDLINE, HT_TRENDMODE
from .api.statistic_functions import BETA, CORREL, LINEARREG, LINEARREG_ANGLE, LINEARREG_INTERCEPT, LINEARREG_SLOPE
from .api.math_operators import MAX, MAXINDEX, MIN, MININDEX, MINMAX, MINMAXINDEX, SUM
from .api.price_transform import MEDPRICE, MIDPOINT, MIDPRICE, TYPPRICE, WCLPRICE
from .api.pattern_recognition import (
    CDL2CROWS, CDL3BLACKCROWS, CDL3INSIDE, CDL3OUTSIDE, CDL3STARSINSOUTH, CDL3WHITESOLDIERS,
    CDLABANDONEDBABY, CDLADVANCEBLOCK, CDLBELTHOLD, CDLBREAKAWAY,
    CDLCLOSINGMARUBOZU, CDLCONCEALBABYSWALL, CDLCOUNTERATTACK, CDLDARKCLOUDCOVER, CDLDOJI, CDLDOJISTAR,
    CDLDRAGONFLYDOJI, CDLENGULFING, CDLEVENINGDOJISTAR, CDLEVENINGSTAR, CDLGAPSIDESIDEWHITE, CDLGRAVESTONEDOJI,
    CDLHAMMER, CDLHANGINGMAN, CDLHARAMI, CDLHARAMICROSS, CDLHIGHWAVE,
    CDLHIKKAKE, CDLHIKKAKEMOD, CDLHOMINGPIGEON, CDLIDENTICAL3CROWS, CDLINNECK,
    CDLINVERTEDHAMMER, CDLKICKING, CDLKICKINGBYLENGTH, CDLLADDERBOTTOM, CDLLONGLEGGEDDOJI, CDLLONGLINE,
    CDLMARUBOZU, CDLMATCHINGLOW, CDLMATHOLD,
    CDLMORNINGDOJISTAR, CDLMORNINGSTAR, CDLONNECK, CDLPIERCING,
    CDLRICKSHAWMAN, CDLRISEFALL3METHODS, CDLSEPARATINGLINES, CDLSHOOTINGSTAR,
    CDLSHORTLINE, CDLSPINNINGTOP, CDLSTALLEDPATTERN, CDLSTICKSANDWICH, CDLTAKURI, CDLTASUKIGAP,
    CDLTHRUSTING, CDLTRISTAR, CDLUNIQUE3RIVER, CDLUPSIDEGAP2CROWS, CDLXSIDEGAP3METHODS
)

# Backend configuration
from .backend import (
    set_backend,
    get_backend,
    get_backend_info
)

# Optimized implementations
from .optimized import (
    SMA_cumsum,
    SMA_auto,
    get_available_backends,
    HAS_NUMBA
)

# Conditional imports for optimized variants
if HAS_NUMBA:
    from .optimized import SMA_numba

__version__ = "0.1.0"

__all__ = [
    # Indicators
    "SMA", "EMA", "DEMA", "BBANDS", "KAMA", "MA", "MAMA", "SAR", "SAREXT", "T3", "TEMA", "TRIMA", "WMA",
    "AD", "OBV", "ADOSC",
    "ADX", "ADXR", "APO", "AROON", "AROONOSC", "ATR", "BOP", "CCI", "CMO", "DX", "MACD", "MACDEXT", "NATR", "ROC", "ROCP", "ROCR", "ROCR100", "RSI", "STDDEV", "STOCH", "STOCHF", "STOCHRSI", "TRANGE", "TRIX", "TSF", "ULTOSC", "VAR", "WILLR",
    "HT_DCPERIOD", "HT_DCPHASE", "HT_PHASOR", "HT_SINE", "HT_TRENDLINE", "HT_TRENDMODE",
    "BETA", "CORREL", "LINEARREG", "LINEARREG_ANGLE", "LINEARREG_INTERCEPT", "LINEARREG_SLOPE",
    "MAX", "MAXINDEX", "MIN", "MININDEX", "MINMAX", "MINMAXINDEX", "SUM",
    "MEDPRICE", "MIDPOINT", "MIDPRICE", "TYPPRICE", "WCLPRICE",
    # Pattern Recognition
    "CDL2CROWS", "CDL3BLACKCROWS", "CDL3INSIDE", "CDL3OUTSIDE", "CDL3STARSINSOUTH", "CDL3WHITESOLDIERS",
    "CDLABANDONEDBABY", "CDLADVANCEBLOCK", "CDLBELTHOLD", "CDLBREAKAWAY",
    "CDLCLOSINGMARUBOZU", "CDLCONCEALBABYSWALL", "CDLCOUNTERATTACK", "CDLDARKCLOUDCOVER", "CDLDOJI", "CDLDOJISTAR",
    "CDLDRAGONFLYDOJI", "CDLENGULFING", "CDLEVENINGDOJISTAR", "CDLEVENINGSTAR", "CDLGAPSIDESIDEWHITE", "CDLGRAVESTONEDOJI",
    "CDLHAMMER", "CDLHANGINGMAN", "CDLHARAMI", "CDLHARAMICROSS", "CDLHIGHWAVE",
    "CDLHIKKAKE", "CDLHIKKAKEMOD", "CDLHOMINGPIGEON", "CDLIDENTICAL3CROWS", "CDLINNECK",
    "CDLINVERTEDHAMMER", "CDLKICKING", "CDLKICKINGBYLENGTH", "CDLLADDERBOTTOM", "CDLLONGLEGGEDDOJI", "CDLLONGLINE",
    "CDLMARUBOZU", "CDLMATCHINGLOW", "CDLMATHOLD",
    "CDLMORNINGDOJISTAR", "CDLMORNINGSTAR", "CDLONNECK", "CDLPIERCING",
    "CDLRICKSHAWMAN", "CDLRISEFALL3METHODS", "CDLSEPARATINGLINES", "CDLSHOOTINGSTAR",
    "CDLSHORTLINE", "CDLSPINNINGTOP", "CDLSTALLEDPATTERN", "CDLSTICKSANDWICH", "CDLTAKURI", "CDLTASUKIGAP",
    "CDLTHRUSTING", "CDLTRISTAR", "CDLUNIQUE3RIVER", "CDLUPSIDEGAP2CROWS", "CDLXSIDEGAP3METHODS",
    # Backend configuration
    "set_backend",
    "get_backend",
    "get_backend_info",
    # Optimized implementations
    "SMA_cumsum",
    "SMA_auto",
    "get_available_backends",
    "HAS_NUMBA",
]

# Add optimized versions to __all__ if available
if HAS_NUMBA:
    __all__.append("SMA_numba")
