# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .problem_cause import ProblemCause
from .problem_details import ProblemDetails
from .problem_type import ProblemType

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Problem(ProblemDetails):
    """
    Generic base type for problems in Synqly. This object carries both machine-readable data as well as information intended for display purposes.
    """

    type: typing.Optional[ProblemType] = None
    occurred_at: dt.datetime = pydantic.Field()
    """
    The date and time the problem occurred.
    """

    status: int = pydantic.Field()
    """
    The HTTP status code of the problem. Matches the HTTP response code sent by the server.
    """

    instance: str = pydantic.Field()
    """
    A URI reference that identifies the specific occurrence of the problem. It may or may not yield further information if dereferenced.
    """

    cause: typing.Optional[typing.List[ProblemCause]] = pydantic.Field(default=None)
    """
    A list of the root cause(s) for this problem occurrence. Includes at minimum one root cause, and is otherwise an unordered list of causes.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
