# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .connection_state import ConnectionState

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class NetworkQuarantineRequest(pydantic.BaseModel):
    state: ConnectionState = pydantic.Field()
    """
    The connection state (Connect or Disconnect) to enforce for the provided endpoint IDs.
    """

    endpoint_ids: typing.List[str] = pydantic.Field()
    """
    The list of endpoint IDs to enforce the connection state on.
    """

    comment: typing.Optional[str] = pydantic.Field(default=None)
    """
    A comment to include with the quarantine action.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
