# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .encryption_details_algorithm_id import EncryptionDetailsAlgorithmId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class EncryptionDetails(pydantic.BaseModel):
    """
    Details about the encrytpion methodology utilized.
    """

    algorithm: typing.Optional[str] = pydantic.Field(default=None)
    """
    The encryption algorithm used, normalized to the caption of 'algorithm_id
    """

    algorithm_id: typing.Optional[EncryptionDetailsAlgorithmId] = pydantic.Field(default=None)
    """
    The encryption algorithm used.
    """

    key_length: typing.Optional[int] = pydantic.Field(default=None)
    """
    The length of the encryption key used.
    """

    key_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the key used for encrpytion. For example, AWS KMS Key ARN.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the encryption used.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
