# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Location(pydantic.BaseModel):
    """
    The Geo Location object describes a geographical location, usually associated with an IP address.
    """

    aerial_height: typing.Optional[str] = pydantic.Field(default=None)
    """
    Expressed as either height above takeoff location or height above ground level (AGL) for a UAS current location. This value is provided in meters and must have a minimum resolution of 1 m. Special Values: <code>Invalid</code>, <code>No Value</code>, or <code>Unknown: -1000 m</code>.
    """

    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the city.
    """

    continent: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the continent.
    """

    coordinates: typing.Optional[typing.List[float]] = pydantic.Field(default=None)
    """
    A two-element array, containing a longitude/latitude pair. The format conforms with <a target='_blank' href='https://geojson.org'>GeoJSON</a>. For example: <code>[-73.983, 40.719]</code>.
    """

    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ISO 3166-1 Alpha-2 country code.<p><b>Note:</b> The two letter country code should be capitalized. For example: <code>US</code> or <code>CA</code>.</p>
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the geographical location.
    """

    geodetic_altitude: typing.Optional[str] = pydantic.Field(default=None)
    """
    The aircraft distance above or below the ellipsoid as measured along a line that passes through the aircraft and is normal to the surface of the WGS-84 ellipsoid. This value is provided in meters and must have a minimum resolution of 1 m. Special Values: <code>Invalid</code>, <code>No Value</code>, or <code>Unknown: -1000 m</code>.
    """

    geodetic_vertical_accuracy: typing.Optional[str] = pydantic.Field(default=None)
    """
    Provides quality/containment on geodetic altitude. This is based on ADS-B Geodetic Vertical Accuracy (GVA). Measured in meters.
    """

    geohash: typing.Optional[str] = pydantic.Field(default=None)
    """
    <p>Geohash of the geo-coordinates (latitude and longitude).</p><a target='_blank' href='https://en.wikipedia.org/wiki/Geohash'>Geohashing</a> is a geocoding system used to encode geographic coordinates in decimal degrees, to a single string.
    """

    horizontal_accuracy: typing.Optional[str] = pydantic.Field(default=None)
    """
    Provides quality/containment on horizontal position. This is based on ADS-B NACp. Measured in meters.
    """

    is_on_premises: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The indication of whether the location is on premises.
    """

    isp: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the Internet Service Provider (ISP).
    """

    lat: typing.Optional[float] = pydantic.Field(default=None)
    """
    The geographical Latitude coordinate represented in Decimal Degrees (DD). For example: <code>42.361145</code>.
    """

    long_: typing.Optional[float] = pydantic.Field(alias="long", default=None)
    """
    The geographical Longitude coordinate represented in Decimal Degrees (DD). For example: <code>-71.057083</code>.
    """

    postal_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The postal code of the location.
    """

    pressure_altitude: typing.Optional[str] = pydantic.Field(default=None)
    """
    The uncorrected barometric pressure altitude (based on reference standard 29.92 inHg, 1013.25 mb) provides a reference for algorithms that utilize 'altitude deltas' between aircraft. This value is provided in meters and must have a minimum resolution of 1 m.. Special Values: <code>Invalid</code>, <code>No Value</code>, or <code>Unknown: -1000 m</code>.
    """

    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    The provider of the geographical location data.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The alphanumeric code that identifies the principal subdivision (e.g. province or state) of the country. For example, 'CH-VD' for the Canton of Vaud, Switzerland
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
