# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class VulnerabilitySeverityFilterValue(str, enum.Enum):
    """
    Values supported by using severity as a filter. Supports `[eq]` and `[in]` operators.
    For example, `severity[eq]critical` or `severity[in]critical, high`.
    """

    CRITICAL = "critical"
    """
    Action is required immediately and the scope is broad.
    """

    HIGH = "high"
    """
    Action is required immediately.
    """

    MEDIUM = "medium"
    """
    Action is required but the situation is not serious at this time.
    """

    LOW = "low"
    """
    The user decides if action is needed.
    """

    INFO = "info"
    """
    Informational message. No action required.
    """

    def visit(
        self,
        critical: typing.Callable[[], T_Result],
        high: typing.Callable[[], T_Result],
        medium: typing.Callable[[], T_Result],
        low: typing.Callable[[], T_Result],
        info: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is VulnerabilitySeverityFilterValue.CRITICAL:
            return critical()
        if self is VulnerabilitySeverityFilterValue.HIGH:
            return high()
        if self is VulnerabilitySeverityFilterValue.MEDIUM:
            return medium()
        if self is VulnerabilitySeverityFilterValue.LOW:
            return low()
        if self is VulnerabilitySeverityFilterValue.INFO:
            return info()
