# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class CategoryId(str, enum.Enum):
    """
    Id of the Integrations category
    """

    ASSETS = "assets"
    CLOUDSECURITY = "cloudsecurity"
    EDR = "edr"
    IDENTITY = "identity"
    NOTIFICATIONS = "notifications"
    SIEM = "siem"
    SINK = "sink"
    STORAGE = "storage"
    TICKETING = "ticketing"
    VULNERABILITIES = "vulnerabilities"

    def visit(
        self,
        assets: typing.Callable[[], T_Result],
        cloudsecurity: typing.Callable[[], T_Result],
        edr: typing.Callable[[], T_Result],
        identity: typing.Callable[[], T_Result],
        notifications: typing.Callable[[], T_Result],
        siem: typing.Callable[[], T_Result],
        sink: typing.Callable[[], T_Result],
        storage: typing.Callable[[], T_Result],
        ticketing: typing.Callable[[], T_Result],
        vulnerabilities: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is CategoryId.ASSETS:
            return assets()
        if self is CategoryId.CLOUDSECURITY:
            return cloudsecurity()
        if self is CategoryId.EDR:
            return edr()
        if self is CategoryId.IDENTITY:
            return identity()
        if self is CategoryId.NOTIFICATIONS:
            return notifications()
        if self is CategoryId.SIEM:
            return siem()
        if self is CategoryId.SINK:
            return sink()
        if self is CategoryId.STORAGE:
            return storage()
        if self is CategoryId.TICKETING:
            return ticketing()
        if self is CategoryId.VULNERABILITIES:
            return vulnerabilities()
