# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .webhook_event import WebhookEvent

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class WebhookItem(pydantic.BaseModel):
    webhook_url: str = pydantic.Field()
    """
    Webhook URL. Events from providers will be sent to this URL.
    """

    event_filter: typing.Optional[typing.List[WebhookEvent]] = pydantic.Field(default=None)
    """
    If specified, only events matching this list will be sent to `webhook_url`. If no filters are specified, all events sent from providers will be forwarded to `webhook_url`.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
