# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .autotask_api_integration_code_credential import AutotaskApiIntegrationCodeCredential
from .autotask_secret_credential import AutotaskSecretCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class TicketingAutotask(pydantic.BaseModel):
    """
    Configuration for Autotask Operations Cloud.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/autotask-ticketing-setup)
    """

    api_integration_code_credential: AutotaskApiIntegrationCodeCredential
    secret_credential: AutotaskSecretCredential
    user_name: str = pydantic.Field()
    """
    User name of the API User created to authenticate with the Autotask API.
    """

    zone_path: str = pydantic.Field()
    """
    Zone for the Autotask API.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
