# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.and_user_filter_model_filters_inner import AndUserFilterModelFiltersInner
from rapidata.api_client.models.feature_flag_model import FeatureFlagModel
from typing import Optional, Set
from typing_extensions import Self

class CreateLeaderboardModel(BaseModel):
    """
    The CreateLeaderboardModel class represents the model for creating a leaderboard.
    """ # noqa: E501
    benchmark_id: Optional[StrictStr] = Field(default=None, description="If a leaderboard should be added to a preexisting benchmark, the benchmark Id can be provided.", alias="benchmarkId")
    benchmark_name: Optional[StrictStr] = Field(default=None, description="If no BenchmarkId is provided a new benchmark will be created. if no name is supplied the benchmark will be called the same as the leaderboard.", alias="benchmarkName")
    name: StrictStr = Field(description="The name of the leaderboard.")
    instruction: StrictStr = Field(description="The instruction datapoints will be matched up against.")
    show_prompt: StrictBool = Field(description="Indicates if the prompt is shown on the rapids.", alias="showPrompt")
    show_prompt_asset: Optional[StrictBool] = Field(default=None, description="Whether the prompt asset should be shown on the rapids.", alias="showPromptAsset")
    response_budget: Optional[StrictInt] = Field(default=None, description="Total amount of responses that get collected per run", alias="responseBudget")
    min_responses: Optional[StrictInt] = Field(default=None, description="The minimum amount of responses that need to be collected per comparison.", alias="minResponses")
    is_inversed: Optional[StrictBool] = Field(default=None, description="If the results should be inversed, meaning people should select the worse model.", alias="isInversed")
    validation_set_id: Optional[StrictStr] = Field(default=None, description="The Validation set that should be attached to every run.", alias="validationSetId")
    filters: Optional[List[AndUserFilterModelFiltersInner]] = Field(default=None, description="The filters will be applied on every order that is created by this leaderboard.")
    feature_flags: Optional[List[FeatureFlagModel]] = Field(default=None, description="Feature flags that will be applied to every order that is created by this leaderboard.", alias="featureFlags")
    __properties: ClassVar[List[str]] = ["benchmarkId", "benchmarkName", "name", "instruction", "showPrompt", "showPromptAsset", "responseBudget", "minResponses", "isInversed", "validationSetId", "filters", "featureFlags"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateLeaderboardModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list)
        _items = []
        if self.filters:
            for _item_filters in self.filters:
                if _item_filters:
                    _items.append(_item_filters.to_dict())
            _dict['filters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in feature_flags (list)
        _items = []
        if self.feature_flags:
            for _item_feature_flags in self.feature_flags:
                if _item_feature_flags:
                    _items.append(_item_feature_flags.to_dict())
            _dict['featureFlags'] = _items
        # set to None if benchmark_id (nullable) is None
        # and model_fields_set contains the field
        if self.benchmark_id is None and "benchmark_id" in self.model_fields_set:
            _dict['benchmarkId'] = None

        # set to None if benchmark_name (nullable) is None
        # and model_fields_set contains the field
        if self.benchmark_name is None and "benchmark_name" in self.model_fields_set:
            _dict['benchmarkName'] = None

        # set to None if validation_set_id (nullable) is None
        # and model_fields_set contains the field
        if self.validation_set_id is None and "validation_set_id" in self.model_fields_set:
            _dict['validationSetId'] = None

        # set to None if filters (nullable) is None
        # and model_fields_set contains the field
        if self.filters is None and "filters" in self.model_fields_set:
            _dict['filters'] = None

        # set to None if feature_flags (nullable) is None
        # and model_fields_set contains the field
        if self.feature_flags is None and "feature_flags" in self.model_fields_set:
            _dict['featureFlags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateLeaderboardModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "benchmarkId": obj.get("benchmarkId"),
            "benchmarkName": obj.get("benchmarkName"),
            "name": obj.get("name"),
            "instruction": obj.get("instruction"),
            "showPrompt": obj.get("showPrompt"),
            "showPromptAsset": obj.get("showPromptAsset"),
            "responseBudget": obj.get("responseBudget"),
            "minResponses": obj.get("minResponses"),
            "isInversed": obj.get("isInversed"),
            "validationSetId": obj.get("validationSetId"),
            "filters": [AndUserFilterModelFiltersInner.from_dict(_item) for _item in obj["filters"]] if obj.get("filters") is not None else None,
            "featureFlags": [FeatureFlagModel.from_dict(_item) for _item in obj["featureFlags"]] if obj.get("featureFlags") is not None else None
        })
        return _obj


