# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.page_info import PageInfo
from rapidata.api_client.models.root_filter import RootFilter
from rapidata.api_client.models.sort_criterion import SortCriterion
from typing import Optional, Set
from typing_extensions import Self

class GetValidationRapidsQuery(BaseModel):
    """
    GetValidationRapidsQuery
    """ # noqa: E501
    t: StrictStr = Field(description="Discriminator value for GetValidationRapidsQuery", alias="_t")
    page_info: Optional[PageInfo] = Field(default=None, alias="pageInfo")
    root_filter: Optional[RootFilter] = Field(default=None, alias="rootFilter")
    sort_criteria: Optional[List[SortCriterion]] = Field(default=None, alias="sortCriteria")
    validation_set_id: StrictStr = Field(alias="validationSetId")
    __properties: ClassVar[List[str]] = ["_t", "pageInfo", "rootFilter", "sortCriteria", "validationSetId"]

    @field_validator('t')
    def t_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['GetValidationRapidsQuery']):
            raise ValueError("must be one of enum values ('GetValidationRapidsQuery')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetValidationRapidsQuery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of page_info
        if self.page_info:
            _dict['pageInfo'] = self.page_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of root_filter
        if self.root_filter:
            _dict['rootFilter'] = self.root_filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in sort_criteria (list)
        _items = []
        if self.sort_criteria:
            for _item_sort_criteria in self.sort_criteria:
                if _item_sort_criteria:
                    _items.append(_item_sort_criteria.to_dict())
            _dict['sortCriteria'] = _items
        # set to None if sort_criteria (nullable) is None
        # and model_fields_set contains the field
        if self.sort_criteria is None and "sort_criteria" in self.model_fields_set:
            _dict['sortCriteria'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetValidationRapidsQuery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_t": obj.get("_t") if obj.get("_t") is not None else 'GetValidationRapidsQuery',
            "pageInfo": PageInfo.from_dict(obj["pageInfo"]) if obj.get("pageInfo") is not None else None,
            "rootFilter": RootFilter.from_dict(obj["rootFilter"]) if obj.get("rootFilter") is not None else None,
            "sortCriteria": [SortCriterion.from_dict(_item) for _item in obj["sortCriteria"]] if obj.get("sortCriteria") is not None else None,
            "validationSetId": obj.get("validationSetId")
        })
        return _obj


