# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class RegisterTemporaryCustomerResult(BaseModel):
    """
    The access parameters of the newly registered temporary customer.
    """ # noqa: E501
    access_token: StrictStr = Field(description="The access token to authenticate the user.")
    expires_in: Optional[StrictInt] = Field(default=None, description="The time in seconds until the access token expires.")
    refresh_token: Optional[StrictStr] = Field(default=None, description="The refresh token to refresh the access token.")
    id_token: StrictStr = Field(description="The id token to identify the user.")
    token_type: StrictStr = Field(description="The type of token. Usually, this is \"Bearer\".")
    scope: Optional[StrictStr] = Field(default=None, description="The scope of access the token has.")
    __properties: ClassVar[List[str]] = ["access_token", "expires_in", "refresh_token", "id_token", "token_type", "scope"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RegisterTemporaryCustomerResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if expires_in (nullable) is None
        # and model_fields_set contains the field
        if self.expires_in is None and "expires_in" in self.model_fields_set:
            _dict['expires_in'] = None

        # set to None if refresh_token (nullable) is None
        # and model_fields_set contains the field
        if self.refresh_token is None and "refresh_token" in self.model_fields_set:
            _dict['refresh_token'] = None

        # set to None if scope (nullable) is None
        # and model_fields_set contains the field
        if self.scope is None and "scope" in self.model_fields_set:
            _dict['scope'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RegisterTemporaryCustomerResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "access_token": obj.get("access_token"),
            "expires_in": obj.get("expires_in"),
            "refresh_token": obj.get("refresh_token"),
            "id_token": obj.get("id_token"),
            "token_type": obj.get("token_type"),
            "scope": obj.get("scope")
        })
        return _obj


