"""Contains every character in the three sizes, small, medium and large and the function :py:func:`_get_char`

It's main function is to store all the character maps.

Every size has it's one dictionary there is a key for every character
and the values are tuples of strings that represent the character in
a sort of character map, every string corresponds to a row. An X means that
the pixel should be set and a space that the pixel should stay as it is.
"""

# TODO: change how characters are drawn to be more efficient and faster


large = {
    " ": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "!": (
        "                  ",
        "        XX        ",
        "       XXXX       ",
        "       XXXX       ",
        "       XXXX       ",
        "       XXXX       ",
        "       XXXX       ",
        "       XXXX       ",
        "       XXXX       ",
        "       XXXX       ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "                  ",
        "                  ",
        "        XX        ",
        "       XXXX       ",
        "       XXXX       ",
        "        XX        ",
        "                  ",
        "                  ",
        "                  ",
    ),
    '"': (
        "                  ",
        "     XX    XX     ",
        "    XXXX  XXXX    ",
        "    XXXX  XXXX    ",
        "     XXX   XXX    ",
        "      XX    XX    ",
        "     XX    XX     ",
        "    XX    XX      ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "#": (
        "                  ",
        "      XX    XX    ",
        "      XX    XX    ",
        "      XX    XX    ",
        "      XX    XX    ",
        "      XX    XX    ",
        "  XXXXXXXXXXXXXX  ",
        "  XXXXXXXXXXXXXX  ",
        "     XX    XX     ",
        "     XX    XX     ",
        "     XX    XX     ",
        "     XX    XX     ",
        "     XX    XX     ",
        "  XXXXXXXXXXXXXX  ",
        "  XXXXXXXXXXXXXX  ",
        "    XX    XX      ",
        "    XX    XX      ",
        "    XX    XX      ",
        "    XX    XX      ",
        "    XX    XX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "$": (
        "        XX        ",
        "        XX        ",
        "     XXXXXXXX     ",
        "    XXXXXXXXXX    ",
        "   XXX  XX  XXX   ",
        "   XX   XX   XX   ",
        "   XX   XX   XX   ",
        "   XXX  XX        ",
        "   XXXXXXX        ",
        "    XXXXXXXX      ",
        "      XXXXXXXX    ",
        "        XXXXXXX   ",
        "        XX  XXX   ",
        "        XX   XX   ",
        "   XX   XX   XX   ",
        "   XX   XX   XX   ",
        "   XXX  XX  XXX   ",
        "    XXXXXXXXXX    ",
        "     XXXXXXXX     ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "                  ",
    ),
    "%": (
        "                  ",
        "   XXX      XX    ",
        "  XXXXX     XX    ",
        " XXX XXX   XXX    ",
        " XX   XX   XX     ",
        " XX   XX  XXX     ",
        " XXX XXX  XX      ",
        "  XXXXX  XXX      ",
        "   XXX   XX       ",
        "        XXX       ",
        "        XX        ",
        "       XXX        ",
        "       XX   XXX   ",
        "      XXX  XXXXX  ",
        "      XX  XXX XXX ",
        "     XXX  XX   XX ",
        "     XX   XX   XX ",
        "    XXX   XXX XXX ",
        "    XX     XXXXX  ",
        "    XX      XXX   ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "&": (
        "                  ",
        "      XXXXX       ",
        "     XXXXXXX      ",
        "    XXXX  XXX     ",
        "    XXX    XX     ",
        "    XXX    XX     ",
        "    XXX   XXX     ",
        "     XXX XXX      ",
        "      XXXXX       ",
        "       XXX        ",
        "     XXXXXX  XXXX ",
        "    XXX XXX  XXXX ",
        "   XXX   XXX  XX  ",
        "   XXX   XXX  XX  ",
        "  XXX     XXX XX  ",
        "  XXX     XXXXX   ",
        "  XXX      XXX    ",
        "   XXX    XXXXX   ",
        "   XXXXXXXXX XXXX ",
        "     XXXXXX   XXX ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "'": (
        "                  ",
        "        XX        ",
        "       XXXX       ",
        "       XXXX       ",
        "        XXX       ",
        "         XX       ",
        "        XX        ",
        "       XX         ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "(": (
        "            XX    ",
        "           XXX    ",
        "          XXX     ",
        "         XXX      ",
        "         XXX      ",
        "        XXX       ",
        "        XXX       ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "        XXX       ",
        "        XXX       ",
        "         XXX      ",
        "         XXX      ",
        "          XXX     ",
        "           XXX    ",
        "            XX    ",
        "                  ",
    ),
    ")": (
        "    XX            ",
        "    XXX           ",
        "     XXX          ",
        "      XXX         ",
        "      XXX         ",
        "       XXX        ",
        "       XXX        ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "       XXX        ",
        "       XXX        ",
        "      XXX         ",
        "      XXX         ",
        "     XXX          ",
        "    XXX           ",
        "    XX            ",
        "                  ",
    ),
    "*": (
        "                  ",
        "                  ",
        "                  ",
        "        XX        ",
        "        XX        ",
        "  XX    XX    XX  ",
        "  XXX   XX   XXX  ",
        "   XXX  XX  XXX   ",
        "    XXX XX XXX    ",
        "     XXXXXXXX     ",
        "      XXXXXX      ",
        "      XXXXXX      ",
        "     XXXXXXXX     ",
        "    XXX XX XXX    ",
        "   XXX  XX  XXX   ",
        "  XXX   XX   XXX  ",
        "  XX    XX    XX  ",
        "        XX        ",
        "        XX        ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "+": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "  XXXXXXXXXXXXXX  ",
        "  XXXXXXXXXXXXXX  ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    ",": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "        XX        ",
        "       XXXX       ",
        "       XXXX       ",
        "        XXX       ",
        "         XX       ",
        "        XX        ",
        "       XX         ",
    ),
    "-": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "  XXXXXXXXXXXXXX  ",
        "  XXXXXXXXXXXXXX  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    ".": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "        XX        ",
        "       XXXX       ",
        "       XXXX       ",
        "        XX        ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "/": (
        "                  ",
        "             XX   ",
        "            XXX   ",
        "            XX    ",
        "           XXX    ",
        "           XX     ",
        "          XXX     ",
        "          XX      ",
        "         XXX      ",
        "         XX       ",
        "        XXX       ",
        "        XX        ",
        "       XXX        ",
        "       XX         ",
        "      XXX         ",
        "      XX          ",
        "     XXX          ",
        "     XX           ",
        "    XXX           ",
        "    XX            ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "0": (
        "                  ",
        "       XXXXX      ",
        "     XXXXXXXXX    ",
        "     XXX   XXX    ",
        "    XXX     XXX   ",
        "    XXX     XXX   ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "    XXX     XXX   ",
        "    XXX     XXX   ",
        "     XXX   XXX    ",
        "     XXXXXXXXX    ",
        "       XXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "1": (
        "                  ",
        "         XX       ",
        "       XXXX       ",
        "     XXXXXX       ",
        "     XXXXXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "     XXXXXXXXX    ",
        "     XXXXXXXXX    ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "2": (
        "                  ",
        "       XXXXX      ",
        "     XXXXXXXXX    ",
        "    XXX    XXXX   ",
        "   XXX      XXXX  ",
        "   XXXX      XXX  ",
        "   XXXX      XXX  ",
        "    XX       XXX  ",
        "            XXXX  ",
        "            XXX   ",
        "           XXXX   ",
        "          XXXX    ",
        "         XXXX     ",
        "        XXX       ",
        "       XXX        ",
        "      XXX     XX  ",
        "     XXX      XX  ",
        "    XXXXXXXXXXXX  ",
        "   XXXXXXXXXXXXX  ",
        "   XXXXXXXXXXXXX  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "3": (
        "                  ",
        "       XXXX       ",
        "     XXXXXXXX     ",
        "    XXX   XXXX    ",
        "   XXX     XXXX   ",
        "   XXXX     XXX   ",
        "   XXXX     XXX   ",
        "    XX      XXX   ",
        "           XXX    ",
        "       XXXXXX     ",
        "       XXXXXXX    ",
        "            XXX   ",
        "             XXX  ",
        "    XX       XXX  ",
        "   XXXX      XXX  ",
        "   XXXX      XXX  ",
        "   XXX      XXXX  ",
        "    XXX    XXXX   ",
        "     XXXXXXXXX    ",
        "       XXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "4": (
        "                  ",
        "           XXX    ",
        "          XXXX    ",
        "         XXXXX    ",
        "        XXXXXX    ",
        "       XXX XXX    ",
        "       XX  XXX    ",
        "      XXX  XXX    ",
        "     XXX   XXX    ",
        "     XX    XXX    ",
        "    XXX    XXX    ",
        "   XXX     XXX    ",
        "  XXX      XXX    ",
        "  XXXXXXXXXXXXXXX ",
        "  XXXXXXXXXXXXXXX ",
        "           XXX    ",
        "           XXX    ",
        "           XXX    ",
        "          XXXXX   ",
        "          XXXXX   ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "5": (
        "                  ",
        "    XXXXXXXXXXX   ",
        "    XXXXXXXXXXX   ",
        "    XXXXXXXXXX    ",
        "    XX            ",
        "    XX            ",
        "    XX            ",
        "    XX XXXXX      ",
        "    XXXXXXXXXX    ",
        "    XXX    XXXX   ",
        "    XX      XXX   ",
        "             XXX  ",
        "             XXX  ",
        "    XX       XXX  ",
        "   XXXX      XXX  ",
        "   XXXX      XXX  ",
        "   XXX      XXX   ",
        "    XXX    XXXX   ",
        "     XXXXXXXXX    ",
        "       XXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "6": (
        "                  ",
        "       XXXXX      ",
        "     XXXXXXXXX    ",
        "    XXXX    XXX   ",
        "    XXX    XXXX   ",
        "   XXX     XXXX   ",
        "   XXX      XX    ",
        "   XXX            ",
        "   XXX XXXXX      ",
        "   XXXXXXXXXXX    ",
        "   XXXX    XXXX   ",
        "   XXX      XXX   ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "    XXX     XXX   ",
        "    XXXX   XXXX   ",
        "     XXXXXXXXX    ",
        "       XXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "7": (
        "                  ",
        "   XXXXXXXXXXXXX  ",
        "   XXXXXXXXXXXXX  ",
        "   XXXXXXXXXXXX   ",
        "   XX        XX   ",
        "   XX       XX    ",
        "   XX       XX    ",
        "           XX     ",
        "           XX     ",
        "          XXX     ",
        "          XXX     ",
        "          XX      ",
        "         XXX      ",
        "         XXX      ",
        "         XXX      ",
        "        XXXX      ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "8": (
        "                  ",
        "       XXXXX      ",
        "     XXXXXXXXX    ",
        "    XXX     XXX   ",
        "    XX       XX   ",
        "    XX       XX   ",
        "    XXX      XX   ",
        "    XXXX    XXX   ",
        "     XXXXX XXX    ",
        "      XXXXXXX     ",
        "     XXXXXXXXX    ",
        "    XXX   XXXXX   ",
        "   XXX      XXXX  ",
        "   XX        XXX  ",
        "   XX        XXX  ",
        "   XX        XXX  ",
        "   XXX       XXX  ",
        "    XXX     XXX   ",
        "     XXXXXXXXX    ",
        "       XXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "9": (
        "                  ",
        "       XXXXX      ",
        "     XXXXXXXXX    ",
        "    XXXX   XXXX   ",
        "    XXX     XXX   ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "    XXX      XXX  ",
        "    XXXX    XXXX  ",
        "     XXXXXXXXXXX  ",
        "       XXXXX XXX  ",
        "             XXX  ",
        "     XX      XXX  ",
        "    XXXX     XXX  ",
        "    XXXX    XXX   ",
        "    XXX    XXXX   ",
        "     XXXXXXXXX    ",
        "       XXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    ":": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "        XX        ",
        "       XXXX       ",
        "       XXXX       ",
        "        XX        ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "        XX        ",
        "       XXXX       ",
        "       XXXX       ",
        "        XX        ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    ";": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "        XX        ",
        "       XXXX       ",
        "       XXXX       ",
        "        XX        ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "        XX        ",
        "       XXXX       ",
        "       XXXX       ",
        "        XXX       ",
        "         XX       ",
        "        XX        ",
        "       XX         ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "<": (
        "                  ",
        "                  ",
        "            XX    ",
        "           XXX    ",
        "          XXX     ",
        "         XXX      ",
        "        XXX       ",
        "       XXX        ",
        "      XXX         ",
        "     XXX          ",
        "    XXX           ",
        "    XXX           ",
        "     XXX          ",
        "      XXX         ",
        "       XXX        ",
        "        XXX       ",
        "         XXX      ",
        "          XXX     ",
        "           XXX    ",
        "            XX    ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "=": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "  XXXXXXXXXXXXXX  ",
        "  XXXXXXXXXXXXXX  ",
        "                  ",
        "                  ",
        "                  ",
        "  XXXXXXXXXXXXXX  ",
        "  XXXXXXXXXXXXXX  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    ">": (
        "                  ",
        "                  ",
        "    XX            ",
        "    XXX           ",
        "     XXX          ",
        "      XXX         ",
        "       XXX        ",
        "        XXX       ",
        "         XXX      ",
        "          XXX     ",
        "           XXX    ",
        "           XXX    ",
        "          XXX     ",
        "         XXX      ",
        "        XXX       ",
        "       XXX        ",
        "      XXX         ",
        "     XXX          ",
        "    XXX           ",
        "    XX            ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "?": (
        "                  ",
        "       XXXX       ",
        "     XXXXXXXX     ",
        "    XXX    XXX    ",
        "   XXX      XXX   ",
        "   XXXX     XXX   ",
        "   XXXX     XXX   ",
        "    XX      XXX   ",
        "           XXX    ",
        "          XXX     ",
        "         XXX      ",
        "        XXX       ",
        "        XX        ",
        "        XX        ",
        "                  ",
        "                  ",
        "        XX        ",
        "       XXXX       ",
        "       XXXX       ",
        "        XX        ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "@": (
        "                  ",
        "      XXXXXXX     ",
        "    XXXXXXXXXXX   ",
        "   XXXX     XXXX  ",
        "  XXX         XX  ",
        "  XX          XXX ",
        " XXX    XXX XX XX ",
        " XX    XXXXXXX XX ",
        " XX   XXX  XXX XX ",
        " XX   XX   XX  XX ",
        " XX  XXX  XXX  XX ",
        " XX  XX   XX   XX ",
        " XX  XX  XXX  XXX ",
        " XX  XXXXXXXXXXX  ",
        " XXX  XXXX XXXX   ",
        "  XX              ",
        "  XXX          XX ",
        "   XXXX      XXXX ",
        "    XXXXXXXXXXXX  ",
        "      XXXXXXXX    ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "A": (
        "                  ",
        "        XX        ",
        "        XX        ",
        "       XXXX       ",
        "       XXXX       ",
        "      XXXXX       ",
        "      XXXXXX      ",
        "      XX XXX      ",
        "     XX  XXXX     ",
        "     XX   XXX     ",
        "     XX   XXX     ",
        "    XX    XXXX    ",
        "    XX     XXX    ",
        "   XXXXXXXXXXXX   ",
        "   XXXXXXXXXXXX   ",
        "   XX       XXX   ",
        "  XX        XXXX  ",
        "  XX         XXX  ",
        " XXXX       XXXXX ",
        " XXXX       XXXXX ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "B": (
        "                  ",
        "  XXXXXXXXXXX     ",
        "  XXXXXXXXXXXXX   ",
        "   XXX      XXXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX      XXXX  ",
        "   XXXXXXXXXXXX   ",
        "   XXXXXXXXXXXXX  ",
        "   XXX       XXXX ",
        "   XXX        XXX ",
        "   XXX        XXX ",
        "   XXX        XXX ",
        "   XXX        XXX ",
        "   XXX       XXXX ",
        "   XXX      XXXX  ",
        "  XXXXXXXXXXXXX   ",
        "  XXXXXXXXXXX     ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "C": (
        "                  ",
        "       XXXXXX     ",
        "     XXXXXXXXX XX ",
        "    XXXX    XXXXX ",
        "   XXXX      XXXX ",
        "   XXX        XXX ",
        "  XXXX         XX ",
        "  XXX          XX ",
        "  XXX             ",
        "  XXX             ",
        "  XXX             ",
        "  XXX             ",
        "  XXX             ",
        "  XXX             ",
        "  XXXX         XX ",
        "   XXX         XX ",
        "   XXXX       XXX ",
        "    XXXX    XXXX  ",
        "     XXXXXXXXXX   ",
        "       XXXXXX     ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "D": (
        "                  ",
        "  XXXXXXXXXX      ",
        "  XXXXXXXXXXXX    ",
        "   XXX     XXXX   ",
        "   XXX      XXXX  ",
        "   XXX       XXX  ",
        "   XXX       XXXX ",
        "   XXX        XXX ",
        "   XXX        XXX ",
        "   XXX        XXX ",
        "   XXX        XXX ",
        "   XXX        XXX ",
        "   XXX        XXX ",
        "   XXX        XXX ",
        "   XXX       XXXX ",
        "   XXX       XXX  ",
        "   XXX      XXXX  ",
        "   XXX     XXXX   ",
        "  XXXXXXXXXXXX    ",
        "  XXXXXXXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "E": (
        "                  ",
        "  XXXXXXXXXXXXXX  ",
        "  XXXXXXXXXXXXXX  ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX     XX     ",
        "   XXXXXXXXXX     ",
        "   XXXXXXXXXX     ",
        "   XXX     XX     ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "  XXXXXXXXXXXXXX  ",
        "  XXXXXXXXXXXXXX  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "F": (
        "                  ",
        "  XXXXXXXXXXXXXX  ",
        "  XXXXXXXXXXXXXX  ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX     XX     ",
        "   XXXXXXXXXX     ",
        "   XXXXXXXXXX     ",
        "   XXX     XX     ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "  XXXXX           ",
        "  XXXXX           ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "G": (
        "                  ",
        "      XXXXXX      ",
        "    XXXXXXXXX XX  ",
        "   XXXX    XXXXX  ",
        "  XXXX      XXXX  ",
        "  XXX        XXX  ",
        " XXXX         XX  ",
        " XXX          XX  ",
        " XXX              ",
        " XXX              ",
        " XXX              ",
        " XXX       XXXXXX ",
        " XXX       XXXXXX ",
        " XXX         XXX  ",
        " XXXX        XXX  ",
        "  XXX        XXX  ",
        "  XXXX      XXXX  ",
        "   XXXX    XXXXX  ",
        "    XXXXXXXXX XX  ",
        "      XXXXXX  XX  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "H": (
        "                  ",
        "  XXXXX     XXXXX ",
        "  XXXXX     XXXXX ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXXXXXXXXXXXX  ",
        "   XXXXXXXXXXXXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "  XXXXX     XXXXX ",
        "  XXXXX     XXXXX ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "I": (
        "                  ",
        "      XXXXXXX     ",
        "      XXXXXXX     ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "      XXXXXXX     ",
        "      XXXXXXX     ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "J": (
        "                  ",
        "         XXXXXXX  ",
        "         XXXXXXX  ",
        "           XXX    ",
        "           XXX    ",
        "           XXX    ",
        "           XXX    ",
        "           XXX    ",
        "           XXX    ",
        "           XXX    ",
        "           XXX    ",
        "           XXX    ",
        "           XXX    ",
        "    XX     XXX    ",
        "   XXXX    XXX    ",
        "   XXXX    XXX    ",
        "   XXX     XXX    ",
        "   XXXX   XXXX    ",
        "    XXXXXXXXX     ",
        "      XXXXX       ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "K": (
        "                  ",
        " XXXXX     XXXXX  ",
        " XXXXX     XXXXX  ",
        "  XXX       XXX   ",
        "  XXX      XXX    ",
        "  XXX     XXX     ",
        "  XXX    XXX      ",
        "  XXX   XXX       ",
        "  XXX  XXX        ",
        "  XXX XXX         ",
        "  XXXXXXX         ",
        "  XXXXXXXX        ",
        "  XXXX XXXX       ",
        "  XXX   XXXX      ",
        "  XXX    XXXX     ",
        "  XXX     XXXX    ",
        "  XXX      XXXX   ",
        "  XXX       XXXX  ",
        " XXXXX     XXXXXX ",
        " XXXXX     XXXXXX ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "L": (
        "                  ",
        "   XXXXX          ",
        "   XXXXX          ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX       XX  ",
        "    XXX       XX  ",
        "    XXX      XXX  ",
        "   XXXXXXXXXXXXX  ",
        "   XXXXXXXXXXXXX  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "M": (
        "                  ",
        " XXXX        XXXX ",
        " XXXX        XXXX ",
        "  XXXX      XXXX  ",
        "  XXXX      XXXX  ",
        "  XXXXX     XXXX  ",
        "  XXXXX    XXXXX  ",
        "  XXXXX    XXXXX  ",
        "  XX XXX   XXXXX  ",
        "  XX XXX  XX XXX  ",
        "  XX  XXX XX XXX  ",
        "  XX  XXX XX XXX  ",
        "  XX  XXXXX  XXX  ",
        "  XX   XXXX  XXX  ",
        "  XX   XXXX  XXX  ",
        "  XX   XXX   XXX  ",
        "  XX    XX   XXX  ",
        "  XX    XX   XXX  ",
        " XXXX       XXXXX ",
        " XXXX       XXXXX ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "N": (
        "                  ",
        "  XXXX       XXXX ",
        "  XXXXX      XXXX ",
        "   XXXX       XX  ",
        "   XXXXX      XX  ",
        "   XXXXX      XX  ",
        "   XX XXX     XX  ",
        "   XX XXX     XX  ",
        "   XX  XXX    XX  ",
        "   XX  XXX    XX  ",
        "   XX   XXX   XX  ",
        "   XX   XXXX  XX  ",
        "   XX    XXX  XX  ",
        "   XX     XXX XX  ",
        "   XX     XXX XX  ",
        "   XX      XXXXX  ",
        "   XX      XXXXX  ",
        "   XX       XXXX  ",
        "  XXXX      XXXX  ",
        "  XXXX       XXX  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "O": (
        "                  ",
        "      XXXXXX      ",
        "    XXXXXXXXXX    ",
        "   XXXX    XXXX   ",
        "  XXX        XXX  ",
        "  XXX        XXX  ",
        " XXXX        XXXX ",
        " XXX          XXX ",
        " XXX          XXX ",
        " XXX          XXX ",
        " XXX          XXX ",
        " XXX          XXX ",
        " XXX          XXX ",
        " XXX          XXX ",
        " XXXX        XXXX ",
        "  XXX        XXX  ",
        "  XXX        XXX  ",
        "   XXXX    XXXX   ",
        "    XXXXXXXXXX    ",
        "      XXXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "P": (
        "                  ",
        "  XXXXXXXXXX      ",
        "  XXXXXXXXXXXX    ",
        "   XXX     XXXX   ",
        "   XXX      XXXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX      XXXX  ",
        "   XXX     XXXX   ",
        "   XXXXXXXXXXX    ",
        "   XXXXXXXXX      ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "  XXXXX           ",
        "  XXXXX           ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "Q": (
        "                  ",
        "      XXXXX       ",
        "    XXXXXXXXX     ",
        "   XXXX   XXXX    ",
        "  XXX       XXX   ",
        "  XXX       XXX   ",
        " XXXX       XXXX  ",
        " XXX         XXX  ",
        " XXX         XXX  ",
        " XXX         XXX  ",
        " XXX         XXX  ",
        " XXX         XXX  ",
        " XXX         XXX  ",
        " XXX         XXX  ",
        " XXXX  XXX  XXXX  ",
        "  XXX XXXXX XXX   ",
        "  XXX XX XXXXXX   ",
        "   XXXX   XXXX    ",
        "    XXXXXXXXX     ",
        "      XXXX XXX  X ",
        "           XXX XX ",
        "            XXXXX ",
        "             XXX  ",
    ),
    "R": (
        "                  ",
        " XXXXXXXXXX       ",
        " XXXXXXXXXXXX     ",
        "  XXX     XXXX    ",
        "  XXX      XXXX   ",
        "  XXX       XXX   ",
        "  XXX       XXX   ",
        "  XXX       XXX   ",
        "  XXX      XXXX   ",
        "  XXX     XXXX    ",
        "  XXXXXXXXXXX     ",
        "  XXXXXXXXX       ",
        "  XXX   XXXX      ",
        "  XXX    XXXX     ",
        "  XXX     XXX     ",
        "  XXX     XXX     ",
        "  XXX     XXX   X ",
        "  XXX     XXXX XX ",
        " XXXXX     XXXXXX ",
        " XXXXX      XXXX  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "S": (
        "                  ",
        "     XXXXXX       ",
        "   XXXXXXXXXX XX  ",
        "   XXX    XXXXXX  ",
        "  XXX       XXXX  ",
        "  XXX        XXX  ",
        "  XXX         XX  ",
        "  XXXX            ",
        "   XXXXX          ",
        "   XXXXXXXX       ",
        "    XXXXXXXXXX    ",
        "       XXXXXXXX   ",
        "          XXXXX   ",
        "  XX        XXXX  ",
        "  XX         XXX  ",
        "  XXX        XXX  ",
        "  XXXX       XXX  ",
        "  XXXXXX    XXX   ",
        "  XX XXXXXXXXXX   ",
        "  XX   XXXXXX     ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "T": (
        "                  ",
        "  XXXXXXXXXXXXXXX ",
        "  XXXXXXXXXXXXXXX ",
        "  XXX   XXX   XXX ",
        "  XX    XXX    XX ",
        "  XX    XXX    XX ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "       XXXXX      ",
        "       XXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "U": (
        "                  ",
        "  XXXXX      XXXX ",
        "  XXXXX      XXXX ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX        XX  ",
        "   XXX       XXX  ",
        "    XXX      XX   ",
        "    XXXX    XXX   ",
        "     XXXXXXXXX    ",
        "       XXXXXX     ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "V": (
        "                  ",
        " XXXXX       XXXX ",
        " XXXXX       XXXX ",
        "  XXX         XX  ",
        "  XXX         XX  ",
        "   XXX       XX   ",
        "   XXX       XX   ",
        "   XXX       XX   ",
        "    XXX     XX    ",
        "    XXX     XX    ",
        "    XXX    XX     ",
        "     XXX   XX     ",
        "     XXX   XX     ",
        "      XXX XX      ",
        "      XXX XX      ",
        "      XXXXX       ",
        "       XXXX       ",
        "       XXXX       ",
        "        XX        ",
        "        XX        ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "W": (
        "                  ",
        " XXXXX  XXX  XXXX ",
        " XXXXX  XXX  XXXX ",
        "  XXX   XXX   XX  ",
        "  XXX   XXX   XX  ",
        "  XXX   XXX   XX  ",
        "  XXX   XXX   XX  ",
        "  XXXX XXXXX XXX  ",
        "   XXX XX XX XX   ",
        "   XXX XX XX XX   ",
        "   XXX XX XX XX   ",
        "   XXX XX XX XX   ",
        "   XXXXXX XXXXX   ",
        "    XXXX   XXX    ",
        "    XXXX   XXX    ",
        "    XXXX   XXX    ",
        "    XXXX   XXX    ",
        "     XX    XX     ",
        "     XX    XX     ",
        "     XX    XX     ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "X": (
        "                  ",
        "  XXXXXX    XXXXX ",
        "  XXXXXX    XXXXX ",
        "   XXXX      XXX  ",
        "    XXXX    XXX   ",
        "    XXXX    XX    ",
        "     XXXX  XXX    ",
        "      XXXX XX     ",
        "      XXXXXX      ",
        "       XXXXX      ",
        "        XXX       ",
        "       XXXXX      ",
        "       XXXXXX     ",
        "      XXX XXX     ",
        "     XXX  XXXX    ",
        "     XX    XXXX   ",
        "    XXX    XXXX   ",
        "   XXX      XXXX  ",
        "  XXXXX    XXXXXX ",
        "  XXXXX    XXXXXX ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "Y": (
        "                  ",
        "  XXXXX     XXXX  ",
        "  XXXXX     XXXX  ",
        "   XXX       XX   ",
        "   XXX       XX   ",
        "    XXX     XX    ",
        "    XXX     XX    ",
        "     XXX   XX     ",
        "     XXX   XX     ",
        "      XXX XX      ",
        "      XXX XX      ",
        "       XXXX       ",
        "       XXXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "       XXXXX      ",
        "       XXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "Z": (
        "                  ",
        "   XXXXXXXXXXXXX  ",
        "   XXXXXXXXXXXXX  ",
        "   XXX      XXX   ",
        "   XX      XXXX   ",
        "   XX      XXX    ",
        "          XXXX    ",
        "          XXX     ",
        "         XXX      ",
        "        XXXX      ",
        "        XXX       ",
        "       XXXX       ",
        "       XXX        ",
        "      XXX         ",
        "     XXXX         ",
        "     XXX      XX  ",
        "    XXXX      XX  ",
        "    XXX      XXX  ",
        "   XXXXXXXXXXXXX  ",
        "   XXXXXXXXXXXXX  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "[": (
        "       XXXXXX     ",
        "       XXXXXX     ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXXXXX     ",
        "       XXXXXX     ",
        "                  ",
    ),
    "\\": (
        "                  ",
        "    XX            ",
        "    XXX           ",
        "     XX           ",
        "     XXX          ",
        "      XX          ",
        "      XXX         ",
        "       XX         ",
        "       XXX        ",
        "        XX        ",
        "        XXX       ",
        "         XX       ",
        "         XXX      ",
        "          XX      ",
        "          XXX     ",
        "           XX     ",
        "           XXX    ",
        "            XX    ",
        "            XXX   ",
        "             XX   ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "]": (
        "     XXXXXX       ",
        "     XXXXXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "     XXXXXX       ",
        "     XXXXXX       ",
        "                  ",
    ),
    "^": (
        "                  ",
        "         XX       ",
        "        XXXX      ",
        "       XXXXXX     ",
        "      XXX  XXX    ",
        "     XXX    XXX   ",
        "    XXX      XXX  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "_": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        " XXXXXXXXXXXXXXXX ",
        " XXXXXXXXXXXXXXXX ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "`": (
        "                  ",
        "      XXX         ",
        "      XXXX        ",
        "       XXX        ",
        "        XXX       ",
        "         XX       ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "a": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "      XXXXXXX     ",
        "    XXXXXXXXXX    ",
        "   XXXXX   XXXX   ",
        "   XXXX     XXX   ",
        "    XX      XXX   ",
        "        XXXXXXX   ",
        "     XXXXXXXXXX   ",
        "    XXXXX   XXX   ",
        "   XXXX     XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXXX    XXXX   ",
        "    XXXXXXXXXXXXX ",
        "     XXXXXXX  XXX ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "b": (
        "    XX            ",
        "  XXXX            ",
        "  XXXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX XXXXX      ",
        "   XXXXXXXXXXX    ",
        "   XXXX    XXXX   ",
        "   XXX      XXX   ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX      XXX   ",
        "   XXXX    XXXX   ",
        "   XXXXXXXXXXX    ",
        "   XX XXXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "c": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "       XXXXX      ",
        "     XXXXXXXXX    ",
        "    XXXX    XXX   ",
        "    XXX      XXX  ",
        "   XXX      XXXX  ",
        "   XXX      XXXX  ",
        "   XXX       XX   ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "    XXX       XX  ",
        "    XXXX    XXXX  ",
        "     XXXXXXXXXX   ",
        "       XXXXXX     ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "d": (
        "             XX   ",
        "           XXXX   ",
        "           XXXX   ",
        "            XXX   ",
        "            XXX   ",
        "            XXX   ",
        "      XXXXX XXX   ",
        "    XXXXXXXXXXX   ",
        "   XXXX    XXXX   ",
        "   XXX      XXX   ",
        "  XXX       XXX   ",
        "  XXX       XXX   ",
        "  XXX       XXX   ",
        "  XXX       XXX   ",
        "  XXX       XXX   ",
        "  XXX       XXX   ",
        "   XXX      XXX   ",
        "   XXXX    XXXX   ",
        "    XXXXXXXXXXXX  ",
        "      XXXXXX XXX  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "e": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "       XXXXX      ",
        "     XXXXXXXXX    ",
        "    XXXX   XXXX   ",
        "    XXX     XXX   ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXXXXXXXXXXXX  ",
        "   XXXXXXXXXXXXX  ",
        "   XXX            ",
        "   XXX            ",
        "    XXX       XX  ",
        "    XXXX    XXXX  ",
        "     XXXXXXXXXX   ",
        "       XXXXXX     ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "f": (
        "                  ",
        "          XXXX    ",
        "        XXXXXXX   ",
        "       XXX   XXX  ",
        "      XXX   XXXX  ",
        "      XXX   XXXX  ",
        "      XXX    XX   ",
        "    XXXXXXXX      ",
        "    XXXXXXXX      ",
        "      XXX         ",
        "      XXX         ",
        "      XXX         ",
        "      XXX         ",
        "      XXX         ",
        "      XXX         ",
        "      XXX         ",
        "      XXX         ",
        "      XXX         ",
        "    XXXXXXXX      ",
        "    XXXXXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "g": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "              XX  ",
        "     XXXXXXX XXXX ",
        "    XXXXXXXXXXXXX ",
        "   XXXX   XXX  XX ",
        "   XXX     XXX    ",
        "   XXX     XXX    ",
        "   XXXX   XXXX    ",
        "    XXXXXXXXX     ",
        "   XXXXXXXXX      ",
        "   XX             ",
        "   XXXXXX         ",
        "    XXXXXXXXX     ",
        "   XXXXXXXXXXX    ",
        "  XXX    XXXXXX   ",
        "  XX        XXX   ",
        "  XXX      XXXX   ",
        "   XXXXXXXXXXX    ",
        "    XXXXXXXX      ",
    ),
    "h": (
        "     XX           ",
        "   XXXX           ",
        "   XXXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX XXXXX     ",
        "    XXXXXXXXXXX   ",
        "    XXXX    XXXX  ",
        "    XXX      XXX  ",
        "    XXX      XXX  ",
        "    XXX      XXX  ",
        "    XXX      XXX  ",
        "    XXX      XXX  ",
        "    XXX      XXX  ",
        "    XXX      XXX  ",
        "    XXX      XXX  ",
        "    XXX      XXX  ",
        "   XXXXX    XXXXX ",
        "   XXXXX    XXXXX ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "i": (
        "                  ",
        "        XX        ",
        "       XXXX       ",
        "       XXXX       ",
        "        XX        ",
        "                  ",
        "         XX       ",
        "      XXXXX       ",
        "      XXXXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "      XXXXXXX     ",
        "      XXXXXXX     ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "j": (
        "                  ",
        "          XX      ",
        "         XXXX     ",
        "         XXXX     ",
        "          XX      ",
        "                  ",
        "           XX     ",
        "        XXXXX     ",
        "        XXXXX     ",
        "          XXX     ",
        "          XXX     ",
        "          XXX     ",
        "          XXX     ",
        "          XXX     ",
        "          XXX     ",
        "          XXX     ",
        "          XXX     ",
        "          XXX     ",
        "     XX   XXX     ",
        "    XXXX  XXX     ",
        "    XXXX XXXX     ",
        "     XXXXXXX      ",
        "      XXXX        ",
    ),
    "k": (
        "    XX            ",
        "  XXXX            ",
        "  XXXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX            ",
        "   XXX    XXXXXX  ",
        "   XXX    XXXXXX  ",
        "   XXX     XXX    ",
        "   XXX    XXX     ",
        "   XXX   XXX      ",
        "   XXX  XXX       ",
        "   XXX XXX        ",
        "   XXXXXXXX       ",
        "   XXXX XXXX      ",
        "   XXX   XXXX     ",
        "   XXX    XXXX    ",
        "   XXX     XXXX   ",
        "  XXXXX   XXXXXXX ",
        "  XXXXX   XXXXXXX ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "l": (
        "         XX       ",
        "       XXXX       ",
        "       XXXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "      XXXXXXX     ",
        "      XXXXXXX     ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "m": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        " XXX XXXX  XXXX   ",
        " XXXXXXXXXXXXXXX  ",
        "  XXXX XXXXX XXXX ",
        "  XXX   XXX   XXX ",
        "  XXX   XXX   XXX ",
        "  XXX   XXX   XXX ",
        "  XXX   XXX   XXX ",
        "  XXX   XXX   XXX ",
        "  XXX   XXX   XXX ",
        "  XXX   XXX   XXX ",
        "  XXX   XXX   XXX ",
        "  XXX   XXX   XXX ",
        " XXXXX XXXXX XXXXX",
        " XXXXX XXXXX XXXXX",
        "                  ",
        "                  ",
        "                  ",
    ),
    "n": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "  XXXX XXXXXX     ",
        "  XXXXXXXXXXXX    ",
        "   XXXX    XXXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "  XXXXX    XXXXX  ",
        "  XXXXX    XXXXX  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "o": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "      XXXXXX      ",
        "    XXXXXXXXXX    ",
        "   XXXX    XXXX   ",
        "   XXX      XXX   ",
        "  XXXX      XXXX  ",
        "  XXX        XXX  ",
        "  XXX        XXX  ",
        "  XXX        XXX  ",
        "  XXX        XXX  ",
        "  XXXX      XXXX  ",
        "   XXX      XXX   ",
        "   XXXX    XXXX   ",
        "    XXXXXXXXXX    ",
        "      XXXXXX      ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "p": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "  XXXX XXXXX      ",
        "  XXXXXXXXXXXX    ",
        "   XXXX    XXXX   ",
        "   XXX      XXX   ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX       XXX  ",
        "   XXX      XXX   ",
        "   XXXX    XXXX   ",
        "   XXXXXXXXXXX    ",
        "   XXX XXXXX      ",
        "   XXX            ",
        "   XXX            ",
        "  XXXXX           ",
        "  XXXXX           ",
    ),
    "q": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "      XXXXXX XX   ",
        "    XXXXXXXXXXX   ",
        "   XXXX    XXXX   ",
        "   XXX      XXX   ",
        "  XXX       XXX   ",
        "  XXX       XXX   ",
        "  XXX       XXX   ",
        "  XXX       XXX   ",
        "  XXX       XXX   ",
        "   XXX      XXX   ",
        "   XXXX    XXXX   ",
        "    XXXXXXXXXXX   ",
        "      XXXXX XXX   ",
        "            XXX   ",
        "            XXX   ",
        "           XXXXX  ",
        "           XXXXX  ",
    ),
    "r": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "  XXXXX  XXXX     ",
        "  XXXXX XXXXXX    ",
        "    XXXXXX XXXX   ",
        "    XXXXX  XXXX   ",
        "    XXXX    XX    ",
        "    XXXX          ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "    XXX           ",
        "  XXXXXXX         ",
        "  XXXXXXX         ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "s": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "      XXXXXX  XX  ",
        "    XXXXXXXXXXXX  ",
        "   XXXX     XXXX  ",
        "   XXX        XX  ",
        "   XXXX           ",
        "   XXXXXXX        ",
        "    XXXXXXXXXX    ",
        "     XXXXXXXXXX   ",
        "         XXXXXXX  ",
        "            XXXX  ",
        "   XX        XXX  ",
        "   XXXX     XXXX  ",
        "   XXXXXXXXXXXX   ",
        "   XX  XXXXXX     ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "t": (
        "                  ",
        "        XX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "   XXXXXXXXXXXX   ",
        "   XXXXXXXXXXXX   ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX   XX   ",
        "       XXXX XXX   ",
        "        XXXXXX    ",
        "         XXXX     ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "u": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "  XXXX     XXXX   ",
        "  XXXX     XXXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXX      XXX   ",
        "   XXXX    XXXX   ",
        "    XXXXXXXXXXXXX ",
        "     XXXXXXX  XXX ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "v": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "  XXXXX     XXXX  ",
        "  XXXXX     XXXX  ",
        "   XXX       XX   ",
        "   XXX       XX   ",
        "    XXX     XX    ",
        "    XXX     XX    ",
        "     XXX   XX     ",
        "     XXX   XX     ",
        "      XXX XX      ",
        "      XXX XX      ",
        "       XXXX       ",
        "       XXXX       ",
        "        XX        ",
        "        XX        ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "w": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        " XXXXX  XXX  XXXX ",
        " XXXXX  XXX  XXXX ",
        "  XXX   XXX   XX  ",
        "  XXX   XXX   XX  ",
        "  XXX   XXXX  XX  ",
        "  XXXX XXXXX XXX  ",
        "   XXX XX XX XX   ",
        "   XXX XX XX XX   ",
        "   XXX XX XXXXX   ",
        "    XXXX   XXXX   ",
        "    XXXX   XXXX   ",
        "    XXXX   XXX    ",
        "     XX     XX    ",
        "     XX     XX    ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "x": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "  XXXXXXX  XXXXXX ",
        "  XXXXXXX  XXXXXX ",
        "    XXXX    XXX   ",
        "     XXXX  XXX    ",
        "      XXX XXX     ",
        "       XXXXX      ",
        "       XXXX       ",
        "        XXXX      ",
        "       XXXXX      ",
        "      XXX XXX     ",
        "     XXX  XXXX    ",
        "    XXX    XXXX   ",
        "  XXXXXX  XXXXXXX ",
        "  XXXXXX  XXXXXXX ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "y": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "  XXXXXX     XXXX ",
        "  XXXXXX     XXXX ",
        "    XXX       XX  ",
        "    XXX       XX  ",
        "     XXX     XX   ",
        "     XXX     XX   ",
        "      XXX   XX    ",
        "      XXX   XX    ",
        "       XXX XX     ",
        "       XXX XX     ",
        "        XXXX      ",
        "        XXXX      ",
        "         XX       ",
        "    XX   XX       ",
        "   XXXX XX        ",
        "   XXXXXXX        ",
        "    XXXX          ",
    ),
    "z": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "   XXXXXXXXXXXXX  ",
        "   XXXXXXXXXXXXX  ",
        "   XX      XXXX   ",
        "   XX     XXXX    ",
        "         XXXX     ",
        "         XXXX     ",
        "        XXXX      ",
        "       XXXX       ",
        "      XXXX        ",
        "      XXXX        ",
        "     XXXX     XX  ",
        "    XXXX      XX  ",
        "   XXXXXXXXXXXXX  ",
        "   XXXXXXXXXXXXX  ",
        "                  ",
        "                  ",
        "                  ",
    ),
    "{": (
        "          XXXX    ",
        "        XXXXXX    ",
        "       XXXX       ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "      XXX         ",
        "     XXX          ",
        "     XXX          ",
        "      XXX         ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXX        ",
        "       XXXX       ",
        "        XXXXXX    ",
        "          XXXX    ",
        "                  ",
    ),
    "|": (
        "                  ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
        "        XX        ",
    ),
    "}": (
        "    XXXX          ",
        "    XXXXXX        ",
        "       XXXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "         XXX      ",
        "          XXX     ",
        "          XXX     ",
        "         XXX      ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "        XXX       ",
        "       XXXX       ",
        "    XXXXXX        ",
        "    XXXX          ",
        "                  ",
    ),
    "~": (
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "    XXXXX         ",
        "   XXXXXXX     XX ",
        "  XXX   XXX   XXX ",
        "  XX     XXXXXXX  ",
        "          XXXXX   ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
        "                  ",
    ),
}
"""The large font dictionary. This dictionary contains the large font characters.

:meta hide-value:
"""


medium = {
    " ": (
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
    ),
    "!": (
        "      ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "      ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "      ",
        "      ",
        "      ",
    ),
    '"': (
        "  XX   XX   ",
        " XXXX XXXX  ",
        " XXXX XXXX  ",
        "  XXX  XXX  ",
        "   XX   XX  ",
        "  XX   XX   ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
    ),
    "#": (
        "            ",
        "    XX  XX  ",
        "    XX  XX  ",
        "    XX  XX  ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        "   XX  XX   ",
        "   XX  XX   ",
        "   XX  XX   ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        "  XX  XX    ",
        "  XX  XX    ",
        "  XX  XX    ",
        "            ",
        "            ",
        "            ",
    ),
    "$": (
        "    XX    ",
        "    XX    ",
        "  XXXXXX  ",
        " XXXXXXXX ",
        " XX XX XX ",
        " XX XX    ",
        " XX XX    ",
        " XXXXXXX  ",
        "  XXXXXXX ",
        "    XX XX ",
        "    XX XX ",
        " XX XX XX ",
        " XXXXXXXX ",
        "  XXXXXX  ",
        "    XX    ",
        "    XX    ",
        "    XX    ",
    ),
    "%": (
        "               ",
        "  XXX    XX    ",
        " XXXXX   XX    ",
        " XX XX  XX     ",
        " XX XX  XX     ",
        " XX XX XX      ",
        " XXXXX XX      ",
        "  XXX  XX XXX  ",
        "      XX XXXXX ",
        "      XX XX XX ",
        "     XX  XX XX ",
        "     XX  XX XX ",
        "    XX   XXXXX ",
        "    XX    XXX  ",
        "               ",
        "               ",
        "               ",
    ),
    "&": (
        "             ",
        "   XXXX      ",
        "  XXXXXX     ",
        "  XX  XX     ",
        "  XX  XX     ",
        "  XXXXX      ",
        "   XXX  XXXX ",
        "  XXXXX XXXX ",
        " XXX XXX XX  ",
        " XX   XXXX   ",
        " XX    XX    ",
        " XXX  XXXX   ",
        " XXXXXXXXXXX ",
        "  XXXXXX XXX ",
        "             ",
        "             ",
        "             ",
    ),
    "'": (
        "  XX   ",
        " XXXX  ",
        " XXXX  ",
        "  XXX  ",
        "   XX  ",
        "  XX   ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
    ),
    "(": (
        "     XX ",
        "    XXX ",
        "    XX  ",
        "   XX   ",
        "   XX   ",
        "  XX    ",
        "  XX    ",
        "  XX    ",
        "  XX    ",
        "  XX    ",
        "  XX    ",
        "   XX   ",
        "   XX   ",
        "    XX  ",
        "    XXX ",
        "     XX ",
        "        ",
    ),
    ")": (
        " XX     ",
        " XXX    ",
        "  XX    ",
        "   XX   ",
        "   XX   ",
        "    XX  ",
        "    XX  ",
        "    XX  ",
        "    XX  ",
        "    XX  ",
        "    XX  ",
        "   XX   ",
        "   XX   ",
        "  XX    ",
        " XXX    ",
        " XX     ",
        "        ",
    ),
    "*": (
        "            ",
        "            ",
        "     XX     ",
        "     XX     ",
        " XX  XX  XX ",
        " XXX XX XXX ",
        "  XXXXXXXX  ",
        "   XXXXXX   ",
        "   XXXXXX   ",
        "  XXXXXXXX  ",
        " XXX XX XXX ",
        " XX  XX  XX ",
        "     XX     ",
        "     XX     ",
        "            ",
        "            ",
        "            ",
    ),
    "+": (
        "            ",
        "            ",
        "            ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "            ",
        "            ",
        "            ",
        "            ",
    ),
    ",": (
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "  XX   ",
        " XXXX  ",
        " XXXX  ",
        "  XXX  ",
        "   XX  ",
        "  XX   ",
        "       ",
    ),
    "-": (
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
    ),
    ".": (
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "     XX     ",
        "    XXXX    ",
        "    XXXX    ",
        "     XX     ",
        "            ",
        "            ",
        "            ",
    ),
    "/": (
        "         ",
        "      XX ",
        "      XX ",
        "     XX  ",
        "     XX  ",
        "    XX   ",
        "    XX   ",
        "    XX   ",
        "   XX    ",
        "   XX    ",
        "  XX     ",
        "  XX     ",
        " XX      ",
        " XX      ",
        "         ",
        "         ",
        "         ",
    ),
    "0": (
        "            ",
        "     XXX    ",
        "   XXXXXXX  ",
        "   XX   XX  ",
        "  XXX   XXX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XXX   XXX ",
        "   XX   XX  ",
        "   XXXXXXX  ",
        "     XXX    ",
        "            ",
        "            ",
        "            ",
    ),
    "1": (
        "            ",
        "     XX     ",
        "   XXXX     ",
        "   XXXX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "   XXXXXX   ",
        "   XXXXXX   ",
        "            ",
        "            ",
        "            ",
    ),
    "2": (
        "            ",
        "    XXXXX   ",
        "   XXXXXXX  ",
        "  XXX   XXX ",
        "  XX     XX ",
        "  XXX    XX ",
        "   XX   XXX ",
        "       XXX  ",
        "      XXX   ",
        "     XXX    ",
        "    XXX     ",
        "   XXX      ",
        "  XXXXXXXXX ",
        "  XXXXXXXXX ",
        "            ",
        "            ",
        "            ",
    ),
    "3": (
        "            ",
        "    XXXXX   ",
        "   XXXXXXX  ",
        "  XXX   XXX ",
        "  XX     XX ",
        "        XXX ",
        "     XXXXX  ",
        "     XXXXX  ",
        "        XXX ",
        "         XX ",
        "  XX     XX ",
        "  XXX   XXX ",
        "   XXXXXXX  ",
        "    XXXXX   ",
        "            ",
        "            ",
        "            ",
    ),
    "4": (
        "            ",
        "      XXX   ",
        "     XXXX   ",
        "     XXXX   ",
        "    XXXXX   ",
        "    XX XX   ",
        "   XXX XX   ",
        "   XX  XX   ",
        "  XXX  XX   ",
        "  XX   XX   ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        "       XX   ",
        "       XX   ",
        "            ",
        "            ",
        "            ",
    ),
    "5": (
        "            ",
        "  XXXXXXXX  ",
        "  XXXXXXXX  ",
        "  XX        ",
        "  XX        ",
        "  XX XXXX   ",
        "  XXXXXXXX  ",
        "  XXX   XXX ",
        "  XX     XX ",
        "         XX ",
        "  XX     XX ",
        "  XXX   XXX ",
        "   XXXXXXX  ",
        "    XXXXX   ",
        "            ",
        "            ",
        "            ",
    ),
    "6": (
        "            ",
        "    XXXXX   ",
        "   XXXXXXX  ",
        "  XXX   XXX ",
        "  XX     XX ",
        "  XX XXXX   ",
        "  XXXXXXXX  ",
        "  XXX   XXX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XXX   XXX ",
        "   XXXXXXX  ",
        "    XXXXX   ",
        "            ",
        "            ",
        "            ",
    ),
    "7": (
        "            ",
        "  XXXXXXXXX ",
        "  XXXXXXXXX ",
        "  XX     XX ",
        "  XX    XX  ",
        "        XX  ",
        "       XX   ",
        "       XX   ",
        "      XX    ",
        "      XX    ",
        "      XX    ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "            ",
        "            ",
        "            ",
    ),
    "8": (
        "            ",
        "    XXXXX   ",
        "   XXXXXXX  ",
        "  XXX   XXX ",
        "  XX     XX ",
        "  XXX   XX  ",
        "   XXXXXX   ",
        "    XXXXXX  ",
        "   XX   XXX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XXX   XXX ",
        "   XXXXXXX  ",
        "    XXXXX   ",
        "            ",
        "            ",
        "            ",
    ),
    "9": (
        "            ",
        "    XXXXX   ",
        "   XXXXXXX  ",
        "  XXX   XXX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XXX   XXX ",
        "   XXXXXXXX ",
        "    XXXX XX ",
        "  XX     XX ",
        "  XXX   XXX ",
        "   XXXXXXX  ",
        "    XXXXX   ",
        "            ",
        "            ",
        "            ",
    ),
    ":": (
        "        ",
        "        ",
        "   XX   ",
        "  XXXX  ",
        "  XXXX  ",
        "   XX   ",
        "        ",
        "        ",
        "        ",
        "   XX   ",
        "  XXXX  ",
        "  XXXX  ",
        "   XX   ",
        "        ",
        "        ",
        "        ",
        "        ",
    ),
    ";": (
        "        ",
        "        ",
        "   XX   ",
        "  XXXX  ",
        "  XXXX  ",
        "   XX   ",
        "        ",
        "        ",
        "        ",
        "   XX   ",
        "  XXXX  ",
        "  XXXX  ",
        "   XXX  ",
        "    XX  ",
        "   XX   ",
        "        ",
        "        ",
    ),
    "<": (
        "         ",
        "         ",
        "      XX ",
        "     XXX ",
        "    XXX  ",
        "   XXX   ",
        "  XXX    ",
        " XXX     ",
        " XXX     ",
        "  XXX    ",
        "   XXX   ",
        "    XXX  ",
        "     XXX ",
        "      XX ",
        "         ",
        "         ",
        "         ",
    ),
    "=": (
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        "            ",
        "            ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
    ),
    ">": (
        "         ",
        "         ",
        " XX      ",
        " XXX     ",
        "  XXX    ",
        "   XXX   ",
        "    XXX  ",
        "     XXX ",
        "     XXX ",
        "    XXX  ",
        "   XXX   ",
        "  XXX    ",
        " XXX     ",
        " XX      ",
        "         ",
        "         ",
        "         ",
    ),
    "?": (
        "           ",
        "    XXX    ",
        "  XXXXXXX  ",
        " XXX   XXX ",
        " XX     XX ",
        " XXX   XXX ",
        "  XX  XXX  ",
        "      XX   ",
        "     XX    ",
        "     XX    ",
        "           ",
        "     XX    ",
        "     XX    ",
        "     XX    ",
        "           ",
        "           ",
        "           ",
    ),
    "@": (
        "             ",
        "    XXXXX    ",
        "  XXXXXXXXX  ",
        "  XX     XX  ",
        " XX  XXXX XX ",
        " XX XXXXX XX ",
        " XX XX XX XX ",
        " XX XX XX XX ",
        " XX XX XX XX ",
        " XX XXXXXXXX ",
        " XX  XX XXX  ",
        "  XX         ",
        "  XXXXXXXXX  ",
        "    XXXXXXX  ",
        "             ",
        "             ",
        "             ",
    ),
    "A": (
        "             ",
        "     XXX     ",
        "     XXX     ",
        "    XXXXX    ",
        "    XX XX    ",
        "    XX XX    ",
        "   XX   XX   ",
        "   XX   XX   ",
        "   XXXXXXX   ",
        "  XXXXXXXXX  ",
        "  XX     XX  ",
        "  XX     XX  ",
        " XXXX   XXXX ",
        " XXXX   XXXX ",
        "             ",
        "             ",
        "             ",
    ),
    "B": (
        "            ",
        " XXXXXXXX   ",
        " XXXXXXXXX  ",
        "  XX    XXX ",
        "  XX     XX ",
        "  XX    XXX ",
        "  XXXXXXXX  ",
        "  XXXXXXXX  ",
        "  XX    XXX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX    XXX ",
        " XXXXXXXXXX ",
        " XXXXXXXXX  ",
        "            ",
        "            ",
        "            ",
    ),
    "C": (
        "            ",
        "    XXXX XX ",
        "   XXXXXXXX ",
        "  XXX   XXX ",
        "  XX     XX ",
        " XX         ",
        " XX         ",
        " XX         ",
        " XX         ",
        " XX         ",
        "  XX     XX ",
        "  XXX   XXX ",
        "   XXXXXXX  ",
        "    XXXXX   ",
        "            ",
        "            ",
        "            ",
    ),
    "D": (
        "            ",
        " XXXXXXX    ",
        " XXXXXXXX   ",
        "  XX   XXX  ",
        "  XX    XX  ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX    XX  ",
        "  XX   XXX  ",
        " XXXXXXXX   ",
        " XXXXXXX    ",
        "            ",
        "            ",
        "            ",
    ),
    "E": (
        "            ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        "  XX     XX ",
        "  XX        ",
        "  XX   XX   ",
        "  XXXXXXX   ",
        "  XXXXXXX   ",
        "  XX   XX   ",
        "  XX        ",
        "  XX        ",
        "  XX     XX ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        "            ",
        "            ",
        "            ",
    ),
    "F": (
        "            ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        "  XX     XX ",
        "  XX        ",
        "  XX   XX   ",
        "  XXXXXXX   ",
        "  XXXXXXX   ",
        "  XX   XX   ",
        "  XX        ",
        "  XX        ",
        "  XX        ",
        " XXXX       ",
        " XXXX       ",
        "            ",
        "            ",
        "            ",
    ),
    "G": (
        "            ",
        "    XXXX XX ",
        "   XXXXXXXX ",
        "  XXX   XXX ",
        "  XX     XX ",
        " XX         ",
        " XX         ",
        " XX    XXXX ",
        " XX    XXXX ",
        " XX      XX ",
        "  XX    XXX ",
        "  XXX  XXXX ",
        "   XXXXXXXX ",
        "    XXXX XX ",
        "            ",
        "            ",
        "            ",
    ),
    "H": (
        "            ",
        " XXXX  XXXX ",
        " XXXX  XXXX ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XXXXXXXX  ",
        "  XXXXXXXX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        " XXXX  XXXX ",
        " XXXX  XXXX ",
        "            ",
        "            ",
        "            ",
    ),
    "I": (
        "        ",
        " XXXXXX ",
        " XXXXXX ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        " XXXXXX ",
        " XXXXXX ",
        "        ",
        "        ",
        "        ",
    ),
    "J": (
        "            ",
        "     XXXXXX ",
        "     XXXXXX ",
        "       XX   ",
        "       XX   ",
        "       XX   ",
        "       XX   ",
        "       XX   ",
        "       XX   ",
        " XX    XX   ",
        " XX    XX   ",
        " XXX  XXX   ",
        "  XXXXXX    ",
        "   XXXX     ",
        "            ",
        "            ",
        "            ",
    ),
    "K": (
        "            ",
        " XXXX  XXXX ",
        " XXXX  XXXX ",
        "  XX   XXX  ",
        "  XX  XXX   ",
        "  XX XXX    ",
        "  XXXXX     ",
        "  XXXX      ",
        "  XXXXX     ",
        "  XX XXX    ",
        "  XX  XXX   ",
        "  XX   XXX  ",
        " XXXX  XXXX ",
        " XXXX  XXXX ",
        "            ",
        "            ",
        "            ",
    ),
    "L": (
        "            ",
        " XXXX       ",
        " XXXX       ",
        "  XX        ",
        "  XX        ",
        "  XX        ",
        "  XX        ",
        "  XX        ",
        "  XX        ",
        "  XX        ",
        "  XX     XX ",
        "  XX     XX ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        "            ",
        "            ",
        "            ",
    ),
    "M": (
        "              ",
        " XXX      XXX ",
        " XXXX    XXXX ",
        "  XXX    XXX  ",
        "  XXXX  XXXX  ",
        "  XXXX  XXXX  ",
        "  XXXXXXXXXX  ",
        "  XX XXXX XX  ",
        "  XX XXXX XX  ",
        "  XX  XX  XX  ",
        "  XX  XX  XX  ",
        "  XX      XX  ",
        " XXXX    XXXX ",
        " XXXX    XXXX ",
        "              ",
        "              ",
        "              ",
    ),
    "N": (
        "            ",
        " XXX   XXXX ",
        " XXX   XXXX ",
        "  XXX   XX  ",
        "  XXX   XX  ",
        "  XXXX  XX  ",
        "  XXXX  XX  ",
        "  XX XX XX  ",
        "  XX XX XX  ",
        "  XX  XXXX  ",
        "  XX  XXXX  ",
        "  XX   XXX  ",
        " XXXX  XXX  ",
        " XXXX   XX  ",
        "            ",
        "            ",
        "            ",
    ),
    "O": (
        "             ",
        "    XXXXX    ",
        "  XXXXXXXXX  ",
        "  XX     XX  ",
        " XXX     XXX ",
        " XX       XX ",
        " XX       XX ",
        " XX       XX ",
        " XX       XX ",
        " XX       XX ",
        " XXX     XXX ",
        "  XX     XX  ",
        "  XXXXXXXXX  ",
        "    XXXXX    ",
        "             ",
        "             ",
        "             ",
    ),
    "P": (
        "            ",
        " XXXXXXXX   ",
        " XXXXXXXXX  ",
        "  XX    XXX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX    XXX ",
        "  XXXXXXXX  ",
        "  XXXXXXX   ",
        "  XX        ",
        "  XX        ",
        "  XX        ",
        " XXXX       ",
        " XXXX       ",
        "            ",
        "            ",
        "            ",
    ),
    "Q": (
        "            ",
        "    XXXX    ",
        "   XXXXXX   ",
        "  XXX  XXX  ",
        "  XX    XX  ",
        " XX      XX ",
        " XX      XX ",
        " XX      XX ",
        " XX      XX ",
        " XX XXXX XX ",
        "  XXXXXXXX  ",
        "  XXX  XXX  ",
        "   XXXXXX   ",
        "    XXXXX X ",
        "       XXXX ",
        "        XX  ",
        "            ",
    ),
    "R": (
        "            ",
        " XXXXXXXX   ",
        " XXXXXXXXX  ",
        "  XX    XXX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX    XXX ",
        "  XXXXXXXX  ",
        "  XXXXXX    ",
        "  XX  XXX   ",
        "  XX   XX   ",
        "  XX   XXX  ",
        " XXXX   XXX ",
        " XXXX    XX ",
        "            ",
        "            ",
        "            ",
    ),
    "S": (
        "           ",
        "   XXXX XX ",
        "  XXXXXXXX ",
        " XXX   XXX ",
        " XX     XX ",
        " XXX       ",
        "  XXXX     ",
        "   XXXXX   ",
        "      XXX  ",
        "       XXX ",
        " XX     XX ",
        " XXX   XXX ",
        " XXXXXXXX  ",
        " XX XXXX   ",
        "           ",
        "           ",
        "           ",
    ),
    "T": (
        "            ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        " XX  XX  XX ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "    XXXX    ",
        "    XXXX    ",
        "            ",
        "            ",
        "            ",
    ),
    "U": (
        "            ",
        " XXXX  XXXX ",
        " XXXX  XXXX ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XXX  XXX  ",
        "   XXXXXX   ",
        "    XXXX    ",
        "            ",
        "            ",
        "            ",
    ),
    "V": (
        "            ",
        " XXXX  XXXX ",
        " XXXX  XXXX ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "   XX  XX   ",
        "   XX  XX   ",
        "   XX  XX   ",
        "    XXXX    ",
        "    XXXX    ",
        "    XXXX    ",
        "     XX     ",
        "     XX     ",
        "            ",
        "            ",
        "            ",
    ),
    "W": (
        "              ",
        " XXXX    XXXX ",
        " XXXX    XXXX ",
        "  XX  XX  XX  ",
        "  XX  XX  XX  ",
        "  XX  XX  XX  ",
        "  XX XXXX XX  ",
        "  XX XXXX XX  ",
        "  XXXXXXXXXX  ",
        "  XXXX  XXXX  ",
        "   XXX  XXX   ",
        "   XX    XX   ",
        "   XX    XX   ",
        "   XX    XX   ",
        "              ",
        "              ",
        "              ",
    ),
    "X": (
        "            ",
        " XXXX  XXXX ",
        " XXXX  XXXX ",
        "  XX    XX  ",
        "   XX  XX   ",
        "   XXXXXX   ",
        "    XXXX    ",
        "     XX     ",
        "    XXXX    ",
        "   XXXXXX   ",
        "   XX  XX   ",
        "  XX    XX  ",
        " XXXX  XXXX ",
        " XXXX  XXXX ",
        "            ",
        "            ",
        "            ",
    ),
    "Y": (
        "            ",
        " XXXX  XXXX ",
        " XXXX  XXXX ",
        "  XX    XX  ",
        "  XX    XX  ",
        "   XX  XX   ",
        "   XX  XX   ",
        "    XXXX    ",
        "    XXXX    ",
        "     XX     ",
        "     XX     ",
        "     XX     ",
        "    XXXX    ",
        "    XXXX    ",
        "            ",
        "            ",
        "            ",
    ),
    "Z": (
        "           ",
        " XXXXXXXXX ",
        " XXXXXXXXX ",
        " XX    XX  ",
        "      XXX  ",
        "      XX   ",
        "     XXX   ",
        "    XXX    ",
        "    XX     ",
        "   XXX     ",
        "  XXX      ",
        "  XX    XX ",
        " XXXXXXXXX ",
        " XXXXXXXXX ",
        "           ",
        "           ",
        "           ",
    ),
    "[": (
        "  XXXX ",
        "  XXXX ",
        "  XX   ",
        "  XX   ",
        "  XX   ",
        "  XX   ",
        "  XX   ",
        "  XX   ",
        "  XX   ",
        "  XX   ",
        "  XX   ",
        "  XX   ",
        "  XX   ",
        "  XX   ",
        "  XXXX ",
        "  XXXX ",
        "       ",
    ),
    "\\": (
        "         ",
        " XX      ",
        " XX      ",
        "  XX     ",
        "  XX     ",
        "   XX    ",
        "   XX    ",
        "   XX    ",
        "    XX   ",
        "    XX   ",
        "     XX  ",
        "     XX  ",
        "      XX ",
        "      XX ",
        "         ",
        "         ",
        "         ",
    ),
    "]": (
        " XXXX  ",
        " XXXX  ",
        "   XX  ",
        "   XX  ",
        "   XX  ",
        "   XX  ",
        "   XX  ",
        "   XX  ",
        "   XX  ",
        "   XX  ",
        "   XX  ",
        "   XX  ",
        "   XX  ",
        "   XX  ",
        " XXXX  ",
        " XXXX  ",
        "       ",
    ),
    "^": (
        "          ",
        "    XX    ",
        "   XXXX   ",
        "  XXXXXX  ",
        " XXX  XXX ",
        " XX    XX ",
        "          ",
        "          ",
        "          ",
        "          ",
        "          ",
        "          ",
        "          ",
        "          ",
        "          ",
        "          ",
        "          ",
    ),
    "_": (
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        " XXXXXXXXXX ",
        " XXXXXXXXXX ",
        "            ",
        "            ",
        "            ",
    ),
    "`": (
        "      ",
        " XX   ",
        " XXX  ",
        "  XXX ",
        "   XX ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
    ),
    "a": (
        "           ",
        "           ",
        "           ",
        "           ",
        "           ",
        "  XXXXXX   ",
        " XXXXXXXX  ",
        " XX    XX  ",
        "   XXXXXX  ",
        "  XXXXXXX  ",
        " XXX   XX  ",
        " XX    XX  ",
        " XXXXXXXXX ",
        "  XXXXX XX ",
        "           ",
        "           ",
        "           ",
    ),
    "b": (
        "  XX        ",
        " XXX        ",
        " XXX        ",
        "  XX        ",
        "  XX        ",
        "  XX XXXX   ",
        "  XXXXXXXX  ",
        "  XXX   XXX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XXX   XXX ",
        "  XXXXXXXX  ",
        "  XX XXXX   ",
        "            ",
        "            ",
        "            ",
    ),
    "c": (
        "          ",
        "          ",
        "          ",
        "          ",
        "          ",
        "   XXXXX  ",
        "  XXXXXXX ",
        " XXX   XX ",
        " XX       ",
        " XX       ",
        " XX       ",
        " XXX   XX ",
        "  XXXXXXX ",
        "   XXXXX  ",
        "          ",
        "          ",
        "          ",
    ),
    "d": (
        "        XX  ",
        "       XXX  ",
        "       XXX  ",
        "        XX  ",
        "        XX  ",
        "   XXXX XX  ",
        "  XXXXXXXX  ",
        " XXX   XXX  ",
        " XX     XX  ",
        " XX     XX  ",
        " XX     XX  ",
        " XXX   XXX  ",
        "  XXXXXXXXX ",
        "   XXXXX XX ",
        "            ",
        "            ",
        "            ",
    ),
    "e": (
        "          ",
        "          ",
        "          ",
        "          ",
        "          ",
        "   XXXX   ",
        "  XXXXXX  ",
        " XXX  XXX ",
        " XX    XX ",
        " XXXXXXXX ",
        " XXXXXXXX ",
        " XXX      ",
        "  XXXXXXX ",
        "   XXXXXX ",
        "          ",
        "          ",
        "          ",
    ),
    "f": (
        "          ",
        "    XXXX  ",
        "   XXXXXX ",
        "   XX  XX ",
        "   XX     ",
        " XXXXXXX  ",
        " XXXXXXX  ",
        "   XX     ",
        "   XX     ",
        "   XX     ",
        "   XX     ",
        "   XX     ",
        " XXXXXXX  ",
        " XXXXXXX  ",
        "          ",
        "          ",
        "          ",
    ),
    "g": (
        "           ",
        "           ",
        "           ",
        "           ",
        "  XXXXX XX ",
        " XXXXXXXXX ",
        " XX   XX   ",
        " XX   XX   ",
        " XXXXXXX   ",
        "  XXXXX    ",
        " XXX       ",
        " XXXXX     ",
        "  XXXXXX   ",
        " XX   XXX  ",
        " XX    XX  ",
        " XXXXXXXX  ",
        "  XXXXXX   ",
    ),
    "h": (
        "  XX        ",
        " XXX        ",
        " XXX        ",
        "  XX        ",
        "  XX        ",
        "  XX XXXX   ",
        "  XXXXXXXX  ",
        "  XXX  XXX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        " XXXX  XXXX ",
        " XXXX  XXXX ",
        "            ",
        "            ",
        "            ",
    ),
    "i": (
        "        ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "        ",
        " XXXX   ",
        " XXXX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        " XXXXXX ",
        " XXXXXX ",
        "        ",
        "        ",
        "        ",
    ),
    "j": (
        "         ",
        "     XX  ",
        "     XX  ",
        "     XX  ",
        "         ",
        "   XXXX  ",
        "   XXXX  ",
        "     XX  ",
        "     XX  ",
        "     XX  ",
        "     XX  ",
        "     XX  ",
        "     XX  ",
        "     XX  ",
        " XX  XX  ",
        " XXXXXX  ",
        "  XXXX   ",
    ),
    "k": (
        "  XX       ",
        " XXX       ",
        " XXX       ",
        "  XX       ",
        "  XX       ",
        "  XX XXXX  ",
        "  XX XXXX  ",
        "  XX  XX   ",
        "  XX XX    ",
        "  XXXXX    ",
        "  XXX XX   ",
        "  XX   XX  ",
        " XXXX XXXX ",
        " XXXX XXXX ",
        "           ",
        "           ",
        "           ",
    ),
    "l": (
        "   XX   ",
        "  XXX   ",
        "  XXX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        " XXXXXX ",
        " XXXXXX ",
        "        ",
        "        ",
        "        ",
    ),
    "m": (
        "              ",
        "              ",
        "              ",
        "              ",
        "              ",
        " XX XXX XXX   ",
        " XXXXXXXXXXX  ",
        "  XXX XXX XX  ",
        "  XX  XX  XX  ",
        "  XX  XX  XX  ",
        "  XX  XX  XX  ",
        "  XX  XX  XX  ",
        " XXX XXX XXXX ",
        " XXX XXX XXXX ",
        "              ",
        "              ",
        "              ",
    ),
    "n": (
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        " XX XXXXX   ",
        " XXXXXXXXX  ",
        "  XXX  XXX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        " XXXX  XXXX ",
        " XXXX  XXXX ",
        "            ",
        "            ",
        "            ",
    ),
    "o": (
        "           ",
        "           ",
        "           ",
        "           ",
        "           ",
        "   XXXXX   ",
        "  XXXXXXX  ",
        " XXX   XXX ",
        " XX     XX ",
        " XX     XX ",
        " XX     XX ",
        " XXX   XXX ",
        "  XXXXXXX  ",
        "   XXXXX   ",
        "           ",
        "           ",
        "           ",
    ),
    "p": (
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        " XXX XXXX   ",
        " XXXXXXXXX  ",
        "  XXX   XXX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XX     XX ",
        "  XXX   XXX ",
        "  XXXXXXXX  ",
        "  XX XXXX   ",
        "  XX        ",
        " XXXX       ",
        " XXXX       ",
    ),
    "q": (
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "   XXXX XX  ",
        "  XXXXXXXX  ",
        " XXX   XXX  ",
        " XX     XX  ",
        " XX     XX  ",
        " XX     XX  ",
        " XXX   XXX  ",
        "  XXXXXXXX  ",
        "   XXXX XX  ",
        "        XX  ",
        "       XXXX ",
        "       XXXX ",
    ),
    "r": (
        "          ",
        "          ",
        "          ",
        "          ",
        "          ",
        " XXX XXX  ",
        " XXXXXXXX ",
        "  XXX  XX ",
        "  XX      ",
        "  XX      ",
        "  XX      ",
        "  XX      ",
        " XXXX     ",
        " XXXX     ",
        "          ",
        "          ",
        "          ",
    ),
    "s": (
        "          ",
        "          ",
        "          ",
        "          ",
        "          ",
        "  XXXXXX  ",
        " XXXXXXXX ",
        " XX    XX ",
        " XXXX     ",
        "  XXXXXX  ",
        "     XXXX ",
        " XX    XX ",
        " XXXXXXXX ",
        "  XXXXXX  ",
        "          ",
        "          ",
        "          ",
    ),
    "t": (
        "          ",
        "          ",
        "    XX    ",
        "    XX    ",
        "   XXX    ",
        " XXXXXXXX ",
        " XXXXXXXX ",
        "    XX    ",
        "    XX    ",
        "    XX    ",
        "    XX    ",
        "    XX XX ",
        "    XXXXX ",
        "     XXX  ",
        "          ",
        "          ",
        "          ",
    ),
    "u": (
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        " XXX   XXX  ",
        " XXX   XXX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XX    XX  ",
        "  XXX  XXX  ",
        "  XXXXXXXXX ",
        "   XXXXX XX ",
        "            ",
        "            ",
        "            ",
    ),
    "v": (
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        " XXXX  XXXX ",
        " XXXX  XXXX ",
        "  XX    XX  ",
        "  XX    XX  ",
        "   XX  XX   ",
        "   XX  XX   ",
        "    XXXX    ",
        "    XXXX    ",
        "     XX     ",
        "            ",
        "            ",
        "            ",
    ),
    "w": (
        "              ",
        "              ",
        "              ",
        "              ",
        "              ",
        " XXXX XX XXXX ",
        " XXXX XX XXXX ",
        "  XX  XX  XX  ",
        "  XX XXXX XX  ",
        "  XX XXXX XX  ",
        "   XXX  XXX   ",
        "   XXX  XXX   ",
        "   XX    XX   ",
        "   XX    XX   ",
        "              ",
        "              ",
        "              ",
    ),
    "x": (
        "           ",
        "           ",
        "           ",
        "           ",
        "           ",
        " XXXX XXXX ",
        " XXXX XXXX ",
        "  XX   XX  ",
        "   XX XX   ",
        "    XXX    ",
        "   XX XX   ",
        "  XX   XX  ",
        " XXXX XXXX ",
        " XXXX XXXX ",
        "           ",
        "           ",
        "           ",
    ),
    "y": (
        "           ",
        "           ",
        "           ",
        "           ",
        "           ",
        " XXXX XXXX ",
        " XXXX XXXX ",
        "  XX   XX  ",
        "  XX   XX  ",
        "   XX XX   ",
        "   XX XX   ",
        "    XXXX   ",
        "    XXX    ",
        "     XX    ",
        " XX XX     ",
        " XXXXX     ",
        "  XXX      ",
    ),
    "z": (
        "          ",
        "          ",
        "          ",
        "          ",
        "          ",
        " XXXXXXXX ",
        " XXXXXXXX ",
        " XX   XXX ",
        "     XXX  ",
        "    XXX   ",
        "   XXX    ",
        "  XXX  XX ",
        " XXXXXXXX ",
        " XXXXXXXX ",
        "          ",
        "          ",
        "          ",
    ),
    "{": (
        "    XXX ",
        "   XXXX ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "  XXX   ",
        " XXX    ",
        " XXX    ",
        "  XXX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XXXX ",
        "    XXX ",
        "        ",
    ),
    "|": (
        "      ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
        "  XX  ",
    ),
    "}": (
        " XXX    ",
        " XXXX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XXX  ",
        "    XXX ",
        "    XXX ",
        "   XXX  ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        "   XX   ",
        " XXXX   ",
        " XXX    ",
        "        ",
    ),
    "~": (
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "  XXX       ",
        " XXXXXX  XX ",
        " XX  XXXXXX ",
        "       XXX  ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
        "            ",
    ),
}
"""The medium font dictionary. This dictionary contains the medium font characters.

:meta hide-value:
"""


small = {
    " ": (
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
        "      ",
    ),
    "!": (
        "  X  ",
        "  X  ",
        "  X  ",
        "  X  ",
        "  X  ",
        "  X  ",
        "     ",
        "  X  ",
        "  X  ",
        "     ",
    ),
    '"': (
        " XX XX ",
        " XX XX ",
        "  X  X ",
        " X  X  ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
    ),
    "#": (
        "    X X ",
        "    X X ",
        "  XXXXXX",
        "   X X  ",
        "   X X  ",
        "   X X  ",
        " XXXXXX ",
        "  X X   ",
        "  X X   ",
        "        ",
    ),
    "$": (
        "   X  ",
        "  XXX ",
        " X X X",
        " X X  ",
        "  XX  ",
        "   XX ",
        "   X X",
        " X X X",
        "  XXX ",
        "   X  ",
    ),
    "%": (
        "  X     ",
        " X X X  ",
        " X X X  ",
        "  X X   ",
        "    X   ",
        "   X  X ",
        "   X X X",
        "  X  X X",
        "  X   X ",
        "        ",
    ),
    "&": (
        "   XX   ",
        "  X  X  ",
        "  X  X  ",
        "  X X   ",
        "   X   X",
        "  X X X ",
        " X   X  ",
        " X   X  ",
        "  XXX XX",
        "        ",
    ),
    "'": (
        " XX ",
        " XX ",
        "  X ",
        " X  ",
        "    ",
        "    ",
        "    ",
        "    ",
        "    ",
        "    ",
    ),
    "(": (
        "   X ",
        "  X  ",
        "  X  ",
        " X   ",
        " X   ",
        " X   ",
        " X   ",
        "  X  ",
        "  X  ",
        "   X ",
    ),
    ")": (
        " X   ",
        "  X  ",
        "  X  ",
        "   X ",
        "   X ",
        "   X ",
        "   X ",
        "  X  ",
        "  X  ",
        " X   ",
    ),
    "*": (
        "       ",
        "   X   ",
        " X X X ",
        "  XXX  ",
        "   X   ",
        "  XXX  ",
        " X X X ",
        "   X   ",
        "       ",
        "       ",
    ),
    "+": (
        "        ",
        "    X   ",
        "    X   ",
        "    X   ",
        " XXXXXXX",
        "    X   ",
        "    X   ",
        "    X   ",
        "        ",
        "        ",
    ),
    ",": (
        "    ",
        "    ",
        "    ",
        "    ",
        "    ",
        "    ",
        "    ",
        " XX ",
        " XX ",
        "  X ",
    ),
    "-": (
        "        ",
        "        ",
        "        ",
        "        ",
        " XXXXXXX",
        "        ",
        "        ",
        "        ",
        "        ",
        "        ",
    ),
    ".": (
        "    ",
        "    ",
        "    ",
        "    ",
        "    ",
        "    ",
        "    ",
        " XX ",
        " XX ",
        "    ",
    ),
    "/": (
        "      ",
        "    X ",
        "    X ",
        "   X  ",
        "   X  ",
        "  X   ",
        "  X   ",
        " X    ",
        " X    ",
        "      ",
    ),
    "0": (
        "  XXXX  ",
        " X    X ",
        " X    X ",
        " X    X ",
        " X    X ",
        " X    X ",
        " X    X ",
        " X    X ",
        "  XXXX  ",
        "        ",
    ),
    "1": (
        "    X   ",
        "  XXX   ",
        "    X   ",
        "    X   ",
        "    X   ",
        "    X   ",
        "    X   ",
        "    X   ",
        "  XXXXX ",
        "        ",
    ),
    "2": (
        "  XXXX  ",
        " X    X ",
        " X    X ",
        "      X ",
        "     X  ",
        "   XX   ",
        "  X     ",
        " X    X ",
        " XXXXXX ",
        "        ",
    ),
    "3": (
        "  XXXX  ",
        " X    X ",
        " X    X ",
        "      X ",
        "   XXX  ",
        "      X ",
        " X    X ",
        " X    X ",
        "  XXXX  ",
        "        ",
    ),
    "4": (
        "    XX  ",
        "   X X  ",
        "   X X  ",
        "  X  X  ",
        "  X  X  ",
        " X   X  ",
        " XXXXXX ",
        "     X  ",
        "    XXX ",
        "        ",
    ),
    "5": (
        " XXXXXX ",
        " X      ",
        " X      ",
        " XXXXX  ",
        " X    X ",
        "      X ",
        "      X ",
        " X    X ",
        "  XXXX  ",
        "        ",
    ),
    "6": (
        "  XXXX  ",
        " X    X ",
        " X      ",
        " X      ",
        " XXXXX  ",
        " X    X ",
        " X    X ",
        " X    X ",
        "  XXXX  ",
        "        ",
    ),
    "7": (
        " XXXXXX ",
        " X    X ",
        " X   X  ",
        "     X  ",
        "    X   ",
        "    X   ",
        "   X    ",
        "   X    ",
        "   X    ",
        "        ",
    ),
    "8": (
        "  XXXX  ",
        " X    X ",
        " X    X ",
        " X    X ",
        "  XXXX  ",
        " X    X ",
        " X    X ",
        " X    X ",
        "  XXXX  ",
        "        ",
    ),
    "9": (
        "  XXXX  ",
        " X    X ",
        " X    X ",
        " X    X ",
        "  XXXXX ",
        "      X ",
        "      X ",
        " X    X ",
        "  XXXX  ",
        "        ",
    ),
    ":": (
        "    ",
        "    ",
        " XX ",
        " XX ",
        "    ",
        "    ",
        " XX ",
        " XX ",
        "    ",
        "    ",
    ),
    ";": (
        "    ",
        "    ",
        " XX ",
        " XX ",
        "    ",
        "    ",
        " XX ",
        " XX ",
        "  X ",
        " X  ",
    ),
    "<": (
        "      ",
        "    X ",
        "   X  ",
        "  X   ",
        " X    ",
        "  X   ",
        "   X  ",
        "    X ",
        "      ",
        "      ",
    ),
    "=": (
        "        ",
        "        ",
        "        ",
        " XXXXXXX",
        "        ",
        " XXXXXXX",
        "        ",
        "        ",
        "        ",
        "        ",
    ),
    ">": (
        "      ",
        " X    ",
        "  X   ",
        "   X  ",
        "    X ",
        "   X  ",
        "  X   ",
        " X    ",
        "      ",
        "      ",
    ),
    "?": (
        "  XXX  ",
        " X   X ",
        " X   X ",
        "    X  ",
        "   X   ",
        "   X   ",
        "       ",
        "   X   ",
        "   X   ",
        "       ",
    ),
    "@": (
        "   XXX  ",
        "  X   X ",
        " X  XX X",
        " X X X X",
        " X X X X",
        " X X X X",
        " X  XXX ",
        "  X     ",
        "   XXXX ",
        "        ",
    ),
    "A": (
        "    X   ",
        "    X   ",
        "   X X  ",
        "   X X  ",
        "  X   X ",
        "  X   X ",
        "  XXXXX ",
        " X     X",
        " X     X",
        "        ",
    ),
    "B": (
        " XXXXXX ",
        "  X    X",
        "  X    X",
        "  X    X",
        "  XXXXX ",
        "  X    X",
        "  X    X",
        "  X    X",
        " XXXXXX ",
        "        ",
    ),
    "C": (
        "   XXX X",
        "  X   XX",
        " X     X",
        " X      ",
        " X      ",
        " X      ",
        " X     X",
        "  X   X ",
        "   XXX  ",
        "        ",
    ),
    "D": (
        " XXXXX  ",
        "  X   X ",
        "  X    X",
        "  X    X",
        "  X    X",
        "  X    X",
        "  X    X",
        "  X   X ",
        " XXXXX  ",
        "        ",
    ),
    "E": (
        " XXXXXXX",
        "  X    X",
        "  X     ",
        "  X   X ",
        "  XXXXX ",
        "  X   X ",
        "  X     ",
        "  X    X",
        " XXXXXXX",
        "        ",
    ),
    "F": (
        " XXXXXXX",
        "  X    X",
        "  X     ",
        "  X   X ",
        "  XXXXX ",
        "  X   X ",
        "  X     ",
        "  X     ",
        " XXX    ",
        "        ",
    ),
    "G": (
        "   XXX X",
        "  X   XX",
        " X     X",
        " X      ",
        " X  XXXX",
        " X     X",
        " X     X",
        "  X   XX",
        "   XXX X",
        "        ",
    ),
    "H": (
        " XXX XXX",
        "  X   X ",
        "  X   X ",
        "  X   X ",
        "  XXXXX ",
        "  X   X ",
        "  X   X ",
        "  X   X ",
        " XXX XXX",
        "        ",
    ),
    "I": (
        " XXXXX",
        "   X  ",
        "   X  ",
        "   X  ",
        "   X  ",
        "   X  ",
        "   X  ",
        "   X  ",
        " XXXXX",
        "      ",
    ),
    "J": (
        "   XXXX",
        "     X ",
        "     X ",
        "     X ",
        "     X ",
        "     X ",
        " X   X ",
        " X   X ",
        "  XXX  ",
        "       ",
    ),
    "K": (
        " XXX XXX",
        "  X   X ",
        "  X  X  ",
        "  X X   ",
        "  XX X  ",
        "  X  X  ",
        "  X   X ",
        "  X   X ",
        " XXX XXX",
        "        ",
    ),
    "L": (
        " XXX    ",
        "  X     ",
        "  X     ",
        "  X     ",
        "  X     ",
        "  X     ",
        "  X    X",
        "  X    X",
        " XXXXXXX",
        "        ",
    ),
    "M": (
        " XX     XX",
        "  XX   XX ",
        "  XX   XX ",
        "  X X X X ",
        "  X X X X ",
        "  X X X X ",
        "  X  X  X ",
        "  X  X  X ",
        " XXX   XXX",
        "          ",
    ),
    "N": (
        " XX  XXX",
        "  XX  X ",
        "  XX  X ",
        "  X X X ",
        "  X X X ",
        "  X  XX ",
        "  X  XX ",
        "  X   X ",
        " XXX  X ",
        "        ",
    ),
    "O": (
        "   XXX  ",
        "  X   X ",
        " X     X",
        " X     X",
        " X     X",
        " X     X",
        " X     X",
        "  X   X ",
        "   XXX  ",
        "        ",
    ),
    "P": (
        " XXXXXX ",
        "  X    X",
        "  X    X",
        "  X    X",
        "  XXXXX ",
        "  X     ",
        "  X     ",
        "  X     ",
        " XXX    ",
        "        ",
    ),
    "Q": (
        "   XXX  ",
        "  X   X ",
        " X     X",
        " X     X",
        " X     X",
        " X     X",
        " X XXX X",
        "  X   X ",
        "   XXX X",
        "        ",
    ),
    "R": (
        " XXXXXX ",
        "  X    X",
        "  X    X",
        "  X    X",
        "  XXXXX ",
        "  X  X  ",
        "  X   X ",
        "  X   X ",
        " XXX   X",
        "        ",
    ),
    "S": (
        "  XXX X",
        " X   XX",
        " X    X",
        "  X    ",
        "   XX  ",
        "     X ",
        " X    X",
        " XX   X",
        " X XXX ",
        "       ",
    ),
    "T": (
        " XXXXXXX",
        " X  X  X",
        "    X   ",
        "    X   ",
        "    X   ",
        "    X   ",
        "    X   ",
        "    X   ",
        "   XXX  ",
        "        ",
    ),
    "U": (
        " XXX XXX",
        "  X   X ",
        "  X   X ",
        "  X   X ",
        "  X   X ",
        "  X   X ",
        "  X   X ",
        "  X   X ",
        "   XXX  ",
        "        ",
    ),
    "V": (
        " XXX XXX",
        "  X   X ",
        "  X   X ",
        "  X   X ",
        "   X X  ",
        "   X X  ",
        "   X X  ",
        "    X   ",
        "    X   ",
        "        ",
    ),
    "W": (
        " XXX X XXX",
        "  X  X  X ",
        "  X  X  X ",
        "  X X X X ",
        "  X X X X ",
        "  X X X X ",
        "   X   X  ",
        "   X   X  ",
        "   X   X  ",
        "          ",
    ),
    "X": (
        " XXX XXX",
        "  X   X ",
        "   X X  ",
        "   X X  ",
        "    X   ",
        "   X X  ",
        "   X X  ",
        "  X   X ",
        " XXX XXX",
        "        ",
    ),
    "Y": (
        " XXX XXX",
        "  X   X ",
        "  X   X ",
        "   X X  ",
        "   X X  ",
        "    X   ",
        "    X   ",
        "    X   ",
        "   XXX  ",
        "        ",
    ),
    "Z": (
        " XXXXXX",
        " X    X",
        "     X ",
        "     X ",
        "    X  ",
        "   X   ",
        "   X   ",
        "  X   X",
        " XXXXXX",
        "       ",
    ),
    "[": (
        " XXX ",
        " X   ",
        " X   ",
        " X   ",
        " X   ",
        " X   ",
        " X   ",
        " X   ",
        " X   ",
        " XXX ",
    ),
    "\\": (
        "      ",
        " X    ",
        " X    ",
        "  X   ",
        "  X   ",
        "   X  ",
        "   X  ",
        "    X ",
        "    X ",
        "      ",
    ),
    "]": (
        " XXX ",
        "   X ",
        "   X ",
        "   X ",
        "   X ",
        "   X ",
        "   X ",
        "   X ",
        "   X ",
        " XXX ",
    ),
    "^": (
        "   X   ",
        "  X X  ",
        " X   X ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
        "       ",
    ),
    "_": (
        "        ",
        "        ",
        "        ",
        "        ",
        "        ",
        "        ",
        "        ",
        "        ",
        " XXXXXXX",
        "        ",
    ),
    "`": (
        " X   ",
        "  X  ",
        "   X ",
        "     ",
        "     ",
        "     ",
        "     ",
        "     ",
        "     ",
        "     ",
    ),
    "a": (
        "       ",
        "       ",
        "       ",
        " XXXX  ",
        "     X ",
        "  XXXX ",
        " X   X ",
        " X   X ",
        "  XXX X",
        "       ",
    ),
    "b": (
        " XX    ",
        "  X    ",
        "  X    ",
        "  X XX ",
        "  XX  X",
        "  X   X",
        "  X   X",
        "  XX  X",
        "  X XX ",
        "       ",
    ),
    "c": (
        "      ",
        "      ",
        "      ",
        "  XXX ",
        " X   X",
        " X    ",
        " X    ",
        " X   X",
        "  XXX ",
        "      ",
    ),
    "d": (
        "    XX ",
        "     X ",
        "     X ",
        "  XX X ",
        " X  XX ",
        " X   X ",
        " X   X ",
        " X  XX ",
        "  XX XX",
        "       ",
    ),
    "e": (
        "      ",
        "      ",
        "      ",
        "  XXX ",
        " X   X",
        " XXXXX",
        " X    ",
        " X   X",
        "  XXX ",
        "      ",
    ),
    "f": (
        "   XX ",
        "  X  X",
        "  X   ",
        " XXXX ",
        "  X   ",
        "  X   ",
        "  X   ",
        "  X   ",
        " XXXX ",
        "      ",
    ),
    "g": (
        "       ",
        "       ",
        "       ",
        "  XXX X",
        " X   X ",
        "  XXX  ",
        " X     ",
        "  XXXX ",
        " X    X",
        "  XXXX ",
    ),
    "h": (
        " XX     ",
        "  X     ",
        "  X     ",
        "  X XX  ",
        "  XX  X ",
        "  X   X ",
        "  X   X ",
        "  X   X ",
        " XXX XXX",
        "        ",
    ),
    "i": (
        "  X ",
        "  X ",
        "    ",
        " XX ",
        "  X ",
        "  X ",
        "  X ",
        "  X ",
        " XXX",
        "    ",
    ),
    "j": (
        "    X ",
        "    X ",
        "      ",
        "   XX ",
        "    X ",
        "    X ",
        "    X ",
        " X  X ",
        "  XX  ",
        "      ",
    ),
    "k": (
        " XX     ",
        "  X     ",
        "  X     ",
        "  X XXX ",
        "  X  X  ",
        "  X X   ",
        "  XX X  ",
        "  X   X ",
        " XXX XXX",
        "        ",
    ),
    "l": (
        " XX ",
        "  X ",
        "  X ",
        "  X ",
        "  X ",
        "  X ",
        "  X ",
        "  X ",
        " XXX",
        "    ",
    ),
    "m": (
        "          ",
        "          ",
        "          ",
        " XX X  X  ",
        "  XX XX X ",
        "  X  X  X ",
        "  X  X  X ",
        "  X  X  X ",
        " XXX X XXX",
        "          ",
    ),
    "n": (
        "        ",
        "        ",
        "        ",
        " XX XX  ",
        "  XX  X ",
        "  X   X ",
        "  X   X ",
        "  X   X ",
        " XXX XXX",
        "        ",
    ),
    "o": (
        "      ",
        "      ",
        "      ",
        "  XXX ",
        " X   X",
        " X   X",
        " X   X",
        " X   X",
        "  XXX ",
        "      ",
    ),
    "p": (
        "       ",
        "       ",
        "       ",
        " XX XX ",
        "  XX  X",
        "  X   X",
        "  XX  X",
        "  X XX ",
        "  X    ",
        " XXX   ",
    ),
    "q": (
        "       ",
        "       ",
        "       ",
        "  XX XX",
        " X  XX ",
        " X   X ",
        " X  XX ",
        "  XX X ",
        "     X ",
        "    XXX",
    ),
    "r": (
        "      ",
        "      ",
        "      ",
        " XX X ",
        "  XX X",
        "  X   ",
        "  X   ",
        "  X   ",
        " XXX  ",
        "      ",
    ),
    "s": (
        "      ",
        "      ",
        "      ",
        "  XXX ",
        " X   X",
        "  XX  ",
        "    X ",
        " X   X",
        "  XXX ",
        "      ",
    ),
    "t": (
        "       ",
        "   X   ",
        "   X   ",
        " XXXXX ",
        "   X   ",
        "   X   ",
        "   X   ",
        "   X  X",
        "    XX ",
        "       ",
    ),
    "u": (
        "        ",
        "        ",
        "        ",
        " XX  XX ",
        "  X   X ",
        "  X   X ",
        "  X   X ",
        "  X  XX ",
        "   XX XX",
        "        ",
    ),
    "v": (
        "        ",
        "        ",
        "        ",
        " XXX XXX",
        "  X   X ",
        "  X   X ",
        "   X X  ",
        "   X X  ",
        "    X   ",
        "        ",
    ),
    "w": (
        "          ",
        "          ",
        "          ",
        " XXX X XXX",
        "  X  X  X ",
        "  X X X X ",
        "  X X X X ",
        "   X   X  ",
        "   X   X  ",
        "          ",
    ),
    "x": (
        "      ",
        "      ",
        "      ",
        " X   X",
        "  X X ",
        "   X  ",
        "   X  ",
        "  X X ",
        " X   X",
        "      ",
    ),
    "y": (
        "        ",
        "        ",
        "        ",
        " XXX XXX",
        "  X   X ",
        "   X X  ",
        "   X X  ",
        "    X   ",
        " X  X   ",
        "  XX    ",
    ),
    "z": (
        "      ",
        "      ",
        "      ",
        " XXXXX",
        " X   X",
        "    X ",
        "   X  ",
        "  X  X",
        " XXXXX",
        "      ",
    ),
    "{": (
        "   X ",
        "  X  ",
        "  X  ",
        "  X  ",
        " X   ",
        " X   ",
        "  X  ",
        "  X  ",
        "  X  ",
        "   X ",
    ),
    "|": (
        "  X ",
        "  X ",
        "  X ",
        "  X ",
        "  X ",
        "  X ",
        "  X ",
        "  X ",
        "  X ",
        "  X ",
    ),
    "}": (
        " X   ",
        "  X  ",
        "  X  ",
        "  X  ",
        "   X ",
        "   X ",
        "  X  ",
        "  X  ",
        "  X  ",
        " X   ",
    ),
    "~": (
        "        ",
        "        ",
        "        ",
        "  XX    ",
        " X  X  X",
        "     XX ",
        "        ",
        "        ",
        "        ",
        "        ",
    ),
}
"""The small font dictionary. This dictionary contains the small font characters.

:meta hide-value:
"""


_size_to_dict = {"small": small, "medium": medium, "large": large}
"""A dictionary that maps the size of the font to the font dictionary

:meta hide-value:
"""


def _get_char(char: str, size: str = "medium") -> tuple:
    """Gets the char_map of a character in a given size

    Gets the character from the dictionaries,
    serves as an interface for :file:`casioplot.py` to get the characters it needs

    :param char: The character
    :param size: The size of the character
    :return: A tuple of string that represent the character
    :raises ValueError: If the character is not implemented for the given size
    """
    if char not in _size_to_dict[size].keys():
        raise ValueError(f"Character '{char}' not implemented for size {size}")

    return _size_to_dict[size][char]
