"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AliasTargetInstance = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const instance_1 = require("./instance");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Instance that uses Route 53 Alias record type.
 *
 * Currently, the only resource types supported are Elastic Load
 * Balancers.
 *
 * @stability stable
 * @resource AWS::ServiceDiscovery::Instance
 */
class AliasTargetInstance extends instance_1.InstanceBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_servicediscovery_AliasTargetInstanceProps(props);
        if (props.service.namespace.type === namespace_1.NamespaceType.HTTP) {
            throw new Error('Namespace associated with Service must be a DNS Namespace.');
        }
        // Should already be enforced when creating service, but validates if service is not instantiated with #createService
        const dnsRecordType = props.service.dnsRecordType;
        if (dnsRecordType !== service_1.DnsRecordType.A
            && dnsRecordType !== service_1.DnsRecordType.AAAA
            && dnsRecordType !== service_1.DnsRecordType.A_AAAA) {
            throw new Error('Service must use `A` or `AAAA` records to register an AliasRecordTarget.');
        }
        if (props.service.routingPolicy !== service_1.RoutingPolicy.WEIGHTED) {
            throw new Error('Service must use `WEIGHTED` routing policy.');
        }
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceAttributes: {
                AWS_ALIAS_DNS_NAME: props.dnsName,
                ...props.customAttributes,
            },
            instanceId: props.instanceId || core_1.Names.uniqueId(this),
            serviceId: props.service.serviceId,
        });
        this.service = props.service;
        this.instanceId = resource.ref;
        this.dnsName = props.dnsName;
    }
}
exports.AliasTargetInstance = AliasTargetInstance;
_a = JSII_RTTI_SYMBOL_1;
AliasTargetInstance[_a] = { fqn: "@aws-cdk/aws-servicediscovery.AliasTargetInstance", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,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