"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNamespace = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Define an HTTP Namespace.
 *
 * @stability stable
 */
class HttpNamespace extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_servicediscovery_HttpNamespaceProps(props);
        const ns = new servicediscovery_generated_1.CfnHttpNamespace(this, 'Resource', {
            name: props.name,
            description: props.description,
        });
        this.namespaceName = props.name;
        this.namespaceId = ns.attrId;
        this.namespaceArn = ns.attrArn;
        this.type = namespace_1.NamespaceType.HTTP;
    }
    /**
     * @stability stable
     */
    static fromHttpNamespaceAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_servicediscovery_HttpNamespaceAttributes(attrs);
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.namespaceName = attrs.namespaceName;
                this.namespaceId = attrs.namespaceId;
                this.namespaceArn = attrs.namespaceArn;
                this.type = namespace_1.NamespaceType.HTTP;
            }
        }
        return new Import(scope, id);
    }
    /**
     * @stability stable
     * @attribute true
     */
    get httpNamespaceArn() { return this.namespaceArn; }
    /**
     * @stability stable
     * @attribute true
     */
    get httpNamespaceName() { return this.namespaceName; }
    /**
     * @stability stable
     * @attribute true
     */
    get httpNamespaceId() { return this.namespaceId; }
    /**
     * Creates a service within the namespace.
     *
     * @stability stable
     */
    createService(id, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_servicediscovery_BaseServiceProps(props);
        return new service_1.Service(this, id, {
            namespace: this,
            ...props,
        });
    }
}
exports.HttpNamespace = HttpNamespace;
_a = JSII_RTTI_SYMBOL_1;
HttpNamespace[_a] = { fqn: "@aws-cdk/aws-servicediscovery.HttpNamespace", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,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