import { IResource } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface INamespace extends IResource {
    /**
     * A name for the Namespace.
     *
     * @stability stable
     * @attribute true
     */
    readonly namespaceName: string;
    /**
     * Namespace Id for the Namespace.
     *
     * @stability stable
     * @attribute true
     */
    readonly namespaceId: string;
    /**
     * Namespace ARN for the Namespace.
     *
     * @stability stable
     * @attribute true
     */
    readonly namespaceArn: string;
    /**
     * Type of Namespace.
     *
     * @stability stable
     */
    readonly type: NamespaceType;
}
/**
 * @stability stable
 */
export interface BaseNamespaceProps {
    /**
     * A name for the Namespace.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * A description of the Namespace.
     *
     * @default none
     * @stability stable
     */
    readonly description?: string;
}
/**
 * @stability stable
 */
export declare enum NamespaceType {
    /**
     * Choose this option if you want your application to use only API calls to discover registered instances.
     *
     * @stability stable
     */
    HTTP = "HTTP",
    /**
     * Choose this option if you want your application to be able to discover instances using either API calls or using DNS queries in a VPC.
     *
     * @stability stable
     */
    DNS_PRIVATE = "DNS_PRIVATE",
    /**
     * Choose this option if you want your application to be able to discover instances using either API calls or using public DNS queries.
     *
     * You aren't required to use both methods.
     *
     * @stability stable
     */
    DNS_PUBLIC = "DNS_PUBLIC"
}
