import { Construct } from 'constructs';
import { BaseInstanceProps, InstanceBase } from './instance';
import { IService } from './service';
/**
 * @stability stable
 */
export interface NonIpInstanceBaseProps extends BaseInstanceProps {
}
/**
 * @stability stable
 */
export interface NonIpInstanceProps extends NonIpInstanceBaseProps {
    /**
     * The Cloudmap service this resource is registered to.
     *
     * @stability stable
     */
    readonly service: IService;
}
/**
 * Instance accessible using values other than an IP address or a domain name (CNAME).
 *
 * Specify the other values in Custom attributes.
 *
 * @stability stable
 * @resource AWS::ServiceDiscovery::Instance
 */
export declare class NonIpInstance extends InstanceBase {
    /**
     * The Id of the instance.
     *
     * @stability stable
     */
    readonly instanceId: string;
    /**
     * The Cloudmap service to which the instance is registered.
     *
     * @stability stable
     */
    readonly service: IService;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: NonIpInstanceProps);
}
