import * as ec2 from '@aws-cdk/aws-ec2';
import { Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { BaseNamespaceProps, INamespace, NamespaceType } from './namespace';
import { DnsServiceProps, Service } from './service';
/**
 * @stability stable
 */
export interface PrivateDnsNamespaceProps extends BaseNamespaceProps {
    /**
     * The Amazon VPC that you want to associate the namespace with.
     *
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
}
/**
 * @stability stable
 */
export interface IPrivateDnsNamespace extends INamespace {
}
/**
 * @stability stable
 */
export interface PrivateDnsNamespaceAttributes {
    /**
     * A name for the Namespace.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Namespace Id for the Namespace.
     *
     * @stability stable
     */
    readonly namespaceId: string;
    /**
     * Namespace ARN for the Namespace.
     *
     * @stability stable
     */
    readonly namespaceArn: string;
}
/**
 * Define a Service Discovery HTTP Namespace.
 *
 * @stability stable
 */
export declare class PrivateDnsNamespace extends Resource implements IPrivateDnsNamespace {
    /**
     * @stability stable
     */
    static fromPrivateDnsNamespaceAttributes(scope: Construct, id: string, attrs: PrivateDnsNamespaceAttributes): IPrivateDnsNamespace;
    /**
     * The name of the PrivateDnsNamespace.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Namespace Id of the PrivateDnsNamespace.
     *
     * @stability stable
     */
    readonly namespaceId: string;
    /**
     * Namespace Arn of the namespace.
     *
     * @stability stable
     */
    readonly namespaceArn: string;
    /**
     * Type of the namespace.
     *
     * @stability stable
     */
    readonly type: NamespaceType;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: PrivateDnsNamespaceProps);
    /**
     * @stability stable
     * @attribute true
     */
    get privateDnsNamespaceArn(): string;
    /**
     * @stability stable
     * @attribute true
     */
    get privateDnsNamespaceName(): string;
    /**
     * @stability stable
     * @attribute true
     */
    get privateDnsNamespaceId(): string;
    /**
     * Creates a service within the namespace.
     *
     * @stability stable
     */
    createService(id: string, props?: DnsServiceProps): Service;
}
