"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublicDnsNamespace = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Define a Public DNS Namespace.
 *
 * @stability stable
 */
class PublicDnsNamespace extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_servicediscovery_PublicDnsNamespaceProps(props);
        const ns = new servicediscovery_generated_1.CfnPublicDnsNamespace(this, 'Resource', {
            name: props.name,
            description: props.description,
        });
        this.namespaceName = props.name;
        this.namespaceId = ns.attrId;
        this.namespaceArn = ns.attrArn;
        this.type = namespace_1.NamespaceType.DNS_PUBLIC;
    }
    /**
     * @stability stable
     */
    static fromPublicDnsNamespaceAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_servicediscovery_PublicDnsNamespaceAttributes(attrs);
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.namespaceName = attrs.namespaceName;
                this.namespaceId = attrs.namespaceId;
                this.namespaceArn = attrs.namespaceArn;
                this.type = namespace_1.NamespaceType.DNS_PUBLIC;
            }
        }
        return new Import(scope, id);
    }
    /**
     * @stability stable
     * @attribute true
     */
    get publicDnsNamespaceArn() { return this.namespaceArn; }
    /**
     * @stability stable
     * @attribute true
     */
    get publicDnsNamespaceName() { return this.namespaceName; }
    /**
     * @stability stable
     * @attribute true
     */
    get publicDnsNamespaceId() { return this.namespaceId; }
    /**
     * Creates a service within the namespace.
     *
     * @stability stable
     */
    createService(id, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_servicediscovery_DnsServiceProps(props);
        return new service_1.Service(this, id, {
            namespace: this,
            ...props,
        });
    }
}
exports.PublicDnsNamespace = PublicDnsNamespace;
_a = JSII_RTTI_SYMBOL_1;
PublicDnsNamespace[_a] = { fqn: "@aws-cdk/aws-servicediscovery.PublicDnsNamespace", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,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