"""This module contains the ISO-4271 currency database in code form.

> Implementation notes
__style_modifiers__: 'ccw/nodisplay'
    THIS MODULE IS 100% AUTOMATICALLY GENERATED VIA THE CODEGEN SIDECAR
    (See sidecars_py).

    Do not modify it directly.
"""
from datetime import date
from typing import Annotated

from docnote import Note

from finnr._types import Singleton
from finnr.currency import Currency
from finnr.currency import CurrencySet

mint: Annotated[
    CurrencySet,
    Note('The ISO-4217 currency database.')
] = CurrencySet({
    Currency(
        code_alpha3='ADP',
        code_num=20,
        minor_unit_denominator=1,
        entities=frozenset({
            'AD'}),
        name='Andorran Peseta',
        approx_active_from=date(1869, 1, 1),
        approx_active_until=date(1999, 1, 1),),
    Currency(
        code_alpha3='AED',
        code_num=784,
        minor_unit_denominator=100,
        entities=frozenset({
            'AE'}),
        name='UAE Dirham',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='AFA',
        code_num=4,
        minor_unit_denominator=100,
        entities=frozenset({
            'AF'}),
        name='Afghani',
        approx_active_from=date(1925, 1, 1),
        approx_active_until=date(2003, 1, 31),),
    Currency(
        code_alpha3='AFN',
        code_num=971,
        minor_unit_denominator=100,
        entities=frozenset({
            'AF'}),
        name='Afghani',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='ALK',
        code_num=8,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'AL'}),
        name='Old Lek',
        approx_active_from=date(1946, 1, 1),
        approx_active_until=date(1989, 12, 31),),
    Currency(
        code_alpha3='ALL',
        code_num=8,
        minor_unit_denominator=100,
        entities=frozenset({
            'AL'}),
        name='Lek',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='AMD',
        code_num=51,
        minor_unit_denominator=100,
        entities=frozenset({
            'AM'}),
        name='Armenian Dram',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='ANG',
        code_num=532,
        minor_unit_denominator=100,
        entities=frozenset({
            'ANHH', 'NL', 'SX'}),
        name='Netherlands Antillean Guilder',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='AOA',
        code_num=973,
        minor_unit_denominator=100,
        entities=frozenset({
            'AO'}),
        name='Kwanza',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='AOK',
        code_num=24,
        minor_unit_denominator=1,
        entities=frozenset({
            'AO'}),
        name='Kwanza',
        approx_active_from=date(1977, 1, 8),
        approx_active_until=date(1990, 9, 24),),
    Currency(
        code_alpha3='AON',
        code_num=24,
        minor_unit_denominator=1,
        entities=frozenset({
            'AO'}),
        name='New Kwanza',
        approx_active_from=date(1990, 9, 25),
        approx_active_until=date(1995, 6, 30),),
    Currency(
        code_alpha3='AOR',
        code_num=982,
        minor_unit_denominator=1,
        entities=frozenset({
            'AO'}),
        name='Kwanza Reajustado',
        approx_active_from=date(1995, 7, 1),
        approx_active_until=date(1999, 11, 30),),
    Currency(
        code_alpha3='ARA',
        code_num=32,
        minor_unit_denominator=100,
        entities=frozenset({
            'AR'}),
        name='Austral',
        approx_active_from=date(1985, 6, 15),
        approx_active_until=date(1991, 12, 31),),
    Currency(
        code_alpha3='ARP',
        code_num=32,
        minor_unit_denominator=100,
        entities=frozenset({
            'AR'}),
        name='Peso Argentino',
        approx_active_from=date(1983, 6, 6),
        approx_active_until=date(1985, 6, 14),),
    Currency(
        code_alpha3='ARS',
        code_num=32,
        minor_unit_denominator=100,
        entities=frozenset({
            'AR'}),
        name='Argentine Peso',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='ARY',
        code_num=32,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'AR'}),
        name='Peso',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1983, 6, 6),),
    Currency(
        code_alpha3='ATS',
        code_num=40,
        minor_unit_denominator=100,
        entities=frozenset({
            'AT'}),
        name='Schilling',
        approx_active_from=date(1945, 1, 1),
        approx_active_until=date(1999, 1, 1),),
    Currency(
        code_alpha3='AUD',
        code_num=36,
        minor_unit_denominator=100,
        entities=frozenset({
            'AU', 'CC', 'CX', 'HM', 'KI', 'NF', 'NR', 'TV'}),
        name='Australian Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='AWG',
        code_num=533,
        minor_unit_denominator=100,
        entities=frozenset({
            'AW'}),
        name='Aruban Florin',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='AYM',
        code_num=945,
        minor_unit_denominator=1,
        entities=frozenset({
            'AZ'}),
        name='Azerbaijan Manat',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(2005, 10, 31),),
    Currency(
        code_alpha3='AZM',
        code_num=31,
        minor_unit_denominator=100,
        entities=frozenset({
            'AZ'}),
        name='Azerbaijanian Manat',
        approx_active_from=date(1992, 8, 15),
        approx_active_until=date(2006, 1, 1),),
    Currency(
        code_alpha3='AZN',
        code_num=944,
        minor_unit_denominator=100,
        entities=frozenset({
            'AZ'}),
        name='Azerbaijan Manat',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BAD',
        code_num=70,
        minor_unit_denominator=100,
        entities=frozenset({
            'BA'}),
        name='Dinar',
        approx_active_from=date(1992, 7, 1),
        approx_active_until=date(1998, 2, 4),),
    Currency(
        code_alpha3='BAM',
        code_num=977,
        minor_unit_denominator=100,
        entities=frozenset({
            'BA'}),
        name='Convertible Mark',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BBD',
        code_num=52,
        minor_unit_denominator=100,
        entities=frozenset({
            'BB'}),
        name='Barbados Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BDT',
        code_num=50,
        minor_unit_denominator=100,
        entities=frozenset({
            'BD'}),
        name='Taka',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BEC',
        code_num=993,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'BE'}),
        name='Convertible Franc',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1990, 5, 1),),
    Currency(
        code_alpha3='BEF',
        code_num=56,
        minor_unit_denominator=100,
        entities=frozenset({
            'BE'}),
        name='Belgian Franc',
        approx_active_from=date(1832, 1, 1),
        approx_active_until=date(1999, 1, 1),),
    Currency(
        code_alpha3='BEL',
        code_num=992,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'BE'}),
        name='Financial Franc',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1990, 3, 31),),
    Currency(
        code_alpha3='BGJ',
        code_num=100,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'BG'}),
        name='Lev A/52',
        approx_active_from=date(1881, 1, 1),
        approx_active_until=date(1952, 12, 31),),
    Currency(
        code_alpha3='BGK',
        code_num=100,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'BG'}),
        name='Lev A/62',
        approx_active_from=date(1952, 1, 1),
        approx_active_until=date(1962, 12, 31),),
    Currency(
        code_alpha3='BGL',
        code_num=100,
        minor_unit_denominator=100,
        entities=frozenset({
            'BG'}),
        name='Lev',
        approx_active_from=date(1962, 1, 1),
        approx_active_until=date(1999, 8, 31),),
    Currency(
        code_alpha3='BGN',
        code_num=975,
        minor_unit_denominator=100,
        entities=frozenset({
            'BG'}),
        name='Bulgarian Lev',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BHD',
        code_num=48,
        minor_unit_denominator=1000,
        entities=frozenset({
            'BH'}),
        name='Bahraini Dinar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BIF',
        code_num=108,
        minor_unit_denominator=1,
        entities=frozenset({
            'BI'}),
        name='Burundi Franc',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BMD',
        code_num=60,
        minor_unit_denominator=100,
        entities=frozenset({
            'BM'}),
        name='Bermudian Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BND',
        code_num=96,
        minor_unit_denominator=100,
        entities=frozenset({
            'BN'}),
        name='Brunei Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BOB',
        code_num=68,
        minor_unit_denominator=100,
        entities=frozenset({
            'BO'}),
        name='Boliviano',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BOP',
        code_num=68,
        minor_unit_denominator=100,
        entities=frozenset({
            'BO'}),
        name='Peso boliviano',
        approx_active_from=date(1963, 1, 1),
        approx_active_until=date(1987, 1, 1),),
    Currency(
        code_alpha3='BOV',
        code_num=984,
        minor_unit_denominator=100,
        entities=frozenset({
            'BO'}),
        name='Mvdol',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BRB',
        code_num=76,
        minor_unit_denominator=100,
        entities=frozenset({
            'BR'}),
        name='Cruzeiro',
        approx_active_from=date(1967, 1, 1),
        approx_active_until=date(1986, 2, 28),),
    Currency(
        code_alpha3='BRC',
        code_num=76,
        minor_unit_denominator=100,
        entities=frozenset({
            'BR'}),
        name='Cruzado',
        approx_active_from=date(1986, 2, 28),
        approx_active_until=date(1989, 1, 15),),
    Currency(
        code_alpha3='BRE',
        code_num=76,
        minor_unit_denominator=100,
        entities=frozenset({
            'BR'}),
        name='Cruzeiro',
        approx_active_from=date(1990, 3, 15),
        approx_active_until=date(1993, 8, 1),),
    Currency(
        code_alpha3='BRL',
        code_num=986,
        minor_unit_denominator=100,
        entities=frozenset({
            'BR'}),
        name='Brazilian Real',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BRN',
        code_num=76,
        minor_unit_denominator=100,
        entities=frozenset({
            'BR'}),
        name='New Cruzado',
        approx_active_from=date(1989, 1, 16),
        approx_active_until=date(1990, 3, 15),),
    Currency(
        code_alpha3='BRR',
        code_num=987,
        minor_unit_denominator=100,
        entities=frozenset({
            'BR'}),
        name='Cruzeiro Real',
        approx_active_from=date(1993, 8, 1),
        approx_active_until=date(1994, 6, 30),),
    Currency(
        code_alpha3='BSD',
        code_num=44,
        minor_unit_denominator=100,
        entities=frozenset({
            'BS'}),
        name='Bahamian Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BTN',
        code_num=64,
        minor_unit_denominator=100,
        entities=frozenset({
            'BT'}),
        name='Ngultrum',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BUK',
        code_num=104,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'BUMM'}),
        name='Kyat',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1990, 2, 28),),
    Currency(
        code_alpha3='BWP',
        code_num=72,
        minor_unit_denominator=100,
        entities=frozenset({
            'BW'}),
        name='Pula',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BYB',
        code_num=112,
        minor_unit_denominator=100,
        entities=frozenset({
            'BY'}),
        name='Belarusian Ruble',
        approx_active_from=date(1992, 1, 1),
        approx_active_until=date(1999, 12, 31),),
    Currency(
        code_alpha3='BYN',
        code_num=933,
        minor_unit_denominator=100,
        entities=frozenset({
            'BY'}),
        name='Belarusian Ruble',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='BYR',
        code_num=974,
        minor_unit_denominator=1,
        entities=frozenset({
            'BY'}),
        name='Belarusian Ruble',
        approx_active_from=date(2000, 1, 1),
        approx_active_until=date(2016, 6, 30),),
    Currency(
        code_alpha3='BZD',
        code_num=84,
        minor_unit_denominator=100,
        entities=frozenset({
            'BZ'}),
        name='Belize Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='CAD',
        code_num=124,
        minor_unit_denominator=100,
        entities=frozenset({
            'CA'}),
        name='Canadian Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='CDF',
        code_num=976,
        minor_unit_denominator=100,
        entities=frozenset({
            'CD'}),
        name='Congolese Franc',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='CHC',
        code_num=948,
        minor_unit_denominator=100,
        entities=frozenset({
            'CH'}),
        name='WIR Franc (for electronic)',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(2004, 11, 30),),
    Currency(
        code_alpha3='CHE',
        code_num=947,
        minor_unit_denominator=100,
        entities=frozenset({
            'CH'}),
        name='WIR Euro',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='CHF',
        code_num=756,
        minor_unit_denominator=100,
        entities=frozenset({
            'CH', 'LI'}),
        name='Swiss Franc',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='CHW',
        code_num=948,
        minor_unit_denominator=100,
        entities=frozenset({
            'CH'}),
        name='WIR Franc',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='CLF',
        code_num=990,
        minor_unit_denominator=10000,
        entities=frozenset({
            'CL'}),
        name='Unidad de Fomento',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='CLP',
        code_num=152,
        minor_unit_denominator=1,
        entities=frozenset({
            'CL'}),
        name='Chilean Peso',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='CNY',
        code_num=156,
        minor_unit_denominator=100,
        entities=frozenset({
            'CN'}),
        name='Yuan Renminbi',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='COP',
        code_num=170,
        minor_unit_denominator=100,
        entities=frozenset({
            'CO'}),
        name='Colombian Peso',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='COU',
        code_num=970,
        minor_unit_denominator=100,
        entities=frozenset({
            'CO'}),
        name='Unidad de Valor Real',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='CRC',
        code_num=188,
        minor_unit_denominator=100,
        entities=frozenset({
            'CR'}),
        name='Costa Rican Colon',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='CSD',
        code_num=891,
        minor_unit_denominator=100,
        entities=frozenset({
            'CSXX'}),
        name='Serbian Dinar',
        approx_active_from=date(2003, 7, 3),
        approx_active_until=date(2006, 10, 25),),
    Currency(
        code_alpha3='CSJ',
        code_num=203,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'CSHH'}),
        name='Krona A/53',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1953, 12, 31),),
    Currency(
        code_alpha3='CSK',
        code_num=200,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'CSHH'}),
        name='Koruna',
        approx_active_from=date(1953, 1, 1),
        approx_active_until=date(1993, 2, 8),),
    Currency(
        code_alpha3='CUC',
        code_num=931,
        minor_unit_denominator=100,
        entities=frozenset({
            'CU'}),
        name='Peso Convertible',
        approx_active_from=date(2009, 3, 1),
        approx_active_until=date(2021, 6, 30),),
    Currency(
        code_alpha3='CUP',
        code_num=192,
        minor_unit_denominator=100,
        entities=frozenset({
            'CU'}),
        name='Cuban Peso',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='CVE',
        code_num=132,
        minor_unit_denominator=100,
        entities=frozenset({
            'CV'}),
        name='Cabo Verde Escudo',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='CYP',
        code_num=196,
        minor_unit_denominator=100,
        entities=frozenset({
            'CY'}),
        name='Cyprus Pound',
        approx_active_from=date(1879, 1, 1),
        approx_active_until=date(2006, 1, 1),),
    Currency(
        code_alpha3='CZK',
        code_num=203,
        minor_unit_denominator=100,
        entities=frozenset({
            'CZ'}),
        name='Czech Koruna',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='DDM',
        code_num=278,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'DDDE'}),
        name='Mark der DDR',
        approx_active_from=date(1948, 6, 21),
        approx_active_until=date(1990, 7, 1),),
    Currency(
        code_alpha3='DEM',
        code_num=276,
        minor_unit_denominator=100,
        entities=frozenset({
            'DE'}),
        name='Deutsche Mark',
        approx_active_from=date(1948, 1, 1),
        approx_active_until=date(1999, 1, 1),),
    Currency(
        code_alpha3='DJF',
        code_num=262,
        minor_unit_denominator=1,
        entities=frozenset({
            'DJ'}),
        name='Djibouti Franc',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='DKK',
        code_num=208,
        minor_unit_denominator=100,
        entities=frozenset({
            'DK', 'FO', 'GL'}),
        name='Danish Krone',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='DOP',
        code_num=214,
        minor_unit_denominator=100,
        entities=frozenset({
            'DO'}),
        name='Dominican Peso',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='DZD',
        code_num=12,
        minor_unit_denominator=100,
        entities=frozenset({
            'DZ'}),
        name='Algerian Dinar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='ECS',
        code_num=218,
        minor_unit_denominator=1,
        entities=frozenset({
            'EC'}),
        name='Sucre',
        approx_active_from=date(1884, 1, 1),
        approx_active_until=date(2000, 2, 29),),
    Currency(
        code_alpha3='ECV',
        code_num=983,
        minor_unit_denominator=100,
        entities=frozenset({
            'EC'}),
        name='Unidad de Valor Constante (UVC)',
        approx_active_from=date(1993, 1, 1),
        approx_active_until=date(2000, 2, 29),),
    Currency(
        code_alpha3='EEK',
        code_num=233,
        minor_unit_denominator=100,
        entities=frozenset({
            'EE'}),
        name='Kroon',
        approx_active_from=date(1992, 1, 1),
        approx_active_until=date(2011, 1, 1),),
    Currency(
        code_alpha3='EGP',
        code_num=818,
        minor_unit_denominator=100,
        entities=frozenset({
            'EG'}),
        name='Egyptian Pound',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='ERN',
        code_num=232,
        minor_unit_denominator=100,
        entities=frozenset({
            'ER'}),
        name='Nakfa',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='ESA',
        code_num=996,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'ES'}),
        name='Spanish Peseta',
        approx_active_from=date(1978, 1, 1),
        approx_active_until=date(1981, 12, 31),),
    Currency(
        code_alpha3='ESB',
        code_num=995,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'ES'}),
        name='"A" Account (convertible Peseta Account)',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1994, 12, 31),),
    Currency(
        code_alpha3='ESP',
        code_num=724,
        minor_unit_denominator=1,
        entities=frozenset({
            'AD', 'ES'}),
        name='Spanish Peseta',
        approx_active_from=date(1869, 1, 1),
        approx_active_until=date(1999, 1, 1),),
    Currency(
        code_alpha3='ETB',
        code_num=230,
        minor_unit_denominator=100,
        entities=frozenset({
            'ET'}),
        name='Ethiopian Birr',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='EUR',
        code_num=978,
        minor_unit_denominator=100,
        entities=frozenset({
            'AD', 'AT', 'AX', 'BE', 'BL', 'CSXX', 'CY', 'DE', 'EE',
            'ES', 'EU', 'FI', 'FR', 'GF', 'GP', 'GR', 'HR', 'IE',
            'IT', 'LT', 'LU', 'LV', 'MC', 'ME', 'MF', 'MQ', 'MT',
            'NL', 'PM', 'PT', 'RE', 'SI', 'SK', 'SM', 'TF', 'VA', 'YT'}),
        name='Euro',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='FIM',
        code_num=246,
        minor_unit_denominator=100,
        entities=frozenset({
            'AX', 'FI'}),
        name='Markka',
        approx_active_from=date(1860, 1, 1),
        approx_active_until=date(1999, 1, 1),),
    Currency(
        code_alpha3='FJD',
        code_num=242,
        minor_unit_denominator=100,
        entities=frozenset({
            'FJ'}),
        name='Fiji Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='FKP',
        code_num=238,
        minor_unit_denominator=100,
        entities=frozenset({
            'FK'}),
        name='Falkland Islands Pound',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='FRF',
        code_num=250,
        minor_unit_denominator=100,
        entities=frozenset({
            'AD', 'FR', 'GF', 'GP', 'MC', 'MF', 'MQ', 'PM', 'RE',
            'TF', 'YT'}),
        name='French Franc',
        approx_active_from=date(1960, 1, 1),
        approx_active_until=date(1999, 1, 1),),
    Currency(
        code_alpha3='GBP',
        code_num=826,
        minor_unit_denominator=100,
        entities=frozenset({
            'GB', 'GG', 'IM', 'JE'}),
        name='Pound Sterling',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='GEK',
        code_num=268,
        minor_unit_denominator=1,
        entities=frozenset({
            'GE'}),
        name='Georgian Coupon',
        approx_active_from=date(1993, 4, 5),
        approx_active_until=date(1995, 10, 2),),
    Currency(
        code_alpha3='GEL',
        code_num=981,
        minor_unit_denominator=100,
        entities=frozenset({
            'GE'}),
        name='Lari',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='GHC',
        code_num=288,
        minor_unit_denominator=100,
        entities=frozenset({
            'GH'}),
        name='Cedi',
        approx_active_from=date(1967, 1, 1),
        approx_active_until=date(2007, 7, 1),),
    Currency(
        code_alpha3='GHP',
        code_num=939,
        minor_unit_denominator=100,
        entities=frozenset({
            'GH'}),
        name='Ghana Cedi',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(2007, 6, 18),),
    Currency(
        code_alpha3='GHS',
        code_num=936,
        minor_unit_denominator=100,
        entities=frozenset({
            'GH'}),
        name='Ghana Cedi',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='GIP',
        code_num=292,
        minor_unit_denominator=100,
        entities=frozenset({
            'GI'}),
        name='Gibraltar Pound',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='GMD',
        code_num=270,
        minor_unit_denominator=100,
        entities=frozenset({
            'GM'}),
        name='Dalasi',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='GNE',
        code_num=324,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'GN'}),
        name='Syli',
        approx_active_from=date(1971, 1, 1),
        approx_active_until=date(1985, 12, 31),),
    Currency(
        code_alpha3='GNF',
        code_num=324,
        minor_unit_denominator=1,
        entities=frozenset({
            'GN'}),
        name='Guinean Franc',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='GNS',
        code_num=324,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'GN'}),
        name='Syli',
        approx_active_from=date(1971, 1, 1),
        approx_active_until=date(1986, 2, 28),),
    Currency(
        code_alpha3='GQE',
        code_num=226,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'GQ'}),
        name='Ekwele',
        approx_active_from=date(1975, 1, 1),
        approx_active_until=date(1985, 12, 31),),
    Currency(
        code_alpha3='GRD',
        code_num=300,
        minor_unit_denominator=100,
        entities=frozenset({
            'GR'}),
        name='Drachma',
        approx_active_from=date(1954, 5, 1),
        approx_active_until=date(2001, 1, 1),),
    Currency(
        code_alpha3='GTQ',
        code_num=320,
        minor_unit_denominator=100,
        entities=frozenset({
            'GT'}),
        name='Quetzal',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='GWE',
        code_num=624,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'GW'}),
        name='Guinea Escudo',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1981, 12, 31),),
    Currency(
        code_alpha3='GWP',
        code_num=624,
        minor_unit_denominator=100,
        entities=frozenset({
            'GW'}),
        name='Guinea-Bissau Peso',
        approx_active_from=date(1975, 1, 1),
        approx_active_until=date(1997, 5, 31),),
    Currency(
        code_alpha3='GYD',
        code_num=328,
        minor_unit_denominator=100,
        entities=frozenset({
            'GY'}),
        name='Guyana Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='HKD',
        code_num=344,
        minor_unit_denominator=100,
        entities=frozenset({
            'HK'}),
        name='Hong Kong Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='HNL',
        code_num=340,
        minor_unit_denominator=100,
        entities=frozenset({
            'HN'}),
        name='Lempira',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='HRD',
        code_num=191,
        minor_unit_denominator=100,
        entities=frozenset({
            'HR'}),
        name='Croatian Dinar',
        approx_active_from=date(1991, 12, 23),
        approx_active_until=date(1994, 5, 30),),
    Currency(
        code_alpha3='HRK',
        code_num=191,
        minor_unit_denominator=100,
        entities=frozenset({
            'HR'}),
        name='Croatian Kuna',
        approx_active_from=date(1994, 5, 30),
        approx_active_until=date(2023, 1, 1),),
    Currency(
        code_alpha3='HTG',
        code_num=332,
        minor_unit_denominator=100,
        entities=frozenset({
            'HT'}),
        name='Gourde',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='HUF',
        code_num=348,
        minor_unit_denominator=100,
        entities=frozenset({
            'HU'}),
        name='Forint',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='IDR',
        code_num=360,
        minor_unit_denominator=100,
        entities=frozenset({
            'ID', 'TL'}),
        name='Rupiah',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='IEP',
        code_num=372,
        minor_unit_denominator=100,
        entities=frozenset({
            'IE'}),
        name='Irish Pound',
        approx_active_from=date(1938, 1, 1),
        approx_active_until=date(1999, 1, 1),),
    Currency(
        code_alpha3='ILP',
        code_num=376,
        minor_unit_denominator=1000,
        entities=frozenset({
            'IL'}),
        name='Pound',
        approx_active_from=date(1948, 1, 1),
        approx_active_until=date(1980, 2, 20),),
    Currency(
        code_alpha3='ILR',
        code_num=376,
        minor_unit_denominator=100,
        entities=frozenset({
            'IL'}),
        name='Old Shekel',
        approx_active_from=date(1980, 2, 24),
        approx_active_until=date(1985, 12, 31),),
    Currency(
        code_alpha3='ILS',
        code_num=376,
        minor_unit_denominator=100,
        entities=frozenset({
            'IL'}),
        name='New Israeli Sheqel',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='INR',
        code_num=356,
        minor_unit_denominator=100,
        entities=frozenset({
            'BT', 'IN'}),
        name='Indian Rupee',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='IQD',
        code_num=368,
        minor_unit_denominator=1000,
        entities=frozenset({
            'IQ'}),
        name='Iraqi Dinar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='IRR',
        code_num=364,
        minor_unit_denominator=100,
        entities=frozenset({
            'IR'}),
        name='Iranian Rial',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='ISJ',
        code_num=352,
        minor_unit_denominator=100,
        entities=frozenset({
            'IS'}),
        name='Old Krona',
        approx_active_from=date(1922, 1, 1),
        approx_active_until=date(1981, 6, 30),),
    Currency(
        code_alpha3='ISK',
        code_num=352,
        minor_unit_denominator=1,
        entities=frozenset({
            'IS'}),
        name='Iceland Krona',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='ITL',
        code_num=380,
        minor_unit_denominator=1,
        entities=frozenset({
            'IT', 'SM', 'VA'}),
        name='Italian Lira',
        approx_active_from=date(1861, 1, 1),
        approx_active_until=date(1999, 1, 1),),
    Currency(
        code_alpha3='JMD',
        code_num=388,
        minor_unit_denominator=100,
        entities=frozenset({
            'JM'}),
        name='Jamaican Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='JOD',
        code_num=400,
        minor_unit_denominator=1000,
        entities=frozenset({
            'JO'}),
        name='Jordanian Dinar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='JPY',
        code_num=392,
        minor_unit_denominator=1,
        entities=frozenset({
            'JP'}),
        name='Yen',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='KES',
        code_num=404,
        minor_unit_denominator=100,
        entities=frozenset({
            'KE'}),
        name='Kenyan Shilling',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='KGS',
        code_num=417,
        minor_unit_denominator=100,
        entities=frozenset({
            'KG'}),
        name='Som',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='KHR',
        code_num=116,
        minor_unit_denominator=100,
        entities=frozenset({
            'KH'}),
        name='Riel',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='KMF',
        code_num=174,
        minor_unit_denominator=1,
        entities=frozenset({
            'KM'}),
        name='Comorian Franc ',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='KPW',
        code_num=408,
        minor_unit_denominator=100,
        entities=frozenset({
            'KP'}),
        name='North Korean Won',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='KRW',
        code_num=410,
        minor_unit_denominator=1,
        entities=frozenset({
            'KR'}),
        name='Won',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='KWD',
        code_num=414,
        minor_unit_denominator=1000,
        entities=frozenset({
            'KW'}),
        name='Kuwaiti Dinar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='KYD',
        code_num=136,
        minor_unit_denominator=100,
        entities=frozenset({
            'KY'}),
        name='Cayman Islands Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='KZT',
        code_num=398,
        minor_unit_denominator=100,
        entities=frozenset({
            'KZ'}),
        name='Tenge',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='LAJ',
        code_num=418,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'LAO'}),
        name='Pathet Lao Kip',
        approx_active_from=date(1965, 1, 1),
        approx_active_until=date(1979, 12, 31),),
    Currency(
        code_alpha3='LAK',
        code_num=418,
        minor_unit_denominator=100,
        entities=frozenset({
            'LA'}),
        name='Lao Kip',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='LBP',
        code_num=422,
        minor_unit_denominator=100,
        entities=frozenset({
            'LB'}),
        name='Lebanese Pound',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='LKR',
        code_num=144,
        minor_unit_denominator=100,
        entities=frozenset({
            'LK'}),
        name='Sri Lanka Rupee',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='LRD',
        code_num=430,
        minor_unit_denominator=100,
        entities=frozenset({
            'LR'}),
        name='Liberian Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='LSL',
        code_num=426,
        minor_unit_denominator=100,
        entities=frozenset({
            'LS'}),
        name='Loti',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='LSM',
        code_num=426,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'LS'}),
        name='Loti',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1985, 5, 31),),
    Currency(
        code_alpha3='LTL',
        code_num=440,
        minor_unit_denominator=100,
        entities=frozenset({
            'LT'}),
        name='Lithuanian Litas',
        approx_active_from=date(1993, 1, 1),
        approx_active_until=date(2015, 1, 1),),
    Currency(
        code_alpha3='LTT',
        code_num=440,
        minor_unit_denominator=100,
        entities=frozenset({
            'LT'}),
        name='Talonas',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1993, 7, 31),),
    Currency(
        code_alpha3='LUC',
        code_num=989,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'LU'}),
        name='Luxembourg Convertible Franc',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1990, 3, 31),),
    Currency(
        code_alpha3='LUF',
        code_num=442,
        minor_unit_denominator=100,
        entities=frozenset({
            'LU'}),
        name='Luxembourg Franc',
        approx_active_from=date(1944, 1, 1),
        approx_active_until=date(1999, 1, 1),),
    Currency(
        code_alpha3='LUL',
        code_num=988,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'LU'}),
        name='Luxembourg Financial Franc',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1990, 3, 31),),
    Currency(
        code_alpha3='LVL',
        code_num=428,
        minor_unit_denominator=100,
        entities=frozenset({
            'LV'}),
        name='Latvian Lats',
        approx_active_from=date(1993, 3, 5),
        approx_active_until=date(2014, 1, 1),),
    Currency(
        code_alpha3='LVR',
        code_num=428,
        minor_unit_denominator=100,
        entities=frozenset({
            'LV'}),
        name='Latvian Ruble',
        approx_active_from=date(1992, 5, 4),
        approx_active_until=date(1993, 3, 5),),
    Currency(
        code_alpha3='LYD',
        code_num=434,
        minor_unit_denominator=1000,
        entities=frozenset({
            'LY'}),
        name='Libyan Dinar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MAD',
        code_num=504,
        minor_unit_denominator=100,
        entities=frozenset({
            'EH', 'MA'}),
        name='Moroccan Dirham',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MDL',
        code_num=498,
        minor_unit_denominator=100,
        entities=frozenset({
            'MD'}),
        name='Moldovan Leu',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MGA',
        code_num=969,
        minor_unit_denominator=5,
        entities=frozenset({
            'MG'}),
        name='Malagasy Ariary',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MGF',
        code_num=450,
        minor_unit_denominator=1,
        entities=frozenset({
            'MG'}),
        name='Malagasy Franc',
        approx_active_from=date(1963, 7, 1),
        approx_active_until=date(2005, 1, 1),),
    Currency(
        code_alpha3='MKD',
        code_num=807,
        minor_unit_denominator=100,
        entities=frozenset({
            'MK'}),
        name='Denar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MLF',
        code_num=466,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'ML'}),
        name='Mali Franc',
        approx_active_from=date(1962, 1, 1),
        approx_active_until=date(1984, 1, 1),),
    Currency(
        code_alpha3='MMK',
        code_num=104,
        minor_unit_denominator=100,
        entities=frozenset({
            'MM'}),
        name='Kyat',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MNT',
        code_num=496,
        minor_unit_denominator=100,
        entities=frozenset({
            'MN'}),
        name='Tugrik',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MOP',
        code_num=446,
        minor_unit_denominator=100,
        entities=frozenset({
            'MO'}),
        name='Pataca',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MRO',
        code_num=478,
        minor_unit_denominator=100,
        entities=frozenset({
            'MR'}),
        name='Ouguiya',
        approx_active_from=date(1973, 6, 29),
        approx_active_until=date(2018, 1, 1),),
    Currency(
        code_alpha3='MRU',
        code_num=929,
        minor_unit_denominator=5,
        entities=frozenset({
            'MR'}),
        name='Ouguiya',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MTL',
        code_num=470,
        minor_unit_denominator=100,
        entities=frozenset({
            'MT'}),
        name='Maltese Lira',
        approx_active_from=date(1972, 5, 26),
        approx_active_until=date(2006, 1, 1),),
    Currency(
        code_alpha3='MTP',
        code_num=470,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'MT'}),
        name='Maltese Pound',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1983, 6, 30),),
    Currency(
        code_alpha3='MUR',
        code_num=480,
        minor_unit_denominator=100,
        entities=frozenset({
            'MU'}),
        name='Mauritius Rupee',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MVQ',
        code_num=462,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'MV'}),
        name='Maldive Rupee',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1981, 12, 31),),
    Currency(
        code_alpha3='MVR',
        code_num=462,
        minor_unit_denominator=100,
        entities=frozenset({
            'MV'}),
        name='Rufiyaa',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MWK',
        code_num=454,
        minor_unit_denominator=100,
        entities=frozenset({
            'MW'}),
        name='Malawi Kwacha',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MXN',
        code_num=484,
        minor_unit_denominator=100,
        entities=frozenset({
            'MX'}),
        name='Mexican Peso',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MXP',
        code_num=484,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'MX'}),
        name='Mexican Peso',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1993, 3, 31),),
    Currency(
        code_alpha3='MXV',
        code_num=979,
        minor_unit_denominator=100,
        entities=frozenset({
            'MX'}),
        name='Mexican Unidad de Inversion (UDI)',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MYR',
        code_num=458,
        minor_unit_denominator=100,
        entities=frozenset({
            'MY'}),
        name='Malaysian Ringgit',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='MZE',
        code_num=508,
        minor_unit_denominator=100,
        entities=frozenset({
            'MZ'}),
        name='Mozambique Escudo',
        approx_active_from=date(1914, 1, 1),
        approx_active_until=date(1980, 12, 31),),
    Currency(
        code_alpha3='MZM',
        code_num=508,
        minor_unit_denominator=100,
        entities=frozenset({
            'MZ'}),
        name='Mozambique Metical',
        approx_active_from=date(1980, 1, 1),
        approx_active_until=date(2006, 6, 30),),
    Currency(
        code_alpha3='MZN',
        code_num=943,
        minor_unit_denominator=100,
        entities=frozenset({
            'MZ'}),
        name='Mozambique Metical',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='NAD',
        code_num=516,
        minor_unit_denominator=100,
        entities=frozenset({
            'NA'}),
        name='Namibia Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='NGN',
        code_num=566,
        minor_unit_denominator=100,
        entities=frozenset({
            'NG'}),
        name='Naira',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='NIC',
        code_num=558,
        minor_unit_denominator=100,
        entities=frozenset({
            'NI'}),
        name='Cordoba',
        approx_active_from=date(1988, 1, 1),
        approx_active_until=date(1990, 10, 31),),
    Currency(
        code_alpha3='NIO',
        code_num=558,
        minor_unit_denominator=100,
        entities=frozenset({
            'NI'}),
        name='Cordoba Oro',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='NLG',
        code_num=528,
        minor_unit_denominator=100,
        entities=frozenset({
            'NL'}),
        name='Netherlands Guilder',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1999, 1, 1),),
    Currency(
        code_alpha3='NOK',
        code_num=578,
        minor_unit_denominator=100,
        entities=frozenset({
            'BV', 'NO', 'SJ'}),
        name='Norwegian Krone',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='NPR',
        code_num=524,
        minor_unit_denominator=100,
        entities=frozenset({
            'NP'}),
        name='Nepalese Rupee',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='NZD',
        code_num=554,
        minor_unit_denominator=100,
        entities=frozenset({
            'CK', 'NU', 'NZ', 'PN', 'TK'}),
        name='New Zealand Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='OMR',
        code_num=512,
        minor_unit_denominator=1000,
        entities=frozenset({
            'OM'}),
        name='Rial Omani',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='PAB',
        code_num=590,
        minor_unit_denominator=100,
        entities=frozenset({
            'PA'}),
        name='Balboa',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='PEH',
        code_num=604,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'PE'}),
        name='Sol',
        approx_active_from=date(1863, 1, 1),
        approx_active_until=date(1985, 2, 1),),
    Currency(
        code_alpha3='PEI',
        code_num=604,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'PE'}),
        name='Inti',
        approx_active_from=date(1985, 2, 1),
        approx_active_until=date(1991, 10, 1),),
    Currency(
        code_alpha3='PEN',
        code_num=604,
        minor_unit_denominator=100,
        entities=frozenset({
            'PE'}),
        name='Sol',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='PES',
        code_num=604,
        minor_unit_denominator=100,
        entities=frozenset({
            'PE'}),
        name='Sol',
        approx_active_from=date(1863, 1, 1),
        approx_active_until=date(1986, 2, 28),),
    Currency(
        code_alpha3='PGK',
        code_num=598,
        minor_unit_denominator=100,
        entities=frozenset({
            'PG'}),
        name='Kina',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='PHP',
        code_num=608,
        minor_unit_denominator=100,
        entities=frozenset({
            'PH'}),
        name='Philippine Peso',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='PKR',
        code_num=586,
        minor_unit_denominator=100,
        entities=frozenset({
            'PK'}),
        name='Pakistan Rupee',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='PLN',
        code_num=985,
        minor_unit_denominator=100,
        entities=frozenset({
            'PL'}),
        name='Zloty',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='PLZ',
        code_num=616,
        minor_unit_denominator=100,
        entities=frozenset({
            'PL'}),
        name='Zloty',
        approx_active_from=date(1950, 10, 30),
        approx_active_until=date(1994, 12, 31),),
    Currency(
        code_alpha3='PTE',
        code_num=620,
        minor_unit_denominator=1,
        entities=frozenset({
            'PT'}),
        name='Portuguese Escudo',
        approx_active_from=date(1911, 5, 22),
        approx_active_until=date(1999, 1, 1),),
    Currency(
        code_alpha3='PYG',
        code_num=600,
        minor_unit_denominator=1,
        entities=frozenset({
            'PY'}),
        name='Guarani',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='QAR',
        code_num=634,
        minor_unit_denominator=100,
        entities=frozenset({
            'QA'}),
        name='Qatari Rial',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='RHD',
        code_num=716,
        minor_unit_denominator=100,
        entities=frozenset({
            'RHZW'}),
        name='Rhodesian Dollar',
        approx_active_from=date(1970, 1, 1),
        approx_active_until=date(1980, 12, 31),),
    Currency(
        code_alpha3='ROK',
        code_num=642,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'RO'}),
        name='Leu A/52',
        approx_active_from=date(1947, 1, 1),
        approx_active_until=date(1952, 12, 31),),
    Currency(
        code_alpha3='ROL',
        code_num=642,
        minor_unit_denominator=1,
        entities=frozenset({
            'RO'}),
        name='Old Leu',
        approx_active_from=date(1952, 1, 28),
        approx_active_until=date(2005, 6, 30),),
    Currency(
        code_alpha3='RON',
        code_num=946,
        minor_unit_denominator=100,
        entities=frozenset({
            'RO'}),
        name='Romanian Leu',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='RSD',
        code_num=941,
        minor_unit_denominator=100,
        entities=frozenset({
            'RS'}),
        name='Serbian Dinar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='RUB',
        code_num=643,
        minor_unit_denominator=100,
        entities=frozenset({
            'RU'}),
        name='Russian Ruble',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='RUR',
        code_num=810,
        minor_unit_denominator=100,
        entities=frozenset({
            'AM', 'AZ', 'BY', 'GE', 'KG', 'KZ', 'MD', 'RU', 'TJ',
            'TM', 'UZ'}),
        name='Russian Ruble',
        approx_active_from=date(1992, 1, 1),
        approx_active_until=date(1997, 12, 31),),
    Currency(
        code_alpha3='RWF',
        code_num=646,
        minor_unit_denominator=1,
        entities=frozenset({
            'RW'}),
        name='Rwanda Franc',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SAR',
        code_num=682,
        minor_unit_denominator=100,
        entities=frozenset({
            'SA'}),
        name='Saudi Riyal',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SBD',
        code_num=90,
        minor_unit_denominator=100,
        entities=frozenset({
            'SB'}),
        name='Solomon Islands Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SCR',
        code_num=690,
        minor_unit_denominator=100,
        entities=frozenset({
            'SC'}),
        name='Seychelles Rupee',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SDD',
        code_num=736,
        minor_unit_denominator=100,
        entities=frozenset({
            'SD'}),
        name='Sudanese Dinar',
        approx_active_from=date(1992, 6, 8),
        approx_active_until=date(2007, 1, 10),),
    Currency(
        code_alpha3='SDG',
        code_num=938,
        minor_unit_denominator=100,
        entities=frozenset({
            'SD', 'SS'}),
        name='Sudanese Pound',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SDP',
        code_num=736,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'SD'}),
        name='Sudanese Pound',
        approx_active_from=date(1956, 1, 1),
        approx_active_until=date(1992, 6, 8),),
    Currency(
        code_alpha3='SEK',
        code_num=752,
        minor_unit_denominator=100,
        entities=frozenset({
            'SE'}),
        name='Swedish Krona',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SGD',
        code_num=702,
        minor_unit_denominator=100,
        entities=frozenset({
            'SG'}),
        name='Singapore Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SHP',
        code_num=654,
        minor_unit_denominator=100,
        entities=frozenset({
            'SH'}),
        name='Saint Helena Pound',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SIT',
        code_num=705,
        minor_unit_denominator=100,
        entities=frozenset({
            'SI'}),
        name='Tolar',
        approx_active_from=date(1991, 10, 8),
        approx_active_until=date(2007, 1, 1),),
    Currency(
        code_alpha3='SKK',
        code_num=703,
        minor_unit_denominator=100,
        entities=frozenset({
            'SK'}),
        name='Slovak Koruna',
        approx_active_from=date(1993, 2, 8),
        approx_active_until=date(2009, 1, 1),),
    Currency(
        code_alpha3='SLE',
        code_num=925,
        minor_unit_denominator=100,
        entities=frozenset({
            'SL'}),
        name='Leone',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SLL',
        code_num=694,
        minor_unit_denominator=100,
        entities=frozenset({
            'SL'}),
        name='Leone',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(2023, 12, 31),),
    Currency(
        code_alpha3='SOS',
        code_num=706,
        minor_unit_denominator=100,
        entities=frozenset({
            'SO'}),
        name='Somali Shilling',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SRD',
        code_num=968,
        minor_unit_denominator=100,
        entities=frozenset({
            'SR'}),
        name='Surinam Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SRG',
        code_num=740,
        minor_unit_denominator=100,
        entities=frozenset({
            'SR'}),
        name='Surinam Guilder',
        approx_active_from=date(1942, 1, 1),
        approx_active_until=date(2003, 12, 31),),
    Currency(
        code_alpha3='SSP',
        code_num=728,
        minor_unit_denominator=100,
        entities=frozenset({
            'SS'}),
        name='South Sudanese Pound',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='STD',
        code_num=678,
        minor_unit_denominator=100,
        entities=frozenset({
            'ST'}),
        name='Dobra',
        approx_active_from=date(1977, 1, 1),
        approx_active_until=date(2018, 4, 1),),
    Currency(
        code_alpha3='STN',
        code_num=930,
        minor_unit_denominator=100,
        entities=frozenset({
            'ST'}),
        name='Dobra',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SUR',
        code_num=810,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'SUHH'}),
        name='Rouble',
        approx_active_from=date(1961, 1, 1),
        approx_active_until=date(1991, 12, 26),),
    Currency(
        code_alpha3='SVC',
        code_num=222,
        minor_unit_denominator=100,
        entities=frozenset({
            'SV'}),
        name='El Salvador Colon',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SYP',
        code_num=760,
        minor_unit_denominator=100,
        entities=frozenset({
            'SY'}),
        name='Syrian Pound',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='SZL',
        code_num=748,
        minor_unit_denominator=100,
        entities=frozenset({
            'SZ'}),
        name='Lilangeni',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='THB',
        code_num=764,
        minor_unit_denominator=100,
        entities=frozenset({
            'TH'}),
        name='Baht',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='TJR',
        code_num=762,
        minor_unit_denominator=1,
        entities=frozenset({
            'TJ'}),
        name='Tajik Ruble',
        approx_active_from=date(1995, 5, 10),
        approx_active_until=date(2000, 10, 30),),
    Currency(
        code_alpha3='TJS',
        code_num=972,
        minor_unit_denominator=100,
        entities=frozenset({
            'TJ'}),
        name='Somoni',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='TMM',
        code_num=795,
        minor_unit_denominator=100,
        entities=frozenset({
            'TM'}),
        name='Turkmenistan Manat',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(2008, 12, 31),),
    Currency(
        code_alpha3='TMT',
        code_num=934,
        minor_unit_denominator=100,
        entities=frozenset({
            'TM'}),
        name='Turkmenistan New Manat',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='TND',
        code_num=788,
        minor_unit_denominator=1000,
        entities=frozenset({
            'TN'}),
        name='Tunisian Dinar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='TOP',
        code_num=776,
        minor_unit_denominator=100,
        entities=frozenset({
            'TO'}),
        name='Pa’anga',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='TPE',
        code_num=626,
        minor_unit_denominator=1,
        entities=frozenset({
            'TL'}),
        name='Timor Escudo',
        approx_active_from=date(1959, 1, 1),
        approx_active_until=date(2002, 11, 30),),
    Currency(
        code_alpha3='TRL',
        code_num=792,
        minor_unit_denominator=1,
        entities=frozenset({
            'TR'}),
        name='Old Turkish Lira',
        approx_active_from=date(1923, 1, 1),
        approx_active_until=date(2005, 12, 31),),
    Currency(
        code_alpha3='TRY',
        code_num=949,
        minor_unit_denominator=100,
        entities=frozenset({
            'TR'}),
        name='Turkish Lira',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='TTD',
        code_num=780,
        minor_unit_denominator=100,
        entities=frozenset({
            'TT'}),
        name='Trinidad and Tobago Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='TWD',
        code_num=901,
        minor_unit_denominator=100,
        entities=frozenset({
            'TW'}),
        name='New Taiwan Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='TZS',
        code_num=834,
        minor_unit_denominator=100,
        entities=frozenset({
            'TZ'}),
        name='Tanzanian Shilling',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='UAH',
        code_num=980,
        minor_unit_denominator=100,
        entities=frozenset({
            'UA'}),
        name='Hryvnia',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='UAK',
        code_num=804,
        minor_unit_denominator=100,
        entities=frozenset({
            'UA'}),
        name='Karbovanet',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1996, 9, 1),),
    Currency(
        code_alpha3='UGS',
        code_num=800,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'UG'}),
        name='Uganda Shilling',
        approx_active_from=date(1966, 1, 1),
        approx_active_until=date(1987, 12, 31),),
    Currency(
        code_alpha3='UGW',
        code_num=800,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'UG'}),
        name='Old Shilling',
        approx_active_from=date(1989, 1, 1),
        approx_active_until=date(1990, 12, 31),),
    Currency(
        code_alpha3='UGX',
        code_num=800,
        minor_unit_denominator=1,
        entities=frozenset({
            'UG'}),
        name='Uganda Shilling',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='USD',
        code_num=840,
        minor_unit_denominator=100,
        entities=frozenset({
            'AS', 'BQ', 'EC', 'FM', 'GU', 'HT', 'IO', 'MH', 'MP',
            'PA', 'PR', 'PW', 'SV', 'TC', 'TL', 'UM', 'US', 'VG', 'VI'}),
        name='US Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='USN',
        code_num=997,
        minor_unit_denominator=100,
        entities=frozenset({
            'US'}),
        name='US Dollar (Next day)',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='USS',
        code_num=998,
        minor_unit_denominator=100,
        entities=frozenset({
            'US'}),
        name='US Dollar (Same day)',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(2014, 3, 28),),
    Currency(
        code_alpha3='UYI',
        code_num=940,
        minor_unit_denominator=1,
        entities=frozenset({
            'UY'}),
        name='Uruguay Peso en Unidades Indexadas (UI)',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='UYN',
        code_num=858,
        minor_unit_denominator=100,
        entities=frozenset({
            'UY'}),
        name='Old Uruguay Peso',
        approx_active_from=date(1896, 1, 1),
        approx_active_until=date(1975, 7, 1),),
    Currency(
        code_alpha3='UYP',
        code_num=858,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'UY'}),
        name='Uruguayan Peso',
        approx_active_from=date(1975, 7, 1),
        approx_active_until=date(1993, 3, 1),),
    Currency(
        code_alpha3='UYU',
        code_num=858,
        minor_unit_denominator=100,
        entities=frozenset({
            'UY'}),
        name='Peso Uruguayo',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='UYW',
        code_num=927,
        minor_unit_denominator=10000,
        entities=frozenset({
            'UY'}),
        name='Unidad Previsional',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='UZS',
        code_num=860,
        minor_unit_denominator=100,
        entities=frozenset({
            'UZ'}),
        name='Uzbekistan Sum',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='VEB',
        code_num=862,
        minor_unit_denominator=100,
        entities=frozenset({
            'VE'}),
        name='Bolivar',
        approx_active_from=date(1879, 3, 31),
        approx_active_until=date(2008, 1, 1),),
    Currency(
        code_alpha3='VED',
        code_num=926,
        minor_unit_denominator=100,
        entities=frozenset({
            'VE'}),
        name='Bolívar Soberano',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='VEF',
        code_num=937,
        minor_unit_denominator=100,
        entities=frozenset({
            'VE'}),
        name='Bolivar Fuerte',
        approx_active_from=date(2008, 1, 1),
        approx_active_until=date(2018, 8, 20),),
    Currency(
        code_alpha3='VES',
        code_num=928,
        minor_unit_denominator=100,
        entities=frozenset({
            'VE'}),
        name='Bolívar Soberano',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='VNC',
        code_num=704,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'VN'}),
        name='Old Dong',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=date(1990, 12, 31),),
    Currency(
        code_alpha3='VND',
        code_num=704,
        minor_unit_denominator=1,
        entities=frozenset({
            'VN'}),
        name='Dong',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='VUV',
        code_num=548,
        minor_unit_denominator=1,
        entities=frozenset({
            'VU'}),
        name='Vatu',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='WST',
        code_num=882,
        minor_unit_denominator=100,
        entities=frozenset({
            'WS'}),
        name='Tala',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XAF',
        code_num=950,
        minor_unit_denominator=1,
        entities=frozenset({
            'CF', 'CG', 'CM', 'GA', 'GQ', 'TD'}),
        name='CFA Franc BEAC',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XAG',
        code_num=961,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='Silver',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XAU',
        code_num=959,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='Gold',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XBA',
        code_num=955,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='Bond Markets Unit European Composite Unit (EURCO)',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XBB',
        code_num=956,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='Bond Markets Unit European Monetary Unit (E.M.U.-6)',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XBC',
        code_num=957,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='Bond Markets Unit European Unit of Account 9 (E.U.A.-9)',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XBD',
        code_num=958,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='Bond Markets Unit European Unit of Account 17 (E.U.A.-17)',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XCD',
        code_num=951,
        minor_unit_denominator=100,
        entities=frozenset({
            'AG', 'AI', 'DM', 'GD', 'KN', 'LC', 'MS', 'VC'}),
        name='East Caribbean Dollar',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XDR',
        code_num=960,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='SDR (Special Drawing Right)',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XEU',
        code_num=954,
        minor_unit_denominator=1,
        entities=frozenset({}),
        name='European Currency Unit (E.C.U)',
        approx_active_from=date(1979, 3, 13),
        approx_active_until=date(1998, 12, 31),),
    Currency(
        code_alpha3='XOF',
        code_num=952,
        minor_unit_denominator=1,
        entities=frozenset({
            'BF', 'BJ', 'CI', 'GW', 'ML', 'NE', 'SN', 'TG'}),
        name='CFA Franc BCEAO',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XPD',
        code_num=964,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='Palladium',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XPF',
        code_num=953,
        minor_unit_denominator=1,
        entities=frozenset({
            'NC', 'PF', 'WF'}),
        name='CFP Franc',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XPT',
        code_num=962,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='Platinum',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XSU',
        code_num=994,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='Sucre',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XTS',
        code_num=963,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='Codes specifically reserved for testing purposes',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XUA',
        code_num=965,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='ADB Unit of Account',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='XXX',
        code_num=999,
        minor_unit_denominator=None,
        entities=frozenset({}),
        name='The codes assigned for transactions where no currency is involved',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='YDD',
        code_num=720,
        minor_unit_denominator=Singleton.UNKNOWN,
        entities=frozenset({
            'YDYE'}),
        name='Yemeni Dinar',
        approx_active_from=date(1965, 1, 1),
        approx_active_until=date(1996, 6, 11),),
    Currency(
        code_alpha3='YER',
        code_num=886,
        minor_unit_denominator=100,
        entities=frozenset({
            'YE'}),
        name='Yemeni Rial',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='YUD',
        code_num=890,
        minor_unit_denominator=100,
        entities=frozenset({
            'YUCS'}),
        name='New Yugoslavian Dinar',
        approx_active_from=date(1966, 1, 1),
        approx_active_until=date(1989, 12, 31),),
    Currency(
        code_alpha3='YUM',
        code_num=891,
        minor_unit_denominator=100,
        entities=frozenset({
            'YUCS'}),
        name='New Dinar',
        approx_active_from=date(1994, 1, 24),
        approx_active_until=date(2003, 7, 2),),
    Currency(
        code_alpha3='YUN',
        code_num=890,
        minor_unit_denominator=100,
        entities=frozenset({
            'YUCS'}),
        name='Yugoslavian Dinar',
        approx_active_from=date(1990, 1, 1),
        approx_active_until=date(1992, 6, 30),),
    Currency(
        code_alpha3='ZAL',
        code_num=991,
        minor_unit_denominator=100,
        entities=frozenset({
            'LS', 'ZA'}),
        name='Financial Rand',
        approx_active_from=date(1985, 9, 1),
        approx_active_until=date(1995, 3, 13),),
    Currency(
        code_alpha3='ZAR',
        code_num=710,
        minor_unit_denominator=100,
        entities=frozenset({
            'LS', 'NA', 'ZA'}),
        name='Rand',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='ZMK',
        code_num=894,
        minor_unit_denominator=100,
        entities=frozenset({
            'ZM'}),
        name='Zambian Kwacha',
        approx_active_from=date(1968, 1, 16),
        approx_active_until=date(2013, 1, 1),),
    Currency(
        code_alpha3='ZMW',
        code_num=967,
        minor_unit_denominator=100,
        entities=frozenset({
            'ZM'}),
        name='Zambian Kwacha',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='ZRN',
        code_num=180,
        minor_unit_denominator=100,
        entities=frozenset({
            'AO'}),
        name='New Zaire',
        approx_active_from=date(1993, 1, 1),
        approx_active_until=date(1999, 6, 30),),
    Currency(
        code_alpha3='ZRZ',
        code_num=180,
        minor_unit_denominator=100,
        entities=frozenset({
            'AO'}),
        name='Zaire',
        approx_active_from=date(1967, 1, 1),
        approx_active_until=date(1994, 2, 28),),
    Currency(
        code_alpha3='ZWC',
        code_num=716,
        minor_unit_denominator=100,
        entities=frozenset({
            'ZW'}),
        name='Rhodesian Dollar',
        approx_active_from=date(1970, 2, 17),
        approx_active_until=date(1989, 12, 31),),
    Currency(
        code_alpha3='ZWD',
        code_num=716,
        minor_unit_denominator=100,
        entities=frozenset({
            'ZW'}),
        name='Zimbabwe Dollar (old)',
        approx_active_from=date(1980, 4, 18),
        approx_active_until=date(2006, 7, 31),),
    Currency(
        code_alpha3='ZWG',
        code_num=924,
        minor_unit_denominator=100,
        entities=frozenset({
            'ZW'}),
        name='Zimbabwe Gold',
        approx_active_from=Singleton.UNKNOWN,
        approx_active_until=None,),
    Currency(
        code_alpha3='ZWL',
        code_num=932,
        minor_unit_denominator=100,
        entities=frozenset({
            'ZW'}),
        name='Zimbabwe Dollar',
        approx_active_from=date(2009, 2, 2),
        approx_active_until=date(2024, 9, 1),),
    Currency(
        code_alpha3='ZWN',
        code_num=942,
        minor_unit_denominator=100,
        entities=frozenset({
            'ZW'}),
        name='Zimbabwe Dollar (new)',
        approx_active_from=date(2006, 8, 1),
        approx_active_until=date(2008, 7, 31),),
    Currency(
        code_alpha3='ZWR',
        code_num=935,
        minor_unit_denominator=100,
        entities=frozenset({
            'ZW'}),
        name='Zimbabwe Dollar',
        approx_active_from=date(2008, 8, 1),
        approx_active_until=date(2009, 2, 2),),
})
