#  Copyright © 2025 Bentley Systems, Incorporated
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#      http://www.apache.org/licenses/LICENSE-2.0
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

"""
Block Model API
=============


    The Block Model API provides the ability to manage and report on block models in your Evo workspaces. Enable your
    product with Evo connected workflows by integrating with the Seequent Block Model API.

    The Block Model API supports a range of sub-blocking options, and both full and partial updates to block models,
    including updates of specified columns and/or sub-volumes. Block models are versioned, and the service supports
    reporting on the material content of current or previous versions, and comparing the content between versions of
    a block model.

    For more information on the Block Model API, see [Overview](/docs/blockmodel/overview), or the API references here.


This code is generated from the OpenAPI specification for Block Model API.
API version: 1.16.1
"""

from evo.common.connector import APIConnector
from evo.common.data import EmptyResponse, RequestMethod

from ..models import *  # noqa: F403

__all__ = ["OperationsApi"]


class OperationsApi:
    """API client for the Operations endpoint.

    NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    :param connector: Client for communicating with the API.
    """

    def __init__(self, connector: APIConnector):
        self.connector = connector

    async def create_block_model(
        self,
        workspace_id: str,
        org_id: str,
        create_data: CreateData,  # noqa: F405
        additional_headers: dict[str, str] | None = None,
        request_timeout: int | float | tuple[int | float, int | float] | None = None,
    ) -> BlockModelAndJobURL:  # noqa: F405
        """Create a block model

        This endpoint is where you define the model type, size, origin point, and rotation to register the block model and create the initial version, which will contain the block model default columns:  - For regular models: `i`, `j`, `k`, `x`, `y`, `z`, `version_id`  - For fully sub-blocked and octree models: `i`, `j`, `k`, `sidx`, `x`, `y`, `z`, `dx`, `dy`, `dz`, `version_id`  - For flexible models: `i`, `j`, `k`, `start_si`, `start_sj`, `start_sk`, `end_si`, `end_sj`, `end_sk`, `x`, `y`, `z`, `dx`, `dy`, `dz`, `version_id`  On a successful request, the server will respond with the details outlined in the `BlockModelAndJobUrl` object. The status of this job can be polled via a GET request to the `job_url`.  A minimum workspace role of Editor is required to use this endpoint.

        :param workspace_id: ID of the workspace this call is scoped to. Represented as a v4 UUID.
            Format: `uuid`
            Example: `'860be2f5-fe06-4c1b-ac8b-7d34d2b6d2ef'`
        :param org_id: ID of the organization this call is scoped to. Represented as a v4 UUID.
            Format: `uuid`
            Example: `'bf1a040c-8c58-4bc2-bec2-c5ae7de8bd84'`
        :param create_data:
            Example: `endpoints.CreateData()`
        :param additional_headers: (optional) Additional headers to send with the request.
        :param request_timeout: (optional) Timeout setting for this request. If one number is provided, it will be the
            total request timeout. It can also be a pair (tuple) of (connection, read) timeouts.

        :return: Returns the result object.

        :raise evo.common.exceptions.BadRequestException: If the server responds with HTTP status 400.
        :raise evo.common.exceptions.UnauthorizedException: If the server responds with HTTP status 401.
        :raise evo.common.exceptions.ForbiddenException: If the server responds with HTTP status 403.
        :raise evo.common.exceptions.NotFoundException: If the server responds with HTTP status 404.
        :raise evo.common.exceptions.BaseTypedError: If the server responds with any other HTTP status between
            400 and 599, and the body of the response contains a descriptive `type` parameter.
        :raise evo.common.exceptions.EvoAPIException: If the server responds with any other HTTP status between 400
            and 599, and the body of the response does not contain a `type` parameter.
        :raise evo.common.exceptions.UnknownResponseError: For other HTTP status codes with no corresponding response
            type in `response_types_map`.
        """
        # Prepare the path parameters.
        _path_params = {
            "workspace_id": workspace_id,
            "org_id": org_id,
        }

        # Prepare the header parameters.
        _header_params = {
            "Content-Type": "application/json",
            "Accept": "application/json",
        }
        if additional_headers is not None:
            _header_params.update(additional_headers)

        # Define the collection formats.
        _collection_formats = {}

        _response_types_map = {
            "201": BlockModelAndJobURL,  # noqa: F405
        }

        return await self.connector.call_api(
            method=RequestMethod.POST,
            resource_path="/blockmodel/orgs/{org_id}/workspaces/{workspace_id}/block-models",
            path_params=_path_params,
            header_params=_header_params,
            body=create_data,
            collection_formats=_collection_formats,
            response_types_map=_response_types_map,
            request_timeout=request_timeout,
        )

    async def delete_block_model(
        self,
        bm_id: str,
        workspace_id: str,
        org_id: str,
        additional_headers: dict[str, str] | None = None,
        request_timeout: int | float | tuple[int | float, int | float] | None = None,
    ) -> EmptyResponse:
        """Delete a block model

        Deletes the block model identified by `bm_id`.  A minimum workspace role of Editor is required to use this endpoint.

        :param bm_id: ID of the block model this call is scoped to. Represented as a v4 UUID.
            Format: `uuid`
            Example: `'e3c277c2-edc6-4a7a-8380-251dd19231f2'`
        :param workspace_id: ID of the workspace this call is scoped to. Represented as a v4 UUID.
            Format: `uuid`
            Example: `'860be2f5-fe06-4c1b-ac8b-7d34d2b6d2ef'`
        :param org_id: ID of the organization this call is scoped to. Represented as a v4 UUID.
            Format: `uuid`
            Example: `'bf1a040c-8c58-4bc2-bec2-c5ae7de8bd84'`
        :param additional_headers: (optional) Additional headers to send with the request.
        :param request_timeout: (optional) Timeout setting for this request. If one number is provided, it will be the
            total request timeout. It can also be a pair (tuple) of (connection, read) timeouts.

        :return: Returns the result object.

        :raise evo.common.exceptions.BadRequestException: If the server responds with HTTP status 400.
        :raise evo.common.exceptions.UnauthorizedException: If the server responds with HTTP status 401.
        :raise evo.common.exceptions.ForbiddenException: If the server responds with HTTP status 403.
        :raise evo.common.exceptions.NotFoundException: If the server responds with HTTP status 404.
        :raise evo.common.exceptions.BaseTypedError: If the server responds with any other HTTP status between
            400 and 599, and the body of the response contains a descriptive `type` parameter.
        :raise evo.common.exceptions.EvoAPIException: If the server responds with any other HTTP status between 400
            and 599, and the body of the response does not contain a `type` parameter.
        :raise evo.common.exceptions.UnknownResponseError: For other HTTP status codes with no corresponding response
            type in `response_types_map`.
        """
        # Prepare the path parameters.
        _path_params = {
            "bm_id": bm_id,
            "workspace_id": workspace_id,
            "org_id": org_id,
        }

        # Prepare the header parameters.
        _header_params = {}
        if additional_headers is not None:
            _header_params.update(additional_headers)

        # Define the collection formats.
        _collection_formats = {}

        _response_types_map = {
            "204": EmptyResponse,
        }

        return await self.connector.call_api(
            method=RequestMethod.DELETE,
            resource_path="/blockmodel/orgs/{org_id}/workspaces/{workspace_id}/block-models/{bm_id}",
            path_params=_path_params,
            header_params=_header_params,
            collection_formats=_collection_formats,
            response_types_map=_response_types_map,
            request_timeout=request_timeout,
        )

    async def restore_block_model(
        self,
        bm_id: str,
        workspace_id: str,
        org_id: str,
        deleted: bool | None = None,
        additional_headers: dict[str, str] | None = None,
        request_timeout: int | float | tuple[int | float, int | float] | None = None,
    ) -> BlockModel:  # noqa: F405
        """Restore a block model

        Restores the deleted block model identified by `bm_id` when the `deleted` flag is set to `false`. Note, the `deleted` flag cannot be set to `true`.  A minimum workspace role of Editor is required to use this endpoint.

        :param bm_id: ID of the block model this call is scoped to. Represented as a v4 UUID.
            Format: `uuid`
            Example: `'e3c277c2-edc6-4a7a-8380-251dd19231f2'`
        :param workspace_id: ID of the workspace this call is scoped to. Represented as a v4 UUID.
            Format: `uuid`
            Example: `'860be2f5-fe06-4c1b-ac8b-7d34d2b6d2ef'`
        :param org_id: ID of the organization this call is scoped to. Represented as a v4 UUID.
            Format: `uuid`
            Example: `'bf1a040c-8c58-4bc2-bec2-c5ae7de8bd84'`
        :param deleted: (optional)  A boolean parameter that must be provided and set to `false` when using this endpoint. Omitting it or setting it to a different value will result in an error.
            Example: `True`
        :param additional_headers: (optional) Additional headers to send with the request.
        :param request_timeout: (optional) Timeout setting for this request. If one number is provided, it will be the
            total request timeout. It can also be a pair (tuple) of (connection, read) timeouts.

        :return: Returns the result object.

        :raise evo.common.exceptions.BadRequestException: If the server responds with HTTP status 400.
        :raise evo.common.exceptions.UnauthorizedException: If the server responds with HTTP status 401.
        :raise evo.common.exceptions.ForbiddenException: If the server responds with HTTP status 403.
        :raise evo.common.exceptions.NotFoundException: If the server responds with HTTP status 404.
        :raise evo.common.exceptions.BaseTypedError: If the server responds with any other HTTP status between
            400 and 599, and the body of the response contains a descriptive `type` parameter.
        :raise evo.common.exceptions.EvoAPIException: If the server responds with any other HTTP status between 400
            and 599, and the body of the response does not contain a `type` parameter.
        :raise evo.common.exceptions.UnknownResponseError: For other HTTP status codes with no corresponding response
            type in `response_types_map`.
        """
        # Prepare the path parameters.
        _path_params = {
            "bm_id": bm_id,
            "workspace_id": workspace_id,
            "org_id": org_id,
        }

        # Prepare the query parameters.
        _query_params = {}
        if deleted is not None:
            _query_params["deleted"] = deleted

        # Prepare the header parameters.
        _header_params = {
            "Accept": "application/json",
        }
        if additional_headers is not None:
            _header_params.update(additional_headers)

        # Define the collection formats.
        _collection_formats = {}

        _response_types_map = {
            "202": BlockModel,  # noqa: F405
        }

        return await self.connector.call_api(
            method=RequestMethod.POST,
            resource_path="/blockmodel/orgs/{org_id}/workspaces/{workspace_id}/block-models/{bm_id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            collection_formats=_collection_formats,
            response_types_map=_response_types_map,
            request_timeout=request_timeout,
        )

    async def update_block_model(
        self,
        workspace_id: str,
        org_id: str,
        bm_id: str,
        update_block_model: UpdateBlockModel,  # noqa: F405
        additional_headers: dict[str, str] | None = None,
        request_timeout: int | float | tuple[int | float, int | float] | None = None,
    ) -> BlockModel:  # noqa: F405
        """Update a block model's metadata

        Updates the block model name, description, and/or size unit ID for the given `bm_id`.  A minimum workspace role of Editor is required to use this endpoint.

        :param workspace_id: ID of the workspace this call is scoped to. Represented as a v4 UUID.
            Format: `uuid`
            Example: `'860be2f5-fe06-4c1b-ac8b-7d34d2b6d2ef'`
        :param org_id: ID of the organization this call is scoped to. Represented as a v4 UUID.
            Format: `uuid`
            Example: `'bf1a040c-8c58-4bc2-bec2-c5ae7de8bd84'`
        :param bm_id: ID of the block model this call is scoped to. Represented as a v4 UUID.
            Format: `uuid`
            Example: `'e3c277c2-edc6-4a7a-8380-251dd19231f2'`
        :param update_block_model:
            Example: `endpoints.UpdateBlockModel()`
        :param additional_headers: (optional) Additional headers to send with the request.
        :param request_timeout: (optional) Timeout setting for this request. If one number is provided, it will be the
            total request timeout. It can also be a pair (tuple) of (connection, read) timeouts.

        :return: Returns the result object.

        :raise evo.common.exceptions.BadRequestException: If the server responds with HTTP status 400.
        :raise evo.common.exceptions.UnauthorizedException: If the server responds with HTTP status 401.
        :raise evo.common.exceptions.ForbiddenException: If the server responds with HTTP status 403.
        :raise evo.common.exceptions.NotFoundException: If the server responds with HTTP status 404.
        :raise evo.common.exceptions.BaseTypedError: If the server responds with any other HTTP status between
            400 and 599, and the body of the response contains a descriptive `type` parameter.
        :raise evo.common.exceptions.EvoAPIException: If the server responds with any other HTTP status between 400
            and 599, and the body of the response does not contain a `type` parameter.
        :raise evo.common.exceptions.UnknownResponseError: For other HTTP status codes with no corresponding response
            type in `response_types_map`.
        """
        # Prepare the path parameters.
        _path_params = {
            "workspace_id": workspace_id,
            "org_id": org_id,
            "bm_id": bm_id,
        }

        # Prepare the header parameters.
        _header_params = {
            "Content-Type": "application/json",
            "Accept": "application/json",
        }
        if additional_headers is not None:
            _header_params.update(additional_headers)

        # Define the collection formats.
        _collection_formats = {}

        _response_types_map = {
            "200": BlockModel,  # noqa: F405
        }

        return await self.connector.call_api(
            method=RequestMethod.PATCH,
            resource_path="/blockmodel/orgs/{org_id}/workspaces/{workspace_id}/block-models/{bm_id}",
            path_params=_path_params,
            header_params=_header_params,
            body=update_block_model,
            collection_formats=_collection_formats,
            response_types_map=_response_types_map,
            request_timeout=request_timeout,
        )
