#  Copyright © 2025 Bentley Systems, Incorporated
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#      http://www.apache.org/licenses/LICENSE-2.0
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

# generated by datamodel-codegen:
#   filename:  spec.yaml

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Literal
from uuid import UUID

from pydantic import AnyUrl, Field, StrictBool, StrictFloat, StrictInt, StrictStr

from .._model_config import CustomBaseModel


class BlockSize(CustomBaseModel):
    x: StrictFloat = Field(..., title="X")
    y: StrictFloat = Field(..., title="Y")
    z: StrictFloat = Field(..., title="Z")


class ColumnHeaderType(Enum):
    id = "id"
    name = "name"


class ColumnNameMapping(CustomBaseModel):
    csv_name: StrictStr = Field(..., title="CSV Name")
    new_title: StrictStr = Field(..., title="New Title")


class ColumnRename(CustomBaseModel):
    new_title: StrictStr = Field(..., title="New Title")
    old_title: StrictStr = Field(..., title="Old Title")


class DataType(Enum):
    """
       Capitalized list of supported PyArrow datatypes outlined in
       [https://arrow.apache.org/docs/python/api/datatypes.html](https://arrow.apache.org/docs/python/api/datatypes.html).

    Timestamp datatype is expected to be used with unit measured in "us" and timezone set to "UTC" inside of parquet
        column header schema or it won't be accepted; an example for PyArrow binding would look like this:
        pa.timestamp("us", tz="UTC")

    """

    Boolean = "Boolean"
    Int8 = "Int8"
    Int16 = "Int16"
    Int32 = "Int32"
    Int64 = "Int64"
    UInt8 = "UInt8"
    UInt16 = "UInt16"
    UInt32 = "UInt32"
    UInt64 = "UInt64"
    Float16 = "Float16"
    Float32 = "Float32"
    Float64 = "Float64"
    Utf8 = "Utf8"
    Date32 = "Date32"
    Timestamp = "Timestamp"


class FloatRange(CustomBaseModel):
    max: StrictFloat = Field(..., title="Max")
    """
    Maximum value for the column
    """
    min: StrictFloat = Field(..., title="Min")
    """
    Minimum value for the column
    """


class GeometryColumns(Enum):
    indices = "indices"
    coordinates = "coordinates"


class InputOptionsCSV(CustomBaseModel):
    column_name_mapping: list[ColumnNameMapping] | None = Field([], title="Column Name Mapping")
    decimal_char: StrictStr | None = Field(".", max_length=1, min_length=1, title="Decimal Char")
    delimiter: StrictStr | None = Field(",", max_length=1, min_length=1, title="Delimiter")
    file_format: Literal["csv"] = Field("csv", title="File Format")
    quote_char: StrictStr | None = Field('"', max_length=1, min_length=1, title="Quote Char")
    skip_rows: StrictInt | None = Field(0, ge=0, title="Skip Rows")
    skip_rows_after_headers: StrictInt | None = Field(0, ge=0, title="Skip Rows After Headers")


class InputOptionsParquet(CustomBaseModel):
    file_format: Literal["parquet"] = Field("parquet", title="File Format")


class IntRange(CustomBaseModel):
    """
    Represents a range of whole numbers from min to max inclusive.
    """

    max: StrictInt = Field(..., title="Max")
    """
    Maximum value for the column
    """
    min: StrictInt = Field(..., title="Min")
    """
    Minimum value for the column
    """


class JobErrorPayload(CustomBaseModel):
    detail: StrictStr = Field(
        ...,
        examples=["Update file 38e3ca486b3b477db0f99646b0529746 not found."],
        title="Detail",
    )
    """
    A human-readable explanation specific to this occurrence of the problem.
    """
    download_url: AnyUrl | None = Field(None, title="Download Url")
    """
    URL for downloading an errors block model file. Set if the job is for block model update and there were block-specific errors.
    """
    status: StrictInt = Field(..., examples=[400], title="Status")
    """
    Status code for the error, equivalent to a HTTP status code.
    """
    title: StrictStr = Field(..., examples=["Error in Update"], title="Title")
    """
    A short, human-readable summary of the problem type.
    """
    type: StrictStr = Field(
        ...,
        examples=["https://seequent.com/error-codes/block-model-service/job/update-error"],
        title="Type",
    )
    """
    A URI reference that is the primary identifier of the problem type.
    """


class JobPendingPayload(CustomBaseModel):
    upload_url: AnyUrl | None = Field(None, title="Upload Url")
    """
    Upload URL for the job, with an up-to-date SAS token
    """


class JobStatus(Enum):
    PENDING_UPLOAD = "PENDING_UPLOAD"
    QUEUED = "QUEUED"
    PROCESSING = "PROCESSING"
    COMPLETE = "COMPLETE"
    FAILED = "FAILED"


class Location(CustomBaseModel):
    x: StrictFloat = Field(..., title="X")
    y: StrictFloat = Field(..., title="Y")
    z: StrictFloat = Field(..., title="Z")


class OctreeSubblocks(CustomBaseModel):
    nx: StrictInt = Field(..., title="Nx")
    ny: StrictInt = Field(..., title="Ny")
    nz: StrictInt = Field(..., title="Nz")


class OutputOptionsCSV(CustomBaseModel):
    column_headers: ColumnHeaderType | None = "name"
    """
    Header values within the output file for non-system columns, either the column's name or UUID
    """
    delimiter: StrictStr | None = Field(",", max_length=1, min_length=1, title="Delimiter")
    """
    Delimiter between values
    """
    exclude_null_rows: StrictBool | None = Field(True, title="Exclude Null Rows")
    """
    Specifies whether or not the output query file should exclude rows where all values for queried user columns are null.
    """
    file_format: Literal["csv"] = Field("csv", title="File Format")
    """
    CSV file
    """


class OutputOptionsParquet(CustomBaseModel):
    column_headers: ColumnHeaderType | None = "name"
    """
    Header values within the output file for non-system columns, either the column's name or UUID
    """
    exclude_null_rows: StrictBool | None = Field(True, title="Exclude Null Rows")
    """
    Specifies whether or not the output query file should exclude rows where all values for queried user columns are null.
    """
    file_format: Literal["parquet"] = Field("parquet", title="File Format")
    """
    Apache Parquet file
    """


class QueryDownload(CustomBaseModel):
    download_url: AnyUrl = Field(
        ...,
        examples=[
            "https://au.static.evo.seequent.com/blocksync/169ccde2-4d0f-4a7a-adb7-1ccadc734cdd/query/{criteria hash}.parquet?st=2023-11-09T03%3A05%3A30Z&se=2023-11-10T03%3A06%3A30Z&sp=r&spr=http&sv=2021-08-06&sr=b&sig=ABCDEF0123456789ABCDEF0123456789"
        ],
        title="Download Url",
    )
    """
    Download URL for the results of the query.
    """


class RegularSubblocks(CustomBaseModel):
    nx: StrictInt = Field(..., title="Nx")
    ny: StrictInt = Field(..., title="Ny")
    nz: StrictInt = Field(..., title="Nz")


class Rename(CustomBaseModel):
    col_id: StrictStr = Field(..., examples=["618d6339-2fa7-4dfd-9c7f-c0b12016639e"], title="Col Id")
    """
    The ID of the column, a UUID for non-system columns
    """
    new_title: StrictStr = Field(..., title="New Title")
    """
    The new human-readable label for the column identified by `col_id`
    """


class RenameLite(CustomBaseModel):
    new_title: StrictStr = Field(..., title="New Title")
    """
    The new human-readable label for the column identified by `title`
    """
    title: StrictStr = Field(..., title="Title")
    """
    The original human-readable label used to identify the column
    """


class ReportAggregation(Enum):
    SUM = "SUM"
    MASS_AVERAGE = "MASS_AVERAGE"


class ReportCategory(CustomBaseModel):
    col_id: UUID = Field(..., examples=["13c277c2-edc6-4a7a-8380-251dd19231f2"], title="Col Id")
    """
    ID of the category column in the block model
    """
    label: StrictStr = Field(..., title="Label")
    """
    The human-readable label used to identify the column
    """
    values: list[StrictStr] | None = Field(
        None,
        examples=[["low", "medium", "high"]],
        max_length=100,
        min_length=1,
        title="Values",
    )
    """
    Values to use for category filtering. If null the report will contain a row for each distinct non-empty value in this column.
    """


class ReportColumn(CustomBaseModel):
    aggregation: ReportAggregation = Field(..., examples=["SUM"])
    """
    The aggregation method to use for the column
    """
    col_id: UUID = Field(..., examples=["13c277c2-edc6-4a7a-8380-251dd19231f2"], title="Col Id")
    """
    ID of the column in the block model
    """
    label: StrictStr = Field(..., examples=["Au Content"], title="Label")
    """
    The human-readable label used to identify the column
    """
    output_unit_id: StrictStr = Field(..., examples=["kg"], title="Output Unit Id")
    """
    ID of the unit to use for the column output
    """


class ReportComparisonJobResult(CustomBaseModel):
    from_result_uuid: UUID | None = Field(
        None,
        examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"],
        title="From Result Uuid",
    )
    """
    ID of the Report Result for the baseline version.
    """
    from_version_uuid: UUID | None = Field(
        None,
        examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"],
        title="From Version Uuid",
    )
    """
    ID of the block model version to use as the baseline for the comparison.
    """
    report_specification_uuid: UUID = Field(
        ...,
        examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"],
        title="Report Specification Uuid",
    )
    """
    ID of the Report Specification that the comparison is for
    """
    to_result_uuid: UUID | None = Field(None, examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"], title="To Result Uuid")
    """
    ID of the Report Result for the version to compare.
    """
    to_version_uuid: UUID | None = Field(
        None, examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"], title="To Version Uuid"
    )
    """
    ID of the block model version to compare.
    """


class ReportComparisonRequestResult(CustomBaseModel):
    from_result_uuid: UUID | None = Field(
        None,
        examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"],
        title="From Result Uuid",
    )
    """
    ID of the Report Result for the baseline version, or null if the result does not yet exist (and a job was created).
    """
    job_url: AnyUrl | None = Field(None, title="Job Url")
    """
    URL to the Report Comparison Job, if created. If both results already exist, no job will be created and this will be null.
    """
    to_result_uuid: UUID | None = Field(None, examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"], title="To Result Uuid")
    """
    ID of the Report Result for the version to compare, or null if the result does not yet exist (and a job was created).
    """


class ReportComparisonSpec(CustomBaseModel):
    from_version_uuid: UUID | None = Field(
        None,
        examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"],
        title="From Version Uuid",
    )
    """
    ID of the block model version to use as the baseline for the comparison.
    """
    to_version_uuid: UUID | None = Field(
        None, examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"], title="To Version Uuid"
    )
    """
    ID of the block model version to compare.
    """


class ReportComparisonValue(CustomBaseModel):
    difference: StrictFloat | StrictInt = Field(..., title="Difference")
    from_value: StrictFloat | StrictInt = Field(..., title="From Value")
    percent: StrictFloat | None = Field(None, title="Percent")
    to_value: StrictFloat | StrictInt = Field(..., title="To Value")


class ReportNegativeValuesPolicy(Enum):
    USE = "USE"
    ZERO = "ZERO"
    IGNORE_BLOCK = "IGNORE_BLOCK"


class ReportNullValuesPolicy(Enum):
    ZERO = "ZERO"
    IGNORE_BLOCK = "IGNORE_BLOCK"


class ReportResultCategory(CustomBaseModel):
    col_id: UUID = Field(..., examples=["ddd277c2-edc6-4a7a-8380-251dd19231f2"], title="Col Id")
    """
    ID of the block model column
    """
    label: StrictStr = Field(..., examples=["Rock type"], title="Label")
    """
    Label of the column
    """


class ReportResultColumn(CustomBaseModel):
    col_id: UUID | None = Field(None, examples=["eee277c2-edc6-4a7a-8380-251dd19231f2"], title="Col Id")
    """
    ID of the block model column, if applicable. This will be null for system-calculated columns such as 'Mass'
    """
    label: StrictStr = Field(..., examples=["Average gold content"], title="Label")
    """
    Label of the column
    """
    unit_id: StrictStr = Field(..., examples=["ppm[mass]"], title="Unit Id")
    """
    ID of the unit of the column
    """


class ReportResultReferencedColumn(CustomBaseModel):
    col_id: UUID = Field(..., examples=["eee277c2-edc6-4a7a-8380-251dd19231f2"], title="Col Id")
    """
    ID of the block model column
    """
    data_type: StrictStr = Field(..., examples=["Utf8"], title="Data Type")
    """
    Data type of the referenced column in the Report Result
    """
    title: StrictStr = Field(..., examples=["Something"], title="Title")
    """
    Title of the referenced column
    """
    unit_id: StrictStr | None = Field(None, examples=["ppm[mass]"], title="Unit Id")
    """
    ID of the unit of the column
    """
    unit_id_from_version: UUID | None = Field(
        None,
        examples=["ccc277c2-edc6-4a7a-8380-251dd19231f2"],
        title="Unit Id From Version",
    )
    """
    Version UUID of the version of block model that the unid was from
    """


class ReportRow(CustomBaseModel):
    categories: list[StrictStr | StrictInt | StrictFloat | StrictBool | None] = Field(
        ..., examples=[["Granite"]], title="Categories"
    )
    """
    List of category values. `null` indicates a total for that category column.
    """
    values: list[StrictInt | StrictFloat] = Field(..., examples=[[2.7, 0.3]], title="Values")
    """
    List of values for the value columns
    """


class ReportRunResult(CustomBaseModel):
    bm_uuid: UUID = Field(..., title="Bm Uuid")
    report_result_uuid: UUID = Field(..., title="Report Result Uuid")
    report_specification_uuid: UUID = Field(..., title="Report Specification Uuid")
    version_id: StrictInt = Field(..., title="Version Id")
    version_uuid: UUID = Field(..., title="Version Uuid")


class ReportWarningType(Enum):
    INVALID_DENSITY_VALUE = "INVALID_DENSITY_VALUE"
    NULL_CUTOFF_VALUE = "NULL_CUTOFF_VALUE"
    NEGATIVE_CUTOFF_VALUE = "NEGATIVE_CUTOFF_VALUE"
    NULL_COLUMN_VALUE = "NULL_COLUMN_VALUE"
    NEGATIVE_COLUMN_VALUE = "NEGATIVE_COLUMN_VALUE"
    INVALID_CATEGORY_VALUE = "INVALID_CATEGORY_VALUE"
    TOO_MANY_CATEGORY_VALUES = "TOO_MANY_CATEGORY_VALUES"
    LONG_CATEGORY_VALUE = "LONG_CATEGORY_VALUE"
    UNIT_FROM_LATEST_VERSION = "UNIT_FROM_LATEST_VERSION"
    MISSING_SUB_BLOCK = "MISSING_SUB_BLOCK"


class ReportingJobResult(CustomBaseModel):
    bm_uuid: UUID = Field(..., examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"], title="Bm Uuid")
    """
    ID of the block model
    """
    job_url: AnyUrl = Field(..., title="Job Url")
    job_uuid: UUID = Field(..., examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"], title="Job Uuid")
    """
    ID of the Reporting Job.
    """
    report_specification_uuid: UUID = Field(..., title="Report Specification Uuid")
    version_id: StrictInt = Field(..., examples=[5], title="Version Id")
    """
    Identifier for the version within a block model as a monotonically increasing integer, where 1 is
    the `version_id` for the version created upon creation of the block model.
    """
    version_uuid: UUID = Field(..., examples=["3e9ce8de-f6ba-4920-8c6e-0882e90f0ed7"], title="Version Uuid")
    """
    A universally unique identifier for the version
    """


class ReportingJobSpec(CustomBaseModel):
    version_uuid: UUID | None = Field(None, examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"], title="Version Uuid")
    """
    ID of the block model version to run the report against. If not provided, the latest will be used.
    """


class RotationAxis(Enum):
    x = "x"
    y = "y"
    z = "z"


class Size3D(CustomBaseModel):
    nx: StrictInt = Field(..., title="Nx")
    ny: StrictInt = Field(..., title="Ny")
    nz: StrictInt = Field(..., title="Nz")


class SizeOptionsFlexible(CustomBaseModel):
    model_type: Literal["flexible"] = Field(title="Model Type")
    """
    Type of sub-blocking
    """
    n_parent_blocks: Size3D
    """
    Number of parent blocks for x, y and z axis. Total must not exceed 500,000,000.
    """
    n_subblocks_per_parent: RegularSubblocks
    """
    Number of sub-blocks per parent block per axis.
    """
    parent_block_size: BlockSize
    """
    Parent block size.
    """


class SizeOptionsFullySubBlocked(CustomBaseModel):
    model_type: Literal["fully-sub-blocked"] = Field(title="Model Type")
    """
    Type of sub-blocking
    """
    n_parent_blocks: Size3D
    """
    Number of parent blocks for x, y and z axis. Total must not exceed 500,000,000.
    """
    n_subblocks_per_parent: RegularSubblocks
    """
    Number of sub-blocks per parent block per axis.
    """
    parent_block_size: BlockSize
    """
    Parent block size.
    """


class SizeOptionsOctree(CustomBaseModel):
    model_type: Literal["variable-octree"] = Field(title="Model Type")
    """
    Type of sub-blocking
    """
    n_parent_blocks: Size3D
    """
    Number of parent blocks for x, y and z axis. Total must not exceed 500,000,000.
    """
    n_subblocks_per_parent: OctreeSubblocks
    """
    Number of sub-blocks per parent block per axis. Accepted values per axis are 1, 2, 4, 8, 16, 32 or 64.
    """
    parent_block_size: BlockSize
    """
    Parent block size.
    """


class SizeOptionsRegular(CustomBaseModel):
    block_size: BlockSize
    """
    Block size
    """
    model_type: Literal["regular"] = Field(title="Model Type")
    """
    Type of sub-blocking
    """
    n_blocks: Size3D
    """
    Number of blocks for x, y and z axis. Total must not exceed 500,000,000.
    """


class UnitType(Enum):
    LENGTH = "LENGTH"
    MASS = "MASS"
    VOLUME = "VOLUME"
    VALUE = "VALUE"
    MASS_PER_VOLUME = "MASS_PER_VOLUME"
    MASS_PER_MASS = "MASS_PER_MASS"
    VOLUME_PER_VOLUME = "VOLUME_PER_VOLUME"
    VALUE_PER_MASS = "VALUE_PER_MASS"


class UpdateBlockModel(CustomBaseModel):
    coordinate_reference_system: StrictStr | None = Field(
        None,
        examples=["EPSG:3395"],
        max_length=10000,
        title="Coordinate Reference System",
    )
    """

    Coordinate reference system used in the block model.

    This may be an EPSG code, signified by the prefix 'EPSG:', or a coordinate system definition in WKT format.

    """
    description: StrictStr | None = Field(None, max_length=500, title="Description")
    """
    Block model description
    """
    name: StrictStr | None = Field(None, max_length=100, min_length=3, title="Name")
    r"""
    Name of the block model. This may not contain `/` nor `\`.
    """
    size_unit_id: StrictStr | None = Field(None, title="Size Unit ID")
    """
    Unit ID denoting the length unit used for the block model's blocks.
    """


class UpdateMetadataValues(CustomBaseModel):
    title: StrictStr | None = Field(None, title="Title")
    """
    The new human-readable label for the column
    """
    unit_id: StrictStr | None = Field(None, title="Unit Id")
    """
    The new unit ID for the column
    """


class UpdateType(Enum):
    merge = "merge"
    replace = "replace"


class UpdatedResponse(CustomBaseModel):
    job_url: AnyUrl = Field(..., title="Job Url")


class UserInfo(CustomBaseModel):
    email: StrictStr | None = Field(None, examples=["kim@example.test"], title="Email Address")
    """
    The primary email address of the user. Can be null if an error occurred while retrieving this information.
    """
    id: UUID = Field(..., examples=["59b73891-5538-4e45-ae67-f8c5b00d7405"], title="User ID")
    """
    The ID of the user
    """
    name: StrictStr | None = Field(None, examples=["Kim Paul"], title="Full Name")
    """
    The full name of the user. Can be null if an error occurred while retrieving this information.
    """


class BBox(CustomBaseModel):
    i_minmax: IntRange
    """
    Minimum and maximum values for the `i` column in the file
    """
    j_minmax: IntRange
    """
    Minimum and maximum values for the `j` column in the file
    """
    k_minmax: IntRange
    """
    Minimum and maximum values for the `k` column in the file
    """


class BBoxXYZ(CustomBaseModel):
    x_minmax: FloatRange
    """
    Minimum and maximum values for the `x` column in the file
    """
    y_minmax: FloatRange
    """
    Minimum and maximum values for the `y` column in the file
    """
    z_minmax: FloatRange
    """
    Minimum and maximum values for the `z` column in the file
    """


class Column(CustomBaseModel):
    col_id: StrictStr = Field(..., examples=["618d6339-2fa7-4dfd-9c7f-c0b12016639e"], title="Col Id")
    """
    The ID of the column, a UUID for non-system columns
    """
    data_type: DataType
    title: StrictStr = Field(..., title="Title")
    """
    The human-readable label used to identify the column
    """
    unit_id: StrictStr | None = Field(None, title="Unit Id")
    """
    The ID of the column's unit
    """


class ColumnLite(CustomBaseModel):
    data_type: DataType
    title: StrictStr = Field(..., title="Title")
    """
    The human-readable label used to identify the column
    """
    unit_id: StrictStr | None = Field(None, title="Unit Id")
    """
    The ID of the column's unit
    """


class CreateReportSpecification(CustomBaseModel):
    autorun: StrictBool = Field(True, title="Autorun")
    """
    Whether to automatically run this Report Specification when a new version is published
    """
    bbox: BBox | BBoxXYZ | None = Field(
        None,
        examples=[
            {
                "i_minmax": {"max": 1, "min": 0},
                "j_minmax": {"max": 1, "min": 0},
                "k_minmax": {"max": 1, "min": 0},
            }
        ],
        title="Bbox",
    )
    """
    Bounding box for the report
    """
    categories: list[ReportCategory] | None = Field(
        None,
        examples=[
            [
                {
                    "col_id": "11c277c2-edc6-4a7a-8380-251dd19231f2",
                    "label": "Grade",
                    "values": ["low", "medium", "high"],
                }
            ]
        ],
        max_length=1,
        min_length=0,
        title="Categories",
    )
    """
    Category columns within this Report Specification. If null or empty, the report will have a single total row for each cut-off.
    """
    columns: list[ReportColumn] = Field(
        ...,
        examples=[
            [
                {
                    "aggregation": "SUM",
                    "col_id": "abc277c2-edc6-4a7a-8380-251dd19231f2",
                    "label": "Au content",
                    "output_unit_id": "kg",
                }
            ]
        ],
        title="Columns",
    )
    """
    Columns within this Report Specification
    """
    cutoff_col_id: UUID | None = Field(None, examples=["13c277c2-edc6-4a7a-8380-251dd19231f2"], title="Cutoff Col Id")
    """
    ID of the column to use for cut-off evaluation
    """
    cutoff_values: list[StrictFloat] | None = Field(
        None,
        examples=[[0.5, 1.5, 5]],
        max_length=20,
        min_length=1,
        title="Cutoff Values",
    )
    """
    Values to use for cut-off evaluation
    """
    density_col_id: UUID | None = Field(None, examples=["24c277c2-edc6-4a7a-8380-251dd19231f2"], title="Density Col Id")
    """
    ID of the column to use for block density
    """
    density_unit_id: StrictStr | None = Field(None, examples=["kg/m3"], title="Density Unit Id")
    """
    ID of the unit to use for block density. The unit must be of type `MASS_PER_VOLUME`.
    """
    density_value: StrictFloat | None = Field(None, examples=[2.5], gt=1, title="Density Value")
    """
    Value to use for block density
    """
    description: StrictStr | None = Field(
        None,
        examples=["Gold resource report for test purposes"],
        max_length=1000,
        title="Description",
    )
    """
    User-supplied description of the report
    """
    mass_unit_id: StrictStr = Field(..., examples=["t"], title="Mass Unit Id")
    """
    ID of the unit to use for total mass. The unit must be of type `MASS`
    """
    name: StrictStr = Field(..., title="Name")
    """
    The human-readable label used to identify the report
    """
    negative_values_policy: ReportNegativeValuesPolicy | None = Field("IGNORE_BLOCK", examples=["USE"])
    """
    Policy for handling negative values in the report's cut-off or value columns
    """
    null_values_policy: ReportNullValuesPolicy | None = Field("IGNORE_BLOCK", examples=["ZERO"])
    """
    Policy for handling null values in the report's cut-off or value columns
    """


class DeltaRequestData(CustomBaseModel):
    bbox: BBox | BBoxXYZ = Field(..., title="Bbox")
    """
    Bounding box within which changes are searched for.
    """
    columns: list[StrictStr] = Field(..., examples=[["*"]], title="Columns")
    """
    List of column IDs to consider when checking for column updates or deletions. Also accepts `['*']`, which will consider all columns.
    """
    end_version_uuid: UUID | None = Field(None, title="End Version Uuid")
    """
    Last version to search for changes in. Any versions newer than this are not searched for changes. If not supplied, changes are searched for within all version beyond the start version, up to and including the latest version of the block model.
    """
    verbose: StrictBool = Field(False, title="Verbose")
    """
    If there are changes, whether to return details about such changes or not.
    """


class Mapping(CustomBaseModel):
    columns: list[Column] = Field(..., title="Columns")


class QueryCriteria(CustomBaseModel):
    bbox: BBox | BBoxXYZ | None = Field(None, title="Bbox")
    """

    Bounding box of the search area as integer indexes or model aligned coordinates. If not provided, this is set to the entire block model.
        If using integer indexes, they must be `>=` zero and `<=` the number of blocks - 1.
        For example, if a block model has:
        ```
        n_blocks: {
            nx: 10,
            ny: 10,
            nz: 10
        }
        ```
        then i_max, j_max, and k_max must all be `>=` 0 and `<=` 9.
        If using model aligned coordinates, that is, rotated by the same scheme as the block model, centroids that are
        encapsulated by the bounding box will be selected. A side effect of this behaviour is a bounding box with x, y, z
        min-max can exceed the model along any axis.


    """
    columns: list[StrictStr] = Field(..., examples=[["*"]], title="Columns")
    """

    List of columns, in addition to the "geometry" columns, that will be included in the output file.
    The `columns` field supports selecting columns by either their title or ID, and can also include a wildcard (`"*"`) placeholder, which will expand to all user columns, ordered alphabetically by title in a case-insensitive manner.
    Please note that the wildcard does not cover the system column `version_id`. To include `version_id` in the output file, it must also be explicitly specified in the `columns` field alongside the wildcard.
    The order of columns in the output file will match the order in the `columns` field. Columns that are part of the initial "geometry" columns will be ignored if specified.

    """
    geometry_columns: GeometryColumns = "indices"
    """

    Determines whether the blocks in the output file will be primarily identified by their coordinates or their block
    indices.

    If `geometry_columns` is set to "indices" (the default), then the first columns in the output file will be `i`, `j`, `k` followed by the sub-block index columns (if applicable).
    If `geometry_columns` is set to "coordinates", then the output file will contain the columns `x`, `y`, `z` for regular block models and `x`, `y`, `z`, `dx`, `dy`, `dz` for sub-blocked block models. These columns are referred to as the "geometry" columns, and will appear before any others columns specified in the `columns` field.

    """
    output_options: OutputOptionsParquet | OutputOptionsCSV | None = Field(
        None, discriminator="file_format", title="Output Options"
    )
    """
    Format of the output file
    """
    version_uuid: UUID | None = Field(None, title="Version Uuid")
    """
    Version UUID of the version of the block model to query, or the latest version if not provided
    """


class QueryResult(CustomBaseModel):
    bbox: BBox | BBoxXYZ = Field(..., title="Bbox")
    """

    Bounding box of the search area as integer indexes or model aligned coordinates. If not provided, this is set to the entire block model.
        If using integer indexes, they must be `>=` zero and `<=` the number of blocks - 1.
        For example, if a block model has:
        ```
        n_blocks: {
            nx: 10,
            ny: 10,
            nz: 10
        }
        ```
        then i_max, j_max, and k_max must all be `>=` 0 and `<=` 9.
        If using model aligned coordinates, that is, rotated by the same scheme as the block model, centroids that are
        encapsulated by the bounding box will be selected. A side effect of this behaviour is a bounding box with x, y, z
        min-max can exceed the model along any axis.


    """
    bm_uuid: UUID = Field(..., examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"], title="Bm Uuid")
    """
    ID of the block model
    """
    columns: list[StrictStr] = Field(..., title="Columns")
    """

    List of columns, in addition to the "geometry" columns, that will be included in the output file.
    The `columns` field supports selecting columns by either their title or ID, and can also include a wildcard (`"*"`) placeholder, which will expand to all user columns, ordered alphabetically by title in a case-insensitive manner.
    Please note that the wildcard does not cover the system column `version_id`. To include `version_id` in the output file, it must also be explicitly specified in the `columns` field alongside the wildcard.
    The order of columns in the output file will match the order in the `columns` field. Columns that are part of the initial "geometry" columns will be ignored if specified.

    """
    job_url: AnyUrl = Field(..., title="Job Url")
    """
    Pollable job URL for this query
    """
    mapping: Mapping
    """

    List of columns, in addition to the "geometry" columns, that will be included in the output file.
    The `columns` field supports selecting columns by either their title or ID, and can also include a wildcard (`"*"`) placeholder, which will expand to all user columns, ordered alphabetically by title in a case-insensitive manner.
    Please note that the wildcard does not cover the system column `version_id`. To include `version_id` in the output file, it must also be explicitly specified in the `columns` field alongside the wildcard.
    The order of columns in the output file will match the order in the `columns` field. Columns that are part of the initial "geometry" columns will be ignored if specified.

    """
    version_id: StrictInt = Field(..., examples=[5], title="Version Id")
    """
    Identifier for the version within a block model as a monotonically increasing integer, where 1 is
    the `version_id` for the version created upon creation of the block model.
    """
    version_uuid: UUID = Field(..., examples=["3e9ce8de-f6ba-4920-8c6e-0882e90f0ed7"], title="Version Uuid")
    """
    A universally unique identifier for the version
    """


class ReportComparisonResultInfo(CustomBaseModel):
    referenced_columns: list[ReportResultReferencedColumn] = Field(..., title="Referenced Columns")
    report_result_created_at: datetime = Field(..., examples=["2021-01-01T00:00:00Z"], title="Report Result Created At")
    """
    Creation date of the Report Result
    """
    report_result_uuid: UUID = Field(
        ...,
        examples=["ccc277c2-edc6-4a7a-8380-251dd19231f2"],
        title="Report Result Uuid",
    )
    """
    ID of the Report Result
    """
    version_comment: StrictStr | None = Field(None, examples=["Updated density"], title="Version Comment")
    """
    Comment of the version of the block model that the report was run on
    """
    version_created_at: datetime = Field(..., examples=["2021-01-01T00:00:00Z"], title="Version Created At")
    """
    Creation date of the version of the block model that the report was run on
    """
    version_created_by: UserInfo
    """
    User who created the version of the block model that the report was run on
    """
    version_id: StrictInt = Field(..., examples=[2], title="Version Id")
    """
    Version ID of the version of the block model that the report was run on
    """
    version_uuid: UUID | None = Field(None, examples=["ccc277c2-edc6-4a7a-8380-251dd19231f2"], title="Version Uuid")
    """
    Version UUID of the version of block model that the report was run on
    """


class ReportComparisonRow(CustomBaseModel):
    categories: list[StrictStr | StrictInt | StrictFloat | StrictBool | None] = Field(
        ..., examples=[["Granite"]], title="Categories"
    )
    """
    List of category values. `null` indicates a total for that category column.
    """
    values: list[ReportComparisonValue] = Field(..., examples=[[2.7, 0.3]], title="Values")
    """
    List of values for the value columns
    """


class ReportResultSet(CustomBaseModel):
    cutoff_value: StrictFloat | None = Field(None, examples=[0.5], title="Cutoff Value")
    """
    Cut-off value for this set
    """
    rows: list[ReportRow] = Field(..., title="Rows")
    """
    List of rows in this result set
    """


class ReportResultSummary(CustomBaseModel):
    report_result_created_at: datetime = Field(..., examples=["2021-01-01T00:00:00Z"], title="Report Result Created At")
    """
    Creation date of the Report Result
    """
    report_result_uuid: UUID = Field(
        ...,
        examples=["ccc277c2-edc6-4a7a-8380-251dd19231f2"],
        title="Report Result Uuid",
    )
    """
    ID of the Report Result
    """
    report_specification_uuid: UUID = Field(
        ...,
        examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"],
        title="Report Specification Uuid",
    )
    """
    ID of the report specification that was run
    """
    version_created_at: datetime = Field(..., examples=["2021-01-01T00:00:00Z"], title="Version Created At")
    """
    Creation date of the version of the block model that the report was run on
    """
    version_created_by: UserInfo
    """
    User who created the version of the block model that the report was run on
    """
    version_id: StrictInt = Field(..., examples=[2], title="Version Id")
    """
    Version ID of the version of block model that the report was run on
    """
    version_uuid: UUID | None = Field(None, examples=["ccc277c2-edc6-4a7a-8380-251dd19231f2"], title="Version Uuid")
    """
    Version UUID of the version of block model that the report was run on
    """


class ReportSpecificationWithJobUrl(CustomBaseModel):
    autorun: StrictBool = Field(True, title="Autorun")
    """
    Whether to automatically run this Report Specification when a new version is published
    """
    bbox: BBox | BBoxXYZ | None = Field(
        None,
        examples=[
            {
                "i_minmax": {"max": 1, "min": 0},
                "j_minmax": {"max": 1, "min": 0},
                "k_minmax": {"max": 1, "min": 0},
            }
        ],
        title="Bbox",
    )
    """
    Bounding box for the report
    """
    bm_uuid: UUID = Field(..., examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"], title="Bm Uuid")
    """
    ID of the block model this Report Specification is associated with
    """
    categories: list[ReportCategory] | None = Field(
        None,
        examples=[
            [
                {
                    "col_id": "11c277c2-edc6-4a7a-8380-251dd19231f2",
                    "label": "Grade",
                    "values": ["low", "medium", "high"],
                }
            ]
        ],
        max_length=1,
        min_length=0,
        title="Categories",
    )
    """
    Category columns within this Report Specification. If null or empty, the report will have a single total row for each cut-off.
    """
    columns: list[ReportColumn] = Field(
        ...,
        examples=[
            [
                {
                    "aggregation": "SUM",
                    "col_id": "abc277c2-edc6-4a7a-8380-251dd19231f2",
                    "label": "Au content",
                    "output_unit_id": "kg",
                }
            ]
        ],
        title="Columns",
    )
    """
    Columns within this Report Specification
    """
    cutoff_col_id: UUID | None = Field(None, examples=["13c277c2-edc6-4a7a-8380-251dd19231f2"], title="Cutoff Col Id")
    """
    ID of the column to use for cut-off evaluation
    """
    cutoff_values: list[StrictFloat] | None = Field(
        None,
        examples=[[0.5, 1.5, 5]],
        max_length=20,
        min_length=1,
        title="Cutoff Values",
    )
    """
    Values to use for cut-off evaluation
    """
    density_col_id: UUID | None = Field(None, examples=["24c277c2-edc6-4a7a-8380-251dd19231f2"], title="Density Col Id")
    """
    ID of the column to use for block density
    """
    density_unit_id: StrictStr | None = Field(None, examples=["kg/m3"], title="Density Unit Id")
    """
    ID of the unit to use for block density. The unit must be of type `MASS_PER_VOLUME`.
    """
    density_value: StrictFloat | None = Field(None, examples=[2.5], gt=1, title="Density Value")
    """
    Value to use for block density
    """
    description: StrictStr | None = Field(
        None,
        examples=["Gold resource report for test purposes"],
        max_length=1000,
        title="Description",
    )
    """
    User-supplied description of the report
    """
    job_url: AnyUrl | None = Field(None, title="Job Url")
    """
    URL for the Reporting Job, if `run_now` was requested
    """
    mass_unit_id: StrictStr = Field(..., examples=["t"], title="Mass Unit Id")
    """
    ID of the unit to use for total mass. The unit must be of type `MASS`
    """
    name: StrictStr = Field(..., title="Name")
    """
    The human-readable label used to identify the report
    """
    negative_values_policy: ReportNegativeValuesPolicy | None = Field("IGNORE_BLOCK", examples=["USE"])
    """
    Policy for handling negative values in the report's cut-off or value columns
    """
    null_values_policy: ReportNullValuesPolicy | None = Field("IGNORE_BLOCK", examples=["ZERO"])
    """
    Policy for handling null values in the report's cut-off or value columns
    """
    report_specification_uuid: UUID = Field(
        ...,
        examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"],
        title="Report Specification Uuid",
    )
    """
    ID of the Report Specification
    """
    revision: StrictInt = Field(0, title="Revision")
    """
    Revision number of this Report Specification
    """


class ReportSpecificationWithLastRunInfo(CustomBaseModel):
    autorun: StrictBool = Field(True, title="Autorun")
    """
    Whether to automatically run this Report Specification when a new version is published
    """
    bbox: BBox | BBoxXYZ | None = Field(
        None,
        examples=[
            {
                "i_minmax": {"max": 1, "min": 0},
                "j_minmax": {"max": 1, "min": 0},
                "k_minmax": {"max": 1, "min": 0},
            }
        ],
        title="Bbox",
    )
    """
    Bounding box for the report
    """
    bm_uuid: UUID = Field(..., examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"], title="Bm Uuid")
    """
    ID of the block model this Report Specification is associated with
    """
    categories: list[ReportCategory] | None = Field(
        None,
        examples=[
            [
                {
                    "col_id": "11c277c2-edc6-4a7a-8380-251dd19231f2",
                    "label": "Grade",
                    "values": ["low", "medium", "high"],
                }
            ]
        ],
        max_length=1,
        min_length=0,
        title="Categories",
    )
    """
    Category columns within this Report Specification. If null or empty, the report will have a single total row for each cut-off.
    """
    columns: list[ReportColumn] = Field(
        ...,
        examples=[
            [
                {
                    "aggregation": "SUM",
                    "col_id": "abc277c2-edc6-4a7a-8380-251dd19231f2",
                    "label": "Au content",
                    "output_unit_id": "kg",
                }
            ]
        ],
        title="Columns",
    )
    """
    Columns within this Report Specification
    """
    cutoff_col_id: UUID | None = Field(None, examples=["13c277c2-edc6-4a7a-8380-251dd19231f2"], title="Cutoff Col Id")
    """
    ID of the column to use for cut-off evaluation
    """
    cutoff_values: list[StrictFloat] | None = Field(
        None,
        examples=[[0.5, 1.5, 5]],
        max_length=20,
        min_length=1,
        title="Cutoff Values",
    )
    """
    Values to use for cut-off evaluation
    """
    density_col_id: UUID | None = Field(None, examples=["24c277c2-edc6-4a7a-8380-251dd19231f2"], title="Density Col Id")
    """
    ID of the column to use for block density
    """
    density_unit_id: StrictStr | None = Field(None, examples=["kg/m3"], title="Density Unit Id")
    """
    ID of the unit to use for block density. The unit must be of type `MASS_PER_VOLUME`.
    """
    density_value: StrictFloat | None = Field(None, examples=[2.5], gt=1, title="Density Value")
    """
    Value to use for block density
    """
    description: StrictStr | None = Field(
        None,
        examples=["Gold resource report for test purposes"],
        max_length=1000,
        title="Description",
    )
    """
    User-supplied description of the report
    """
    last_result_created_at: datetime | None = Field(
        None, examples=["2021-01-01T00:00:00Z"], title="Last Result Created At"
    )
    """
    Creation date of the Report Result
    """
    last_result_version_id: StrictInt | None = Field(None, examples=[2], title="Last Result Version Id")
    """
    Version ID of the version of the block model that the report was run on
    """
    mass_unit_id: StrictStr = Field(..., examples=["t"], title="Mass Unit Id")
    """
    ID of the unit to use for total mass. The unit must be of type `MASS`
    """
    name: StrictStr = Field(..., title="Name")
    """
    The human-readable label used to identify the report
    """
    negative_values_policy: ReportNegativeValuesPolicy | None = Field("IGNORE_BLOCK", examples=["USE"])
    """
    Policy for handling negative values in the report's cut-off or value columns
    """
    null_values_policy: ReportNullValuesPolicy | None = Field("IGNORE_BLOCK", examples=["ZERO"])
    """
    Policy for handling null values in the report's cut-off or value columns
    """
    report_specification_uuid: UUID = Field(
        ...,
        examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"],
        title="Report Specification Uuid",
    )
    """
    ID of the Report Specification
    """
    revision: StrictInt = Field(0, title="Revision")
    """
    Revision number of this Report Specification
    """


class ReportWarning(CustomBaseModel):
    message: StrictStr = Field(
        ...,
        examples=["Density value was null, or less than or equal to 0. The default density value of 2.7 was used."],
        title="Message",
    )
    """
    Warning message
    """
    occurrences: StrictInt = Field(..., examples=[1], title="Occurrences")
    """
    Number of occurrences of the warning
    """
    warning_type: ReportWarningType = Field(..., examples=["INVALID_DENSITY_VALUE"])
    """
    Type of warning
    """


class Rotation(CustomBaseModel):
    angle: StrictFloat = Field(..., title="Angle")
    """
    Angle of rotation in degrees
    """
    axis: RotationAxis
    """
    Axis of rotation
    """


class Unit(CustomBaseModel):
    conversion_factor: StrictFloat = Field(..., examples=[1], title="Conversion Factor")
    """
    Conversion factor to convert to the reference unit for this unit type
    """
    description: StrictStr = Field(..., examples=["Metres"], title="Description")
    """
    Description of the unit
    """
    symbol: StrictStr = Field(..., examples=["m"], title="Symbol")
    """
    Display symbol for the unit
    """
    unit_id: StrictStr = Field(..., examples=["m"], title="Unit Id")
    """
    ID of the unit
    """
    unit_type: UnitType = Field(..., examples=["LENGTH"])
    """
    Type of the unit
    """


class UpdateMetadata(CustomBaseModel):
    col_id: StrictStr = Field(..., examples=["618d6339-2fa7-4dfd-9c7f-c0b12016639e"], title="Col Id")
    """
    The ID of the column, a UUID for non-system columns
    """
    values: UpdateMetadataValues


class UpdateMetadataLite(CustomBaseModel):
    title: StrictStr = Field(..., title="Title")
    """
    The original human-readable label used to identify the column
    """
    values: UpdateMetadataValues


class Version(CustomBaseModel):
    """
    API output
    """

    base_version_id: StrictInt | None = Field(None, examples=[4], title="Base Version Id")
    """
    Version the update was applied to. This will be the same as `parent_version_id`, except for
    updates made by Leapfrog, where it is the current local version when the block model is published. This is null if this
    is the first version.
    """
    bbox: BBox | None = None
    """

    Bounding box of data updated between this version and last version. Will be None for the initial version, and updates
    that only delete and rename columns.

    """
    bm_uuid: UUID = Field(..., examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"], title="Bm Uuid")
    """
    ID of the block model
    """
    comment: StrictStr = Field("", title="Comment")
    """
    User-supplied comment
    """
    created_at: datetime = Field(..., title="Created At")
    """
    When the version was created
    """
    created_by: UserInfo
    """
    User who performed the action that created the version
    """
    geoscience_version_id: StrictStr | None = Field(None, examples=["1234567890"], title="Geoscience Version Id")
    """
    ID of the Geoscience Object Service object version associated with this block model version
    """
    mapping: Mapping
    """
    Columns within this version
    """
    parent_version_id: StrictInt | None = Field(None, examples=[4], title="Parent Version Id")
    """
    Previous version. 0 if this is the first version.
    """
    version_id: StrictInt = Field(..., examples=[5], title="Version Id")
    """
    Identifier for the version within a block model as a monotonically increasing integer, where 1 is
    the `version_id` for the version created upon creation of the block model.
    """
    version_uuid: UUID = Field(..., examples=["3e9ce8de-f6ba-4920-8c6e-0882e90f0ed7"], title="Version Uuid")
    """
    A universally unique identifier for the version
    """


class VersionColumnChanges(CustomBaseModel):
    deleted: list[StrictStr] = Field([], title="Deleted")
    metadata_updated: list[UpdateMetadataLite] | None = Field([], title="Metadata Updated")
    new: list[StrictStr] = Field([], title="New")
    renamed: list[ColumnRename] = Field([], title="Renamed")
    updated: list[StrictStr] = Field([], title="Updated")


class BlockModel(CustomBaseModel):
    bbox: BBoxXYZ
    """

    Axis-aligned bounding box of the block model.

    This is the smallest box that fully contains all blocks within the block model, regardless of whether they contain data.
    It is defined by the minimum and maximum coordinates along each axis.

    """
    block_rotation: list[Rotation] = Field(..., title="Block Rotation")
    """

    The rotation of the block model. Defined by a list of clockwise rotations around given axes.

    The combined equation for the rotation is given by:

        R_1 ... R_n A = B

    where `A` is the location in the IJK space, `B` is the location in coordinate space, and `R_i` is the rotation matrix for the `i`th rotation.

    For example, if the first rotation is a rotation of 15 degrees clockwise around the X axis, `R_1` would be `[[1, 0, 0], [0, cos(15), sin(15)], [0, -sin(15), cos(15)]]`.

    Two rotations around the same axis cannot be consecutive items within the list of rotations.

    """
    bm_uuid: UUID = Field(..., title="Block model ID")
    """
    ID of the block model
    """
    coordinate_reference_system: StrictStr | None = Field(
        None, examples=["EPSG:3395"], title="Coordinate Reference System"
    )
    """

    Coordinate reference system used in the block model.

    This may be an EPSG code, signified by the prefix 'EPSG:', or a coordinate system definition in WKT format.

    """
    created_at: datetime = Field(..., title="Created At")
    """
    Block model creation time
    """
    created_by: UserInfo
    """
    User who created the block model
    """
    description: StrictStr | None = Field(None, title="Description")
    """
    User-supplied description of the block model
    """
    geoscience_object_id: UUID | None = Field(
        None,
        examples=["f1230d69-c779-4736-9eb6-f82d49aafa9a"],
        title="Geoscience Object Id",
    )
    """
    UUID of the Geoscience Object Service object associated with the block model
    """
    last_updated_at: datetime = Field(..., title="Last Updated At")
    """
    Date and time of the last block model update, including metadata updates
    """
    last_updated_by: UserInfo
    """
    User who last updated the block model, including metadata updates
    """
    model_origin: Location
    """
    Origin of the block model
    """
    name: StrictStr = Field(..., title="Name")
    """
    The human-readable label used to identify the block model
    """
    normalized_rotation: list = Field(..., max_length=3, min_length=3, title="Normalized Rotation")
    """
    Normalised rotation of the block model, represented as intrinsic rotations around the Z axis, then X axis, then Z axis.
    """
    org_uuid: UUID = Field(..., examples=["e6230d69-c779-4736-9eb6-f82d49aafa06"], title="Organisation ID")
    """
    Organisation the block model belongs to.
    """
    size_options: SizeOptionsRegular | SizeOptionsOctree | SizeOptionsFullySubBlocked | SizeOptionsFlexible = Field(
        ..., discriminator="model_type", title="Size Options"
    )
    """
    Size of the block model
    """
    size_unit_id: StrictStr | None = Field(None, title="Size Unit Id")
    """
    Unit ID denoting the length unit used for the block model's blocks.
    """
    workspace_id: UUID = Field(..., examples=["860be2f5-fe06-4c1b-ac8b-7d34d2b6d2ef"], title="Workspace ID")
    """
    Workspace the block model belongs to.
    """


class BlockModelAndJobURL(CustomBaseModel):
    bbox: BBoxXYZ
    """

    Axis-aligned bounding box of the block model.

    This is the smallest box that fully contains all blocks within the block model, regardless of whether they contain data.
    It is defined by the minimum and maximum coordinates along each axis.

    """
    block_rotation: list[Rotation] = Field(..., title="Block Rotation")
    """

    The rotation of the block model. Defined by a list of clockwise rotations around given axes.

    The combined equation for the rotation is given by:

        R_1 ... R_n A = B

    where `A` is the location in the IJK space, `B` is the location in coordinate space, and `R_i` is the rotation matrix for the `i`th rotation.

    For example, if the first rotation is a rotation of 15 degrees clockwise around the X axis, `R_1` would be `[[1, 0, 0], [0, cos(15), sin(15)], [0, -sin(15), cos(15)]]`.

    Two rotations around the same axis cannot be consecutive items within the list of rotations.

    """
    bm_uuid: UUID = Field(..., title="Block model ID")
    """
    ID of the block model
    """
    coordinate_reference_system: StrictStr | None = Field(
        None, examples=["EPSG:3395"], title="Coordinate Reference System"
    )
    """

    Coordinate reference system used in the block model.

    This may be an EPSG code, signified by the prefix 'EPSG:', or a coordinate system definition in WKT format.

    """
    created_at: datetime = Field(..., title="Created At")
    """
    Block model creation time
    """
    created_by: UserInfo
    """
    User who created the block model
    """
    description: StrictStr | None = Field(None, title="Description")
    """
    User-supplied description of the block model
    """
    geoscience_object_id: UUID | None = Field(
        None,
        examples=["f1230d69-c779-4736-9eb6-f82d49aafa9a"],
        title="Geoscience Object Id",
    )
    """
    UUID of the Geoscience Object Service object associated with the block model
    """
    job_url: AnyUrl = Field(..., title="Job Url")
    last_updated_at: datetime = Field(..., title="Last Updated At")
    """
    Date and time of the last block model update, including metadata updates
    """
    last_updated_by: UserInfo
    """
    User who last updated the block model, including metadata updates
    """
    model_origin: Location
    """
    Origin of the block model
    """
    name: StrictStr = Field(..., title="Name")
    """
    The human-readable label used to identify the block model
    """
    normalized_rotation: list = Field(..., max_length=3, min_length=3, title="Normalized Rotation")
    """
    Normalised rotation of the block model, represented as intrinsic rotations around the Z axis, then X axis, then Z axis.
    """
    org_uuid: UUID = Field(..., examples=["e6230d69-c779-4736-9eb6-f82d49aafa06"], title="Organisation ID")
    """
    Organisation the block model belongs to.
    """
    size_options: SizeOptionsRegular | SizeOptionsOctree | SizeOptionsFullySubBlocked | SizeOptionsFlexible = Field(
        ..., discriminator="model_type", title="Size Options"
    )
    """
    Size of the block model
    """
    size_unit_id: StrictStr | None = Field(None, title="Size Unit Id")
    """
    Unit ID denoting the length unit used for the block model's blocks.
    """
    workspace_id: UUID = Field(..., examples=["860be2f5-fe06-4c1b-ac8b-7d34d2b6d2ef"], title="Workspace ID")
    """
    Workspace the block model belongs to.
    """


class CreateData(CustomBaseModel):
    block_rotation: list[Rotation] = Field(..., max_length=3, title="Block Rotation")
    """

    The rotation of the block model. Defined by a list of clockwise rotations around given axes.

    The combined equation for the rotation is given by:

        R_1 ... R_n A = B

    where `A` is the location in the IJK space, `B` is the location in coordinate space, and `R_i` is the rotation matrix for the `i`th rotation.

    For example, if the first rotation is a rotation of 15 degrees clockwise around the X axis, `R_1` would be `[[1, 0, 0], [0, cos(15), sin(15)], [0, -sin(15), cos(15)]]`.

    Two rotations around the same axis cannot be consecutive items within the list of rotations.

    """
    comment: StrictStr | None = Field(None, max_length=250, title="Comment")
    coordinate_reference_system: StrictStr | None = Field(
        None,
        examples=["EPSG:3395"],
        max_length=10000,
        title="Coordinate Reference System",
    )
    """

    Coordinate reference system used in the block model.

    This may be an EPSG code, signified by the prefix 'EPSG:', or a coordinate system definition in WKT format.

    """
    description: StrictStr | None = Field(None, max_length=500, title="Description")
    """
    Description of the block model
    """
    model_origin: Location
    name: StrictStr = Field(..., title="Name")
    r"""
    Name of the block model. This may not contain `/` nor `\`.
    """
    object_path: StrictStr | None = Field(None, examples=["/path/to/folder"], title="Object Path")
    r"""

    Path of the folder in Geoscience Object Service to create the reference object in.

    This may not contain relative elements like `.` or `..`. It may not contain double slashes `//`, nor backslashes `\`,
    nor elements ending in `.`.

    """
    size_options: SizeOptionsRegular | SizeOptionsOctree | SizeOptionsFullySubBlocked | SizeOptionsFlexible = Field(
        ..., discriminator="model_type", title="Size Options"
    )
    size_unit_id: StrictStr | None = Field(None, examples=["m"], title="Size Unit Id")
    """
    Unit ID denoting the length unit used for the block model's blocks.
    """


class JobResponse(CustomBaseModel):
    job_status: JobStatus = Field(..., examples=["COMPLETE"])
    """

    Status of this job. The statuses have the following meanings:
     - `PENDING_UPLOAD`: This is a model update job, and is awaiting notification that file upload has
       completed before proceeding any further.
     - `QUEUED`: The job is ready for processing, and is queued waiting for a worker process to become available.
     - `PROCESSING`: The job is actively being processed by a worker.
     - `COMPLETE`: The job completed successfully.
     - `FAILED`: The job failed. No further processing of this job will be attempted.

    """
    payload: (
        Version
        | QueryDownload
        | JobErrorPayload
        | ReportRunResult
        | ReportComparisonJobResult
        | JobPendingPayload
        | None
    ) = Field(None, title="Payload")
    """

    The payload describes the outcome of the job, and is set for completed or failed jobs. This property will not appear if the
    job is not yet `COMPLETE` or `FAILED`.
     - For all failed jobs, this will be a `JobErrorPayload`.
     - For completed create or update jobs, this will be a `Version`.
     - For completed query jobs, this will be a `QueryDownload`.

    """


class PaginatedResponseWithUnitsReportSpecificationWithLastRunInfo(CustomBaseModel):
    count: StrictInt = Field(..., title="Count")
    """
    Number of results returned in `results`
    """
    limit: StrictInt = Field(..., title="Limit")
    """
    Maximum number of items requested
    """
    offset: StrictInt = Field(..., title="Offset")
    """
    Index of the first item in `results` with respect to the full list without pagination
    """
    referenced_units: list[Unit] = Field(..., title="Referenced Units")
    """
    List of all units referenced in the results
    """
    results: list[ReportSpecificationWithLastRunInfo] = Field(..., title="Results")
    """
    List of results
    """
    total: StrictInt = Field(..., title="Total")
    """
    Total number of items within the full list without pagination
    """


class PaginatedResponseWithUnitsVersion(CustomBaseModel):
    count: StrictInt = Field(..., title="Count")
    """
    Number of results returned in `results`
    """
    limit: StrictInt = Field(..., title="Limit")
    """
    Maximum number of items requested
    """
    offset: StrictInt = Field(..., title="Offset")
    """
    Index of the first item in `results` with respect to the full list without pagination
    """
    referenced_units: list[Unit] = Field(..., title="Referenced Units")
    """
    List of all units referenced in the results
    """
    results: list[Version] = Field(..., title="Results")
    """
    List of results
    """
    total: StrictInt = Field(..., title="Total")
    """
    Total number of items within the full list without pagination
    """


class PaginatedResponseBlockModel(CustomBaseModel):
    count: StrictInt = Field(..., title="Count")
    """
    Number of results returned in `results`
    """
    limit: StrictInt = Field(..., title="Limit")
    """
    Maximum number of items requested
    """
    offset: StrictInt = Field(..., title="Offset")
    """
    Index of the first item in `results` with respect to the full list without pagination
    """
    results: list[BlockModel] = Field(..., title="Results")
    """
    List of results
    """
    total: StrictInt = Field(..., title="Total")
    """
    Total number of items within the full list without pagination
    """


class PaginatedResponseReportResultSummary(CustomBaseModel):
    count: StrictInt = Field(..., title="Count")
    """
    Number of results returned in `results`
    """
    limit: StrictInt = Field(..., title="Limit")
    """
    Maximum number of items requested
    """
    offset: StrictInt = Field(..., title="Offset")
    """
    Index of the first item in `results` with respect to the full list without pagination
    """
    results: list[ReportResultSummary] = Field(..., title="Results")
    """
    List of results
    """
    total: StrictInt = Field(..., title="Total")
    """
    Total number of items within the full list without pagination
    """


class ReportComparisonResultSet(CustomBaseModel):
    cutoff_value: StrictFloat | None = Field(None, examples=[1], title="Cutoff Value")
    """
    Cut-off value used in the report
    """
    rows: list[ReportComparisonRow] = Field(
        ..., examples=[{"categories": ["Granite"], "values": [2.7, 0.3]}], title="Rows"
    )
    """
    List of rows in the Report Result
    """


class ReportComparisonWarnings(CustomBaseModel):
    comparison: list[ReportWarning] = Field(..., title="Comparison")
    from_result: list[ReportWarning] = Field(..., title="From Result")
    to_result: list[ReportWarning] = Field(..., title="To Result")


class ReportResult(CustomBaseModel):
    bm_uuid: UUID = Field(..., examples=["bbb277c2-edc6-4a7a-8380-251dd19231f2"], title="Bm Uuid")
    """
    ID of the block model that the report was run on
    """
    categories: list[ReportResultCategory] = Field(
        ...,
        examples=[{"col_id": "ddd277c2-edc6-4a7a-8380-251dd19231f2", "label": "Rock type"}],
        title="Categories",
    )
    """
    List of categories used in the report
    """
    cutoff_col_id: UUID | None = Field(None, examples=["ccc277c2-edc6-4a7a-8380-251dd19231f2"], title="Cutoff Col Id")
    """
    ID of the column that was used for cut-off evaluation
    """
    referenced_columns: list[ReportResultReferencedColumn] = Field(..., title="Referenced Columns")
    report_result_created_at: datetime = Field(..., examples=["2021-01-01T00:00:00Z"], title="Report Result Created At")
    """
    Creation date of the Report Result
    """
    report_result_uuid: UUID = Field(
        ...,
        examples=["ccc277c2-edc6-4a7a-8380-251dd19231f2"],
        title="Report Result Uuid",
    )
    """
    ID of the Report Result
    """
    report_specification_description: StrictStr | None = Field(
        None,
        examples=["A report to show the density of the block model"],
        title="Report Specification Description",
    )
    """
    Description of the report specification that was run
    """
    report_specification_name: StrictStr = Field(..., examples=["Density Report"], title="Report Specification Name")
    """
    Name of the report specification that was run
    """
    report_specification_revision: StrictInt = Field(..., examples=[1], title="Report Specification Revision")
    """
    Revision of the report specification that was run
    """
    report_specification_uuid: UUID = Field(
        ...,
        examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"],
        title="Report Specification Uuid",
    )
    """
    ID of the report specification that was run
    """
    result_sets: list[ReportResultSet] = Field(..., title="Result Sets")
    value_columns: list[ReportResultColumn] = Field(
        ...,
        examples=[
            {
                "col_id": "eee277c2-edc6-4a7a-8380-251dd19231f2",
                "label": "Average gold content",
                "unit_id": "ppm[mass]",
            }
        ],
        title="Value Columns",
    )
    """
    List of value columns used in the report
    """
    version_comment: StrictStr | None = Field(None, examples=["Updated density"], title="Version Comment")
    """
    Comment of the version of the block model that the report was run on
    """
    version_created_at: datetime = Field(..., examples=["2021-01-01T00:00:00Z"], title="Version Created At")
    """
    Creation date of the version of the block model that the report was run on
    """
    version_created_by: UserInfo
    """
    User who created the version of the block model that the report was run on
    """
    version_id: StrictInt = Field(..., examples=[2], title="Version Id")
    """
    Version ID of the version of block model that the report was run on
    """
    version_uuid: UUID | None = Field(None, examples=["ccc277c2-edc6-4a7a-8380-251dd19231f2"], title="Version Uuid")
    """
    Version UUID of the version of block model that the report was run on
    """
    warnings: list[ReportWarning] = Field(..., title="Warnings")


class UpdateColumns(CustomBaseModel):
    delete: list[StrictStr] = Field(..., title="Delete")
    """
    The list of column IDs for deletion
    """
    new: list[Column] = Field(..., title="New")
    rename: list[Rename] = Field(..., title="Rename")
    update: list[StrictStr] = Field(..., title="Update")
    """
    The list of column IDs for update
    """
    update_metadata: list[UpdateMetadata] | None = Field(None, title="Update Metadata")


class UpdateColumnsLiteInput(CustomBaseModel):
    delete: list[StrictStr] = Field(..., title="Delete")
    """
    The list of column titles for deletion
    """
    new: list[ColumnLite] = Field(..., title="New")
    rename: list[RenameLite] = Field(..., title="Rename")
    update: list[StrictStr] = Field(..., title="Update")
    """
    The list of column titles for update
    """
    update_metadata: list[UpdateMetadataLite] | None = Field(None, title="Update Metadata")


class UpdateColumnsLiteOutput(CustomBaseModel):
    delete: list[StrictStr] = Field(..., title="Delete")
    """
    The list of column titles for deletion
    """
    new: list[ColumnLite] = Field(..., title="New")
    rename: list[RenameLite] = Field(..., title="Rename")
    update: list[StrictStr] = Field(..., title="Update")
    """
    The list of column titles for update
    """
    update_metadata: list[UpdateMetadataLite] | None = Field(None, title="Update Metadata")


class UpdateDataLiteInput(CustomBaseModel):
    columns: UpdateColumnsLiteInput
    comment: StrictStr | None = Field(None, max_length=250, title="Comment")
    geometry_change: StrictBool | None = Field(None, title="Geometry Change")
    """

    Whether the update will create or destroy sub-blocks.
    - If set to `false`, no sub-blocks can be created nor destroyed, only sub-blocks that exist in the latest version can be updated.
    - If set to `true`:
        - New sub-blocks can be created and/or existing sub-blocks can be destroyed, but all columns must be provided.
        - Only `new`, `update`, and `delete` column operations are allowed as standalone operations.
        - `update_metadata` is allowed, but only when the target columns are being updated as part of the `update` operation, and only when there are no columns being renamed.
        - If `update_type` is set to `merge`, then all sub-blocks within a parent block must be provided.

    """
    input_options: InputOptionsParquet | InputOptionsCSV | None = Field(
        None, discriminator="file_format", title="Input Options"
    )
    update_type: UpdateType = "merge"
    """

    Behaviour of the update, for blocks that are omitted from the update file.
    - If set to `replace`, the values for blocks that are omitted will be set to null, for the selected columns. If `geometry_change` is true, the geometry of any parent block that has no blocks in the update file will be reset to an un-subdivided state.
    - If set to `merge`, blocks that are omitted will be left unchanged, the values within those blocks will be the same as within the previous version.

    """


class UpdateDataLiteOutput(CustomBaseModel):
    columns: UpdateColumnsLiteOutput
    comment: StrictStr | None = Field(None, max_length=250, title="Comment")
    geometry_change: StrictBool | None = Field(None, title="Geometry Change")
    """

    Whether the update will create or destroy sub-blocks.
    - If set to `false`, no sub-blocks can be created nor destroyed, only sub-blocks that exist in the latest version can be updated.
    - If set to `true`:
        - New sub-blocks can be created and/or existing sub-blocks can be destroyed, but all columns must be provided.
        - Only `new`, `update`, and `delete` column operations are allowed as standalone operations.
        - `update_metadata` is allowed, but only when the target columns are being updated as part of the `update` operation, and only when there are no columns being renamed.
        - If `update_type` is set to `merge`, then all sub-blocks within a parent block must be provided.

    """
    input_options: InputOptionsParquet | InputOptionsCSV | None = Field(
        None, discriminator="file_format", title="Input Options"
    )
    update_type: UpdateType = UpdateType.merge
    """

    Behaviour of the update, for blocks that are omitted from the update file.
    - If set to `replace`, the values for blocks that are omitted will be set to null, for the selected columns. If `geometry_change` is true, the geometry of any parent block that has no blocks in the update file will be reset to an un-subdivided state.
    - If set to `merge`, blocks that are omitted will be left unchanged, the values within those blocks will be the same as within the previous version.

    """


class UpdateDataWithVersion(CustomBaseModel):
    base_version_uuid: UUID = Field(..., title="Base Version Uuid")
    bbox: BBox | BBoxXYZ | None = Field(None, title="Bbox")
    columns: UpdateColumns
    comment: StrictStr | None = Field(None, max_length=250, title="Comment")
    geometry_change: StrictBool | None = Field(None, title="Geometry Change")
    """

    Whether the update will create or destroy sub-blocks.
    - If set to `false`, no sub-blocks can be created nor destroyed, only sub-blocks that exist in the latest version can be updated.
    - If set to `true`:
        - New sub-blocks can be created and/or existing sub-blocks can be destroyed, but all columns must be provided.
        - Only `new`, `update`, and `delete` column operations are allowed as standalone operations.
        - `update_metadata` is allowed, but only when the target columns are being updated as part of the `update` operation, and only when there are no columns being renamed.
        - If `update_type` is set to `merge`, then all sub-blocks within a parent block must be provided.

    """
    update_type: UpdateType = "merge"
    """

    Behaviour of the update, for blocks that are omitted from the update file.
    - If set to `replace`, the values for blocks that are omitted will be set to null, for the selected columns. If `geometry_change` is true, the geometry of any parent block that has no blocks in the update file will be reset to an un-subdivided state.
    - If set to `merge`, blocks that are omitted will be left unchanged, the values within those blocks will be the same as within the previous version.

    """


class UpdateWithUrl(CustomBaseModel):
    changes: UpdateDataWithVersion | UpdateDataLiteOutput = Field(..., title="Changes")
    job_url: AnyUrl = Field(..., title="Job Url")
    job_uuid: UUID = Field(..., title="Job Uuid")
    upload_url: AnyUrl | None = Field(None, title="Upload Url")
    version_uuid: UUID = Field(..., title="Version Uuid")


class VersionChanges(CustomBaseModel):
    blocks_uploaded: StrictInt | None = Field(None, title="Blocks Uploaded")
    columns: VersionColumnChanges
    total_blocks: StrictInt = Field(..., title="Total Blocks")
    update_type: UpdateType | None = None
    """

    Behaviour of the update, for blocks that are omitted from the update file.
    - If set to `replace`, the values for blocks that are omitted will be set to null, for the selected columns. If `geometry_change` is true, the geometry of any parent block that has no blocks in the update file will be reset to an un-subdivided state.
    - If set to `merge`, blocks that are omitted will be left unchanged, the values within those blocks will be the same as within the previous version.

    This is null if there were no columns updated and `geometry_change` was not set to false.

    """


class VersionWithChanges(CustomBaseModel):
    base_version_id: StrictInt | None = Field(None, examples=[4], title="Base Version Id")
    """
    Version the update was applied to. This will be the same as `parent_version_id`, except for
    updates made by Leapfrog, where it is the current local version when the block model is published. This is null if this
    is the first version.
    """
    bbox: BBox | None = None
    """

    Bounding box of data updated between this version and last version. Will be None for the initial version, and updates
    that only delete and rename columns.

    """
    bm_uuid: UUID = Field(..., examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"], title="Bm Uuid")
    """
    ID of the block model
    """
    changes: VersionChanges
    comment: StrictStr = Field("", title="Comment")
    """
    User-supplied comment
    """
    created_at: datetime = Field(..., title="Created At")
    """
    When the version was created
    """
    created_by: UserInfo
    """
    User who performed the action that created the version
    """
    geoscience_version_id: StrictStr | None = Field(None, examples=["1234567890"], title="Geoscience Version Id")
    """
    ID of the Geoscience Object Service object version associated with this block model version
    """
    mapping: Mapping
    """
    Columns within this version
    """
    parent_version_id: StrictInt | None = Field(None, examples=[4], title="Parent Version Id")
    """
    Previous version. 0 if this is the first version.
    """
    version_id: StrictInt = Field(..., examples=[5], title="Version Id")
    """
    Identifier for the version within a block model as a monotonically increasing integer, where 1 is
    the `version_id` for the version created upon creation of the block model.
    """
    version_uuid: UUID = Field(..., examples=["3e9ce8de-f6ba-4920-8c6e-0882e90f0ed7"], title="Version Uuid")
    """
    A universally unique identifier for the version
    """


class DeltaVersionData(CustomBaseModel):
    bbox: BBox | None = None
    """
    Bounding box of the search area as integer indexes
    """
    mapping: Mapping
    """
    List of internal column names to be included into the result
    """
    update_columns: UpdateColumns
    """
    Columns added, updated, or deleted in this version
    """
    version_id: StrictInt = Field(..., examples=[5], title="Version Id")
    """
    Identifier for the version within a block model as a monotonically increasing integer, where 1 is
    the `version_id` for the version created upon creation of the block model.
    """
    version_uuid: UUID = Field(..., examples=["3e9ce8de-f6ba-4920-8c6e-0882e90f0ed7"], title="Version Uuid")
    """
    A universally unique identifier for the version
    """


class ReportComparison(CustomBaseModel):
    bm_uuid: UUID = Field(..., examples=["bbb277c2-edc6-4a7a-8380-251dd19231f2"], title="Bm Uuid")
    """
    ID of the block model that the report was run on
    """
    categories: list[ReportResultCategory] = Field(
        ...,
        examples=[{"col_id": "ddd277c2-edc6-4a7a-8380-251dd19231f2", "label": "Rock type"}],
        title="Categories",
    )
    """
    List of categories used in the report
    """
    cutoff_col_id: UUID | None = Field(None, examples=["ccc277c2-edc6-4a7a-8380-251dd19231f2"], title="Cutoff Col Id")
    """
    ID of the column that was used for cut-off evaluation
    """
    from_result: ReportComparisonResultInfo
    report_specification_description: StrictStr | None = Field(
        None,
        examples=["A report to show the density of the block model"],
        title="Report Specification Description",
    )
    """
    Description of the Report Specification that was run
    """
    report_specification_name: StrictStr = Field(..., examples=["Density Report"], title="Report Specification Name")
    """
    Name of the Report Specification that was run
    """
    report_specification_revision: StrictInt = Field(..., examples=[1], title="Report Specification Revision")
    """
    Revision of the Report Specification that was run
    """
    report_specification_uuid: UUID = Field(
        ...,
        examples=["e3c277c2-edc6-4a7a-8380-251dd19231f2"],
        title="Report Specification Uuid",
    )
    """
    ID of the Report Specification that was run
    """
    result_sets: list[ReportComparisonResultSet] = Field(..., title="Result Sets")
    to_result: ReportComparisonResultInfo
    value_columns: list[ReportResultColumn] = Field(
        ...,
        examples=[
            {
                "col_id": "eee277c2-edc6-4a7a-8380-251dd19231f2",
                "label": "Average gold content",
                "unit_id": "ppm[mass]",
            }
        ],
        title="Value Columns",
    )
    """
    List of value columns used in the report
    """
    warnings: ReportComparisonWarnings


class DeltaResponseData(CustomBaseModel):
    """
    Details about changes that occurred between two versions, within the specified bounding box.
    """

    delete_deltas: list[UUID] = Field(..., title="Delete Deltas")
    """
    List of versions that deleted specified columns
    """
    new_deltas: list[UUID] = Field(..., title="New Deltas")
    """
    List of versions that added new columns
    """
    update_deltas: list[UUID] = Field(..., title="Update Deltas")
    """
    List of versions that contain updates within the specified bounding box, to the specified columns
    """
    version_data: list[DeltaVersionData] = Field(..., title="Version Data")
    """
    Details about the changes per version
    """
