#  Copyright © 2025 Bentley Systems, Incorporated
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#      http://www.apache.org/licenses/LICENSE-2.0
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

"""
Colormap API
=============


        The Evo Colormap API allows you to create and manage colormaps, and associate them to attributes.


This code is generated from the OpenAPI specification for Colormap API.
API version: 1.0
"""

from evo.common.connector import APIConnector
from evo.common.data import EmptyResponse, RequestMethod  # noqa: F401

from ..models import *  # noqa: F403

__all__ = ["ColormapsApi"]


class ColormapsApi:
    """Api client for the Colormaps endpoint.

    NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    :param connector: Client for communicating with the API.
    """

    def __init__(self, connector: APIConnector):
        self.connector = connector

    async def get_colormap_by_id(
        self,
        org_id: str,
        workspace_id: str,
        colormap_id: str,
        api_preview: str | None = None,
        additional_headers: dict[str, str] | None = None,
        request_timeout: int | float | tuple[int | float, int | float] | None = None,
    ) -> ResponseGetColormapByID:  # noqa: F405
        """Get colormap by ID

        Get a colormap by its ID, for a specified workspace and organization.

        :param org_id:
            Format: `uuid`
            Example: `'org_id_example'`
        :param workspace_id:
            Format: `uuid`
            Example: `'workspace_id_example'`
        :param colormap_id:
            Format: `uuid`
            Example: `'colormap_id_example'`
        :param api_preview: (optional)
            Example: `'api_preview_example'`
        :param additional_headers: (optional) Additional headers to send with the request.
        :param request_timeout: (optional) Timeout setting for this request. If one number is provided, it will be the
            total request timeout. It can also be a pair (tuple) of (connection, read) timeouts.

        :return: Returns the result object.

        :raise evo.common.exceptions.BadRequestException: If the server responds with HTTP status 400.
        :raise evo.common.exceptions.UnauthorizedException: If the server responds with HTTP status 401.
        :raise evo.common.exceptions.ForbiddenException: If the server responds with HTTP status 403.
        :raise evo.common.exceptions.NotFoundException: If the server responds with HTTP status 404.
        :raise evo.common.exceptions.BaseRFC87Error: If the server responds with any other HTTP status between
            400 and 599, and the body of the response conforms to RFC 87.
        :raise evo.common.exceptions.EvoApiException: If the server responds with any other HTTP status between 400
            and 599, and the body of the response does not conform to RFC 87.
        :raise evo.common.exceptions.UnknownResponseError: For other HTTP status codes with no corresponding response
            type in `response_types_map`.
        """
        # Prepare the path parameters.
        _path_params = {
            "org_id": org_id,
            "workspace_id": workspace_id,
            "colormap_id": colormap_id,
        }

        # Prepare the header parameters.
        _header_params = {
            "Accept": "application/json",
        }
        if api_preview is not None:
            _header_params["api-preview"] = api_preview
        if additional_headers is not None:
            _header_params.update(additional_headers)

        # Define the collection formats.
        _collection_formats = {}

        _response_types_map = {
            "200": ResponseGetColormapByID,  # noqa: F405
        }

        return await self.connector.call_api(
            method=RequestMethod.GET,
            resource_path="/colormap/orgs/{org_id}/workspaces/{workspace_id}/colormaps/{colormap_id}",
            path_params=_path_params,
            header_params=_header_params,
            collection_formats=_collection_formats,
            response_types_map=_response_types_map,
            request_timeout=request_timeout,
        )

    async def get_colormap_collection(
        self,
        org_id: str,
        workspace_id: str,
        api_preview: str | None = None,
        additional_headers: dict[str, str] | None = None,
        request_timeout: int | float | tuple[int | float, int | float] | None = None,
    ) -> ColormapResponseList:  # noqa: F405
        """List colormaps

        Get a list of all colormaps for a specified workspace and organization.

        :param org_id:
            Format: `uuid`
            Example: `'org_id_example'`
        :param workspace_id:
            Format: `uuid`
            Example: `'workspace_id_example'`
        :param api_preview: (optional)
            Example: `'api_preview_example'`
        :param additional_headers: (optional) Additional headers to send with the request.
        :param request_timeout: (optional) Timeout setting for this request. If one number is provided, it will be the
            total request timeout. It can also be a pair (tuple) of (connection, read) timeouts.

        :return: Returns the result object.

        :raise evo.common.exceptions.BadRequestException: If the server responds with HTTP status 400.
        :raise evo.common.exceptions.UnauthorizedException: If the server responds with HTTP status 401.
        :raise evo.common.exceptions.ForbiddenException: If the server responds with HTTP status 403.
        :raise evo.common.exceptions.NotFoundException: If the server responds with HTTP status 404.
        :raise evo.common.exceptions.BaseRFC87Error: If the server responds with any other HTTP status between
            400 and 599, and the body of the response conforms to RFC 87.
        :raise evo.common.exceptions.EvoApiException: If the server responds with any other HTTP status between 400
            and 599, and the body of the response does not conform to RFC 87.
        :raise evo.common.exceptions.UnknownResponseError: For other HTTP status codes with no corresponding response
            type in `response_types_map`.
        """
        # Prepare the path parameters.
        _path_params = {
            "org_id": org_id,
            "workspace_id": workspace_id,
        }

        # Prepare the header parameters.
        _header_params = {
            "Accept": "application/json",
        }
        if api_preview is not None:
            _header_params["api-preview"] = api_preview
        if additional_headers is not None:
            _header_params.update(additional_headers)

        # Define the collection formats.
        _collection_formats = {}

        _response_types_map = {
            "200": ColormapResponseList,  # noqa: F405
        }

        return await self.connector.call_api(
            method=RequestMethod.GET,
            resource_path="/colormap/orgs/{org_id}/workspaces/{workspace_id}/colormaps",
            path_params=_path_params,
            header_params=_header_params,
            collection_formats=_collection_formats,
            response_types_map=_response_types_map,
            request_timeout=request_timeout,
        )

    async def post_colormap(
        self,
        org_id: str,
        workspace_id: str,
        colormap_data: ColormapData,  # noqa: F405
        api_preview: str | None = None,
        additional_headers: dict[str, str] | None = None,
        request_timeout: int | float | tuple[int | float, int | float] | None = None,
    ) -> ResponsePostColormap:  # noqa: F405
        """Create colormap

        Create a new colormap for a specified workspace and organization. You may choose from either a continuous, discrete, or category colormap.

        :param org_id:
            Format: `uuid`
            Example: `'org_id_example'`
        :param workspace_id:
            Format: `uuid`
            Example: `'workspace_id_example'`
        :param colormap_data:
            Example: `endpoints.ColormapData()`
        :param api_preview: (optional)
            Example: `'api_preview_example'`
        :param additional_headers: (optional) Additional headers to send with the request.
        :param request_timeout: (optional) Timeout setting for this request. If one number is provided, it will be the
            total request timeout. It can also be a pair (tuple) of (connection, read) timeouts.

        :return: Returns the result object.

        :raise evo.common.exceptions.BadRequestException: If the server responds with HTTP status 400.
        :raise evo.common.exceptions.UnauthorizedException: If the server responds with HTTP status 401.
        :raise evo.common.exceptions.ForbiddenException: If the server responds with HTTP status 403.
        :raise evo.common.exceptions.NotFoundException: If the server responds with HTTP status 404.
        :raise evo.common.exceptions.BaseRFC87Error: If the server responds with any other HTTP status between
            400 and 599, and the body of the response conforms to RFC 87.
        :raise evo.common.exceptions.EvoApiException: If the server responds with any other HTTP status between 400
            and 599, and the body of the response does not conform to RFC 87.
        :raise evo.common.exceptions.UnknownResponseError: For other HTTP status codes with no corresponding response
            type in `response_types_map`.
        """
        # Prepare the path parameters.
        _path_params = {
            "org_id": org_id,
            "workspace_id": workspace_id,
        }

        # Prepare the header parameters.
        _header_params = {
            "Content-Type": "application/json",
            "Accept": "application/json",
        }
        if api_preview is not None:
            _header_params["api-preview"] = api_preview
        if additional_headers is not None:
            _header_params.update(additional_headers)

        # Define the collection formats.
        _collection_formats = {}

        _response_types_map = {
            "201": ResponsePostColormap,  # noqa: F405
        }

        return await self.connector.call_api(
            method=RequestMethod.POST,
            resource_path="/colormap/orgs/{org_id}/workspaces/{workspace_id}/colormaps",
            path_params=_path_params,
            header_params=_header_params,
            body=colormap_data,
            collection_formats=_collection_formats,
            response_types_map=_response_types_map,
            request_timeout=request_timeout,
        )
