#  Copyright © 2025 Bentley Systems, Incorporated
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#      http://www.apache.org/licenses/LICENSE-2.0
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

# generated by datamodel-codegen:
#   filename:  colormap.yaml

from __future__ import annotations

from datetime import datetime
from enum import Enum
from uuid import UUID

from pydantic import (
    AnyUrl,
    Field,
    RootModel,
    StrictBool,
    StrictFloat,
    StrictInt,
    StrictStr,
)

from .._model_config import CustomBaseModel


class AttributeAssociationData(CustomBaseModel):
    attribute_id: StrictStr = Field(..., title="Attribute Id")
    colormap_id: UUID = Field(..., title="Colormap Id")


class AttributeAssociationsData(CustomBaseModel):
    associations: list[AttributeAssociationData] = Field(..., max_length=128, min_length=1, title="Associations")


class AttributeColormapAssociation(CustomBaseModel):
    attribute_id: StrictStr = Field(..., title="Attribute ID")
    colormap_id: UUID = Field(..., title="Colormap ID")
    colormap_uri: AnyUrl = Field(..., title="Colormap URI")
    created_at: datetime = Field(..., title="Created at")
    created_by: UUID = Field(..., title="Created by")
    id: UUID = Field(..., title="ID")
    modified_at: datetime = Field(..., title="Modified at")
    modified_by: UUID = Field(..., title="Modified by")
    self_link: AnyUrl = Field(..., title="Self link")
    workspace_id: UUID = Field(..., title="Workspace ID")


class AttributeColormapAssociationList(CustomBaseModel):
    associations: list[AttributeColormapAssociation] = Field(..., title="Associations")


class ColorItem(RootModel[StrictInt]):
    root: StrictInt


class Color(RootModel[list[ColorItem]]):
    root: list[ColorItem] = Field(..., max_length=3, min_length=3)


class ColormapTypeEnum(Enum):
    continuous = "continuous"
    category = "category"
    discrete = "discrete"


class ContinuousColormapData(CustomBaseModel):
    attribute_controls: list[StrictFloat] = Field(..., min_length=2, title="Attribute Controls")
    colors: list[Color] = Field(..., max_length=1024, min_length=2, title="Colors")
    """
    An ordered list of RGB colors, containing between 2 and 1024 colors. Each color is represented by three integer values (for Red, Green, and Blue) ranging from 0 to 255.
    """
    dtype: ColormapTypeEnum = ColormapTypeEnum.continuous
    gradient_controls: list[StrictFloat] = Field(..., min_length=2, title="Gradient Controls")
    name: StrictStr = Field(..., title="Name")


class ContinuousColormapResponse(CustomBaseModel):
    attribute_controls: list[StrictFloat] = Field(..., min_length=1, title="Attribute controls")
    """
    List of ordered attribute values for gradient curve
    """
    colors: list[Color] = Field(..., max_length=1024, min_length=2, title="Colors")
    """
    An ordered list of RGB colors, containing between 2 and 1024 colors. Each color is represented by three integer values (for Red, Green, and Blue) ranging from 0 to 255.
    """
    created_at: datetime = Field(..., title="Created at")
    created_by: UUID = Field(..., title="Created by")
    gradient_controls: list[StrictFloat] = Field(..., min_length=1, title="Gradient controls")
    """
    List of gradient positions for gradient curve, floats between 0 and 1
    """
    id: UUID = Field(..., title="ID")
    modified_at: datetime = Field(..., title="Modified at")
    modified_by: UUID = Field(..., title="Modified by")
    name: StrictStr = Field(..., title="Name")
    schema_: ColormapTypeEnum = Field(..., alias="schema")
    self_link: AnyUrl = Field(..., title="Self link")


class DiscreteColormapData(CustomBaseModel):
    colors: list[Color] = Field(..., max_length=1024, min_length=1, title="Colors")
    """
    An ordered list of RGB colors, containing between 1 and 1024 colors. Each color is represented by three integer values (for Red, Green, and Blue) ranging from 0 to 255.
    """
    dtype: ColormapTypeEnum = ColormapTypeEnum.discrete
    end_inclusive: list[StrictBool] = Field(..., title="End Inclusive")
    end_points: list[StrictFloat] = Field(..., title="End Points")
    name: StrictStr = Field(..., title="Name")


class DiscreteColormapResponse(CustomBaseModel):
    colors: list[Color] = Field(..., max_length=1024, min_length=1, title="Colors")
    """
    An ordered list of RGB colors, containing between 1 and 1024 colors. Each color is represented by three integer values (for Red, Green, and Blue) ranging from 0 to 255.
    """
    created_at: datetime = Field(..., title="Created at")
    created_by: UUID = Field(..., title="Created by")
    end_inclusive: list[StrictBool] = Field(..., title="End inclusive")
    """
    Boolean array indicating whether to include the endpoint in the bucket or not
    """
    end_points: list[StrictFloat] = Field(..., title="End points")
    """
    List of colormap bucket endpoints, must be one fewer than the number of colors
    """
    id: UUID = Field(..., title="ID")
    modified_at: datetime = Field(..., title="Modified at")
    modified_by: UUID = Field(..., title="Modified by")
    name: StrictStr = Field(..., title="Name")
    schema_: ColormapTypeEnum = Field(..., alias="schema")
    self_link: AnyUrl = Field(..., title="Self link")


class CategoryColormapData(CustomBaseModel):
    colors: list[Color] = Field(..., max_length=10000, min_length=1, title="Colors")
    """
    An ordered list of RGB colors, containing between 1 and 1024 colors. Each color is represented by three integer values (for Red, Green, and Blue) ranging from 0 to 255.
    """
    dtype: ColormapTypeEnum = ColormapTypeEnum.category
    map: list[StrictStr] = Field(..., title="Map")
    name: StrictStr = Field(..., title="Name")


class CategoryColormapResponse(CustomBaseModel):
    colors: list[Color] = Field(..., max_length=10000, min_length=1, title="Colors")
    """
    An ordered list of RGB colors, containing between 1 and 10000 colors. Each color is represented by three integer values (for Red, Green, and Blue) ranging from 0 to 255.
    """
    created_at: datetime = Field(..., title="Created at")
    created_by: UUID = Field(..., title="Created by")
    id: UUID = Field(..., title="ID")
    map: list[StrictStr] = Field(..., title="Map")
    """
    String array mapping arbitrary strings to colors
    """
    modified_at: datetime = Field(..., title="Modified at")
    modified_by: UUID = Field(..., title="Modified by")
    name: StrictStr = Field(..., title="Name")
    schema_: ColormapTypeEnum = Field(..., alias="schema")
    self_link: AnyUrl = Field(..., title="Self link")


class ColormapData(RootModel[ContinuousColormapData | DiscreteColormapData | CategoryColormapData]):
    root: ContinuousColormapData | DiscreteColormapData | CategoryColormapData = Field(..., title="Colormap Data")


class ColormapResponseList(CustomBaseModel):
    colormaps: list[CategoryColormapResponse | DiscreteColormapResponse | ContinuousColormapResponse] = Field(
        ..., title="Colormaps"
    )


class ResponseGetColormapByID(
    RootModel[ContinuousColormapResponse | CategoryColormapResponse | DiscreteColormapResponse]
):
    root: ContinuousColormapResponse | CategoryColormapResponse | DiscreteColormapResponse = Field(  # noqa: E501
        ..., title="ResponseGetColormapByID"
    )


class ResponsePostColormap(RootModel[ContinuousColormapResponse | CategoryColormapResponse | DiscreteColormapResponse]):
    root: ContinuousColormapResponse | CategoryColormapResponse | DiscreteColormapResponse = Field(  # noqa: E501
        ..., title="ResponsePostColormap"
    )
