#  Copyright © 2025 Bentley Systems, Incorporated
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#      http://www.apache.org/licenses/LICENSE-2.0
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

# generated by datamodel-codegen:
#   filename:  spec.yaml

from __future__ import annotations

from datetime import datetime
from typing import Annotated
from uuid import UUID

from pydantic import Field, StrictInt, StrictStr

from .._model_config import CustomBaseModel


class ListFileLinks(CustomBaseModel):
    self: Annotated[StrictStr, Field(title="Self")]


class ListFilesResponseLinks(CustomBaseModel):
    next: Annotated[StrictStr | None, Field(title="Next")] = None
    prev: Annotated[StrictStr | None, Field(title="Prev")] = None
    self: Annotated[StrictStr, Field(title="Self")]


class UploadFileResponse(CustomBaseModel):
    """
    Upload file response
    """

    file_id: Annotated[UUID, Field(title="File Id")]
    upload: Annotated[StrictStr, Field(title="Upload")]
    version_id: Annotated[StrictStr, Field(title="Version Id")]


class UserInfo(CustomBaseModel):
    email: Annotated[StrictStr | None, Field(examples=["kim@example.test"], title="Email Address")] = None
    """
    The primary email address of the user. Can be null if an error occurred while retrieving this information.
    """
    id: Annotated[UUID, Field(examples=["59b73891-5538-4e45-ae67-f8c5b00d7405"], title="User ID")]
    """
    The ID of the user
    """
    name: Annotated[StrictStr | None, Field(examples=["Kim Kim"], title="Full Name")] = None
    """
    The full name of the user. Can be null if an error occurred while retrieving this information.
    """


class FileVersionResponse(CustomBaseModel):
    """
    Metadata for specific file version
    """

    created_at: Annotated[datetime, Field(title="Created At")]
    created_by: UserInfo | None = None
    file_id: Annotated[UUID, Field(title="File Id")]
    link: Annotated[StrictStr, Field(title="Link")]
    name: Annotated[StrictStr, Field(title="Name")]
    path: Annotated[StrictStr, Field(title="Path")]
    size: Annotated[StrictInt, Field(title="Size")]
    version_id: Annotated[StrictStr, Field(title="Version Id")]


class ListFile(CustomBaseModel):
    created_at: Annotated[datetime, Field(title="Created At")]
    created_by: UserInfo | None = None
    deleted_at: Annotated[datetime | None, Field(title="Deleted At")] = None
    deleted_by: UserInfo | None = None
    etag: Annotated[StrictStr, Field(title="Etag")]
    file_id: Annotated[UUID, Field(title="File Id")]
    links: ListFileLinks
    modified_at: Annotated[datetime, Field(title="Modified At")]
    modified_by: UserInfo | None = None
    name: Annotated[StrictStr, Field(title="Name")]
    path: Annotated[StrictStr, Field(title="Path")]
    size: Annotated[StrictInt, Field(title="Size")]
    version_id: Annotated[StrictStr, Field(title="Version Id")]


class ListFilesResponse(CustomBaseModel):
    """
    List files.
    """

    count: Annotated[StrictInt, Field(title="Count")]
    files: Annotated[list[ListFile], Field(title="Files")]
    limit: Annotated[StrictInt, Field(title="Limit")]
    links: ListFilesResponseLinks
    offset: Annotated[StrictInt, Field(title="Offset")]
    total: Annotated[StrictInt, Field(title="Total")]


class DownloadFileResponse(CustomBaseModel):
    """
    Download file response.
    """

    created_at: Annotated[datetime, Field(title="Created At")]
    created_by: UserInfo | None = None
    deleted_at: Annotated[datetime | None, Field(title="Deleted At")] = None
    deleted_by: UserInfo | None = None
    download: Annotated[StrictStr, Field(title="Download")]
    etag: Annotated[StrictStr, Field(title="Etag")]
    file_id: Annotated[UUID, Field(title="File Id")]
    modified_at: Annotated[datetime, Field(title="Modified At")]
    modified_by: UserInfo | None = None
    name: Annotated[StrictStr, Field(title="Name")]
    path: Annotated[StrictStr, Field(title="Path")]
    self: Annotated[StrictStr, Field(title="Self")]
    size: Annotated[StrictInt, Field(title="Size")]
    version_id: Annotated[StrictStr, Field(title="Version Id")]
    versions: Annotated[list[FileVersionResponse] | None, Field(title="Versions")] = None
