#  Copyright © 2025 Bentley Systems, Incorporated
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#      http://www.apache.org/licenses/LICENSE-2.0
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
"""
Geoscience Object API
=============


The Geoscience Object API enables technological integrations at the object level. It enables users to access and utilise their data across all products through a common and accessible data structure.

A Geoscience Object is a data structure that represents a concrete geological, geotechnical, or geophysical concept. Geoscience Objects can be referenced by their UUID or by a user-defined object path.

For more information on using the Geoscience Object API, see the [Geoscience Object API overview](/docs/guides/objects), or the API references here.


This code is generated from the OpenAPI specification for Geoscience Object API.
API version: 1.14.0
"""

from evo.common.connector import APIConnector
from evo.common.data import EmptyResponse, RequestMethod  # noqa: F401

from ..models import *  # noqa: F403

__all__ = ["DataApi"]


class DataApi:
    """API client for the Data endpoint.

    NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    :param connector: Client for communicating with the API.
    """

    def __init__(self, connector: APIConnector):
        self.connector = connector

    async def put_data_in_workspace(
        self,
        org_id: str,
        workspace_id: str,
        data_upload_request_body: list[DataUploadRequestBody],  # noqa: F405
        additional_headers: dict[str, str] | None = None,
        request_timeout: int | float | tuple[int | float, int | float] | None = None,
    ) -> list[DataUploadResponseBody]:  # noqa: F405
        """Upload geoscience data

        Request to upload geoscience data.  The client provides names for the data they intend to upload and receives upload URLs for those that have not already been uploaded. This data `name` must a valid SHA256 hash or UUID. Calculating the SHA256 hash is recommended as it enables clients to avoid re-uploading duplicate data.  Each upload URL is secured with a SAS token and is valid for a limited time. If a URL has expired before the data upload is complete, simply repeat this request to obtain a new URL. Clients can use the new URL to continue uploading where they left off.  Multiple data names can be provided, with an upload URL generated for each data digest individually (up to a maximum of 32).

        :param org_id: The customer's organisation ID
            Format: `uuid`
            Example: `'b208a6c9-6881-4b97-b02d-acb5d81299bb'`
        :param workspace_id:
            Format: `uuid`
            Example: `'032806a8-dcd7-11ed-8d5c-00155d8f28b5'`
        :param data_upload_request_body:
            Example: `[endpoints.DataUploadRequestBody()]`
        :param additional_headers: (optional) Additional headers to send with the request.
        :param request_timeout: (optional) Timeout setting for this request. If one number is provided, it will be the
            total request timeout. It can also be a pair (tuple) of (connection, read) timeouts.

        :return: Returns the result object.

        :raise evo.common.exceptions.BadRequestException: If the server responds with HTTP status 400.
        :raise evo.common.exceptions.UnauthorizedException: If the server responds with HTTP status 401.
        :raise evo.common.exceptions.ForbiddenException: If the server responds with HTTP status 403.
        :raise evo.common.exceptions.NotFoundException: If the server responds with HTTP status 404.
        :raise evo.common.exceptions.BaseTypedError: If the server responds with any other HTTP status between
            400 and 599, and the body of the response contains a descriptive `type` parameter.
        :raise evo.common.exceptions.EvoAPIException: If the server responds with any other HTTP status between 400
            and 599, and the body of the response does not contain a `type` parameter.
        :raise evo.common.exceptions.UnknownResponseError: For other HTTP status codes with no corresponding response
            type in `response_types_map`.
        """
        # Prepare the path parameters.
        _path_params = {
            "org_id": org_id,
            "workspace_id": workspace_id,
        }

        # Prepare the header parameters.
        _header_params = {
            "Content-Type": "application/json",
            "Accept": "application/json",
        }
        if additional_headers is not None:
            _header_params.update(additional_headers)

        # Define the collection formats.
        _collection_formats = {
            "DataUploadRequestBody": "",
        }

        _response_types_map = {
            "200": list[DataUploadResponseBody],  # noqa: F405
        }

        return await self.connector.call_api(
            method=RequestMethod.PUT,
            resource_path="/geoscience-object/orgs/{org_id}/workspaces/{workspace_id}/data",
            path_params=_path_params,
            header_params=_header_params,
            body=data_upload_request_body,
            collection_formats=_collection_formats,
            response_types_map=_response_types_map,
            request_timeout=request_timeout,
        )
