#  Copyright © 2025 Bentley Systems, Incorporated
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#      http://www.apache.org/licenses/LICENSE-2.0
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
"""
Workspaces API
=============

The Workspaces API enables users to organize, maintain, and store project data, but does not use or process the data. The workspace APIs allow you to manage:
- Workspaces
- User roles within workspaces
- Workspace thumbnails

There are three pre-defined roles within workspaces:

- Owner: can perform all actions in the workspace
- Editor: can perform all actions excluding deleting of a workspace
- Viewer: can view the workspace

These user roles can be assigned to users in a workspace. Once a role has been assigned it can be replaced or removed.
Users can also retrieve user roles, the role of a particular user, and their own role if applicable.
For more information on using the Workspaces API, see the [Workspaces API overview](https://developer.seequent.com/docs/guides/workspaces/), or the API references here.


This code is generated from the OpenAPI specification for Workspaces API.
API version: 1.0
"""

from evo.common.connector import APIConnector
from evo.common.data import EmptyResponse, RequestMethod  # noqa: F401

from ..models import *  # noqa: F403

__all__ = ["LicenseAccessApi"]


class LicenseAccessApi:
    """API client for the LicenseAccess endpoint.

    NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    :param connector: Client for communicating with the API.
    """

    def __init__(self, connector: APIConnector):
        self.connector = connector

    async def v2_license_access_workspace_evo_identity_v2_license_access_get(
        self,
        service: list[str] | None = None,
        hub: str | None = None,
        org_id: str | None = None,
        required_scope: list[str] | None = None,
        tx_uuid: str | None = None,
        additional_headers: dict[str, str] | None = None,
        request_timeout: int | float | tuple[int | float, int | float] | None = None,
    ) -> LicenseAccessResponseModel:  # noqa: F405
        """V2 License Access

        Verify the user and token has access to the requested resources.  Given a user token, verify that the user has access to the requested service, org and hub, as well as that the token as the required scope.  On success, returns details of the calling user, what they are entitled to, and the authorization the request was made with.  Args:     org_id (UUID): UUID of the Evo organisation     service (str): service name (i.e. \"blockmodel\")     hub (str): the hub code     required_scope(str): scope required for the service Returns:     A JSON response.

        :param service: (optional)
            Example: `['service_example']`
        :param hub: (optional)
            Example: `'hub_example'`
        :param org_id: (optional)
            Example: `'org_id_example'`
        :param required_scope: (optional)
            Example: `['required_scope_example']`
        :param tx_uuid: (optional)
            Example: `'tx_uuid_example'`
        :param additional_headers: (optional) Additional headers to send with the request.
        :param request_timeout: (optional) Timeout setting for this request. If one number is provided, it will be the
            total request timeout. It can also be a pair (tuple) of (connection, read) timeouts.

        :return: Returns the result object.

        :raise evo.common.exceptions.BadRequestException: If the server responds with HTTP status 400.
        :raise evo.common.exceptions.UnauthorizedException: If the server responds with HTTP status 401.
        :raise evo.common.exceptions.ForbiddenException: If the server responds with HTTP status 403.
        :raise evo.common.exceptions.NotFoundException: If the server responds with HTTP status 404.
        :raise evo.common.exceptions.BaseTypedError: If the server responds with any other HTTP status between
            400 and 599, and the body of the response contains a descriptive `type` parameter.
        :raise evo.common.exceptions.EvoAPIException: If the server responds with any other HTTP status between 400
            and 599, and the body of the response does not contain a `type` parameter.
        :raise evo.common.exceptions.UnknownResponseError: For other HTTP status codes with no corresponding response
            type in `response_types_map`.
        """
        # Prepare the query parameters.
        _query_params = {}
        if service is not None:
            _query_params["service"] = service
        if hub is not None:
            _query_params["hub"] = hub
        if org_id is not None:
            _query_params["org_id"] = org_id
        if required_scope is not None:
            _query_params["required_scope"] = required_scope

        # Prepare the header parameters.
        _header_params = {
            "Accept": "application/json",
        }
        if tx_uuid is not None:
            _header_params["tx-uuid"] = tx_uuid
        if additional_headers is not None:
            _header_params.update(additional_headers)

        # Define the collection formats.
        _collection_formats = {
            "service": "multi",
            "required_scope": "multi",
        }

        _response_types_map = {
            "200": LicenseAccessResponseModel,  # noqa: F405
        }

        return await self.connector.call_api(
            method=RequestMethod.GET,
            resource_path="/workspace/evo/identity/v2/license-access",
            query_params=_query_params,
            header_params=_header_params,
            collection_formats=_collection_formats,
            response_types_map=_response_types_map,
            request_timeout=request_timeout,
        )
