#  Copyright © 2025 Bentley Systems, Incorporated
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#      http://www.apache.org/licenses/LICENSE-2.0
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

# generated by datamodel-codegen:
#   filename:  spec.yaml

from __future__ import annotations

from enum import Enum
from pathlib import Path
from typing import Annotated, Any
from uuid import UUID

from pydantic import (
    AnyUrl,
    AwareDatetime,
    Field,
    RootModel,
    StrictBool,
    StrictFloat,
    StrictInt,
    StrictStr,
)

from .._model_config import CustomBaseModel


class BaseInstanceUserRoleResponse(CustomBaseModel):
    description: Annotated[StrictStr, Field(title="Description")]
    id: Annotated[UUID, Field(title="Id")]
    name: Annotated[StrictStr, Field(title="Name")]


class BasicWorkspaceResponse(CustomBaseModel):
    id: Annotated[UUID, Field(title="Id")]
    name: Annotated[StrictStr, Field(title="Name")]
    """
    The name of the workspace, unique within an organization and hub
    """


class Coordinate(RootModel[list[StrictFloat | StrictInt]]):
    root: Annotated[list[StrictFloat | StrictInt], Field(max_length=2, min_length=2)]
    """
    Coordinate as [longitude, latitude]. First one MUST be the longitude.
    """


class CoordinateSystemEntry(CustomBaseModel):
    title: Annotated[StrictStr, Field(title="Title")]
    well_known_id: Annotated[StrictStr, Field(title="Well Known Id")]


class Label(RootModel[StrictStr]):
    root: StrictStr


class ErrorInvalidParam(CustomBaseModel):
    name: Annotated[StrictStr, Field(title="Name")]
    reason: Annotated[StrictStr, Field(title="Reason")]


class ErrorResponse(CustomBaseModel):
    detail: Annotated[StrictStr | None, Field(title="Detail")] = None
    invalid_params: Annotated[
        list[ErrorInvalidParam] | None,
        Field(alias="invalid-params", title="Invalid-Params"),
    ] = None
    status: Annotated[StrictInt, Field(title="Status")]
    title: Annotated[StrictStr, Field(title="Title")]
    type: Annotated[StrictStr, Field(title="Type")]


class FolderCreateRequest(CustomBaseModel):
    name: Annotated[StrictStr, Field(title="Name")]
    """
    The name of the folder
    """
    parent_folder_id: Annotated[UUID | None, Field(title="Parent Folder Id")] = None
    """
    The ID of the parent folder
    """
    parent_folder_path: Annotated[Path | None, Field(title="Parent Folder Path")] = None
    """
    The path of the parent folder
    """


class FolderMoveRequest(CustomBaseModel):
    parent_folder_id: Annotated[UUID, Field(title="Parent Folder Id")]
    """
    The ID of the new parent folder
    """


class FolderUpdateRequest(CustomBaseModel):
    name: Annotated[StrictStr, Field(title="Name")]
    """
    The new name of the folder
    """


class GeometryTypeEnum(Enum):
    Polygon = "Polygon"


class Hub(CustomBaseModel):
    code: Annotated[StrictStr, Field(title="Code")]
    display_name: Annotated[StrictStr, Field(title="Display Name")]
    url: Annotated[StrictStr, Field(title="Url")]


class HubTypeEnum(Enum):
    enterprise = "enterprise"
    multitenant = "multitenant"


class InstanceRoleWithPermissions(CustomBaseModel):
    description: Annotated[StrictStr, Field(title="Description")]
    id: Annotated[UUID, Field(title="Id")]
    name: Annotated[StrictStr, Field(title="Name")]
    permissions: Annotated[list[StrictStr], Field(title="Permissions")]


class InstanceStatusEnum(Enum):
    active = "active"
    inactive = "inactive"
    new = "new"


class InstanceTypeEnum(Enum):
    commercial = "commercial"
    partner = "partner"
    sandbox = "sandbox"
    internal = "internal"
    trial = "trial"
    early_access = "early-access"


class LicenseAccessAuthDetails(CustomBaseModel):
    """
    Auth details,retrieved from token, for v2 License Access Response
    """

    client_id: Annotated[StrictStr, Field(title="Client Id")]
    exp: Annotated[StrictInt, Field(title="Exp")]
    iat: Annotated[StrictInt, Field(title="Iat")]
    iss: Annotated[StrictStr | None, Field(title="Iss")] = None
    jti: Annotated[StrictStr | None, Field(title="Jti")] = None
    scope: Annotated[list[StrictStr] | None, Field(title="Scope")] = None
    sid: Annotated[StrictStr | None, Field(title="Sid")] = None
    type: Annotated[StrictStr, Field(title="Type")]
    ver: Annotated[StrictStr, Field(title="Ver")]


class LicenseAccessEntitlements(CustomBaseModel):
    """
    Entitlement details for v2 License Access Response
    """

    hub_code: Annotated[StrictStr, Field(title="Hub Code")]
    instance_id: Annotated[StrictStr | None, Field(title="Instance Id")] = None
    instance_name: Annotated[StrictStr | None, Field(title="Instance Name")] = None
    org_id: Annotated[StrictStr, Field(title="Org Id")]
    org_name: Annotated[StrictStr, Field(title="Org Name")]
    roles: Annotated[list[StrictStr], Field(title="Roles")]
    services: Annotated[list[StrictStr], Field(title="Services")]


class LicenseAccessUser(CustomBaseModel):
    """
    User details for v2 License Access Response
    """

    org_id: Annotated[StrictStr | None, Field(title="Org Id")] = None
    org_name: Annotated[StrictStr | None, Field(title="Org Name")] = None
    sub: Annotated[StrictStr, Field(title="Sub")]


class ListInstanceRolesResponse(CustomBaseModel):
    roles: Annotated[list[InstanceRoleWithPermissions], Field(title="Roles")]


class Organization(CustomBaseModel):
    display_name: Annotated[StrictStr, Field(title="Display Name")]
    id: Annotated[StrictStr, Field(title="Id")]


class OrganizationSettingsFieldResponse(CustomBaseModel):
    ml_enabled: Annotated[StrictBool, Field(title="Ml Enabled")] = False


class OrganizationSettingsResponse(CustomBaseModel):
    created_at: Annotated[AwareDatetime | None, Field(title="Created At")] = None
    created_by: Annotated[UUID | None, Field(title="Created By")] = None
    id: Annotated[UUID, Field(title="Id")]
    settings: Annotated[OrganizationSettingsFieldResponse, Field()] = {"ml_enabled": False}
    updated_at: Annotated[AwareDatetime | None, Field(title="Updated At")] = None
    updated_by: Annotated[UUID | None, Field(title="Updated By")] = None


class PaginationLinks(CustomBaseModel):
    count: Annotated[StrictInt, Field(title="Count")]
    first: Annotated[AnyUrl, Field(title="First")]
    last: Annotated[AnyUrl, Field(title="Last")]
    next: Annotated[AnyUrl | None, Field(title="Next")] = None
    previous: Annotated[AnyUrl | None, Field(title="Previous")] = None
    total: Annotated[StrictInt, Field(title="Total")]


class PaginationLinksWithoutTotal(CustomBaseModel):
    count: Annotated[StrictInt, Field(title="Count")]
    first: Annotated[AnyUrl, Field(title="First")]
    next: Annotated[AnyUrl | None, Field(title="Next")] = None
    previous: Annotated[AnyUrl | None, Field(title="Previous")] = None


class RoleEnum(Enum):
    owner = "owner"
    editor = "editor"
    viewer = "viewer"


class Service(CustomBaseModel):
    code: Annotated[StrictStr, Field(title="Code")]
    display_name: Annotated[StrictStr, Field(title="Display Name")]


class ServiceAccess(CustomBaseModel):
    hub_code: Annotated[StrictStr, Field(title="Hub Code")]
    org_id: Annotated[StrictStr, Field(title="Org Id")]
    services: Annotated[list[StrictStr], Field(title="Services")]


class UpdateInstanceDetailsRequest(CustomBaseModel):
    display_name: Annotated[StrictStr | None, Field(max_length=100, min_length=1, title="Display Name")] = None
    status: InstanceStatusEnum | None = None
    type: InstanceTypeEnum | None = None


class UpdateInstanceUserRolesRequest(CustomBaseModel):
    roles: Annotated[list[UUID], Field(title="Roles")]


class UpdateInstanceUserRolesResponse(CustomBaseModel):
    id: Annotated[UUID, Field(title="Id")]
    roles: Annotated[list[BaseInstanceUserRoleResponse], Field(title="Roles")]


class User(CustomBaseModel):
    email: Annotated[StrictStr | None, Field(title="Email")] = None
    full_name: Annotated[StrictStr | None, Field(title="Full Name")] = None
    role: RoleEnum
    user_id: Annotated[UUID, Field(title="User Id")]


class UserModel(CustomBaseModel):
    email: Annotated[StrictStr | None, Field(title="Email")] = None
    id: Annotated[UUID, Field(title="Id")]
    name: Annotated[StrictStr | None, Field(title="Name")] = None


class UserRole(CustomBaseModel):
    role: RoleEnum
    user_id: Annotated[UUID, Field(title="User Id")]


class UserRoleAssignmentRequest(CustomBaseModel):
    role: RoleEnum
    user_id: Annotated[UUID, Field(title="User Id")]
    workspace_id: Annotated[UUID, Field(title="Workspace Id")]


class UserRoleMapping(CustomBaseModel):
    email: Annotated[StrictStr, Field(title="Email")]
    roles: Annotated[list[UUID], Field(title="Roles")]


class UserRoleViaEmail(CustomBaseModel):
    email: Annotated[StrictStr, Field(title="Email")]
    role: RoleEnum


class WorkspaceMlEnablementRequest(CustomBaseModel):
    ml_enabled: Annotated[StrictBool, Field(title="Ml Enabled")]
    workspace_id: Annotated[UUID, Field(title="Workspace Id")]


class AddInstanceUsersRequest(CustomBaseModel):
    users: Annotated[list[UserRoleMapping], Field(title="Users")]


class AssignRoleRequest(RootModel[UserRole | UserRoleViaEmail]):
    root: Annotated[UserRole | UserRoleViaEmail, Field(title="AssignRoleRequest")]


class BaseInstanceUserInvitationResponse(CustomBaseModel):
    created_date: Annotated[AwareDatetime, Field(title="Created Date")]
    email: Annotated[StrictStr, Field(title="Email")]
    expiration_date: Annotated[AwareDatetime, Field(title="Expiration Date")]
    id: Annotated[UUID, Field(title="Id")]
    invited_by_email: Annotated[StrictStr, Field(title="Invited By Email")]
    roles: Annotated[list[BaseInstanceUserRoleResponse], Field(title="Roles")]
    status: Annotated[StrictStr, Field(title="Status")]


class BaseInstanceUserResponse(CustomBaseModel):
    email: Annotated[StrictStr, Field(title="Email")]
    full_name: Annotated[StrictStr, Field(title="Full Name")]
    id: Annotated[UUID, Field(title="Id")]
    roles: Annotated[list[BaseInstanceUserRoleResponse], Field(title="Roles")]


class BoundingBox(CustomBaseModel):
    coordinates: Annotated[list[list[Coordinate]], Field(title="Coordinates")]
    type: GeometryTypeEnum


class BulkUserRoleAssignmentsRequest(CustomBaseModel):
    role_assignments: Annotated[list[UserRoleAssignmentRequest], Field(max_length=100, title="Role Assignments")]


class CoordinateSystemCategory(CustomBaseModel):
    items: Annotated[list[CoordinateSystemCategory | CoordinateSystemEntry], Field(title="Items")]
    title: Annotated[StrictStr, Field(title="Title")]


class CreateHubRequest(CustomBaseModel):
    hub_code: Annotated[StrictStr, Field(title="Hub Code")]
    """
    The abbreviated code for the hub. This is used to identify the hub in the system.
    """
    hub_display_name: Annotated[StrictStr, Field(title="Hub Display Name")]
    hub_type: HubTypeEnum = "multitenant"
    hub_url: Annotated[StrictStr, Field(title="Hub Url")]


class CreateInstanceRequest(CustomBaseModel):
    display_name: Annotated[StrictStr, Field(title="Display Name")]
    hub_code: Annotated[StrictStr, Field(title="Hub Code")]
    instance_id: Annotated[UUID | None, Field(title="Instance Id")] = None
    org_id: Annotated[UUID, Field(title="Org Id")]
    owner_id: Annotated[UUID, Field(title="Owner Id")]
    """
    The id of the Bentley user to give initial ownership permission for the instance.
    """
    type: InstanceTypeEnum = "commercial"


class CreateWorkspaceRequest(CustomBaseModel):
    bounding_box: BoundingBox | None = None
    default_coordinate_system: Annotated[StrictStr, Field(title="Default Coordinate System")] = ""
    description: Annotated[StrictStr, Field(title="Description")] = ""
    labels: Annotated[list[Label] | None, Field(max_length=20, title="Labels")] = None
    """
    A list of labels
    """
    name: Annotated[StrictStr, Field(title="Name")]
    """
    The name of the workspace, unique within an organization and hub
    """


class DiscoveryResponseContent(CustomBaseModel):
    hubs: Annotated[list[Hub], Field(title="Hubs")]
    organizations: Annotated[list[Organization], Field(title="Organizations")]
    service_access: Annotated[list[ServiceAccess], Field(title="Service Access")]
    services: Annotated[list[Service], Field(title="Services")]


class FolderResponse(CustomBaseModel):
    created_at: Annotated[AwareDatetime, Field(title="Created At")]
    created_by: UserModel
    deleted: Annotated[StrictBool, Field(title="Deleted")]
    folder_id: Annotated[UUID, Field(title="Folder Id")]
    name: Annotated[StrictStr, Field(title="Name")]
    parent_folder_id: Annotated[UUID | None, Field(title="Parent Folder Id")] = None
    path: Annotated[Path, Field(title="Path")]
    updated_at: Annotated[AwareDatetime, Field(title="Updated At")]
    updated_by: UserModel
    workspace_id: Annotated[UUID, Field(title="Workspace Id")]


class HubResponse(CustomBaseModel):
    created_at: Annotated[AwareDatetime, Field(title="Created At")]
    created_by: Annotated[UUID | StrictStr, Field(title="Created By")]
    hub_code: Annotated[StrictStr, Field(title="Hub Code")]
    hub_display_name: Annotated[StrictStr, Field(title="Hub Display Name")]
    hub_type: HubTypeEnum
    hub_url: Annotated[StrictStr, Field(title="Hub Url")]
    updated_at: Annotated[AwareDatetime, Field(title="Updated At")]
    updated_by: Annotated[UUID | StrictStr, Field(title="Updated By")]


class InstanceResponse(CustomBaseModel):
    context_id: Annotated[UUID, Field(title="Context Id")]
    created_at: Annotated[AwareDatetime, Field(title="Created At")]
    created_by: Annotated[UUID | StrictStr, Field(title="Created By")]
    hub_code: Annotated[StrictStr, Field(title="Hub Code")]
    hub_display_name: Annotated[StrictStr, Field(title="Hub Display Name")]
    hub_type: HubTypeEnum
    hub_url: Annotated[StrictStr, Field(title="Hub Url")]
    instance_id: Annotated[UUID, Field(title="Instance Id")]
    instance_name: Annotated[StrictStr, Field(title="Instance Name")]
    instance_status: InstanceStatusEnum
    instance_type: InstanceTypeEnum
    instance_version: Annotated[StrictInt, Field(title="Instance Version")]
    org_id: Annotated[UUID, Field(title="Org Id")]
    org_name: Annotated[StrictStr, Field(title="Org Name")]
    updated_at: Annotated[AwareDatetime, Field(title="Updated At")]
    updated_by: Annotated[UUID | StrictStr, Field(title="Updated By")]


class LicenseAccessResponseModel(CustomBaseModel):
    """
    v2 License Access Response
    """

    auth_details: LicenseAccessAuthDetails
    entitlements: LicenseAccessEntitlements
    user: LicenseAccessUser


class ListCoordinateSystemsResponse(CustomBaseModel):
    links: Annotated[dict[str, Any], Field(title="Links")]
    results: Annotated[list[CoordinateSystemCategory], Field(title="Results")]


class ListInstanceUserInvitationsResponse(CustomBaseModel):
    links: PaginationLinksWithoutTotal
    results: Annotated[list[BaseInstanceUserInvitationResponse], Field(title="Results")]


class ListInstanceUsersResponse(CustomBaseModel):
    links: PaginationLinksWithoutTotal
    results: Annotated[list[BaseInstanceUserResponse], Field(title="Results")]


class ListUserRoleResponse(CustomBaseModel):
    links: Annotated[dict[str, Any], Field(title="Links")]
    results: Annotated[list[User], Field(title="Results")]


class ListWorkspaceSummaryResponse(CustomBaseModel):
    links: PaginationLinks
    results: Annotated[list[BasicWorkspaceResponse], Field(title="Results")]


class MlEnablementRequest(CustomBaseModel):
    ml_enablements: Annotated[
        list[WorkspaceMlEnablementRequest],
        Field(max_length=100, min_length=1, title="Ml Enablements"),
    ]


class UpdateWorkspaceRequest(CustomBaseModel):
    bounding_box: BoundingBox | None = None
    default_coordinate_system: Annotated[StrictStr | None, Field(title="Default Coordinate System")] = None
    description: Annotated[StrictStr | None, Field(title="Description")] = None
    labels: Annotated[list[Label] | None, Field(max_length=20, title="Labels")] = None
    """
    A list of labels
    """
    name: Annotated[StrictStr | None, Field(max_length=60, min_length=1, title="Name")] = None


class UserWorkspaceResponse(CustomBaseModel):
    bounding_box: BoundingBox | None = None
    created_at: Annotated[AwareDatetime, Field(title="Created At")]
    created_by: UserModel
    default_coordinate_system: Annotated[StrictStr, Field(title="Default Coordinate System")] = ""
    description: Annotated[StrictStr, Field(title="Description")] = ""
    id: Annotated[UUID, Field(title="Id")]
    labels: Annotated[list[StrictStr], Field(title="Labels")] = []
    ml_enabled: Annotated[StrictBool, Field(title="Ml Enabled")] = False
    name: Annotated[StrictStr, Field(title="Name")]
    """
    The name of the workspace, unique within an organization and hub
    """
    self_link: Annotated[AnyUrl, Field(title="Self Link")]
    updated_at: Annotated[AwareDatetime, Field(title="Updated At")]
    updated_by: UserModel
    user_role: RoleEnum


class WorkspaceRoleOptionalResponse(CustomBaseModel):
    bounding_box: BoundingBox | None = None
    created_at: Annotated[AwareDatetime, Field(title="Created At")]
    created_by: UserModel
    current_user_role: RoleEnum | None = None
    default_coordinate_system: Annotated[StrictStr, Field(title="Default Coordinate System")] = ""
    description: Annotated[StrictStr, Field(title="Description")] = ""
    id: Annotated[UUID, Field(title="Id")]
    labels: Annotated[list[StrictStr], Field(title="Labels")] = []
    ml_enabled: Annotated[StrictBool, Field(title="Ml Enabled")] = False
    name: Annotated[StrictStr, Field(title="Name")]
    """
    The name of the workspace, unique within an organization and hub
    """
    self_link: Annotated[AnyUrl, Field(title="Self Link")]
    updated_at: Annotated[AwareDatetime, Field(title="Updated At")]
    updated_by: UserModel


class WorkspaceRoleRequiredResponse(CustomBaseModel):
    bounding_box: BoundingBox | None = None
    created_at: Annotated[AwareDatetime, Field(title="Created At")]
    created_by: UserModel
    current_user_role: RoleEnum
    default_coordinate_system: Annotated[StrictStr, Field(title="Default Coordinate System")] = ""
    description: Annotated[StrictStr, Field(title="Description")] = ""
    id: Annotated[UUID, Field(title="Id")]
    labels: Annotated[list[StrictStr], Field(title="Labels")] = []
    ml_enabled: Annotated[StrictBool, Field(title="Ml Enabled")] = False
    name: Annotated[StrictStr, Field(title="Name")]
    """
    The name of the workspace, unique within an organization and hub
    """
    self_link: Annotated[AnyUrl, Field(title="Self Link")]
    updated_at: Annotated[AwareDatetime, Field(title="Updated At")]
    updated_by: UserModel


class AddInstanceUsersResponse(CustomBaseModel):
    invitations: Annotated[list[BaseInstanceUserInvitationResponse], Field(title="Invitations")]
    members: Annotated[list[BaseInstanceUserResponse], Field(title="Members")]


class ChildFolderListResponse(CustomBaseModel):
    count: Annotated[StrictInt, Field(title="Count")]
    folders: Annotated[list[FolderResponse], Field(title="Folders")]
    limit: Annotated[StrictInt, Field(title="Limit")]
    offset: Annotated[StrictInt, Field(title="Offset")]
    total: Annotated[StrictInt, Field(title="Total")]


class CreatePathFoldersResponse(CustomBaseModel):
    folders: Annotated[list[FolderResponse], Field(title="Folders")]


class DiscoveryResponse(CustomBaseModel):
    discovery: DiscoveryResponseContent


class GetFolderResponse(CustomBaseModel):
    child_folders: ChildFolderListResponse
    folder: FolderResponse


class ListUserWorkspacesResponse(CustomBaseModel):
    links: PaginationLinks
    results: Annotated[list[UserWorkspaceResponse], Field(title="Results")]


class ListWorkspacesResponse(CustomBaseModel):
    links: PaginationLinks
    results: Annotated[
        list[WorkspaceRoleRequiredResponse] | list[WorkspaceRoleOptionalResponse],
        Field(title="Results"),
    ]


CoordinateSystemCategory.model_rebuild()
