# generated by datamodel-codegen:
#   filename:  api/data/createTable.json
#   timestamp: 2025-09-27T10:11:06+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import table
from ...type import basic, entityReferenceList, lifeCycle, tagLabel


class CreateTableRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(
            description='Name that identifies the this entity instance uniquely. Same as id if when name is not unique'
        ),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this table.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of entity instance.'),
    ]
    tableType: Optional[table.TableType] = None
    columns: Annotated[
        List[table.Column], Field(description='Name of the tables in the database')
    ]
    dataModel: Optional[table.DataModel] = None
    locationPath: Annotated[
        Optional[str],
        Field(
            None,
            description='Full storage path in case of external and managed tables.',
        ),
    ]
    tableConstraints: Optional[List[table.TableConstraint]] = None
    tablePartition: Optional[table.TablePartition] = None
    tableProfilerConfig: Optional[table.TableProfilerConfig] = None
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this entity'),
    ]
    databaseSchema: Annotated[
        basic.FullyQualifiedEntityName,
        Field(
            description='FullyQualified name of the Schema corresponding to this table'
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this table'),
    ]
    schemaDefinition: Annotated[
        Optional[basic.SqlQuery], Field(None, description='DDL for Tables and Views')
    ]
    retentionPeriod: Annotated[
        Optional[basic.Duration],
        Field(
            None,
            description='Retention period of the data in the database. Period is expressed as duration in ISO 8601 format in UTC. Example - `P23DT23H`.',
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl], Field(None, description='Source URL of table.')
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None, description='Fully qualified name of the domain the Table belongs to.'
        ),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    fileFormat: Annotated[
        Optional[table.FileFormat],
        Field(None, description='File format in case of file/datalake tables.'),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
