# generated by datamodel-codegen:
#   filename:  api/services/createMlModelService.json
#   timestamp: 2025-09-27T10:11:06+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.services import mlmodelService
from ...type import basic, entityReference, entityReferenceList, tagLabel


class CreateMlModelServiceRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies the this entity instance uniquely'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this mlModel service.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of mlModel service entity.'),
    ]
    serviceType: mlmodelService.MlModelServiceType
    connection: Optional[mlmodelService.MlModelConnection] = None
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this MlModel Service.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this mlModel service.'),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None,
            description='Fully qualified name of the domain the MLModel Service belongs to.',
        ),
    ]
    ingestionRunner: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='The ingestion agent responsible for executing the ingestion pipeline.',
        ),
    ]
