# generated by datamodel-codegen:
#   filename:  entity/data/mlmodel.json
#   timestamp: 2025-09-27T10:11:06+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    usageDetails,
    votes,
)
from ..services import mlmodelService


class FeatureType(Enum):
    numerical = 'numerical'
    categorical = 'categorical'


class FeatureSourceDataType(Enum):
    integer = 'integer'
    number = 'number'
    string = 'string'
    array = 'array'
    date = 'date'
    timestamp = 'timestamp'
    object = 'object'
    boolean = 'boolean'


class MlHyperParameter(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[Optional[str], Field(None, description='Hyper parameter name.')]
    value: Annotated[Optional[str], Field(None, description='Hyper parameter value.')]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Hyper Parameter.'),
    ]


class MlStore(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    storage: Annotated[
        Optional[str],
        Field(None, description='Storage Layer containing the ML Model data.'),
    ]
    imageRepository: Annotated[
        Optional[str],
        Field(None, description='Container Repository with the ML Model image.'),
    ]


class FeatureSource(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Optional[basic.EntityName] = None
    dataType: Annotated[
        Optional[FeatureSourceDataType],
        Field(None, description='Data type of the source (int, date etc.).'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the feature source.'),
    ]
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = None
    dataSource: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Description of the Data Source (e.g., a Table).'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags associated with the feature source.'),
    ]


class MlFeature(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Optional[basic.EntityName] = None
    dataType: Annotated[
        Optional[FeatureType],
        Field(None, description='Data type of the column (numerical vs. categorical).'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the ML Feature.'),
    ]
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = None
    featureSources: Annotated[
        Optional[List[FeatureSource]],
        Field(None, description='Columns used to create the ML Feature.'),
    ]
    featureAlgorithm: Annotated[
        Optional[str],
        Field(
            None,
            description='Description of the algorithm used to compute the feature, e.g., PCA, bucketing...',
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags associated with the feature.'),
    ]


class MlModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of an ML Model instance.')
    ]
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this ML Model.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='A unique name that identifies an ML Model.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this ML Model.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='Description of the ML Model, what it is, and how to use it.',
        ),
    ]
    algorithm: Annotated[
        str, Field(description='Algorithm used to train the ML Model.')
    ]
    mlFeatures: Annotated[
        Optional[List[MlFeature]],
        Field(None, description='Features used to train the ML Model.'),
    ]
    mlHyperParameters: Annotated[
        Optional[List[MlHyperParameter]],
        Field(None, description='Hyper Parameters used to train the ML Model.'),
    ]
    target: Annotated[
        Optional[basic.EntityName],
        Field(None, description='For supervised ML Models, the value to estimate.'),
    ]
    dashboard: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Performance Dashboard URL to track metric evolution.'),
    ]
    mlStore: Annotated[
        Optional[MlStore],
        Field(
            None,
            description='Location containing the ML Model. It can be a storage layer and/or a container repository.',
        ),
    ]
    server: Annotated[
        Optional[basic.Href],
        Field(
            None,
            description='Endpoint that makes the ML Model available, e.g,. a REST API serving the data or computing predictions.',
        ),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this ML Model.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this ML Model.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this ML Model.'),
    ]
    usageSummary: Annotated[
        Optional[usageDetails.UsageDetails],
        Field(None, description='Latest usage information for this ML Model.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    service: Annotated[
        entityReference.EntityReference,
        Field(description='Link to service where this pipeline is hosted in.'),
    ]
    serviceType: Annotated[
        Optional[mlmodelService.MlModelServiceType],
        Field(None, description='Service type where this pipeline is hosted in.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl], Field(None, description='Source URL of mlModel.')
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the MLModel belongs to. When not set, the MLModel inherits the domain from the ML Model Service it belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle properties of the entity'),
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
