# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/snowflakeConnection.json
#   timestamp: 2025-09-27T10:11:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class SnowflakeType(Enum):
    Snowflake = 'Snowflake'


class SnowflakeScheme(Enum):
    snowflake = 'snowflake'


class SnowflakeConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[SnowflakeType],
        Field(
            SnowflakeType.Snowflake, description='Service Type', title='Service Type'
        ),
    ]
    scheme: Annotated[
        Optional[SnowflakeScheme],
        Field(
            SnowflakeScheme.snowflake,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to Snowflake. This user should have privileges to read all the metadata in Snowflake.',
            title='Username',
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='Password to connect to Snowflake.', title='Password'),
    ]
    account: Annotated[
        str,
        Field(
            description='If the Snowflake URL is https://xyz1234.us-east-1.gcp.snowflakecomputing.com, then the account is xyz1234.us-east-1.gcp',
            title='Account',
        ),
    ]
    role: Annotated[
        Optional[str], Field(None, description='Snowflake Role.', title='Role')
    ]
    database: Annotated[
        Optional[str],
        Field(
            None,
            description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
            title='Database',
        ),
    ]
    warehouse: Annotated[
        str, Field(description='Snowflake warehouse.', title='Warehouse')
    ]
    queryTag: Annotated[
        Optional[str],
        Field(
            None,
            description='Session query tag used to monitor usage on snowflake. To use a query tag snowflake user should have enough privileges to alter the session.',
            title='Query Tag',
        ),
    ]
    accountUsageSchema: Annotated[
        Optional[str],
        Field(
            'SNOWFLAKE.ACCOUNT_USAGE',
            description='Full name of the schema where the account usage data is stored.',
            title='Account Usage Schema Name',
        ),
    ]
    privateKey: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='Connection to Snowflake instance via Private Key',
            title='Private Key',
        ),
    ]
    snowflakePrivatekeyPassphrase: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='Snowflake Passphrase Key used with Private Key',
            title='Snowflake Passphrase Key',
        ),
    ]
    includeTransientTables: Annotated[
        Optional[bool],
        Field(
            False,
            description='Optional configuration for ingestion of TRANSIENT tables, By default, it will skip the TRANSIENT tables.',
            title='Include Transient Tables',
        ),
    ]
    includeStreams: Annotated[
        Optional[bool],
        Field(
            False,
            description='Optional configuration for ingestion of streams, By default, it will skip the streams.',
            title='Include Streams',
        ),
    ]
    clientSessionKeepAlive: Annotated[
        Optional[bool],
        Field(
            False,
            description='Optional configuration for ingestion to keep the client session active in case the ingestion process runs for longer durations.',
            title='Client Session Keep Alive',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            {'includes': [], 'excludes': ['^information_schema$']},
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            {'includes': [], 'excludes': ['^snowflake$']},
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsIncrementalMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsIncrementalMetadataExtraction],
        Field(None, title='Supports Incremental Metadata Extraction'),
    ]
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
    supportsLineageExtraction: Optional[
        connectionBasicType.SupportsLineageExtraction
    ] = None
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    supportsDatabase: Annotated[
        Optional[connectionBasicType.SupportsDatabase],
        Field(None, title='Supports Database'),
    ]
    supportsQueryComment: Annotated[
        Optional[connectionBasicType.SupportsQueryComment],
        Field(None, title='Supports Query Comment'),
    ]
    supportsSystemProfile: Annotated[
        Optional[connectionBasicType.SupportsSystemProfile],
        Field(None, title='Supports System Profile'),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
    supportsDataDiff: Annotated[
        Optional[connectionBasicType.SupportsDataDiff],
        Field(None, title='Supports Data Diff Extraction.'),
    ]
    creditCost: Annotated[
        Optional[float],
        Field(
            3.3,
            description='Cost of credit for the Snowflake account.',
            title='Cost of Credit',
        ),
    ]
