# generated by datamodel-codegen:
#   filename:  metadataIngestion/messagingServiceMetadataPipeline.json
#   timestamp: 2025-09-27T10:11:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import filterPattern


class MessagingMetadataConfigType(Enum):
    MessagingMetadata = 'MessagingMetadata'


class MessagingServiceMetadataPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[MessagingMetadataConfigType],
        Field(
            MessagingMetadataConfigType.MessagingMetadata, description='Pipeline type'
        ),
    ]
    topicFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch topics that matches the pattern.',
            title='Topic Filter Pattern',
        ),
    ]
    generateSampleData: Annotated[
        Optional[bool],
        Field(
            False,
            description='Option to turn on/off generating sample data during metadata extraction.',
            title='Generate Sample Data',
        ),
    ]
    markDeletedTopics: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete topics in OpenMetadata if the source topics are deleted. Also, if the topic is deleted, all the associated entities like sample data, lineage, etc., with that topic will be deleted',
            title='Mark Deleted Topics',
        ),
    ]
    overrideMetadata: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName",
            title='Override Metadata',
        ),
    ]
