# generated by datamodel-codegen:
#   filename:  tests/testDefinition.json
#   timestamp: 2025-09-27T10:11:06+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..entity.data import table
from ..type import basic, entityHistory, entityReference, entityReferenceList


class TestPlatform(Enum):
    OpenMetadata = 'OpenMetadata'
    GreatExpectations = 'GreatExpectations'
    DBT = 'DBT'
    Deequ = 'Deequ'
    Soda = 'Soda'
    Other = 'Other'


class TestDataType(Enum):
    NUMBER = 'NUMBER'
    INT = 'INT'
    FLOAT = 'FLOAT'
    DOUBLE = 'DOUBLE'
    DECIMAL = 'DECIMAL'
    TIMESTAMP = 'TIMESTAMP'
    TIME = 'TIME'
    DATE = 'DATE'
    DATETIME = 'DATETIME'
    ARRAY = 'ARRAY'
    MAP = 'MAP'
    SET = 'SET'
    STRING = 'STRING'
    BOOLEAN = 'BOOLEAN'


class EntityType(Enum):
    TABLE = 'TABLE'
    COLUMN = 'COLUMN'


class Rule(Enum):
    EQUALS = 'EQUALS'
    NOT_EQUALS = 'NOT_EQUALS'
    GREATER_THAN_OR_EQUALS = 'GREATER_THAN_OR_EQUALS'
    LESS_THAN_OR_EQUALS = 'LESS_THAN_OR_EQUALS'


class ValidationRule(BaseModel):
    parameterField: Annotated[
        Optional[str],
        Field(None, description='Name of the parameter to validate against.'),
    ]
    rule: Annotated[
        Optional[Rule],
        Field(
            None,
            description='This enum defines the type to use for a parameter validation rule.',
        ),
    ]


class TestCaseParameterDefinition(BaseModel):
    name: Annotated[Optional[str], Field(None, description='name of the parameter.')]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this parameter name.'),
    ]
    dataType: Annotated[
        Optional[TestDataType],
        Field(None, description='Data type of the parameter (int, date etc.).'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the parameter.'),
    ]
    required: Annotated[
        Optional[bool], Field(False, description='Is this parameter required.')
    ]
    optionValues: Annotated[
        Optional[List],
        Field([], description='List of values that can be passed for this parameter.'),
    ]
    validationRule: Annotated[
        Optional[ValidationRule],
        Field(None, description='Validation for the test parameter value.'),
    ]


class DataQualityDimensions(Enum):
    Completeness = 'Completeness'
    Accuracy = 'Accuracy'
    Consistency = 'Consistency'
    Validity = 'Validity'
    Uniqueness = 'Uniqueness'
    Integrity = 'Integrity'
    SQL = 'SQL'


class TestDefinition(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(
            None, description='Unique identifier of this test case definition instance.'
        ),
    ]
    name: Annotated[
        basic.TestCaseEntityName,
        Field(description='Name that identifies this test case.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this test case.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Description of the testcase.')
    ]
    entityType: Optional[EntityType] = None
    testPlatforms: List[TestPlatform]
    supportedDataTypes: Optional[List[table.DataType]] = None
    parameterDefinition: Optional[List[TestCaseParameterDefinition]] = None
    dataQualityDimension: Optional[DataQualityDimensions] = None
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this TestCase definition.'),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    supportsRowLevelPassedFailed: Annotated[
        Optional[bool],
        Field(
            False,
            description='When `true` indicates the test case supports row level passed/failed.',
        ),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
    supportsDynamicAssertion: Annotated[
        Optional[bool],
        Field(
            False,
            description='When `true` indicates the test case supports dynamic assertions.',
        ),
    ]
