# generated by datamodel-codegen:
#   filename:  type/auditLog.json
#   timestamp: 2025-09-27T10:11:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic


class Method(Enum):
    POST = 'POST'
    PUT = 'PUT'
    PATCH = 'PATCH'
    DELETE = 'DELETE'


class AuditLog(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    method: Annotated[Method, Field(description='HTTP Method used in a call.')]
    responseCode: Annotated[
        int, Field(description='HTTP response code for the api requested.')
    ]
    path: Annotated[str, Field(description='Requested API Path.')]
    userName: Annotated[
        str, Field(description='Name of the user who made the API request.')
    ]
    entityId: Annotated[
        basic.Uuid,
        Field(description='Identifier of entity that was modified by the operation.'),
    ]
    entityType: Annotated[
        str, Field(description='Type of Entity that is modified by the operation.')
    ]
    timestamp: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Timestamp when the API call is made in Unix epoch time milliseconds in Unix epoch time milliseconds.',
        ),
    ]
