# generated by datamodel-codegen:
#   filename:  type/csvFile.json
#   timestamp: 2025-09-27T10:11:06+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic


class CsvHeader(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: str
    required: Optional[bool] = False
    description: Annotated[
        basic.Markdown,
        Field(
            description='Description of the header field for documentation purposes.'
        ),
    ]
    examples: Annotated[List[str], Field(description='Example values for the field')]


class CsvRecord(RootModel[List[str]]):
    root: Annotated[
        List[str],
        Field(
            description='Represents a CSV record that contains one row values separated by a separator.'
        ),
    ]


class CsvFile(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    headers: Optional[List[CsvHeader]] = None
    records: Optional[List[CsvRecord]] = None
