# generated by datamodel-codegen:
#   filename:  type/customProperty.json
#   timestamp: 2025-09-27T10:11:06+00:00

from __future__ import annotations

from typing import List, Optional, Union

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic, entityReference
from .customProperties import enumConfig, tableConfig


class Format(RootModel[str]):
    root: Annotated[
        str, Field(description='Applies to date interval, date, time format.')
    ]


class EntityTypes(RootModel[List[str]]):
    root: Annotated[
        List[str],
        Field(
            description='Applies to Entity References. Entity Types can be used to restrict what type of entities can be configured for a entity reference.'
        ),
    ]


class CustomPropertyConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    config: Optional[
        Union[enumConfig.EnumConfig, Format, EntityTypes, tableConfig.TableConfig]
    ] = None


class PropertyType(RootModel[entityReference.EntityReference]):
    root: Annotated[
        entityReference.EntityReference,
        Field(
            description='Reference to a property type. Only property types are allowed and entity types are not allowed as custom properties to extend an existing entity'
        ),
    ]


class CustomProperty(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(
            description='Name of the entity property. Note a property name must be unique for an entity. Property name must follow camelCase naming adopted by openMetadata - must start with lower case with no space, underscore, or dots.'
        ),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name for the custom property.Must be unique for an entity.',
        ),
    ]
    description: basic.Markdown
    propertyType: PropertyType
    customPropertyConfig: Optional[CustomPropertyConfig] = None
