from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="rfdb",
    version="2.0.1",
    author="Suriya",
    author_email="tsuriya621@outlook.com",  # Update this
    description="A powerful interactive debugger for Robot Framework",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/yourusername/rfdb",  # Update this
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Testing",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Framework :: Robot Framework",
        "Operating System :: OS Independent",
    ],
    keywords="robotframework testing debugger debug interactive",
    python_requires=">=3.10",
    install_requires=[
        "robotframework>=7.1.1",
    ],
    project_urls={
        "Bug Reports": "https://github.com/suri-53/rfdb/issues",
        "Source": "https://github.com/suri-53/rfdb",
    },
)
