# 📦 Публикация SDK в PyPI

## Подготовка к публикации

### 1. Проверка файлов

Убедитесь, что все файлы на месте:

```
strayl_logging/
├── pyproject.toml          ✅
├── README.md               ✅
├── LICENSE                 ✅
├── src/
│   └── strayl_logging/
│       ├── __init__.py     ✅
│       └── client.py       ✅
└── .gitignore              ✅
```

### 2. Обновление версии

Перед каждой публикацией обновите версию в `pyproject.toml`:

```toml
version = "0.1.0"  # → "0.1.1" для патча, "0.2.0" для минора, "1.0.0" для мажора
```

---

## Шаг 1: Регистрация на PyPI

### Тестовый PyPI (рекомендуется сначала протестировать):

1. Создайте аккаунт на https://test.pypi.org/account/register/
2. Подтвердите email

### Production PyPI:

1. Создайте аккаунт на https://pypi.org/account/register/
2. Подтвердите email
3. Включите двухфакторную аутентификацию (рекомендуется)

---

## Шаг 2: Установка инструментов

```bash
pip install build twine
```

---

## Шаг 3: Сборка пакета

```bash
cd SDK/strayl_logging
python -m build
```

Это создаст папку `dist/` с файлами:
- `strayl-logging-0.1.0.tar.gz` (исходный код)
- `strayl_logging-0.1.0-py3-none-any.whl` (wheel)

---

## Шаг 4: Проверка сборки (опционально)

```bash
# Проверка содержимого
python -m twine check dist/*
```

---

## Шаг 5: Публикация в Test PyPI (рекомендуется)

### Создайте API токен:

1. Откройте https://test.pypi.org/manage/account/token/
2. Создайте новый токен (scope: "Entire account" или "All projects")
3. Скопируйте токен (показывается только один раз!)

### Загрузите пакет:

```bash
python -m twine upload --repository testpypi dist/*
```

Введите:
- Username: `__token__`
- Password: ваш API токен (начинается с `pypi-`)

### Проверьте установку из Test PyPI:

```bash
pip install --index-url https://test.pypi.org/simple/ strayl-logging
```

---

## Шаг 6: Публикация в Production PyPI

### Создайте API токен:

1. Откройте https://pypi.org/manage/account/token/
2. Создайте новый токен
3. Скопируйте токен

### Загрузите пакет:

```bash
python -m twine upload dist/*
```

Введите:
- Username: `__token__`
- Password: ваш API токен

---

## Шаг 7: Проверка публикации

После публикации (может занять несколько минут):

1. Проверьте страницу пакета:
   - Test PyPI: https://test.pypi.org/project/strayl-logging/
   - Production PyPI: https://pypi.org/project/strayl-logging/

2. Установите пакет:

```bash
pip install strayl-logging
```

3. Проверьте работу:

```python
from strayl_logging import StraylLogger
print("✅ SDK установлен и работает!")
```

---

## Обновление версии

При обновлении пакета:

1. Обновите версию в `pyproject.toml`
2. Обновите `CHANGELOG.md` (если есть)
3. Соберите заново: `python -m build`
4. Загрузите: `python -m twine upload dist/*`

---

## Безопасность

### API токены:

- ✅ Храните токены в безопасном месте
- ✅ Используйте разные токены для test и production
- ✅ Не коммитьте токены в Git
- ✅ Можно использовать `.pypirc` файл (не коммитить!)

### Создание `.pypirc` (опционально):

Создайте файл `~/.pypirc`:

```ini
[distutils]
index-servers =
    pypi
    testpypi

[pypi]
username = __token__
password = pypi-ваш_токен_здесь

[testpypi]
repository = https://test.pypi.org/legacy/
username = __token__
password = pypi-ваш_тестовый_токен_здесь
```

Тогда можно просто:
```bash
twine upload --repository testpypi dist/*  # для теста
twine upload dist/*  # для production
```

---

## Автоматизация через GitHub Actions (опционально)

Можно настроить автоматическую публикацию при создании тега:

```yaml
# .github/workflows/publish.yml
name: Publish to PyPI

on:
  release:
    types: [created]

jobs:
  publish:
    runs-on: ubuntu-latest
    steps:
      - uses: actions/checkout@v3
      - uses: actions/setup-python@v4
        with:
          python-version: '3.x'
      - run: pip install build twine
      - run: python -m build
      - run: twine upload dist/*
        env:
          TWINE_USERNAME: __token__
          TWINE_PASSWORD: ${{ secrets.PYPI_API_TOKEN }}
```

---

## Чеклист перед публикацией

- [ ] Версия обновлена в `pyproject.toml`
- [ ] README.md актуален
- [ ] LICENSE файл добавлен
- [ ] Код протестирован
- [ ] Сборка успешна (`python -m build`)
- [ ] Проверка twine прошла (`twine check dist/*`)
- [ ] Тестовая публикация в Test PyPI прошла успешно
- [ ] Установка из Test PyPI работает

---

## Полезные ссылки

- **PyPI**: https://pypi.org
- **Test PyPI**: https://test.pypi.org
- **Документация PyPI**: https://packaging.python.org/
- **Twine документация**: https://twine.readthedocs.io/

---

**Готово! После публикации пользователи смогут установить SDK:**

```bash
pip install strayl-logging
```

