# 🛠️ Инструкция по установке и запуску

## Проблема: `ModuleNotFoundError: No module named 'strayl_logging'`

Это значит, что пакет не установлен. Вот как это исправить:

---

## ✅ Решение 1: Установка пакета (рекомендуется)

```bash
cd SDK/strayl_logging
pip install -e .
```

Флаг `-e` означает "editable" - изменения в коде сразу будут видны.

После установки запустите:

```bash
python test_debug.py
```

---

## ✅ Решение 2: Запуск без установки

Если не хотите устанавливать пакет, можно запустить тесты напрямую:

```bash
cd SDK/strayl_logging
python -m src.strayl_logging.client
```

Или используйте `test_debug.py` - он автоматически добавит путь к модулю.

---

## ✅ Решение 3: Установка зависимостей

Если не установлен `requests`:

```bash
pip install requests
```

---

## 🔍 Проверка установки

После установки проверьте:

```bash
python -c "from strayl_logging import StraylLogger; print('✅ Установлено!')"
```

Если видите `✅ Установлено!` - всё готово!

---

## 📝 Полная последовательность команд

```bash
# 1. Перейдите в папку SDK
cd SDK/strayl_logging

# 2. Установите пакет
pip install -e .

# 3. Запустите тест с отладкой
python test_debug.py
```

---

## ❓ Если всё ещё не работает

1. Проверьте, что вы в правильной папке:
   ```bash
   pwd  # Linux/Mac
   cd   # Windows
   ```

2. Проверьте, что Python видит пакет:
   ```bash
   python -c "import sys; print(sys.path)"
   ```

3. Установите зависимости вручную:
   ```bash
   pip install requests
   ```

