# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from minknow_api import device_pb2 as minknow__api_dot_device__pb2


class DeviceServiceStub(object):
    """Missing associated documentation comment in .proto file."""

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.get_device_info = channel.unary_unary(
                '/minknow_api.device.DeviceService/get_device_info',
                request_serializer=minknow__api_dot_device__pb2.GetDeviceInfoRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetDeviceInfoResponse.FromString,
                )
        self.get_device_state = channel.unary_unary(
                '/minknow_api.device.DeviceService/get_device_state',
                request_serializer=minknow__api_dot_device__pb2.GetDeviceStateRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetDeviceStateResponse.FromString,
                )
        self.stream_device_state = channel.unary_stream(
                '/minknow_api.device.DeviceService/stream_device_state',
                request_serializer=minknow__api_dot_device__pb2.StreamDeviceStateRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetDeviceStateResponse.FromString,
                )
        self.get_flow_cell_info = channel.unary_unary(
                '/minknow_api.device.DeviceService/get_flow_cell_info',
                request_serializer=minknow__api_dot_device__pb2.GetFlowCellInfoRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetFlowCellInfoResponse.FromString,
                )
        self.stream_flow_cell_info = channel.unary_stream(
                '/minknow_api.device.DeviceService/stream_flow_cell_info',
                request_serializer=minknow__api_dot_device__pb2.StreamFlowCellInfoRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetFlowCellInfoResponse.FromString,
                )
        self.set_user_specified_flow_cell_id = channel.unary_unary(
                '/minknow_api.device.DeviceService/set_user_specified_flow_cell_id',
                request_serializer=minknow__api_dot_device__pb2.SetUserSpecifiedFlowCellIdRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.SetUserSpecifiedFlowCellIdResponse.FromString,
                )
        self.set_user_specified_product_code = channel.unary_unary(
                '/minknow_api.device.DeviceService/set_user_specified_product_code',
                request_serializer=minknow__api_dot_device__pb2.SetUserSpecifiedProductCodeRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.SetUserSpecifiedProductCodeResponse.FromString,
                )
        self.get_channels_layout = channel.unary_unary(
                '/minknow_api.device.DeviceService/get_channels_layout',
                request_serializer=minknow__api_dot_device__pb2.GetChannelsLayoutRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetChannelsLayoutResponse.FromString,
                )
        self.reset_device_settings = channel.unary_unary(
                '/minknow_api.device.DeviceService/reset_device_settings',
                request_serializer=minknow__api_dot_device__pb2.ResetDeviceSettingsRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.ResetDeviceSettingsResponse.FromString,
                )
        self.set_calibration = channel.unary_unary(
                '/minknow_api.device.DeviceService/set_calibration',
                request_serializer=minknow__api_dot_device__pb2.SetCalibrationRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.SetCalibrationResponse.FromString,
                )
        self.clear_calibration = channel.unary_unary(
                '/minknow_api.device.DeviceService/clear_calibration',
                request_serializer=minknow__api_dot_device__pb2.ClearCalibrationRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.ClearCalibrationResponse.FromString,
                )
        self.get_calibration = channel.unary_unary(
                '/minknow_api.device.DeviceService/get_calibration',
                request_serializer=minknow__api_dot_device__pb2.GetCalibrationRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetCalibrationResponse.FromString,
                )
        self.set_temperature = channel.unary_unary(
                '/minknow_api.device.DeviceService/set_temperature',
                request_serializer=minknow__api_dot_device__pb2.SetTemperatureRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.SetTemperatureResponse.FromString,
                )
        self.get_temperature = channel.unary_unary(
                '/minknow_api.device.DeviceService/get_temperature',
                request_serializer=minknow__api_dot_device__pb2.GetTemperatureRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetTemperatureResponse.FromString,
                )
        self.stream_temperature = channel.unary_stream(
                '/minknow_api.device.DeviceService/stream_temperature',
                request_serializer=minknow__api_dot_device__pb2.StreamTemperatureRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetTemperatureResponse.FromString,
                )
        self.unblock = channel.unary_unary(
                '/minknow_api.device.DeviceService/unblock',
                request_serializer=minknow__api_dot_device__pb2.UnblockRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.UnblockResponse.FromString,
                )
        self.cancel_unblocks = channel.unary_unary(
                '/minknow_api.device.DeviceService/cancel_unblocks',
                request_serializer=minknow__api_dot_device__pb2.CancelUnblocksRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.CancelUnblocksResponse.FromString,
                )
        self.get_channel_configuration = channel.unary_unary(
                '/minknow_api.device.DeviceService/get_channel_configuration',
                request_serializer=minknow__api_dot_device__pb2.GetChannelConfigurationRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetChannelConfigurationResponse.FromString,
                )
        self.set_channel_configuration = channel.unary_unary(
                '/minknow_api.device.DeviceService/set_channel_configuration',
                request_serializer=minknow__api_dot_device__pb2.SetChannelConfigurationRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.SetChannelConfigurationResponse.FromString,
                )
        self.set_channel_configuration_all = channel.unary_unary(
                '/minknow_api.device.DeviceService/set_channel_configuration_all',
                request_serializer=minknow__api_dot_device__pb2.SetChannelConfigurationAllRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.SetChannelConfigurationAllResponse.FromString,
                )
        self.set_saturation_config = channel.unary_unary(
                '/minknow_api.device.DeviceService/set_saturation_config',
                request_serializer=minknow__api_dot_device__pb2.SetSaturationConfigRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.SetSaturationConfigResponse.FromString,
                )
        self.get_saturation_config = channel.unary_unary(
                '/minknow_api.device.DeviceService/get_saturation_config',
                request_serializer=minknow__api_dot_device__pb2.GetSaturationConfigRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetSaturationConfigResponse.FromString,
                )
        self.get_sample_rate = channel.unary_unary(
                '/minknow_api.device.DeviceService/get_sample_rate',
                request_serializer=minknow__api_dot_device__pb2.GetSampleRateRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetSampleRateResponse.FromString,
                )
        self.set_sample_rate = channel.unary_unary(
                '/minknow_api.device.DeviceService/set_sample_rate',
                request_serializer=minknow__api_dot_device__pb2.SetSampleRateRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.SetSampleRateResponse.FromString,
                )
        self.get_bias_voltage = channel.unary_unary(
                '/minknow_api.device.DeviceService/get_bias_voltage',
                request_serializer=minknow__api_dot_device__pb2.GetBiasVoltageRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.GetBiasVoltageResponse.FromString,
                )
        self.set_bias_voltage = channel.unary_unary(
                '/minknow_api.device.DeviceService/set_bias_voltage',
                request_serializer=minknow__api_dot_device__pb2.SetBiasVoltageRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.SetBiasVoltageResponse.FromString,
                )
        self.dump_state = channel.unary_unary(
                '/minknow_api.device.DeviceService/dump_state',
                request_serializer=minknow__api_dot_device__pb2.DumpStateRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.DumpStateResponse.FromString,
                )
        self.increment_flow_cell_use_count = channel.unary_unary(
                '/minknow_api.device.DeviceService/increment_flow_cell_use_count',
                request_serializer=minknow__api_dot_device__pb2.IncrementFlowCellUseCountRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.IncrementFlowCellUseCountResponse.FromString,
                )
        self.set_flow_cell_barcode_kit = channel.unary_unary(
                '/minknow_api.device.DeviceService/set_flow_cell_barcode_kit',
                request_serializer=minknow__api_dot_device__pb2.SetFlowCellBarcodeKitRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.SetFlowCellBarcodeKitResponse.FromString,
                )
        self.register_flow_cell_barcodes = channel.unary_unary(
                '/minknow_api.device.DeviceService/register_flow_cell_barcodes',
                request_serializer=minknow__api_dot_device__pb2.RegisterFlowCellBarcodesRequest.SerializeToString,
                response_deserializer=minknow__api_dot_device__pb2.RegisterFlowCellBarcodesResponse.FromString,
                )


class DeviceServiceServicer(object):
    """Missing associated documentation comment in .proto file."""

    def get_device_info(self, request, context):
        """Get information about the device this MinKNOW instance was started for.

        In normal circumstances (ie: when using the manager service), a new MinKNOW instance
        is started for each available device. This call provides information about this device.

        The information returned by this call will not change (providing the MinKNOW instance
        was started by the manager service).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def get_device_state(self, request, context):
        """Get information about the current device state.

        Information in this call may change as the device is used with MinKNOW, for example,
        by unplugging or plugging in the device.

        It includes information about whether the hardware is actually attached (in the case of
        MinIONs, which can be unplugged), as well as what types of flow cells can be inserted (which
        may be affected by flow cell adapters).

        Since 1.12
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def stream_device_state(self, request, context):
        """Streaming version of get_device_state

        Since 1.13
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def get_flow_cell_info(self, request, context):
        """Get information about the flow cell (if any).

        This provides information about the flow_cell attached to the device (described by
        get_device_info()), if any.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def stream_flow_cell_info(self, request, context):
        """Streaming version of get_flow_cell_info

        Since 1.13
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def set_user_specified_flow_cell_id(self, request, context):
        """Set the user specified flow cell id.

        This changes the user specified flow cell id.
        MinKNOW will use this id in place of the id read from the eeprom, if no eeprom data
        is available.

        This data is reset when the flow cell is disconnected.

        Since 1.12
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def set_user_specified_product_code(self, request, context):
        """Set the user specified product code.

        This changes the user specified product code.

        MinKNOW does not use the product code, it is intended for use in MinKNOW's clients.

        This data is reset when the flow cell is disconnected.

        Since 1.12
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def get_channels_layout(self, request, context):
        """Get information about the channel layout

        Since 1.14
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def reset_device_settings(self, request, context):
        """Reset all settings associated with the current device.

        This call will initialise all settings to their default state, ie the same as when MinKNOW boots.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def set_calibration(self, request, context):
        """Set the calibration measurements to be used by MinKNOW.

        Calibration describes how to convert from the raw ADC (analog-to-digital converter) values
        from the device into picoamps (pA).

        Note that calibration depends on the device, flow cell and some of the device settings
        (including sampling frequency and the capacitance used in the integration circuit). If
        any of these are changed, the calibration will no longer be used. Instead, a previously-saved
        calibration (for that combination of flow cell and settings) might be used, or the identity
        calibration might be used.

        On a MinION, the settings that a calibration depends on are sampling frequency and
        integration capacitor.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def clear_calibration(self, request, context):
        """Clear the current calibration.

        This is the same as setting the calibration to be the identity function (setting all offsets
        to 0, and all pA ranges to the digitisation value).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def get_calibration(self, request, context):
        """The calibration measurements being used by MinKNOW.

        Calibration describes how to convert from the raw ADC (analog-to-digital converter) values
        from the device into picoamps (pA).

        To get a pA value from an ADC value the following function is applied::

        pA_current = (adc_current + offset) / (digitisation / pA_range)

        The digitisation is the range of possible ADC values. It is the same for all channels.

        If there is no calibration (including if it was cleared with ``clear_calibration()`` or
        invalidated because of device settings changes), this will return the identity calibration:
        all offsets will be 0, and the pA ranges will be the same as the digitisation.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def set_temperature(self, request, context):
        """Set the target primary device temperature

        If the device is not temperature-controllable (see the fields
        `device.GetDeviceInfoResponse.can_set_temperature` and
        `minion_device.MinionDeviceSettings.enable_temperature_control`) then this call will have
        no effect

        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def get_temperature(self, request, context):
        """Get the current temperature of the device.

        Since 1.11
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def stream_temperature(self, request, context):
        """Stream the current temperature of the device.

        Since 4.3
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def unblock(self, request, context):
        """Triggers an unblock for a list of channels for a given duration (Please see UnblockRequest).
        It will start an unblock for every channel received as a parameter, then this RPC returns.
        After the timeout expires (the duration in seconds given in the request), the return from
        unblock is automatically triggered, which resets the channel configuration (mux) to the
        value preceding the unblock.

        Notes!!

        During the unblock the user should NOT do any mux changes, as the unblock will be interrupted.
        On Promethion this would be even more complicated, as an unblock would normally restore
        hardware saturation. If an unblock is interrupted it will not restore the state to the original
        one.

        The user should NOT change the overload mode during an unblock - this will confuse the return from
        unblock, which tries to reset the overload mode to the state preceding the unblock.

        The unblock can fail if the channel is not in a valid well state (this means a channel needs to be
        in one of pore1-4, not test current, regen pore or unblock). If a mux is not valid, the unblock grpc
        will try to continue for the rest of the channels, ignoring the one with the wrong mux.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def cancel_unblocks(self, request, context):
        """Cancel in progress unblocks.

        Any unblocks registered with `device.unblock` will be stopped before this command returns.
        Unblocks are stopped by applying any actions required to return from unblock (mux changes, or hardware configuration).

        Since 1.15
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def get_channel_configuration(self, request, context):
        """Get the channel configuration for any number of channels

        The maximum addressable channel will depend on the device. Currently this will be 512 on a MinION/GridION
        and 3000 on a PromethION
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def set_channel_configuration(self, request, context):
        """Set the channel configuration for any number of channels

        The maximum addressable channel will depend on the device. Currently this will be 512 on a MinION/GridION
        and 3000 on a PromethION.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def set_channel_configuration_all(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def set_saturation_config(self, request, context):
        """Set the saturation control configuration.

        The request is immediately sent to the data acquisition module, and applied. All settings can be changed
        whilst the experiment is running.

        If any keys are not specified when this method is called (see the message for specific optional parameters),
        the previously applied parameters are kept; initially, when this method has never been called, defaults from the
        application config are used.

        note: calling this method resets anu in-progress saturations when it is called, causing them to need to start
        saturation counts again, this may mean any saturations may take longer to occur.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def get_saturation_config(self, request, context):
        """Get the saturation control configuration.

        The default configuration is specified by the MinKNOW application configuration, the command returns the most
        recently applied saturation config.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def get_sample_rate(self, request, context):
        """Get the sample rate of the device

        Please refer to MinionDeviceService and PromethionDeviceService for the expected
        return value for a minion and promethion respectively
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def set_sample_rate(self, request, context):
        """Set the sample rate of the device, and returns the actual value set on the device

        Please refer to MinionDeviceService and PromethionDeviceService to see
        how the value set here will be used to determine the real sample rate for a
        minion and promethion respectively

        Trying to set the sample rate during an acquisition period will result in an error
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def get_bias_voltage(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def set_bias_voltage(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def dump_state(self, request, context):
        """Trigger a device specific dump of device-state control-server log. The
        information will appear in a "diagnostic_information" message

        Since 5.0
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def increment_flow_cell_use_count(self, request, context):
        """Increment use count so that it is possible to track the amount of times a flow cell has been used

        This has a hard limit of 255, and an error will occur if an overflow is detected.

        Since 5.6
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def set_flow_cell_barcode_kit(self, request, context):
        """Specify the barcode kit that has been used with the flow cell

        Once this has been set it cannot be modified. It is also not possible to register the
        barcodes that have been used until this has been set.

        Since 5.6
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def register_flow_cell_barcodes(self, request, context):
        """Register that a distinct barcode has been used with the flow-cell

        Barcodes cannot be cleared once registered. A Barcode Kit must also be set using set_flow_cell_barcode_kit()

        Since 5.6
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_DeviceServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'get_device_info': grpc.unary_unary_rpc_method_handler(
                    servicer.get_device_info,
                    request_deserializer=minknow__api_dot_device__pb2.GetDeviceInfoRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetDeviceInfoResponse.SerializeToString,
            ),
            'get_device_state': grpc.unary_unary_rpc_method_handler(
                    servicer.get_device_state,
                    request_deserializer=minknow__api_dot_device__pb2.GetDeviceStateRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetDeviceStateResponse.SerializeToString,
            ),
            'stream_device_state': grpc.unary_stream_rpc_method_handler(
                    servicer.stream_device_state,
                    request_deserializer=minknow__api_dot_device__pb2.StreamDeviceStateRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetDeviceStateResponse.SerializeToString,
            ),
            'get_flow_cell_info': grpc.unary_unary_rpc_method_handler(
                    servicer.get_flow_cell_info,
                    request_deserializer=minknow__api_dot_device__pb2.GetFlowCellInfoRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetFlowCellInfoResponse.SerializeToString,
            ),
            'stream_flow_cell_info': grpc.unary_stream_rpc_method_handler(
                    servicer.stream_flow_cell_info,
                    request_deserializer=minknow__api_dot_device__pb2.StreamFlowCellInfoRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetFlowCellInfoResponse.SerializeToString,
            ),
            'set_user_specified_flow_cell_id': grpc.unary_unary_rpc_method_handler(
                    servicer.set_user_specified_flow_cell_id,
                    request_deserializer=minknow__api_dot_device__pb2.SetUserSpecifiedFlowCellIdRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.SetUserSpecifiedFlowCellIdResponse.SerializeToString,
            ),
            'set_user_specified_product_code': grpc.unary_unary_rpc_method_handler(
                    servicer.set_user_specified_product_code,
                    request_deserializer=minknow__api_dot_device__pb2.SetUserSpecifiedProductCodeRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.SetUserSpecifiedProductCodeResponse.SerializeToString,
            ),
            'get_channels_layout': grpc.unary_unary_rpc_method_handler(
                    servicer.get_channels_layout,
                    request_deserializer=minknow__api_dot_device__pb2.GetChannelsLayoutRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetChannelsLayoutResponse.SerializeToString,
            ),
            'reset_device_settings': grpc.unary_unary_rpc_method_handler(
                    servicer.reset_device_settings,
                    request_deserializer=minknow__api_dot_device__pb2.ResetDeviceSettingsRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.ResetDeviceSettingsResponse.SerializeToString,
            ),
            'set_calibration': grpc.unary_unary_rpc_method_handler(
                    servicer.set_calibration,
                    request_deserializer=minknow__api_dot_device__pb2.SetCalibrationRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.SetCalibrationResponse.SerializeToString,
            ),
            'clear_calibration': grpc.unary_unary_rpc_method_handler(
                    servicer.clear_calibration,
                    request_deserializer=minknow__api_dot_device__pb2.ClearCalibrationRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.ClearCalibrationResponse.SerializeToString,
            ),
            'get_calibration': grpc.unary_unary_rpc_method_handler(
                    servicer.get_calibration,
                    request_deserializer=minknow__api_dot_device__pb2.GetCalibrationRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetCalibrationResponse.SerializeToString,
            ),
            'set_temperature': grpc.unary_unary_rpc_method_handler(
                    servicer.set_temperature,
                    request_deserializer=minknow__api_dot_device__pb2.SetTemperatureRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.SetTemperatureResponse.SerializeToString,
            ),
            'get_temperature': grpc.unary_unary_rpc_method_handler(
                    servicer.get_temperature,
                    request_deserializer=minknow__api_dot_device__pb2.GetTemperatureRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetTemperatureResponse.SerializeToString,
            ),
            'stream_temperature': grpc.unary_stream_rpc_method_handler(
                    servicer.stream_temperature,
                    request_deserializer=minknow__api_dot_device__pb2.StreamTemperatureRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetTemperatureResponse.SerializeToString,
            ),
            'unblock': grpc.unary_unary_rpc_method_handler(
                    servicer.unblock,
                    request_deserializer=minknow__api_dot_device__pb2.UnblockRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.UnblockResponse.SerializeToString,
            ),
            'cancel_unblocks': grpc.unary_unary_rpc_method_handler(
                    servicer.cancel_unblocks,
                    request_deserializer=minknow__api_dot_device__pb2.CancelUnblocksRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.CancelUnblocksResponse.SerializeToString,
            ),
            'get_channel_configuration': grpc.unary_unary_rpc_method_handler(
                    servicer.get_channel_configuration,
                    request_deserializer=minknow__api_dot_device__pb2.GetChannelConfigurationRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetChannelConfigurationResponse.SerializeToString,
            ),
            'set_channel_configuration': grpc.unary_unary_rpc_method_handler(
                    servicer.set_channel_configuration,
                    request_deserializer=minknow__api_dot_device__pb2.SetChannelConfigurationRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.SetChannelConfigurationResponse.SerializeToString,
            ),
            'set_channel_configuration_all': grpc.unary_unary_rpc_method_handler(
                    servicer.set_channel_configuration_all,
                    request_deserializer=minknow__api_dot_device__pb2.SetChannelConfigurationAllRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.SetChannelConfigurationAllResponse.SerializeToString,
            ),
            'set_saturation_config': grpc.unary_unary_rpc_method_handler(
                    servicer.set_saturation_config,
                    request_deserializer=minknow__api_dot_device__pb2.SetSaturationConfigRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.SetSaturationConfigResponse.SerializeToString,
            ),
            'get_saturation_config': grpc.unary_unary_rpc_method_handler(
                    servicer.get_saturation_config,
                    request_deserializer=minknow__api_dot_device__pb2.GetSaturationConfigRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetSaturationConfigResponse.SerializeToString,
            ),
            'get_sample_rate': grpc.unary_unary_rpc_method_handler(
                    servicer.get_sample_rate,
                    request_deserializer=minknow__api_dot_device__pb2.GetSampleRateRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetSampleRateResponse.SerializeToString,
            ),
            'set_sample_rate': grpc.unary_unary_rpc_method_handler(
                    servicer.set_sample_rate,
                    request_deserializer=minknow__api_dot_device__pb2.SetSampleRateRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.SetSampleRateResponse.SerializeToString,
            ),
            'get_bias_voltage': grpc.unary_unary_rpc_method_handler(
                    servicer.get_bias_voltage,
                    request_deserializer=minknow__api_dot_device__pb2.GetBiasVoltageRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.GetBiasVoltageResponse.SerializeToString,
            ),
            'set_bias_voltage': grpc.unary_unary_rpc_method_handler(
                    servicer.set_bias_voltage,
                    request_deserializer=minknow__api_dot_device__pb2.SetBiasVoltageRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.SetBiasVoltageResponse.SerializeToString,
            ),
            'dump_state': grpc.unary_unary_rpc_method_handler(
                    servicer.dump_state,
                    request_deserializer=minknow__api_dot_device__pb2.DumpStateRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.DumpStateResponse.SerializeToString,
            ),
            'increment_flow_cell_use_count': grpc.unary_unary_rpc_method_handler(
                    servicer.increment_flow_cell_use_count,
                    request_deserializer=minknow__api_dot_device__pb2.IncrementFlowCellUseCountRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.IncrementFlowCellUseCountResponse.SerializeToString,
            ),
            'set_flow_cell_barcode_kit': grpc.unary_unary_rpc_method_handler(
                    servicer.set_flow_cell_barcode_kit,
                    request_deserializer=minknow__api_dot_device__pb2.SetFlowCellBarcodeKitRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.SetFlowCellBarcodeKitResponse.SerializeToString,
            ),
            'register_flow_cell_barcodes': grpc.unary_unary_rpc_method_handler(
                    servicer.register_flow_cell_barcodes,
                    request_deserializer=minknow__api_dot_device__pb2.RegisterFlowCellBarcodesRequest.FromString,
                    response_serializer=minknow__api_dot_device__pb2.RegisterFlowCellBarcodesResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'minknow_api.device.DeviceService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class DeviceService(object):
    """Missing associated documentation comment in .proto file."""

    @staticmethod
    def get_device_info(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/get_device_info',
            minknow__api_dot_device__pb2.GetDeviceInfoRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetDeviceInfoResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def get_device_state(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/get_device_state',
            minknow__api_dot_device__pb2.GetDeviceStateRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetDeviceStateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def stream_device_state(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/minknow_api.device.DeviceService/stream_device_state',
            minknow__api_dot_device__pb2.StreamDeviceStateRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetDeviceStateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def get_flow_cell_info(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/get_flow_cell_info',
            minknow__api_dot_device__pb2.GetFlowCellInfoRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetFlowCellInfoResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def stream_flow_cell_info(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/minknow_api.device.DeviceService/stream_flow_cell_info',
            minknow__api_dot_device__pb2.StreamFlowCellInfoRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetFlowCellInfoResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def set_user_specified_flow_cell_id(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/set_user_specified_flow_cell_id',
            minknow__api_dot_device__pb2.SetUserSpecifiedFlowCellIdRequest.SerializeToString,
            minknow__api_dot_device__pb2.SetUserSpecifiedFlowCellIdResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def set_user_specified_product_code(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/set_user_specified_product_code',
            minknow__api_dot_device__pb2.SetUserSpecifiedProductCodeRequest.SerializeToString,
            minknow__api_dot_device__pb2.SetUserSpecifiedProductCodeResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def get_channels_layout(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/get_channels_layout',
            minknow__api_dot_device__pb2.GetChannelsLayoutRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetChannelsLayoutResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def reset_device_settings(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/reset_device_settings',
            minknow__api_dot_device__pb2.ResetDeviceSettingsRequest.SerializeToString,
            minknow__api_dot_device__pb2.ResetDeviceSettingsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def set_calibration(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/set_calibration',
            minknow__api_dot_device__pb2.SetCalibrationRequest.SerializeToString,
            minknow__api_dot_device__pb2.SetCalibrationResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def clear_calibration(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/clear_calibration',
            minknow__api_dot_device__pb2.ClearCalibrationRequest.SerializeToString,
            minknow__api_dot_device__pb2.ClearCalibrationResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def get_calibration(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/get_calibration',
            minknow__api_dot_device__pb2.GetCalibrationRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetCalibrationResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def set_temperature(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/set_temperature',
            minknow__api_dot_device__pb2.SetTemperatureRequest.SerializeToString,
            minknow__api_dot_device__pb2.SetTemperatureResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def get_temperature(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/get_temperature',
            minknow__api_dot_device__pb2.GetTemperatureRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetTemperatureResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def stream_temperature(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/minknow_api.device.DeviceService/stream_temperature',
            minknow__api_dot_device__pb2.StreamTemperatureRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetTemperatureResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def unblock(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/unblock',
            minknow__api_dot_device__pb2.UnblockRequest.SerializeToString,
            minknow__api_dot_device__pb2.UnblockResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def cancel_unblocks(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/cancel_unblocks',
            minknow__api_dot_device__pb2.CancelUnblocksRequest.SerializeToString,
            minknow__api_dot_device__pb2.CancelUnblocksResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def get_channel_configuration(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/get_channel_configuration',
            minknow__api_dot_device__pb2.GetChannelConfigurationRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetChannelConfigurationResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def set_channel_configuration(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/set_channel_configuration',
            minknow__api_dot_device__pb2.SetChannelConfigurationRequest.SerializeToString,
            minknow__api_dot_device__pb2.SetChannelConfigurationResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def set_channel_configuration_all(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/set_channel_configuration_all',
            minknow__api_dot_device__pb2.SetChannelConfigurationAllRequest.SerializeToString,
            minknow__api_dot_device__pb2.SetChannelConfigurationAllResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def set_saturation_config(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/set_saturation_config',
            minknow__api_dot_device__pb2.SetSaturationConfigRequest.SerializeToString,
            minknow__api_dot_device__pb2.SetSaturationConfigResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def get_saturation_config(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/get_saturation_config',
            minknow__api_dot_device__pb2.GetSaturationConfigRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetSaturationConfigResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def get_sample_rate(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/get_sample_rate',
            minknow__api_dot_device__pb2.GetSampleRateRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetSampleRateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def set_sample_rate(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/set_sample_rate',
            minknow__api_dot_device__pb2.SetSampleRateRequest.SerializeToString,
            minknow__api_dot_device__pb2.SetSampleRateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def get_bias_voltage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/get_bias_voltage',
            minknow__api_dot_device__pb2.GetBiasVoltageRequest.SerializeToString,
            minknow__api_dot_device__pb2.GetBiasVoltageResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def set_bias_voltage(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/set_bias_voltage',
            minknow__api_dot_device__pb2.SetBiasVoltageRequest.SerializeToString,
            minknow__api_dot_device__pb2.SetBiasVoltageResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def dump_state(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/dump_state',
            minknow__api_dot_device__pb2.DumpStateRequest.SerializeToString,
            minknow__api_dot_device__pb2.DumpStateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def increment_flow_cell_use_count(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/increment_flow_cell_use_count',
            minknow__api_dot_device__pb2.IncrementFlowCellUseCountRequest.SerializeToString,
            minknow__api_dot_device__pb2.IncrementFlowCellUseCountResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def set_flow_cell_barcode_kit(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/set_flow_cell_barcode_kit',
            minknow__api_dot_device__pb2.SetFlowCellBarcodeKitRequest.SerializeToString,
            minknow__api_dot_device__pb2.SetFlowCellBarcodeKitResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def register_flow_cell_barcodes(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.device.DeviceService/register_flow_cell_barcodes',
            minknow__api_dot_device__pb2.RegisterFlowCellBarcodesRequest.SerializeToString,
            minknow__api_dot_device__pb2.RegisterFlowCellBarcodesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
