### THIS FILE IS AUTOGENERATED. DO NOT EDIT THIS FILE DIRECTLY ###
import minknow_api
from minknow_api.device_pb2_grpc import *
import minknow_api.device_pb2 as device_pb2
from minknow_api.device_pb2 import *
from minknow_api._support import MessageWrapper, ArgumentError
import time
import logging
import sys

__all__ = [
    "DeviceService",
    "ChannelConfiguration",
    "ReturnedChannelConfiguration",
    "GetDeviceInfoRequest",
    "GetDeviceInfoResponse",
    "GetDeviceStateRequest",
    "GetDeviceStateResponse",
    "StreamDeviceStateRequest",
    "GetFlowCellInfoRequest",
    "GetFlowCellInfoResponse",
    "StreamFlowCellInfoRequest",
    "SetUserSpecifiedFlowCellIdRequest",
    "SetUserSpecifiedFlowCellIdResponse",
    "SetUserSpecifiedProductCodeRequest",
    "SetUserSpecifiedProductCodeResponse",
    "GetChannelsLayoutRequest",
    "GetChannelsLayoutResponse",
    "ChannelRecord",
    "ResetDeviceSettingsRequest",
    "ResetDeviceSettingsResponse",
    "SetCalibrationRequest",
    "SetCalibrationResponse",
    "ClearCalibrationRequest",
    "ClearCalibrationResponse",
    "GetCalibrationRequest",
    "GetCalibrationResponse",
    "SetTemperatureRequest",
    "SetTemperatureResponse",
    "GetTemperatureRequest",
    "GetTemperatureResponse",
    "StreamTemperatureRequest",
    "UnblockRequest",
    "UnblockResponse",
    "CancelUnblocksRequest",
    "CancelUnblocksResponse",
    "GetChannelConfigurationRequest",
    "GetChannelConfigurationResponse",
    "SetChannelConfigurationRequest",
    "SetChannelConfigurationResponse",
    "SetChannelConfigurationAllRequest",
    "SetChannelConfigurationAllResponse",
    "SaturationConfig",
    "SetSaturationConfigRequest",
    "SetSaturationConfigResponse",
    "GetSaturationConfigRequest",
    "GetSaturationConfigResponse",
    "GetSampleRateRequest",
    "GetSampleRateResponse",
    "SetSampleRateRequest",
    "SetSampleRateResponse",
    "GetBiasVoltageRequest",
    "GetBiasVoltageResponse",
    "SetBiasVoltageRequest",
    "SetBiasVoltageResponse",
    "DumpStateRequest",
    "DumpStateResponse",
    "IncrementFlowCellUseCountRequest",
    "IncrementFlowCellUseCountResponse",
    "SetFlowCellBarcodeKitRequest",
    "SetFlowCellBarcodeKitResponse",
    "RegisterFlowCellBarcodesRequest",
    "RegisterFlowCellBarcodesResponse",
    "FlowCellConnectorType",
    "FCCON_NOT_SET",
    "FCCON_PROMETHION",
    "FCCON_MINION_MK1",
    "FCCON_FLONGLE",
    "FCCON_PEBBLE",
    "InsertionScriptStatus",
    "NOT_RUN",
    "FAILED",
    "SUCCEEDED",
    "SelectedWell",
    "WELL_NONE",
    "WELL_1",
    "WELL_2",
    "WELL_3",
    "WELL_4",
    "WELL_OTHER",
]

def run_with_retry(method, message, timeout, unwraps, full_name):
    retry_count = 20
    error = None
    for i in range(retry_count):
        try:
            result = MessageWrapper(method(message, timeout=timeout), unwraps=unwraps)
            return result
        except grpc.RpcError as e:
            # Retrying unidentified grpc errors to keep clients from crashing
            retryable_error = (e.code() == grpc.StatusCode.UNKNOWN and "Stream removed" in e.details() or \
                                (e.code() == grpc.StatusCode.INTERNAL and "RST_STREAM" in e.details()))
            if retryable_error:
                logging.info('Bypassed ({}: {}) error for grpc: {}. Attempt {}.'.format(e.code(), e.details(), full_name, i))
            else:
                raise
            error = e
        time.sleep(1)
    raise error


class DeviceService(object):
    def __init__(self, channel):
        self._stub = DeviceServiceStub(channel)
        self._pb = device_pb2
    def get_device_info(self, _message=None, _timeout=None, **kwargs):
        """Get information about the device this MinKNOW instance was started for.

        In normal circumstances (ie: when using the manager service), a new MinKNOW instance
        is started for each available device. This call provides information about this device.

        The information returned by this call will not change (providing the MinKNOW instance
        was started by the manager service).

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.GetDeviceInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.GetDeviceInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_device_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = GetDeviceInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_device_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_device_info,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def get_device_state(self, _message=None, _timeout=None, **kwargs):
        """Get information about the current device state.

        Information in this call may change as the device is used with MinKNOW, for example,
        by unplugging or plugging in the device.

        It includes information about whether the hardware is actually attached (in the case of
        MinIONs, which can be unplugged), as well as what types of flow cells can be inserted (which
        may be affected by flow cell adapters).

        Since 1.12

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.GetDeviceStateRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.GetDeviceStateResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_device_state,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = GetDeviceStateRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_device_state: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_device_state,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def stream_device_state(self, _message=None, _timeout=None, **kwargs):
        """Streaming version of get_device_state

        Since 1.13

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.StreamDeviceStateRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.

        Returns:
            iter of minknow_api.device_pb2.GetDeviceStateResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_device_state,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = StreamDeviceStateRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_device_state: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_device_state,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def get_flow_cell_info(self, _message=None, _timeout=None, **kwargs):
        """Get information about the flow cell (if any).

        This provides information about the flow_cell attached to the device (described by
        get_device_info()), if any.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.GetFlowCellInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.GetFlowCellInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_flow_cell_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = GetFlowCellInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_flow_cell_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_flow_cell_info,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def stream_flow_cell_info(self, _message=None, _timeout=None, **kwargs):
        """Streaming version of get_flow_cell_info

        Since 1.13

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.StreamFlowCellInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.

        Returns:
            iter of minknow_api.device_pb2.GetFlowCellInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_flow_cell_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = StreamFlowCellInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_flow_cell_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_flow_cell_info,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def set_user_specified_flow_cell_id(self, _message=None, _timeout=None, **kwargs):
        """Set the user specified flow cell id.

        This changes the user specified flow cell id.
        MinKNOW will use this id in place of the id read from the eeprom, if no eeprom data
        is available.

        This data is reset when the flow cell is disconnected.

        Since 1.12

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.device_pb2.SetUserSpecifiedFlowCellIdRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            id (str): A unique identifier for the flow cell, which the user can specify.

                In the event a flow cell does not have an eeprom, this field can be used by the user
                to record their flow_cell_id.

                Since 1.12

        Returns:
            minknow_api.device_pb2.SetUserSpecifiedFlowCellIdResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_user_specified_flow_cell_id,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = SetUserSpecifiedFlowCellIdRequest()

        if "id" in kwargs:
            unused_args.remove("id")
            _message.id = kwargs['id']
        else:
            raise ArgumentError("set_user_specified_flow_cell_id requires a 'id' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_user_specified_flow_cell_id: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_user_specified_flow_cell_id,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def set_user_specified_product_code(self, _message=None, _timeout=None, **kwargs):
        """Set the user specified product code.

        This changes the user specified product code.

        MinKNOW does not use the product code, it is intended for use in MinKNOW's clients.

        This data is reset when the flow cell is disconnected.

        Since 1.12

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.device_pb2.SetUserSpecifiedProductCodeRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            code (str): A product code for the flow cell, which the user can specify.

                In the event a flow cell does not have an eeprom, the user can specify product code here.

                Since 1.12

        Returns:
            minknow_api.device_pb2.SetUserSpecifiedProductCodeResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_user_specified_product_code,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = SetUserSpecifiedProductCodeRequest()

        if "code" in kwargs:
            unused_args.remove("code")
            _message.code = kwargs['code']
        else:
            raise ArgumentError("set_user_specified_product_code requires a 'code' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_user_specified_product_code: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_user_specified_product_code,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def get_channels_layout(self, _message=None, _timeout=None, **kwargs):
        """Get information about the channel layout

        Since 1.14

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.GetChannelsLayoutRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.GetChannelsLayoutResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_channels_layout,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = GetChannelsLayoutRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_channels_layout: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_channels_layout,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def reset_device_settings(self, _message=None, _timeout=None, **kwargs):
        """Reset all settings associated with the current device.

        This call will initialise all settings to their default state, ie the same as when MinKNOW boots.

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.device_pb2.ResetDeviceSettingsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.ResetDeviceSettingsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.reset_device_settings,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = ResetDeviceSettingsRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to reset_device_settings: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.reset_device_settings,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def set_calibration(self, _message=None, _timeout=None, **kwargs):
        """Set the calibration measurements to be used by MinKNOW.

        Calibration describes how to convert from the raw ADC (analog-to-digital converter) values
        from the device into picoamps (pA).

        Note that calibration depends on the device, flow cell and some of the device settings
        (including sampling frequency and the capacitance used in the integration circuit). If
        any of these are changed, the calibration will no longer be used. Instead, a previously-saved
        calibration (for that combination of flow cell and settings) might be used, or the identity
        calibration might be used.

        On a MinION, the settings that a calibration depends on are sampling frequency and
        integration capacitor.

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.device_pb2.SetCalibrationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            first_channel (int): The first channel included in calibration data.

                This must always be 1. This is required in order to make sure the client and MinKNOW agree on
                what data is being provided.
            last_channel (int): The last channel included in calibration data.

                This must always be the same as the channel count returned by
                :meth:`get_flow_cell_info`. This is required in order to make
                sure the client and MinKNOW agree on what data is being provided.
            offsets (float): The ADC value adjustment to reach 0pA on each channel.

                This is ``-x``, where ``x`` is the (mean) ADC value at 0pA.
            pa_ranges (float): The range of possible pA values that can be produced by the device.

        Returns:
            minknow_api.device_pb2.SetCalibrationResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_calibration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = SetCalibrationRequest()

        if "first_channel" in kwargs:
            unused_args.remove("first_channel")
            _message.first_channel = kwargs['first_channel']
        else:
            raise ArgumentError("set_calibration requires a 'first_channel' argument")

        if "last_channel" in kwargs:
            unused_args.remove("last_channel")
            _message.last_channel = kwargs['last_channel']
        else:
            raise ArgumentError("set_calibration requires a 'last_channel' argument")

        if "offsets" in kwargs:
            unused_args.remove("offsets")
            _message.offsets.extend(kwargs['offsets'])
        else:
            raise ArgumentError("set_calibration requires a 'offsets' argument")

        if "pa_ranges" in kwargs:
            unused_args.remove("pa_ranges")
            _message.pa_ranges.extend(kwargs['pa_ranges'])
        else:
            raise ArgumentError("set_calibration requires a 'pa_ranges' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_calibration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_calibration,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def clear_calibration(self, _message=None, _timeout=None, **kwargs):
        """Clear the current calibration.

        This is the same as setting the calibration to be the identity function (setting all offsets
        to 0, and all pA ranges to the digitisation value).

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.device_pb2.ClearCalibrationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.ClearCalibrationResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.clear_calibration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = ClearCalibrationRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to clear_calibration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.clear_calibration,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def get_calibration(self, _message=None, _timeout=None, **kwargs):
        """The calibration measurements being used by MinKNOW.

        Calibration describes how to convert from the raw ADC (analog-to-digital converter) values
        from the device into picoamps (pA).

        To get a pA value from an ADC value the following function is applied::

             pA_current = (adc_current + offset) / (digitisation / pA_range)

        The digitisation is the range of possible ADC values. It is the same for all channels.

        If there is no calibration (including if it was cleared with ``clear_calibration()`` or
        invalidated because of device settings changes), this will return the identity calibration:
        all offsets will be 0, and the pA ranges will be the same as the digitisation.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.GetCalibrationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            first_channel (int): The first channel to get calibration data for.

                This should normally be 1.
            last_channel (int): The last channel included in calibration data.

                This should normally be the channel count returned by
                :meth:`get_flow_cell_info`.

        Returns:
            minknow_api.device_pb2.GetCalibrationResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_calibration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = GetCalibrationRequest()

        if "first_channel" in kwargs:
            unused_args.remove("first_channel")
            _message.first_channel = kwargs['first_channel']
        else:
            raise ArgumentError("get_calibration requires a 'first_channel' argument")

        if "last_channel" in kwargs:
            unused_args.remove("last_channel")
            _message.last_channel = kwargs['last_channel']
        else:
            raise ArgumentError("get_calibration requires a 'last_channel' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_calibration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_calibration,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def set_temperature(self, _message=None, _timeout=None, **kwargs):
        """Set the target primary device temperature

        If the device is not temperature-controllable (see the fields
        `device.GetDeviceInfoResponse.can_set_temperature` and
        `minion_device.MinionDeviceSettings.enable_temperature_control`) then this call will have
        no effect

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.device_pb2.SetTemperatureRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            temperature (float, optional): The desired temperature in degrees Celsius.

                If temperature control is supported and enabled, the device will attempt to keep its
                primary temperature at this value. The reading used as the "primary" temperature depends
                on the device:
                - For MinIONs, the primary temperature is the heatsink temperature
                - For PromethIONs, the primary temperature is the flow cell temperature

                (If temperature control is not supported or is not enabled, the call to `set_temperature`
                will fail with `FAILED_PRECONDITION`)
            wait_for_temperature (minknow_api.device_pb2.SetTemperatureRequest.WaitForTemperatureSettings, optional): Settings which can be specified in order to wait for the temperature to be reached.

                If this is not set at all, no waiting will be done. If it is set (even to an empty
                WaitForTemperatureSettings object), the call will not return until either:
                - The target temperature was reached, or
                - The timeout was reached, or
                - The secondary temperature limits were exceeded

                If `wait_for_temperature` is supplied then, on MinIONs and GridIONs, the ASIC power will be
                enabled if it was not already. See `acquisition.StopRequest.keep_power_on` for more details
                about the implications of this.

                Since 1.15
            secondary_temperature_limits (minknow_api.device_pb2.SetTemperatureRequest.SecondaryTemperatureLimits, optional): Specify "secondary" temperature limits

                This field allows limits to be placed on the "secondary" temperature, while waiting for
                the primary temperature to reach its target value (as specified in the `temperature` field,
                above).

                The meaning of the "secondary" temperature depends on the device in question:
                - For MinIONs, this is the ASIC temperature (i.e. flow cell or flow cell adapter
                  temperature)
                - For PromethIONs, this is the "chamber" temperature (which is derived from the measurements
                  of the ASIC temperature)

                These limits are intended to act as a safeguard against the case where the flow cell does
                not have good thermal contact with temperature control hardware (e.g. if the flow cell was
                not fully seated when it was inserted into the device). In such cases, the flow cell
                temperature may rise high enough to damage the flow cell; these limits may be used to
                mitigate the risk of the flow cell temperature rising high enough to cause damage to the
                flow cell.

                If the secondary temperature exceeds the specified limits while waiting for the target
                temperature to be reached, then all temperature control settings are reset to the values
                they had prior to the call to `set_temperature()` being made.

                NB - These limits apply ONLY when waiting for the target temperature to be reached; once the
                call to `set_temperature()` returns, these limits are no longer checked.

                Since 5.5

        Returns:
            minknow_api.device_pb2.SetTemperatureResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_temperature,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = SetTemperatureRequest()

        if "temperature" in kwargs:
            unused_args.remove("temperature")
            _message.temperature = kwargs['temperature']

        if "wait_for_temperature" in kwargs:
            unused_args.remove("wait_for_temperature")
            _message.wait_for_temperature.CopyFrom(kwargs['wait_for_temperature'])

        if "secondary_temperature_limits" in kwargs:
            unused_args.remove("secondary_temperature_limits")
            _message.secondary_temperature_limits.CopyFrom(kwargs['secondary_temperature_limits'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_temperature: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_temperature,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def get_temperature(self, _message=None, _timeout=None, **kwargs):
        """Get the current temperature of the device.

        Since 1.11

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.GetTemperatureRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.GetTemperatureResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_temperature,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = GetTemperatureRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_temperature: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_temperature,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def stream_temperature(self, _message=None, _timeout=None, **kwargs):
        """Stream the current temperature of the device.

        Since 4.3

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.StreamTemperatureRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            period_seconds (int, optional): How often temperature updates should be sent
                Defaults to a period of 1 second, if not specified, or set to 0

        Returns:
            iter of minknow_api.device_pb2.GetTemperatureResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_temperature,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = StreamTemperatureRequest()

        if "period_seconds" in kwargs:
            unused_args.remove("period_seconds")
            _message.period_seconds = kwargs['period_seconds']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_temperature: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_temperature,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def unblock(self, _message=None, _timeout=None, **kwargs):
        """Triggers an unblock for a list of channels for a given duration (Please see UnblockRequest).
        It will start an unblock for every channel received as a parameter, then this RPC returns.
        After the timeout expires (the duration in seconds given in the request), the return from
        unblock is automatically triggered, which resets the channel configuration (mux) to the
        value preceding the unblock.

        Notes!!

        During the unblock the user should NOT do any mux changes, as the unblock will be interrupted.
        On Promethion this would be even more complicated, as an unblock would normally restore
        hardware saturation. If an unblock is interrupted it will not restore the state to the original
        one.

        The user should NOT change the overload mode during an unblock - this will confuse the return from
        unblock, which tries to reset the overload mode to the state preceding the unblock.

        The unblock can fail if the channel is not in a valid well state (this means a channel needs to be
        in one of pore1-4, not test current, regen pore or unblock). If a mux is not valid, the unblock grpc
        will try to continue for the rest of the channels, ignoring the one with the wrong mux.

        

        Args:
            _message (minknow_api.device_pb2.UnblockRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            channels (int, optional): List of channels indexed from 1.
            duration_in_seconds (int, optional): 
            duration_in_milliseconds (int, optional): 

        Returns:
            minknow_api.device_pb2.UnblockResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.unblock,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        # check oneof group 'duration'
        oneof_fields = set([
            "duration_in_seconds",
            "duration_in_milliseconds",
        ])

        if len(unused_args & oneof_fields) > 1:
            raise ArgumentError("unblock given multiple conflicting arguments: '{}'".format(", ".join(unused_args & oneof_fields)))

        _message = UnblockRequest()

        if "channels" in kwargs:
            unused_args.remove("channels")
            _message.channels.extend(kwargs['channels'])

        if "duration_in_seconds" in kwargs:
            unused_args.remove("duration_in_seconds")
            _message.duration_in_seconds = kwargs['duration_in_seconds']

        if "duration_in_milliseconds" in kwargs:
            unused_args.remove("duration_in_milliseconds")
            _message.duration_in_milliseconds = kwargs['duration_in_milliseconds']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to unblock: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.unblock,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def cancel_unblocks(self, _message=None, _timeout=None, **kwargs):
        """Cancel in progress unblocks.

        Any unblocks registered with `device.unblock` will be stopped before this command returns.
        Unblocks are stopped by applying any actions required to return from unblock (mux changes, or hardware configuration).

        Since 1.15

        

        Args:
            _message (minknow_api.device_pb2.CancelUnblocksRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.CancelUnblocksResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.cancel_unblocks,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = CancelUnblocksRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to cancel_unblocks: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.cancel_unblocks,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def get_channel_configuration(self, _message=None, _timeout=None, **kwargs):
        """Get the channel configuration for any number of channels

        The maximum addressable channel will depend on the device. Currently this will be 512 on a MinION/GridION
        and 3000 on a PromethION

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.GetChannelConfigurationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            channels (int, optional): A list of channel names (1-indexed) to specify what channels to get channel configs for

                Will return an error if any of the channel names are below 1, or above the channel count value
                returned from :meth:`get_flow_cell_info`

        Returns:
            minknow_api.device_pb2.GetChannelConfigurationResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_channel_configuration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = GetChannelConfigurationRequest()

        if "channels" in kwargs:
            unused_args.remove("channels")
            _message.channels.extend(kwargs['channels'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_channel_configuration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_channel_configuration,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def set_channel_configuration(self, _message=None, _timeout=None, **kwargs):
        """Set the channel configuration for any number of channels

        The maximum addressable channel will depend on the device. Currently this will be 512 on a MinION/GridION
        and 3000 on a PromethION.

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.device_pb2.SetChannelConfigurationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            channel_configurations (minknow_api.device_pb2.SetChannelConfigurationRequest.ChannelConfigurationsEntry, optional): A map between <channel name, config to set>

                Will return an error if any of the key values (representing channel names) are below 1, or
                above the channel count value returned from :meth:`get_flow_cell_info`

                The selected well cannot be set to WELL_OTHER, and will error if it tries to do so

                DEPRECATED: Note that the type to set may change from 4.0 to enforce the fact that
                unblock cannot be set through this call

        Returns:
            minknow_api.device_pb2.SetChannelConfigurationResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_channel_configuration,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = SetChannelConfigurationRequest()

        if "channel_configurations" in kwargs:
            unused_args.remove("channel_configurations")
            for key, value in kwargs['channel_configurations'].items():
                _message.channel_configurations[key].CopyFrom(value)

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_channel_configuration: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_channel_configuration,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def set_channel_configuration_all(self, _message=None, _timeout=None, **kwargs):
        """

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.device_pb2.SetChannelConfigurationAllRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            well (int, optional): The currently-connected well.

                Wells are counted from 1. 0 indicates that no well is connected. 5 indicates some non-generic configuration
                such as ground for a minion or connecting all wells on promethion

                Note that MinKNOW can return channel configurations where the well number is larger than the
                ``max_well_count`` value returned by :meth:`DeviceService.get_device_info`. This indicates
                that some other connection has been made (for example, PromethIONs can simultaneously
                connect all wells, and MinIONs can connect to ground).
            test_current (bool, optional): Whether the test current is connected to the integrator (measurement circuit).

                The signal will be a steady test current produced on the device. This can be used for
                calibration or to test the device integration circuits.

        Returns:
            minknow_api.device_pb2.SetChannelConfigurationAllResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_channel_configuration_all,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = SetChannelConfigurationAllRequest()

        if "well" in kwargs:
            unused_args.remove("well")
            _message.channel_configuration.well = kwargs['well']

        if "test_current" in kwargs:
            unused_args.remove("test_current")
            _message.channel_configuration.test_current = kwargs['test_current']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_channel_configuration_all: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_channel_configuration_all,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def set_saturation_config(self, _message=None, _timeout=None, **kwargs):
        """Set the saturation control configuration.

        The request is immediately sent to the data acquisition module, and applied. All settings can be changed
        whilst the experiment is running.

        If any keys are not specified when this method is called (see the message for specific optional parameters),
        the previously applied parameters are kept; initially, when this method has never been called, defaults from the
        application config are used.

        note: calling this method resets anu in-progress saturations when it is called, causing them to need to start
        saturation counts again, this may mean any saturations may take longer to occur.

        

        Args:
            _message (minknow_api.device_pb2.SetSaturationConfigRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            thresholds (minknow_api.device_pb2.SaturationConfig.Thresholds, optional): Settings for saturation count thresholds, this controls how long a
                saturated value must be over limit before the channel is turned off.

                If not specified, the previous thresholds are kept.
            software_saturation (minknow_api.device_pb2.SaturationConfig.SoftwareSaturation, optional): Settings for software saturation, specified in adc units of the device.

                If not specified, the previous thresholds are kept.
            user_threshold_saturation (minknow_api.device_pb2.SaturationConfig.UserThresholdSaturation, optional): Settings for user threshold saturation, specified in pA.

                If not specified, the previous thresholds are kept.

        Returns:
            minknow_api.device_pb2.SetSaturationConfigResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_saturation_config,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = SetSaturationConfigRequest()

        if "thresholds" in kwargs:
            unused_args.remove("thresholds")
            _message.settings.thresholds.CopyFrom(kwargs['thresholds'])

        if "software_saturation" in kwargs:
            unused_args.remove("software_saturation")
            _message.settings.software_saturation.CopyFrom(kwargs['software_saturation'])

        if "user_threshold_saturation" in kwargs:
            unused_args.remove("user_threshold_saturation")
            _message.settings.user_threshold_saturation.CopyFrom(kwargs['user_threshold_saturation'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_saturation_config: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_saturation_config,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def get_saturation_config(self, _message=None, _timeout=None, **kwargs):
        """Get the saturation control configuration.

        The default configuration is specified by the MinKNOW application configuration, the command returns the most
        recently applied saturation config.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.GetSaturationConfigRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.GetSaturationConfigResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_saturation_config,
                                  _message, _timeout,
                                  ['settings'],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = GetSaturationConfigRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_saturation_config: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_saturation_config,
                              _message, _timeout,
                              ['settings'],
                              "minknow_api.device.DeviceService")
    def get_sample_rate(self, _message=None, _timeout=None, **kwargs):
        """Get the sample rate of the device

        Please refer to MinionDeviceService and PromethionDeviceService for the expected
        return value for a minion and promethion respectively

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.GetSampleRateRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.GetSampleRateResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_sample_rate,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = GetSampleRateRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_sample_rate: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_sample_rate,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def set_sample_rate(self, _message=None, _timeout=None, **kwargs):
        """Set the sample rate of the device, and returns the actual value set on the device

        Please refer to MinionDeviceService and PromethionDeviceService to see
        how the value set here will be used to determine the real sample rate for a
        minion and promethion respectively

        Trying to set the sample rate during an acquisition period will result in an error

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.device_pb2.SetSampleRateRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            sample_rate (int): 

        Returns:
            minknow_api.device_pb2.SetSampleRateResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_sample_rate,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = SetSampleRateRequest()

        if "sample_rate" in kwargs:
            unused_args.remove("sample_rate")
            _message.sample_rate = kwargs['sample_rate']
        else:
            raise ArgumentError("set_sample_rate requires a 'sample_rate' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_sample_rate: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_sample_rate,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def get_bias_voltage(self, _message=None, _timeout=None, **kwargs):
        """

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.device_pb2.GetBiasVoltageRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.GetBiasVoltageResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_bias_voltage,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = GetBiasVoltageRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_bias_voltage: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_bias_voltage,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def set_bias_voltage(self, _message=None, _timeout=None, **kwargs):
        """

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.device_pb2.SetBiasVoltageRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            bias_voltage (float): 

        Returns:
            minknow_api.device_pb2.SetBiasVoltageResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_bias_voltage,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = SetBiasVoltageRequest()

        if "bias_voltage" in kwargs:
            unused_args.remove("bias_voltage")
            _message.bias_voltage = kwargs['bias_voltage']
        else:
            raise ArgumentError("set_bias_voltage requires a 'bias_voltage' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_bias_voltage: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_bias_voltage,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def dump_state(self, _message=None, _timeout=None, **kwargs):
        """Trigger a device specific dump of device-state control-server log. The
        information will appear in a "diagnostic_information" message

        Since 5.0

        

        Args:
            _message (minknow_api.device_pb2.DumpStateRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.DumpStateResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.dump_state,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = DumpStateRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to dump_state: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.dump_state,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def increment_flow_cell_use_count(self, _message=None, _timeout=None, **kwargs):
        """Increment use count so that it is possible to track the amount of times a flow cell has been used

        This has a hard limit of 255, and an error will occur if an overflow is detected.

        Since 5.6

        

        Args:
            _message (minknow_api.device_pb2.IncrementFlowCellUseCountRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.device_pb2.IncrementFlowCellUseCountResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.increment_flow_cell_use_count,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = IncrementFlowCellUseCountRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to increment_flow_cell_use_count: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.increment_flow_cell_use_count,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def set_flow_cell_barcode_kit(self, _message=None, _timeout=None, **kwargs):
        """Specify the barcode kit that has been used with the flow cell

        Once this has been set it cannot be modified. It is also not possible to register the
        barcodes that have been used until this has been set.

        Since 5.6

        

        Args:
            _message (minknow_api.device_pb2.SetFlowCellBarcodeKitRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            id (str): The Barcode Kit ID can be up to 8 characters long

        Returns:
            minknow_api.device_pb2.SetFlowCellBarcodeKitResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_flow_cell_barcode_kit,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = SetFlowCellBarcodeKitRequest()

        if "id" in kwargs:
            unused_args.remove("id")
            _message.id = kwargs['id']
        else:
            raise ArgumentError("set_flow_cell_barcode_kit requires a 'id' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_flow_cell_barcode_kit: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_flow_cell_barcode_kit,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
    def register_flow_cell_barcodes(self, _message=None, _timeout=None, **kwargs):
        """Register that a distinct barcode has been used with the flow-cell

        Barcodes cannot be cleared once registered. A Barcode Kit must also be set using set_flow_cell_barcode_kit()

        Since 5.6

        

        Args:
            _message (minknow_api.device_pb2.RegisterFlowCellBarcodesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            barcodes (int, optional): List of unique barcodes that have been used with the flow-cell
                Where a barcode is represented by an index in the range of 1 to 384 only.

        Returns:
            minknow_api.device_pb2.RegisterFlowCellBarcodesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.register_flow_cell_barcodes,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.device.DeviceService")

        unused_args = set(kwargs.keys())

        _message = RegisterFlowCellBarcodesRequest()

        if "barcodes" in kwargs:
            unused_args.remove("barcodes")
            _message.barcodes.extend(kwargs['barcodes'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to register_flow_cell_barcodes: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.register_flow_cell_barcodes,
                              _message, _timeout,
                              [],
                              "minknow_api.device.DeviceService")
