### THIS FILE IS AUTOGENERATED. DO NOT EDIT THIS FILE DIRECTLY ###
import minknow_api
from minknow_api.pebble_device_pb2_grpc import *
import minknow_api.pebble_device_pb2 as pebble_device_pb2
from minknow_api.pebble_device_pb2 import *
from minknow_api._support import MessageWrapper, ArgumentError
import time
import logging
import sys

__all__ = [
    "PebbleDeviceService",
    "WaveformSettings",
    "TimingEnginePeriods",
    "OverloadProtectionConfig",
    "DeviceSettings",
    "ChangeDeviceSettingsRequest",
    "ChangeDeviceSettingsResponse",
    "GetDeviceSettingsRequest",
    "GetDeviceSettingsResponse",
    "ChannelSettings",
    "ChangeChannelSettingsRequest",
    "ChangeChannelSettingsResponse",
    "GetChannelSettingsRequest",
    "GetChannelSettingsResponse",
    "ResearchOnlySettings",
    "ChangeResearchOnlySettingsRequest",
    "ChangeResearchOnlySettingsResponse",
]

def run_with_retry(method, message, timeout, unwraps, full_name):
    retry_count = 20
    error = None
    for i in range(retry_count):
        try:
            result = MessageWrapper(method(message, timeout=timeout), unwraps=unwraps)
            return result
        except grpc.RpcError as e:
            # Retrying unidentified grpc errors to keep clients from crashing
            retryable_error = (e.code() == grpc.StatusCode.UNKNOWN and "Stream removed" in e.details() or \
                                (e.code() == grpc.StatusCode.INTERNAL and "RST_STREAM" in e.details()))
            if retryable_error:
                logging.info('Bypassed ({}: {}) error for grpc: {}. Attempt {}.'.format(e.code(), e.details(), full_name, i))
            else:
                raise
            error = e
        time.sleep(1)
    raise error


class PebbleDeviceService(object):
    """Interface to control Pebble devices.
    This service should be treated as experimental and subject to change"""
    def __init__(self, channel):
        self._stub = PebbleDeviceServiceStub(channel)
        self._pb = pebble_device_pb2
    def change_device_settings(self, _message=None, _timeout=None, **kwargs):
        """Change the settings which apply to the whole device.

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.pebble_device_pb2.ChangeDeviceSettingsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            sample_rate (google.protobuf.wrappers_pb2.Int32Value, optional): The number of measurements to take each second.

                Possible values are between 1000, and 5000.
                If the value is outside of this range, it will be clamped within it

                FAILED_PRECONDITION will be returned if attempting to change during acquisition
            temperature_target (google.protobuf.wrappers_pb2.FloatValue, optional): If the device is capable (see device.get_device_info().temperature_controllable)
                then this sets the target temperature to keep the flow-cell at.

                This value must be between the limits specified in the application config,
                see: min_user_setpoint_temperature_celsius and max_user_setpoint_temperature_celsius
                INVALID_ARGUMENT will be returned if outside these limits
            reference_voltage (google.protobuf.wrappers_pb2.Int32Value, optional): The reference voltage Vref

                This value must be within the range of [700..1100](mV) and will be rounded down
                to the nearest 50mV.
                INVALID_ARGUMENT will be returned if outside these limits
            unblock_voltage (google.protobuf.wrappers_pb2.Int32Value, optional): The unblock voltage to apply when a channel is unblocking.

                The acceptable input range depends on Vref
                The default Vref of 900mV gives the unblock level a range between [-840..900]mV
                INVALID_ARGUMENT will be returned if outside of the limits set depending on Vref
            regen_current_range (minknow_api.pebble_device_pb2.DeviceSettings.RegenCurrentRange, optional): Determines the range of regen current available for selection
                        Range 0.5nA, step 0.1nA
                        Range 0.667nA, step 0.133nA
                        Range 1.0nA, step 0.2nA (DEFAULT)
                        Range 2.0nA, step 0.4nA
                INVALID_ARGUMENT will be returned if range option does not exist
            regen_current (google.protobuf.wrappers_pb2.Int32Value, optional): Control the regeneration current used when regenerating well's.

                The acceptable value is in pico Amps and depends on the specified
                regen_current_range option. Will round down to nearest acceptable
                step in value within the range.
                INVALID_ARGUMENT will be returned if outside the acceptable range
            regen_current_voltage_clamp (google.protobuf.wrappers_pb2.UInt32Value, optional): Voltage clamp for regeneration circuit (in millivolts)

                The voltage in the regeneration circuit is clamped under this value,
                whilst applying the current specified in each quads settings.

                This is a +/- voltage relative to Vref
                The polarity is determined by the regen current
                With a default Vref of 900mV this gives the regen level a range of [0..840]mV
                INVALID_ARGUMENT will be returned if outside the acceptable range
            bias_voltage (google.protobuf.wrappers_pb2.DoubleValue, optional): The value to apply as the bias voltage (in millivolts)

                Valid values are in the range [-Vref..Vref]mv
                INVALID_ARGUMENT will be returned if outside this range
            bias_voltage_waveform (minknow_api.pebble_device_pb2.WaveformSettings, optional): The wavetable settings
            int_capacitor (google.protobuf.wrappers_pb2.Int32Value, optional): Integration capacitor used for controlling the Gain
                This size of the capacitance used is based on the provided setting
                with a value of [0..31]

                Refer to §2.3.1 of the OG2 ASIC documentation for both the nominal
                and measured capacitance that each setting produces.

                This value is applied globally to all QUADs and therefore all channels

                INVALID_ARGUMENT will be returned if outside the range of [0..31]
            lpf_time_constant (minknow_api.pebble_device_pb2.DeviceSettings.LowPassFilterValue, optional): Low pass filter time constant
                This modifies the anti-alias resistor to produce a specific time constant
                for the low pass filter.
            timings (minknow_api.pebble_device_pb2.TimingEnginePeriods, optional): If specified, the device will adopt these timings to set how
                long is spent at various stages of the sampling process.
                The message includes a way of returning to default timings.

                FAILED_PRECONDITION will be returned if attempting to change during acquisition
            power_save_active (google.protobuf.wrappers_pb2.BoolValue, optional): Enable ASIC power save.

                Setting to active will save power, but doing so will allow the ASIC to cool down,
                and it will take time to heat it up again along with performing a device reset.
            overload_protection (minknow_api.pebble_device_pb2.OverloadProtectionConfig, optional): Settings for the hardware based saturation/overload protection (spike suppression)

        Returns:
            minknow_api.pebble_device_pb2.ChangeDeviceSettingsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.change_device_settings,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.pebble_device.PebbleDeviceService")

        unused_args = set(kwargs.keys())

        _message = ChangeDeviceSettingsRequest()

        if "sample_rate" in kwargs:
            unused_args.remove("sample_rate")
            _message.settings.sample_rate.value = kwargs['sample_rate']

        if "temperature_target" in kwargs:
            unused_args.remove("temperature_target")
            _message.settings.temperature_target.value = kwargs['temperature_target']

        if "reference_voltage" in kwargs:
            unused_args.remove("reference_voltage")
            _message.settings.reference_voltage.value = kwargs['reference_voltage']

        if "unblock_voltage" in kwargs:
            unused_args.remove("unblock_voltage")
            _message.settings.unblock_voltage.value = kwargs['unblock_voltage']

        if "regen_current_range" in kwargs:
            unused_args.remove("regen_current_range")
            _message.settings.regen_current_range = kwargs['regen_current_range']

        if "regen_current" in kwargs:
            unused_args.remove("regen_current")
            _message.settings.regen_current.value = kwargs['regen_current']

        if "regen_current_voltage_clamp" in kwargs:
            unused_args.remove("regen_current_voltage_clamp")
            _message.settings.regen_current_voltage_clamp.value = kwargs['regen_current_voltage_clamp']

        if "bias_voltage" in kwargs:
            unused_args.remove("bias_voltage")
            _message.settings.bias_voltage.value = kwargs['bias_voltage']

        if "bias_voltage_waveform" in kwargs:
            unused_args.remove("bias_voltage_waveform")
            _message.settings.bias_voltage_waveform.CopyFrom(kwargs['bias_voltage_waveform'])

        if "int_capacitor" in kwargs:
            unused_args.remove("int_capacitor")
            _message.settings.int_capacitor.value = kwargs['int_capacitor']

        if "lpf_time_constant" in kwargs:
            unused_args.remove("lpf_time_constant")
            _message.settings.lpf_time_constant = kwargs['lpf_time_constant']

        if "timings" in kwargs:
            unused_args.remove("timings")
            _message.settings.timings.CopyFrom(kwargs['timings'])

        if "power_save_active" in kwargs:
            unused_args.remove("power_save_active")
            _message.settings.power_save_active.value = kwargs['power_save_active']

        if "overload_protection" in kwargs:
            unused_args.remove("overload_protection")
            _message.settings.overload_protection.CopyFrom(kwargs['overload_protection'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to change_device_settings: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.change_device_settings,
                              _message, _timeout,
                              [],
                              "minknow_api.pebble_device.PebbleDeviceService")
    def get_device_settings(self, _message=None, _timeout=None, **kwargs):
        """Get the current settings which apply to the whole device.

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.pebble_device_pb2.GetDeviceSettingsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.pebble_device_pb2.GetDeviceSettingsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_device_settings,
                                  _message, _timeout,
                                  ['settings'],
                                  "minknow_api.pebble_device.PebbleDeviceService")

        unused_args = set(kwargs.keys())

        _message = GetDeviceSettingsRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_device_settings: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_device_settings,
                              _message, _timeout,
                              ['settings'],
                              "minknow_api.pebble_device.PebbleDeviceService")
    def change_channel_settings(self, _message=None, _timeout=None, **kwargs):
        """Change the settings which apply to the referenced channels.

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.pebble_device_pb2.ChangeChannelSettingsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            channels (minknow_api.pebble_device_pb2.ChangeChannelSettingsRequest.ChannelsEntry, optional): 1 based map of up to 400 different channel settings
            channel_default (minknow_api.pebble_device_pb2.ChannelSettings, optional): If supplied, contains settings applied to every channel before then
                applying any specific settings in the per channel settings.

        Returns:
            minknow_api.pebble_device_pb2.ChangeChannelSettingsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.change_channel_settings,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.pebble_device.PebbleDeviceService")

        unused_args = set(kwargs.keys())

        _message = ChangeChannelSettingsRequest()

        if "channels" in kwargs:
            unused_args.remove("channels")
            for key, value in kwargs['channels'].items():
                _message.channels[key].CopyFrom(value)

        if "channel_default" in kwargs:
            unused_args.remove("channel_default")
            _message.channel_default.CopyFrom(kwargs['channel_default'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to change_channel_settings: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.change_channel_settings,
                              _message, _timeout,
                              [],
                              "minknow_api.pebble_device.PebbleDeviceService")
    def get_channel_settings(self, _message=None, _timeout=None, **kwargs):
        """Get the channels settings for the requested channel's

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.pebble_device_pb2.GetChannelSettingsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            channels (int): The channels (one based) to return data for.

        Returns:
            minknow_api.pebble_device_pb2.GetChannelSettingsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_channel_settings,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.pebble_device.PebbleDeviceService")

        unused_args = set(kwargs.keys())

        _message = GetChannelSettingsRequest()

        if "channels" in kwargs:
            unused_args.remove("channels")
            _message.channels.extend(kwargs['channels'])
        else:
            raise ArgumentError("get_channel_settings requires a 'channels' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_channel_settings: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_channel_settings,
                              _message, _timeout,
                              [],
                              "minknow_api.pebble_device.PebbleDeviceService")
    def change_research_only_settings(self, _message=None, _timeout=None, **kwargs):
        """Experimental access for research purposes to modify low level settings
        Note: Access will be removed once device integration complete

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Note this API is experimental - it may be changed, revised or removed in future minor versions.

        Args:
            _message (minknow_api.pebble_device_pb2.ChangeResearchOnlySettingsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            asic_writes (minknow_api.pebble_device_pb2.ResearchOnlySettings.AsicRegisterWrite, optional): List of ASIC register writes to append
                Use at own risk as no validation is performed on the address
                or value of the individual writes.

                The number of writes in single request limited to 128
                due to internal MinKNOW limitations
                INVALID_ARGUMENT will be returned if greater than this limit
            instrument_writes (minknow_api.pebble_device_pb2.ResearchOnlySettings.InstrumentRegisterWrite, optional): List of instrument register writes
                Use at own risk as no validation is performed on the address
                or value of the individual writes.

                The number of writes in single request limited to 16
                due to internal MinKNOW limitations
                INVALID_ARGUMENT will be returned if greater than this limit

        Returns:
            minknow_api.pebble_device_pb2.ChangeResearchOnlySettingsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        print("Warning: Method PebbleDeviceService.change_research_only_settings is experimental and may be changed, revised or removed in future minor versions.", file=sys.stderr)
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.change_research_only_settings,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.pebble_device.PebbleDeviceService")

        unused_args = set(kwargs.keys())

        _message = ChangeResearchOnlySettingsRequest()

        if "asic_writes" in kwargs:
            unused_args.remove("asic_writes")
            _message.settings.asic_writes.extend(kwargs['asic_writes'])

        if "instrument_writes" in kwargs:
            unused_args.remove("instrument_writes")
            _message.settings.instrument_writes.extend(kwargs['instrument_writes'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to change_research_only_settings: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.change_research_only_settings,
                              _message, _timeout,
                              [],
                              "minknow_api.pebble_device.PebbleDeviceService")
