### THIS FILE IS AUTOGENERATED. DO NOT EDIT THIS FILE DIRECTLY ###
import minknow_api
from minknow_api.protocol_pb2_grpc import *
import minknow_api.protocol_pb2 as protocol_pb2
from minknow_api.protocol_pb2 import *
from minknow_api._support import MessageWrapper, ArgumentError
import time
import logging
import sys

__all__ = [
    "ProtocolService",
    "BarcodeUserData",
    "KitInfo",
    "ProtocolRunUserInfo",
    "OffloadLocationInfo",
    "StartProtocolRequest",
    "StartProtocolResponse",
    "StopProtocolRequest",
    "StopProtocolResponse",
    "PauseProtocolRequest",
    "PauseProtocolResponse",
    "ResumeProtocolRequest",
    "ResumeProtocolResponse",
    "TriggerMuxScanRequest",
    "TriggerMuxScanResponse",
    "ListProtocolsRequest",
    "ProtocolInfo",
    "ListProtocolsResponse",
    "WaitForFinishedRequest",
    "GetRunInfoRequest",
    "RequestOrigin",
    "ProtocolPhaseSnapshot",
    "Epi2meWorkflowReference",
    "AssociatedPostProcessingAnalysis",
    "PlatformQcResult",
    "HardwareCheckTemperatureResults",
    "HardwareCheckCalibrationResults",
    "HardwareCheckResult",
    "ExternalOffload",
    "GetVersionInfoResponse",
    "AnalysisWorkflowInfo",
    "ProtocolRunInfo",
    "FilteringInfo",
    "ListProtocolRunsRequest",
    "ListProtocolRunsResponse",
    "GetCurrentProtocolRunRequest",
    "GetCurrentProtocolRunResponse",
    "WatchCurrentProtocolRunRequest",
    "GetContextInfoRequest",
    "GetContextInfoResponse",
    "SetContextInfoRequest",
    "SetContextInfoResponse",
    "GetProtocolPurposeRequest",
    "GetProtocolPurposeResponse",
    "SetProtocolPurposeRequest",
    "SetProtocolPurposeResponse",
    "AddEpi2meWorkflowRequest",
    "AddEpi2meWorkflowResponse",
    "ProtocolGroupIdInfo",
    "ListProtocolGroupIdsRequest",
    "ListProtocolGroupIdsResponse",
    "BeginHardwareCheckRequest",
    "BeginHardwareCheckResponse",
    "BeginPlatformQcRequest",
    "BeginPlatformQcResponse",
    "BeginProtocolRequest",
    "BeginProtocolResponse",
    "SetPlatformQcResultRequest",
    "SetPlatformQcResultResponse",
    "SetHardwareCheckResultRequest",
    "SetHardwareCheckResultResponse",
    "AssociatePostProcessingAnalysisRequest",
    "AssociatePostProcessingAnalysisResponse",
    "ClearProtocolHistoryDataRequest",
    "ClearProtocolHistoryDataResponse",
    "ProtocolPhaseManagementRequest",
    "ProtocolPhaseManagementResponse",
    "GenerateRunReportRequest",
    "GenerateRunReportResponse",
    "ProtocolState",
    "PROTOCOL_RUNNING",
    "PROTOCOL_WAITING_FOR_TEMPERATURE",
    "PROTOCOL_WAITING_FOR_ACQUISITION",
    "PROTOCOL_COMPLETED",
    "PROTOCOL_STOPPED_BY_USER",
    "PROTOCOL_FINISHED_WITH_ERROR",
    "PROTOCOL_FINISHED_WITH_DEVICE_ERROR",
    "PROTOCOL_FINISHED_UNABLE_TO_SEND_TELEMETRY",
    "PROTOCOL_FINISHED_WITH_FLOW_CELL_DISCONNECT",
    "PROTOCOL_FINISHED_WITH_DEVICE_DISCONNECT",
    "PROTOCOL_FINISHED_WITH_ERROR_CALIBRATION",
    "PROTOCOL_FINISHED_WITH_ERROR_BASECALL_SETTINGS",
    "PROTOCOL_FINISHED_WITH_ERROR_TEMPERATURE_REQUIRED",
    "PROTOCOL_FINISHED_WITH_ERROR_NO_DISK_SPACE",
    "PROTOCOL_FINISHED_WITH_ERROR_TEMPERATURE_HIGH",
    "PROTOCOL_FINISHED_WITH_ERROR_BASECALLER_COMMUNICATION",
    "PROTOCOL_FINISHED_WITH_NO_FLOWCELL_FOR_ACQUISITION",
    "PROTOCOL_FINISHED_WITH_ERROR_BASECALLER_UNAVAILABLE",
    "ProtocolPhase",
    "PHASE_UNKNOWN",
    "PHASE_INITIALISING",
    "PHASE_SEQUENCING",
    "PHASE_PREPARING_FOR_MUX_SCAN",
    "PHASE_MUX_SCAN",
    "PHASE_PAUSED",
    "PHASE_PAUSING",
    "PHASE_BAD_TEMPERATURE_AUTOMATIC_PAUSE",
    "PHASE_FLOWCELL_DISCONNECT_AUTOMATIC_PAUSE",
    "PHASE_FLOWCELL_MISMATCH_AUTOMATIC_PAUSE",
    "PHASE_DEVICE_ERROR_AUTOMATIC_PAUSE",
    "PHASE_LOW_DISK_SPACE_AUTOMATIC_PAUSE",
    "PHASE_RESUMING",
    "PHASE_COMPLETED",
    "Action",
    "ACTION_NONE",
    "ACTION_PAUSE",
    "ACTION_RESUME",
    "ACTION_TRIGGER_MUX_SCAN",
]

def run_with_retry(method, message, timeout, unwraps, full_name):
    retry_count = 20
    error = None
    for i in range(retry_count):
        try:
            result = MessageWrapper(method(message, timeout=timeout), unwraps=unwraps)
            return result
        except grpc.RpcError as e:
            # Retrying unidentified grpc errors to keep clients from crashing
            retryable_error = (e.code() == grpc.StatusCode.UNKNOWN and "Stream removed" in e.details() or \
                                (e.code() == grpc.StatusCode.INTERNAL and "RST_STREAM" in e.details()))
            if retryable_error:
                logging.info('Bypassed ({}: {}) error for grpc: {}. Attempt {}.'.format(e.code(), e.details(), full_name, i))
            else:
                raise
            error = e
        time.sleep(1)
    raise error


class ProtocolService(object):
    def __init__(self, channel):
        self._stub = ProtocolServiceStub(channel)
        self._pb = protocol_pb2
    def start_protocol(self, _message=None, _timeout=None, **kwargs):
        """Initiates a python instance that runs the script specified by the `path` argument.
        `list_protocols` will give back a list of protocol scripts that can be started by this call

        

        Args:
            _message (minknow_api.protocol_pb2.StartProtocolRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            identifier (str): The identifier of the protocol, as provided by list_protocols().
            args (str, optional): The arguments to pass to the protocol.
            user_info (minknow_api.protocol_pb2.ProtocolRunUserInfo, optional): User input describing the protocol.
            offload_location_info (minknow_api.protocol_pb2.OffloadLocationInfo, optional): Information about data offload locations to use to store data

                Since 5.0.
            target_run_until_criteria (minknow_api.acquisition_pb2.TargetRunUntilCriteria, optional): Initial Target Run-Until Criteria to use when starting an acquisition for this protocol.
                These can be updated during the acquisition using the Run-Until API.

                Since 5.3
            analysis_workflow_request (minknow_api.analysis_workflows_pb2.AnalysisWorkflowRequest, optional): Workflow request that should be started when the protocol is started

        Returns:
            minknow_api.protocol_pb2.StartProtocolResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.start_protocol,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = StartProtocolRequest()

        if "identifier" in kwargs:
            unused_args.remove("identifier")
            _message.identifier = kwargs['identifier']
        else:
            raise ArgumentError("start_protocol requires a 'identifier' argument")

        if "args" in kwargs:
            unused_args.remove("args")
            _message.args.extend(kwargs['args'])

        if "user_info" in kwargs:
            unused_args.remove("user_info")
            _message.user_info.CopyFrom(kwargs['user_info'])

        if "offload_location_info" in kwargs:
            unused_args.remove("offload_location_info")
            _message.offload_location_info.CopyFrom(kwargs['offload_location_info'])

        if "target_run_until_criteria" in kwargs:
            unused_args.remove("target_run_until_criteria")
            _message.target_run_until_criteria.CopyFrom(kwargs['target_run_until_criteria'])

        if "analysis_workflow_request" in kwargs:
            unused_args.remove("analysis_workflow_request")
            _message.analysis_workflow_request.CopyFrom(kwargs['analysis_workflow_request'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to start_protocol: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.start_protocol,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def stop_protocol(self, _message=None, _timeout=None, **kwargs):
        """Stop a running protocol

         If `protocol_run_id` is supplied, stops that protocol if it is currently running.
         Otherwise, if no `protocol_run_id` is supplied, stops the protocol that is currently in
         progress.

         The call will fail with `INVALID_ARGUMENT` if:
        	- An invalid `protocol_run_id` is supplied (i.e. one which does not exist on the current
            position)

         The call will fail with `FAILED_PRECONDITION` if:
        	- There is no protocol in progress
        	- A valid `protocol_run_id` is supplied that does not match the `protocol_run_id` of the
            protocol in progress.

        

        Args:
            _message (minknow_api.protocol_pb2.StopProtocolRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            protocol_run_id (str, optional): The protocol run id of the protocol to stop

                If empty, stops the currently running protocol (if any)
                Otherwise, stops the specified protocol if it is currently in progress

                Since 6.4
            data_action_on_stop (minknow_api.acquisition_pb2.StopRequest.DataAction, optional): Specify how any running acquisition should
                be handled when stopping the protocol.

                Protocol state will enter PROTOCOL_WAITING_FOR_ACQUISITION whilst any running
                acquisition is finished.

                If a script ends on its own any analysis that was started is stopped, and it
                is allowed to catchup. If the caller wants to end catchup they can call stop_protocol
                to end catchup.

                Since 1.15

        Returns:
            minknow_api.protocol_pb2.StopProtocolResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stop_protocol,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = StopProtocolRequest()

        if "protocol_run_id" in kwargs:
            unused_args.remove("protocol_run_id")
            _message.protocol_run_id = kwargs['protocol_run_id']

        if "data_action_on_stop" in kwargs:
            unused_args.remove("data_action_on_stop")
            _message.data_action_on_stop = kwargs['data_action_on_stop']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stop_protocol: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stop_protocol,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def pause_protocol(self, _message=None, _timeout=None, **kwargs):
        """Request the protocol to pause.

         This will return an error unless the ProtocolRunInfo has the `can_pause` field set to true.
         It will have no effect if the protocol is already paused or pausing.

         If `protocol_run_id` is supplied, pauses that protocol if it is currently running.
         Otherwise, if no `protocol_run_id` is supplied, pauses the protocol that is currently in
         progress.

         The call will fail with `INVALID_ARGUMENT` if:
        	- An invalid `protocol_run_id` is supplied (i.e. one which does not exist on the current
            position)

         The call will fail with `FAILED_PRECONDITION` if:
        	- There is no protocol in progress
        	- A valid `protocol_run_id` is supplied that does not match the `protocol_run_id` of the
            protocol in progress.

         Since 4.4.

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.protocol_pb2.PauseProtocolRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            protocol_run_id (str, optional): The protocol run id of the protocol to pause

                If empty, pause the currently running protocol (if any)
                Otherwise, pauses the specified protocol if it is currently in progress

                Since 6.4

        Returns:
            minknow_api.protocol_pb2.PauseProtocolResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.pause_protocol,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = PauseProtocolRequest()

        if "protocol_run_id" in kwargs:
            unused_args.remove("protocol_run_id")
            _message.protocol_run_id = kwargs['protocol_run_id']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to pause_protocol: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.pause_protocol,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def resume_protocol(self, _message=None, _timeout=None, **kwargs):
        """Request the protocol to resume.

         This will return an error unless the ProtocolRunInfo has the `can_pause` field set to true.
         It will have no effect if the protocol is not paused or pausing.

         If `protocol_run_id` is supplied, resumes that protocol if it is currently running.
         Otherwise, if no `protocol_run_id` is supplied, resumes the protocol that is currently in
         progress.

         The call will fail with `INVALID_ARGUMENT` if:
        	- An invalid `protocol_run_id` is supplied (i.e. one which does not exist on the current
            position)

         The call will fail with `FAILED_PRECONDITION` if:
        	- There is no protocol in progress
        	- A valid `protocol_run_id` is supplied that does not match the `protocol_run_id` of the
            protocol in progress.

         Since 4.4.

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.protocol_pb2.ResumeProtocolRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            protocol_run_id (str, optional): The protocol run id of the protocol to resume

                If empty, resumes the currently running protocol (if any)
                Otherwise, resumes the specified protocol if it is currently in progress

                Since 6.4

        Returns:
            minknow_api.protocol_pb2.ResumeProtocolResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.resume_protocol,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = ResumeProtocolRequest()

        if "protocol_run_id" in kwargs:
            unused_args.remove("protocol_run_id")
            _message.protocol_run_id = kwargs['protocol_run_id']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to resume_protocol: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.resume_protocol,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def trigger_mux_scan(self, _message=None, _timeout=None, **kwargs):
        """Request the protocol to perform a mux scan.

        This will return an error unless the ProtocolRunInfo has the `can_trigger_mux_scan` field set
        to true. It will have no effect if the protocol is already running or preparing for a mux
        scan.

        Since 4.4.

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.protocol_pb2.TriggerMuxScanRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.protocol_pb2.TriggerMuxScanResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.trigger_mux_scan,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = TriggerMuxScanRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to trigger_mux_scan: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.trigger_mux_scan,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def wait_for_finished(self, _message=None, _timeout=None, **kwargs):
        """Wait for a protocol run to finish.

        The call blocks until the run with the given run ID has finished (or returns immediately if
        it had already finished) and returns information about the protocol run.

        If no run has been started with the provided run ID (or no run ID is given), an error is
        returned.

        If NOTIFY_BEFORE_TERMINATION is specified for state, the protocol end time is an estimate, including
        the allowed timeout.

        Since 1.10

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.protocol_pb2.WaitForFinishedRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            run_id (str): Only consider a specific protocol run.
            state (minknow_api.protocol_pb2.WaitForFinishedRequest.NotificationState, optional): Control what to wait for.

                Specifying NOTIFY_BEFORE_TERMINATION allows a caller to be notified the script will be ended _soon_,
                and do final work to end cleanly.

                Since 1.11
            timeout (float, optional): Timeout to wait for finished, if the timeout expires before the protocol is complete (in the state requested)
                then the response returns.

                By default the timeout will wait forever.

                Since 1.15

        Returns:
            minknow_api.protocol_pb2.ProtocolRunInfo

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.wait_for_finished,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = WaitForFinishedRequest()

        if "run_id" in kwargs:
            unused_args.remove("run_id")
            _message.run_id = kwargs['run_id']
        else:
            raise ArgumentError("wait_for_finished requires a 'run_id' argument")

        if "state" in kwargs:
            unused_args.remove("state")
            _message.state = kwargs['state']

        if "timeout" in kwargs:
            unused_args.remove("timeout")
            _message.timeout = kwargs['timeout']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to wait_for_finished: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.wait_for_finished,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def get_run_info(self, _message=None, _timeout=None, **kwargs):
        """Gets information about a protocol run.

        If no run ID is provided, information about the most recently started protocol run is
        provided.

        Since 1.10

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.protocol_pb2.GetRunInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            run_id (str, optional): The protocol run to get information about.

        Returns:
            minknow_api.protocol_pb2.ProtocolRunInfo

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_run_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = GetRunInfoRequest()

        if "run_id" in kwargs:
            unused_args.remove("run_id")
            _message.run_id = kwargs['run_id']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_run_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_run_info,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def list_protocol_runs(self, _message=None, _timeout=None, **kwargs):
        """List previously started protocol run ids (including any current protocol), in order of starting.

        The returned object can be used to find protocol information with get_run_info.

        Since 1.11

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.protocol_pb2.ListProtocolRunsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            filter_info (minknow_api.protocol_pb2.FilteringInfo, optional): 

        Returns:
            minknow_api.protocol_pb2.ListProtocolRunsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.list_protocol_runs,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = ListProtocolRunsRequest()

        if "filter_info" in kwargs:
            unused_args.remove("filter_info")
            _message.filter_info.CopyFrom(kwargs['filter_info'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to list_protocol_runs: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.list_protocol_runs,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def get_current_protocol_run(self, _message=None, _timeout=None, **kwargs):
        """Returns the name and run id of the currently running protocol.

        Will fail with FAILED_PRECONDITION if there is no protocol running

        Since 1.11

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.protocol_pb2.GetCurrentProtocolRunRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.protocol_pb2.ProtocolRunInfo

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_current_protocol_run,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = GetCurrentProtocolRunRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_current_protocol_run: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_current_protocol_run,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def watch_current_protocol_run(self, _message=None, _timeout=None, **kwargs):
        """Returns current protocol run info and streams any changes to the current protocol

        This call can be made even if there is no current protocol running. In this case, the next streamed
        response will be the start of a new protocol instance and you will receive updates for that protocol
        until it finishes

        If a protocol finishes this stream will still continue to run and you will be notified when a new protocol starts

        Since 1.12

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.protocol_pb2.WatchCurrentProtocolRunRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.

        Returns:
            iter of minknow_api.protocol_pb2.ProtocolRunInfo

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.watch_current_protocol_run,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = WatchCurrentProtocolRunRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to watch_current_protocol_run: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.watch_current_protocol_run,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def list_protocols(self, _message=None, _timeout=None, **kwargs):
        """Gives back a list that contains info about each possible protocol script minknow is aware of.
        This will most likely be used to retrieve a suitable protocol script that can be passed on to `start_protocol`

        Since 1.10

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.protocol_pb2.ListProtocolsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            force_reload (bool, optional): If this is false, then will try to use the cached value of the protocol list where possible
                (still subject to changes in flow cell).
                If this is true, then will force a reload of the protocol list

                Defaults to false

        Returns:
            minknow_api.protocol_pb2.ListProtocolsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.list_protocols,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = ListProtocolsRequest()

        if "force_reload" in kwargs:
            unused_args.remove("force_reload")
            _message.force_reload = kwargs['force_reload']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to list_protocols: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.list_protocols,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def get_context_info(self, _message=None, _timeout=None, **kwargs):
        """Returns string-to-string map of the context tags

        Since 1.11

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.protocol_pb2.GetContextInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.protocol_pb2.GetContextInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_context_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = GetContextInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_context_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_context_info,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def set_context_info(self, _message=None, _timeout=None, **kwargs):
        """Store context tags as arbitrary string-to-string map

        Since 1.11

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.protocol_pb2.SetContextInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            context_info (minknow_api.protocol_pb2.SetContextInfoRequest.ContextInfoEntry, optional): 

        Returns:
            minknow_api.protocol_pb2.SetContextInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_context_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = SetContextInfoRequest()

        if "context_info" in kwargs:
            unused_args.remove("context_info")
            _message.context_info.update(kwargs['context_info'])
            

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_context_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_context_info,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def get_protocol_purpose(self, _message=None, _timeout=None, **kwargs):
        """Value set by protocol scripts to define the purpose of the script. Gets this value

        Since 1.11

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.protocol_pb2.GetProtocolPurposeRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.protocol_pb2.GetProtocolPurposeResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_protocol_purpose,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = GetProtocolPurposeRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_protocol_purpose: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_protocol_purpose,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def set_protocol_purpose(self, _message=None, _timeout=None, **kwargs):
        """Sets the protocol purpose. See also get_protocol_purpose

        Since 1.11

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.protocol_pb2.SetProtocolPurposeRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            purpose (str, optional): 

        Returns:
            minknow_api.protocol_pb2.SetProtocolPurposeResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_protocol_purpose,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = SetProtocolPurposeRequest()

        if "purpose" in kwargs:
            unused_args.remove("purpose")
            _message.purpose = kwargs['purpose']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_protocol_purpose: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_protocol_purpose,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def add_epi2me_workflow(self, _message=None, _timeout=None, **kwargs):
        """Links an epi2me workflow reference to a run id.

        Since 1.15

        

        Args:
            _message (minknow_api.protocol_pb2.AddEpi2meWorkflowRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            run_id (str): 
            epi2me_workflow (minknow_api.protocol_pb2.Epi2meWorkflowReference): 

        Returns:
            minknow_api.protocol_pb2.AddEpi2meWorkflowResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.add_epi2me_workflow,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = AddEpi2meWorkflowRequest()

        if "run_id" in kwargs:
            unused_args.remove("run_id")
            _message.run_id = kwargs['run_id']
        else:
            raise ArgumentError("add_epi2me_workflow requires a 'run_id' argument")

        if "epi2me_workflow" in kwargs:
            unused_args.remove("epi2me_workflow")
            _message.epi2me_workflow.CopyFrom(kwargs['epi2me_workflow'])
        else:
            raise ArgumentError("add_epi2me_workflow requires a 'epi2me_workflow' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to add_epi2me_workflow: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.add_epi2me_workflow,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def list_protocol_group_ids(self, _message=None, _timeout=None, **kwargs):
        """List all used protocol group ids used in any previous protocol on the box.

        Since 3.2

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.protocol_pb2.ListProtocolGroupIdsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            filter_info (minknow_api.protocol_pb2.FilteringInfo, optional): 

        Returns:
            minknow_api.protocol_pb2.ListProtocolGroupIdsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.list_protocol_group_ids,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = ListProtocolGroupIdsRequest()

        if "filter_info" in kwargs:
            unused_args.remove("filter_info")
            _message.filter_info.CopyFrom(kwargs['filter_info'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to list_protocol_group_ids: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.list_protocol_group_ids,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def begin_hardware_check(self, _message=None, _timeout=None, **kwargs):
        """Run a hardware check on the connected flow cell.

        Throws an error if there is no flow cell connected.

        Since 4.3

        

        Note this API is experimental - it may be changed, revised or removed in future minor versions.

        Args:
            _message (minknow_api.protocol_pb2.BeginHardwareCheckRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.protocol_pb2.BeginHardwareCheckResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        print("Warning: Method ProtocolService.begin_hardware_check is experimental and may be changed, revised or removed in future minor versions.", file=sys.stderr)
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.begin_hardware_check,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = BeginHardwareCheckRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to begin_hardware_check: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.begin_hardware_check,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def begin_platform_qc(self, _message=None, _timeout=None, **kwargs):
        """Run platform qc on the connected flow cell

        Throws an error if there is no flow cell connected.

        Since 4.3

        

        Note this API is experimental - it may be changed, revised or removed in future minor versions.

        Args:
            _message (minknow_api.protocol_pb2.BeginPlatformQcRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.protocol_pb2.BeginPlatformQcResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        print("Warning: Method ProtocolService.begin_platform_qc is experimental and may be changed, revised or removed in future minor versions.", file=sys.stderr)
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.begin_platform_qc,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = BeginPlatformQcRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to begin_platform_qc: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.begin_platform_qc,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def begin_protocol(self, _message=None, _timeout=None, **kwargs):
        """Run protocol on the connected flow cell

        The protocol must be described by a toml file. The request identifies the
        protocol and supplies overrides to the default protocol-settings described
        in the toml file, in addition it provides user-info for the experiment.

        Throws an error if there is no flow cell connected.

        Since 5.0

        

        Note this API is experimental - it may be changed, revised or removed in future minor versions.

        Args:
            _message (minknow_api.protocol_pb2.BeginProtocolRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            identifier (str, optional): Specify the protocol with a string containing all the protocol's identifying components, eg:
                "sequencing/sequencing_MIN106_DNA:FLO-MIN106:SQK-RPB004"
            components (minknow_api.protocol_settings_pb2.ProtocolIdentifierComponents, optional): Specify the protocol providing the identifying components individually, all components are optional.
                Exactly one protocol should match the given components otherwise and error will be returned
            user_info (minknow_api.protocol_pb2.ProtocolRunUserInfo, optional): User info options for the protocol
            offload_location_info (minknow_api.protocol_pb2.OffloadLocationInfo, optional): Information about data offload locations to use to store data

                Since 5.0.
            target_run_until_criteria (minknow_api.acquisition_pb2.TargetRunUntilCriteria, optional): Initial Target Run-Until Criteria to use when starting an acquisition for this protocol.
                These can be updated during the acquisition using the Run-Until API.

                Since 5.3
            settings (minknow_api.protocol_pb2.BeginProtocolRequest.SettingsEntry, optional): Any settings changed from the defaults specified in the protocol's .toml file.
            analysis_workflow_request (minknow_api.analysis_workflows_pb2.AnalysisWorkflowRequest, optional): Workflow request that should be started when the protocol is started
            simulation_source (str, optional): Simulation source for playback device data, either an hdf file or directory for use with arrow playback files.

                Since 6.2

        Returns:
            minknow_api.protocol_pb2.BeginProtocolResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        print("Warning: Method ProtocolService.begin_protocol is experimental and may be changed, revised or removed in future minor versions.", file=sys.stderr)
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.begin_protocol,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        # check oneof group 'protocol_identifier'
        oneof_fields = set([
            "identifier",
            "components",
        ])

        if len(unused_args & oneof_fields) > 1:
            raise ArgumentError("begin_protocol given multiple conflicting arguments: '{}'".format(", ".join(unused_args & oneof_fields)))

        _message = BeginProtocolRequest()

        if "identifier" in kwargs:
            unused_args.remove("identifier")
            _message.identifier = kwargs['identifier']

        if "components" in kwargs:
            unused_args.remove("components")
            _message.components.CopyFrom(kwargs['components'])

        if "user_info" in kwargs:
            unused_args.remove("user_info")
            _message.user_info.CopyFrom(kwargs['user_info'])

        if "offload_location_info" in kwargs:
            unused_args.remove("offload_location_info")
            _message.offload_location_info.CopyFrom(kwargs['offload_location_info'])

        if "target_run_until_criteria" in kwargs:
            unused_args.remove("target_run_until_criteria")
            _message.target_run_until_criteria.CopyFrom(kwargs['target_run_until_criteria'])

        if "settings" in kwargs:
            unused_args.remove("settings")
            for key, value in kwargs['settings'].items():
                _message.settings[key].CopyFrom(value)

        if "analysis_workflow_request" in kwargs:
            unused_args.remove("analysis_workflow_request")
            _message.analysis_workflow_request.CopyFrom(kwargs['analysis_workflow_request'])

        if "simulation_source" in kwargs:
            unused_args.remove("simulation_source")
            _message.simulation_source = kwargs['simulation_source']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to begin_protocol: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.begin_protocol,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def set_platform_qc_result(self, _message=None, _timeout=None, **kwargs):
        """

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.protocol_pb2.SetPlatformQcResultRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            protocol_run_id (str, optional): The protocol_run_id that was given when the pqc run was started
            pqc_result (minknow_api.protocol_pb2.PlatformQcResult, optional): 

        Returns:
            minknow_api.protocol_pb2.SetPlatformQcResultResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_platform_qc_result,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = SetPlatformQcResultRequest()

        if "protocol_run_id" in kwargs:
            unused_args.remove("protocol_run_id")
            _message.protocol_run_id = kwargs['protocol_run_id']

        if "pqc_result" in kwargs:
            unused_args.remove("pqc_result")
            _message.pqc_result.CopyFrom(kwargs['pqc_result'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_platform_qc_result: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_platform_qc_result,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def set_hardware_check_result(self, _message=None, _timeout=None, **kwargs):
        """Set the hardware check result

        Should be called to set the status to `Started` at the start of any hardware check script
        Should be called again to set the final status when a hardware check script finishes

        If a script finishes, and the hardware check status is `Started`, then MinKNOW will set the
        status to `Failed: ScriptError`.  (The hardware check script should have updated the status
        when the hardware check finished; failure to do so indicates that the script failed).

        The call will fail with `INVALID_ARGUMENT` if:
        - HardwareCheckStatus is NOT `Failed`, and `HardwareCheckFailureReason` is NOT `NoError`
        - HardwareCheckStatus is `Failed` and `HardwareCheckFailureReason` is `NoError`
        - HardwareCheckStatus is not a valid value (None, Started, Succeeded or Failed)
        - The supplied `protocol_run_id` does not correspond to an existing protocol

        The call will fail with `FAILED_PRECONDITION` if:
        - The supplied `protocol_run_id` does not correspond to an in-progress protocol
        - Hardware check status are not moved through in order:
             None -> Started -> Succeeded/Failed

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.protocol_pb2.SetHardwareCheckResultRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            protocol_run_id (str, optional): The protocol_run_id that was given when the hardware check run was started
            result (minknow_api.protocol_pb2.HardwareCheckResult, optional): 

        Returns:
            minknow_api.protocol_pb2.SetHardwareCheckResultResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_hardware_check_result,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = SetHardwareCheckResultRequest()

        if "protocol_run_id" in kwargs:
            unused_args.remove("protocol_run_id")
            _message.protocol_run_id = kwargs['protocol_run_id']

        if "result" in kwargs:
            unused_args.remove("result")
            _message.result.CopyFrom(kwargs['result'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_hardware_check_result: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_hardware_check_result,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def associate_post_processing_analysis_for_protocol(self, _message=None, _timeout=None, **kwargs):
        """Associated a post processing analysis process, and schedule it to run once the protocol is complete.

        If the protocol is already complete, the post processing analysis is executed immediately.

        Since 4.4

        

        Args:
            _message (minknow_api.protocol_pb2.AssociatePostProcessingAnalysisRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            run_id (str, optional): Protocol id to associate analysis with:
            start_request (minknow_api.basecaller_pb2.StartRequest, optional): 

        Returns:
            minknow_api.protocol_pb2.AssociatePostProcessingAnalysisResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.associate_post_processing_analysis_for_protocol,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = AssociatePostProcessingAnalysisRequest()

        if "run_id" in kwargs:
            unused_args.remove("run_id")
            _message.run_id = kwargs['run_id']

        if "start_request" in kwargs:
            unused_args.remove("start_request")
            _message.start_request.CopyFrom(kwargs['start_request'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to associate_post_processing_analysis_for_protocol: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.associate_post_processing_analysis_for_protocol,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def clear_protocol_history_data(self, _message=None, _timeout=None, **kwargs):
        """Clears history data for specified protocol(s)

        History data includes protocol protocol info, acquisition info and statistics.

        Also clears any persistence data that has been written to disk for those protocols -- this
        data will not be available after a restart.

        Does NOT clear experiment results (fast5, fastq, sequencing_summary, etc)

        Since 4.4

        

        Args:
            _message (minknow_api.protocol_pb2.ClearProtocolHistoryDataRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            protocol_ids (str, optional): 

        Returns:
            minknow_api.protocol_pb2.ClearProtocolHistoryDataResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.clear_protocol_history_data,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = ClearProtocolHistoryDataRequest()

        if "protocol_ids" in kwargs:
            unused_args.remove("protocol_ids")
            _message.protocol_ids.extend(kwargs['protocol_ids'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to clear_protocol_history_data: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.clear_protocol_history_data,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
    def protocol_phase_management(self, iterator):
        """This RPC should only be used by the protocol script.

        The protocol script can call this to opt in to protocol phase management. It can report the
        phase it is currently in, and handle requests to change phase.

        Only one call to this RPC is possible at once. Ending the call will reset the phase to
        PHASE_UNKNOWN and clear any set capabilities.

        Since 4.4.

        

        Args:
            iterator (iter of minknow_api.protocol_pb2.ProtocolPhaseManagementRequest): An interable that
                yields the messages to send.

        Returns:
            iter of minknow_api.protocol_pb2.ProtocolPhaseManagementResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        return self._stub.protocol_phase_management(iterator)
    def generate_run_report(self, _message=None, _timeout=None, **kwargs):
        """Generate a run report and return the report data.

        If the protocol selected for report generation is already complete the report is a completed report, otherwise
        the report will be from the in progress protocol.

        Since 5.0

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.protocol_pb2.GenerateRunReportRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            protocol_run_id (str, optional): The protocol_run_id to generate a report for.
            include_input_data (bool, optional): Optionally return the input data used to generate the report. This input data is
                represented as the data seen in report_data.proto

        Returns:
            iter of minknow_api.protocol_pb2.GenerateRunReportResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.generate_run_report,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.protocol.ProtocolService")

        unused_args = set(kwargs.keys())

        _message = GenerateRunReportRequest()

        if "protocol_run_id" in kwargs:
            unused_args.remove("protocol_run_id")
            _message.protocol_run_id = kwargs['protocol_run_id']

        if "include_input_data" in kwargs:
            unused_args.remove("include_input_data")
            _message.include_input_data = kwargs['include_input_data']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to generate_run_report: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.generate_run_report,
                              _message, _timeout,
                              [],
                              "minknow_api.protocol.ProtocolService")
