# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from minknow_api import run_until_pb2 as minknow__api_dot_run__until__pb2


class RunUntilServiceStub(object):
    """Overview
    ========

    This service allows a user to set certain criteria (Target Run-Until Criteria), which indicate
    the conditions under which the experiment should be stopped or paused.  For example, the user
    can specify that the experiment should be stopped after a certain time has elapsed, or paused
    when the number of available pores drops below a certain level.  This functionality is referred
    to as "Run-Until", since it allows the user to specify that an experiment should "run until"
    some condition has been fulfilled.

    The Target Run-Until Criteria are the conditions that are used to determine whether an
    experiment should be stopped or paused.  There is a "standard" set of Run-Until Criteria, which
    can always be used.  Additional Run-Until Criteria may also be supported by custom Run-Until
    Scripts (see below).

    This service also provides updates about the Run-Until status.  These include updates about
    the experiment's progress towards the Run-Until Criteria, as well as updates about the estimated
    time remaining, and Run-Until actions (i.e. starting/stopping the experiment).

    Finally, this service provides an API for Run-Until Scripts.  A Run-Until Script is responsible
    for actually implementing the Run-Until functionality.  The Run-Until Script reads the Target
    Run-Until Criteria that are set by the user.  It then monitors the experiment's progress, and
    pauses or stops the experiment when the Run-Until Criteria have been fulfilled.  There is a
    "standard" ONT-provided run-until script, which supports the "standard" Run-Until Criteria.
    Custom Run-Until Scripts can be implemented which extend the "standard" Run-Until Script to
    provide support for additional criteria.

    Usage -- Users
    ==============

    Overview
    --------

    The user sets the initial target Run-Until Criteria when the protocol is started, supplying them
    in the parameters passed to `start_protocol()` or `begin_protocol()`.

    The user may update these criteria as the experiment progresses by calling
    `write_target_criteria()` with the new criteria.

    The user can also obtain updates from the Run-Until Script by calling
    `stream_updates()`.  The Run-Until Script may send "estimated time remaining"
    information, or messages relating to the Run-Until status.

    If a criterion is specified in `write_target_criteria()` that is not recognised by the
    Run-Until Script, then the Run-Until Script will ignore that criterion.  It will also
    report that it has encountered an unrecognised criterion through `stream_updates()`.


    Standard Run-Until Criteria
    ---------------------------

    The Standard Run-Until Criteria are described below.  These criteria are always available for
    use.

    `runtime` (uint64)
    Acquisition runtime, in seconds
    Criterion is met if the runtime is greater than or equal to the specified value.

    `available_pores` (float)
    Pores marked available, following a mux scan.
    Criterion is met if the percentage of available pores is less than the specified value.
    An update will be supplied after each mux scan that is performed.

    `estimated_bases` (uint64)
    Estimated bases generated during the experiment.
    Criterion is met if the number of estimated bases is greater than or equal to the specified
    value.

    `passed_basecalled_bases` (uint64)
    Basecalled bases which pass filtering (following basecalling)
    Criterion will never be met if basecalling is not enabled.
    Updates will not be supplied if basecalling is not enabled.
    Criterion is met if the number of basecalled bases which pass filtering is greater than or
    equal to the specified value.

    `coverage` (float)
    The number of times a given reference genome is sequenced
    Criterion will never be met if basecalling is not enabled or a reference is not supplied
    Updates will not be supplied if basecalling is not enabled or a reference is not supplied
    Criterion is met if the coverage amount is greater than or equal than the specified value

    `barcode_coverage` (float)
    The number of times a given reference genome is sequenced and has also been identified to have an attached barcode
    Criterion will never be met if basecalling is not enabled, a reference is not supplied, barcoding is not enabled, or the samples have no attached barcode
    Updates will not be supplied if basecalling is not enabled or a reference is not supplied, barcoding is not enabled, or the samples have no attached barcode
    Criterion is met if the coverage amount is greater than or equal than the specified value

    `bed_coverage` (float)
    The same as `coverage`, with the addition that the bases have to be associated with a BED region
    Criterion will also never be met if a BED file is not supplied

    `bed_barcode_coverage` (float)
    The same as `barcode_coverage`, with the addition that the bases have to be associated with a BED region
    Criterion will also never be met if a BED file is not supplied


    Additional Run-Until Criteria
    -----------------------------

    Custom Run-Until Scripts may support additional criteria (beyond the Standard Run-Until Criteria
    described above).  The list of these criteria, and their meaning, will be supplied in the
    documentation for the custom run-until script.


    Usage -- Run-Until Scripts
    ==========================

    Overview
    --------

    The Run-Until Script is started as a custom script.

    The script obtains the Run-Until Criteria from MinKNOW using `stream_target_criteria()`.  Any
    updates to the Run-Until Criteria are also transmitted through this call.  If any of the
    criteria specified are not support by the script, the script reports an error via
    `write_updates()`.

    Finally, the Run-Until Script can perform actions and send updates to the user using the
    `write_updates()` interface.  Actions include pausing, resuming and stopping the
    acquisition.  Updates include estimated time remaining.

    Update History
    ==============

    MinKNOW stores an "merged" history of updates that are received on the `write_updates()`
    interface.  The history is calculated as MinKNOW receives updates on the `write_updates()`
    stream as follows:

    - When the protocol starts, an empty message is added to the history
    - When an update is received on the `write_updates()` interface, the values of the
    `estimated_time_remaining_update` and `current_progress_update` fields are updated, by
    "merging" the corresponding fields of the last message in the history.  "Merging" here means
    copying keys/values which appear in the "previous" message, but which don't have
    corresponding keys in the newly received message.
    - Once the values in the update have been updated, the "merged" message is then added to the
    history:
    - If the previous message in the history has no fields set, besides the
    `estimated_time_remaining_update` and/or `current_progress_update` fields, then the
    previous message in the history is overwritten with the "merged" message
    - Otherwise, the "merged" message is appended to the history.

    After updating the history, the final entry in the history is sent to any open
    `stream_updates()` streams.  The `idx` in the `StreamUpdatesResponse` message is set equal to
    the index of the entry in the history.  This means that the `stream_updates()` stream will
    likely contain repeated `idx` values -- this will happen when the previous message in the
    history is overwritten by the "merged" message.  The `time` in the `StreamUpdatesResponse`
    message is set equal to the time at which the entry in the history was last updated.


    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.write_target_criteria = channel.unary_unary(
                '/minknow_api.run_until.RunUntilService/write_target_criteria',
                request_serializer=minknow__api_dot_run__until__pb2.WriteTargetCriteriaRequest.SerializeToString,
                response_deserializer=minknow__api_dot_run__until__pb2.WriteTargetCriteriaResponse.FromString,
                )
        self.stream_target_criteria = channel.unary_stream(
                '/minknow_api.run_until.RunUntilService/stream_target_criteria',
                request_serializer=minknow__api_dot_run__until__pb2.StreamTargetCriteriaRequest.SerializeToString,
                response_deserializer=minknow__api_dot_run__until__pb2.StreamTargetCriteriaResponse.FromString,
                )
        self.write_updates = channel.unary_unary(
                '/minknow_api.run_until.RunUntilService/write_updates',
                request_serializer=minknow__api_dot_run__until__pb2.WriteUpdatesRequest.SerializeToString,
                response_deserializer=minknow__api_dot_run__until__pb2.WriteUpdatesResponse.FromString,
                )
        self.stream_updates = channel.unary_stream(
                '/minknow_api.run_until.RunUntilService/stream_updates',
                request_serializer=minknow__api_dot_run__until__pb2.StreamUpdatesRequest.SerializeToString,
                response_deserializer=minknow__api_dot_run__until__pb2.StreamUpdatesResponse.FromString,
                )


class RunUntilServiceServicer(object):
    """Overview
    ========

    This service allows a user to set certain criteria (Target Run-Until Criteria), which indicate
    the conditions under which the experiment should be stopped or paused.  For example, the user
    can specify that the experiment should be stopped after a certain time has elapsed, or paused
    when the number of available pores drops below a certain level.  This functionality is referred
    to as "Run-Until", since it allows the user to specify that an experiment should "run until"
    some condition has been fulfilled.

    The Target Run-Until Criteria are the conditions that are used to determine whether an
    experiment should be stopped or paused.  There is a "standard" set of Run-Until Criteria, which
    can always be used.  Additional Run-Until Criteria may also be supported by custom Run-Until
    Scripts (see below).

    This service also provides updates about the Run-Until status.  These include updates about
    the experiment's progress towards the Run-Until Criteria, as well as updates about the estimated
    time remaining, and Run-Until actions (i.e. starting/stopping the experiment).

    Finally, this service provides an API for Run-Until Scripts.  A Run-Until Script is responsible
    for actually implementing the Run-Until functionality.  The Run-Until Script reads the Target
    Run-Until Criteria that are set by the user.  It then monitors the experiment's progress, and
    pauses or stops the experiment when the Run-Until Criteria have been fulfilled.  There is a
    "standard" ONT-provided run-until script, which supports the "standard" Run-Until Criteria.
    Custom Run-Until Scripts can be implemented which extend the "standard" Run-Until Script to
    provide support for additional criteria.

    Usage -- Users
    ==============

    Overview
    --------

    The user sets the initial target Run-Until Criteria when the protocol is started, supplying them
    in the parameters passed to `start_protocol()` or `begin_protocol()`.

    The user may update these criteria as the experiment progresses by calling
    `write_target_criteria()` with the new criteria.

    The user can also obtain updates from the Run-Until Script by calling
    `stream_updates()`.  The Run-Until Script may send "estimated time remaining"
    information, or messages relating to the Run-Until status.

    If a criterion is specified in `write_target_criteria()` that is not recognised by the
    Run-Until Script, then the Run-Until Script will ignore that criterion.  It will also
    report that it has encountered an unrecognised criterion through `stream_updates()`.


    Standard Run-Until Criteria
    ---------------------------

    The Standard Run-Until Criteria are described below.  These criteria are always available for
    use.

    `runtime` (uint64)
    Acquisition runtime, in seconds
    Criterion is met if the runtime is greater than or equal to the specified value.

    `available_pores` (float)
    Pores marked available, following a mux scan.
    Criterion is met if the percentage of available pores is less than the specified value.
    An update will be supplied after each mux scan that is performed.

    `estimated_bases` (uint64)
    Estimated bases generated during the experiment.
    Criterion is met if the number of estimated bases is greater than or equal to the specified
    value.

    `passed_basecalled_bases` (uint64)
    Basecalled bases which pass filtering (following basecalling)
    Criterion will never be met if basecalling is not enabled.
    Updates will not be supplied if basecalling is not enabled.
    Criterion is met if the number of basecalled bases which pass filtering is greater than or
    equal to the specified value.

    `coverage` (float)
    The number of times a given reference genome is sequenced
    Criterion will never be met if basecalling is not enabled or a reference is not supplied
    Updates will not be supplied if basecalling is not enabled or a reference is not supplied
    Criterion is met if the coverage amount is greater than or equal than the specified value

    `barcode_coverage` (float)
    The number of times a given reference genome is sequenced and has also been identified to have an attached barcode
    Criterion will never be met if basecalling is not enabled, a reference is not supplied, barcoding is not enabled, or the samples have no attached barcode
    Updates will not be supplied if basecalling is not enabled or a reference is not supplied, barcoding is not enabled, or the samples have no attached barcode
    Criterion is met if the coverage amount is greater than or equal than the specified value

    `bed_coverage` (float)
    The same as `coverage`, with the addition that the bases have to be associated with a BED region
    Criterion will also never be met if a BED file is not supplied

    `bed_barcode_coverage` (float)
    The same as `barcode_coverage`, with the addition that the bases have to be associated with a BED region
    Criterion will also never be met if a BED file is not supplied


    Additional Run-Until Criteria
    -----------------------------

    Custom Run-Until Scripts may support additional criteria (beyond the Standard Run-Until Criteria
    described above).  The list of these criteria, and their meaning, will be supplied in the
    documentation for the custom run-until script.


    Usage -- Run-Until Scripts
    ==========================

    Overview
    --------

    The Run-Until Script is started as a custom script.

    The script obtains the Run-Until Criteria from MinKNOW using `stream_target_criteria()`.  Any
    updates to the Run-Until Criteria are also transmitted through this call.  If any of the
    criteria specified are not support by the script, the script reports an error via
    `write_updates()`.

    Finally, the Run-Until Script can perform actions and send updates to the user using the
    `write_updates()` interface.  Actions include pausing, resuming and stopping the
    acquisition.  Updates include estimated time remaining.

    Update History
    ==============

    MinKNOW stores an "merged" history of updates that are received on the `write_updates()`
    interface.  The history is calculated as MinKNOW receives updates on the `write_updates()`
    stream as follows:

    - When the protocol starts, an empty message is added to the history
    - When an update is received on the `write_updates()` interface, the values of the
    `estimated_time_remaining_update` and `current_progress_update` fields are updated, by
    "merging" the corresponding fields of the last message in the history.  "Merging" here means
    copying keys/values which appear in the "previous" message, but which don't have
    corresponding keys in the newly received message.
    - Once the values in the update have been updated, the "merged" message is then added to the
    history:
    - If the previous message in the history has no fields set, besides the
    `estimated_time_remaining_update` and/or `current_progress_update` fields, then the
    previous message in the history is overwritten with the "merged" message
    - Otherwise, the "merged" message is appended to the history.

    After updating the history, the final entry in the history is sent to any open
    `stream_updates()` streams.  The `idx` in the `StreamUpdatesResponse` message is set equal to
    the index of the entry in the history.  This means that the `stream_updates()` stream will
    likely contain repeated `idx` values -- this will happen when the previous message in the
    history is overwritten by the "merged" message.  The `time` in the `StreamUpdatesResponse`
    message is set equal to the time at which the entry in the history was last updated.


    """

    def write_target_criteria(self, request, context):
        """Write target run-until criteria

        Updates to these criteria are forwarded to `stream_target_criteria()`.  When an update is
        made, all existing criteria are replaced with those specified in the
        WriteTargetCriteriaRequest
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def stream_target_criteria(self, request, context):
        """Obtain the current target run-until criteria, and listen for changes in the target
        run-until criteria

        When an update is received, it specifies the new target criteria, which should replace all
        existing criteria.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def write_updates(self, request, context):
        """Send an update about the current Run-Until state

        The Run-Until Script can use this to provide information about the expected time remaining
        (as well as other information) to users of the Run-Until functionality

        Updates written here are forwarded on to `stream_updates()`
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def stream_updates(self, request, context):
        """Obtain updates about the current Run-Until state

        The user can use this to obtain information about the expected time remaining (as well as
        other information) from the Run-Until Script.

        Updates are sent following writes to `write_updates()`
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_RunUntilServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'write_target_criteria': grpc.unary_unary_rpc_method_handler(
                    servicer.write_target_criteria,
                    request_deserializer=minknow__api_dot_run__until__pb2.WriteTargetCriteriaRequest.FromString,
                    response_serializer=minknow__api_dot_run__until__pb2.WriteTargetCriteriaResponse.SerializeToString,
            ),
            'stream_target_criteria': grpc.unary_stream_rpc_method_handler(
                    servicer.stream_target_criteria,
                    request_deserializer=minknow__api_dot_run__until__pb2.StreamTargetCriteriaRequest.FromString,
                    response_serializer=minknow__api_dot_run__until__pb2.StreamTargetCriteriaResponse.SerializeToString,
            ),
            'write_updates': grpc.unary_unary_rpc_method_handler(
                    servicer.write_updates,
                    request_deserializer=minknow__api_dot_run__until__pb2.WriteUpdatesRequest.FromString,
                    response_serializer=minknow__api_dot_run__until__pb2.WriteUpdatesResponse.SerializeToString,
            ),
            'stream_updates': grpc.unary_stream_rpc_method_handler(
                    servicer.stream_updates,
                    request_deserializer=minknow__api_dot_run__until__pb2.StreamUpdatesRequest.FromString,
                    response_serializer=minknow__api_dot_run__until__pb2.StreamUpdatesResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'minknow_api.run_until.RunUntilService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class RunUntilService(object):
    """Overview
    ========

    This service allows a user to set certain criteria (Target Run-Until Criteria), which indicate
    the conditions under which the experiment should be stopped or paused.  For example, the user
    can specify that the experiment should be stopped after a certain time has elapsed, or paused
    when the number of available pores drops below a certain level.  This functionality is referred
    to as "Run-Until", since it allows the user to specify that an experiment should "run until"
    some condition has been fulfilled.

    The Target Run-Until Criteria are the conditions that are used to determine whether an
    experiment should be stopped or paused.  There is a "standard" set of Run-Until Criteria, which
    can always be used.  Additional Run-Until Criteria may also be supported by custom Run-Until
    Scripts (see below).

    This service also provides updates about the Run-Until status.  These include updates about
    the experiment's progress towards the Run-Until Criteria, as well as updates about the estimated
    time remaining, and Run-Until actions (i.e. starting/stopping the experiment).

    Finally, this service provides an API for Run-Until Scripts.  A Run-Until Script is responsible
    for actually implementing the Run-Until functionality.  The Run-Until Script reads the Target
    Run-Until Criteria that are set by the user.  It then monitors the experiment's progress, and
    pauses or stops the experiment when the Run-Until Criteria have been fulfilled.  There is a
    "standard" ONT-provided run-until script, which supports the "standard" Run-Until Criteria.
    Custom Run-Until Scripts can be implemented which extend the "standard" Run-Until Script to
    provide support for additional criteria.

    Usage -- Users
    ==============

    Overview
    --------

    The user sets the initial target Run-Until Criteria when the protocol is started, supplying them
    in the parameters passed to `start_protocol()` or `begin_protocol()`.

    The user may update these criteria as the experiment progresses by calling
    `write_target_criteria()` with the new criteria.

    The user can also obtain updates from the Run-Until Script by calling
    `stream_updates()`.  The Run-Until Script may send "estimated time remaining"
    information, or messages relating to the Run-Until status.

    If a criterion is specified in `write_target_criteria()` that is not recognised by the
    Run-Until Script, then the Run-Until Script will ignore that criterion.  It will also
    report that it has encountered an unrecognised criterion through `stream_updates()`.


    Standard Run-Until Criteria
    ---------------------------

    The Standard Run-Until Criteria are described below.  These criteria are always available for
    use.

    `runtime` (uint64)
    Acquisition runtime, in seconds
    Criterion is met if the runtime is greater than or equal to the specified value.

    `available_pores` (float)
    Pores marked available, following a mux scan.
    Criterion is met if the percentage of available pores is less than the specified value.
    An update will be supplied after each mux scan that is performed.

    `estimated_bases` (uint64)
    Estimated bases generated during the experiment.
    Criterion is met if the number of estimated bases is greater than or equal to the specified
    value.

    `passed_basecalled_bases` (uint64)
    Basecalled bases which pass filtering (following basecalling)
    Criterion will never be met if basecalling is not enabled.
    Updates will not be supplied if basecalling is not enabled.
    Criterion is met if the number of basecalled bases which pass filtering is greater than or
    equal to the specified value.

    `coverage` (float)
    The number of times a given reference genome is sequenced
    Criterion will never be met if basecalling is not enabled or a reference is not supplied
    Updates will not be supplied if basecalling is not enabled or a reference is not supplied
    Criterion is met if the coverage amount is greater than or equal than the specified value

    `barcode_coverage` (float)
    The number of times a given reference genome is sequenced and has also been identified to have an attached barcode
    Criterion will never be met if basecalling is not enabled, a reference is not supplied, barcoding is not enabled, or the samples have no attached barcode
    Updates will not be supplied if basecalling is not enabled or a reference is not supplied, barcoding is not enabled, or the samples have no attached barcode
    Criterion is met if the coverage amount is greater than or equal than the specified value

    `bed_coverage` (float)
    The same as `coverage`, with the addition that the bases have to be associated with a BED region
    Criterion will also never be met if a BED file is not supplied

    `bed_barcode_coverage` (float)
    The same as `barcode_coverage`, with the addition that the bases have to be associated with a BED region
    Criterion will also never be met if a BED file is not supplied


    Additional Run-Until Criteria
    -----------------------------

    Custom Run-Until Scripts may support additional criteria (beyond the Standard Run-Until Criteria
    described above).  The list of these criteria, and their meaning, will be supplied in the
    documentation for the custom run-until script.


    Usage -- Run-Until Scripts
    ==========================

    Overview
    --------

    The Run-Until Script is started as a custom script.

    The script obtains the Run-Until Criteria from MinKNOW using `stream_target_criteria()`.  Any
    updates to the Run-Until Criteria are also transmitted through this call.  If any of the
    criteria specified are not support by the script, the script reports an error via
    `write_updates()`.

    Finally, the Run-Until Script can perform actions and send updates to the user using the
    `write_updates()` interface.  Actions include pausing, resuming and stopping the
    acquisition.  Updates include estimated time remaining.

    Update History
    ==============

    MinKNOW stores an "merged" history of updates that are received on the `write_updates()`
    interface.  The history is calculated as MinKNOW receives updates on the `write_updates()`
    stream as follows:

    - When the protocol starts, an empty message is added to the history
    - When an update is received on the `write_updates()` interface, the values of the
    `estimated_time_remaining_update` and `current_progress_update` fields are updated, by
    "merging" the corresponding fields of the last message in the history.  "Merging" here means
    copying keys/values which appear in the "previous" message, but which don't have
    corresponding keys in the newly received message.
    - Once the values in the update have been updated, the "merged" message is then added to the
    history:
    - If the previous message in the history has no fields set, besides the
    `estimated_time_remaining_update` and/or `current_progress_update` fields, then the
    previous message in the history is overwritten with the "merged" message
    - Otherwise, the "merged" message is appended to the history.

    After updating the history, the final entry in the history is sent to any open
    `stream_updates()` streams.  The `idx` in the `StreamUpdatesResponse` message is set equal to
    the index of the entry in the history.  This means that the `stream_updates()` stream will
    likely contain repeated `idx` values -- this will happen when the previous message in the
    history is overwritten by the "merged" message.  The `time` in the `StreamUpdatesResponse`
    message is set equal to the time at which the entry in the history was last updated.


    """

    @staticmethod
    def write_target_criteria(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.run_until.RunUntilService/write_target_criteria',
            minknow__api_dot_run__until__pb2.WriteTargetCriteriaRequest.SerializeToString,
            minknow__api_dot_run__until__pb2.WriteTargetCriteriaResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def stream_target_criteria(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/minknow_api.run_until.RunUntilService/stream_target_criteria',
            minknow__api_dot_run__until__pb2.StreamTargetCriteriaRequest.SerializeToString,
            minknow__api_dot_run__until__pb2.StreamTargetCriteriaResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def write_updates(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/minknow_api.run_until.RunUntilService/write_updates',
            minknow__api_dot_run__until__pb2.WriteUpdatesRequest.SerializeToString,
            minknow__api_dot_run__until__pb2.WriteUpdatesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def stream_updates(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/minknow_api.run_until.RunUntilService/stream_updates',
            minknow__api_dot_run__until__pb2.StreamUpdatesRequest.SerializeToString,
            minknow__api_dot_run__until__pb2.StreamUpdatesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
