### THIS FILE IS AUTOGENERATED. DO NOT EDIT THIS FILE DIRECTLY ###
import minknow_api
from minknow_api.ui.sequencing_run.presets_pb2_grpc import *
import minknow_api.ui.sequencing_run.presets_pb2 as presets_pb2
from minknow_api.ui.sequencing_run.presets_pb2 import *
from minknow_api._support import MessageWrapper, ArgumentError
import time
import logging
import sys

__all__ = [
    "PresetsService",
    "PresetMeta",
    "Preset",
    "PresetType",
    "StorePresetRequest",
    "StorePresetResponse",
    "DeletePresetRequest",
    "DeletePresetResponse",
    "ListPresetsRequest",
    "ListPresetsResponse",
    "CheckPresetRequest",
    "CheckPresetResponse",
    "GetStartProtocolRequest",
    "GetStartProtocolResponse",
    "GetPresetRequest",
    "GetPresetResponse",
]

def run_with_retry(method, message, timeout, unwraps, full_name):
    retry_count = 20
    error = None
    for i in range(retry_count):
        try:
            result = MessageWrapper(method(message, timeout=timeout), unwraps=unwraps)
            return result
        except grpc.RpcError as e:
            # Retrying unidentified grpc errors to keep clients from crashing
            retryable_error = (e.code() == grpc.StatusCode.UNKNOWN and "Stream removed" in e.details() or \
                                (e.code() == grpc.StatusCode.INTERNAL and "RST_STREAM" in e.details()))
            if retryable_error:
                logging.info('Bypassed ({}: {}) error for grpc: {}. Attempt {}.'.format(e.code(), e.details(), full_name, i))
            else:
                raise
            error = e
        time.sleep(1)
    raise error


class PresetsService(object):
    def __init__(self, channel):
        self._stub = PresetsServiceStub(channel)
        self._pb = presets_pb2
    def store_preset(self, _message=None, _timeout=None, **kwargs):
        """Store preset data. Input can contain a (protobuf) preset object or a (json) string
        preset. Will store the preset in persistent storage and return a unique preset id

        

        Args:
            _message (minknow_api.ui.sequencing_run.presets_pb2.StorePresetRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            preset_string (str, optional): 
            preset_object (minknow_api.ui.sequencing_run.presets_pb2.Preset, optional): 
            preset_id (str, optional): 
            overwrite (bool, optional): 

        Returns:
            minknow_api.ui.sequencing_run.presets_pb2.StorePresetResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.store_preset,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.ui.sequencing_run.presets.PresetsService")

        unused_args = set(kwargs.keys())

        # check oneof group 'data'
        oneof_fields = set([
            "preset_string",
            "preset_object",
        ])

        if len(unused_args & oneof_fields) > 1:
            raise ArgumentError("store_preset given multiple conflicting arguments: '{}'".format(", ".join(unused_args & oneof_fields)))

        _message = StorePresetRequest()

        if "preset_string" in kwargs:
            unused_args.remove("preset_string")
            _message.preset_string = kwargs['preset_string']

        if "preset_object" in kwargs:
            unused_args.remove("preset_object")
            _message.preset_object.CopyFrom(kwargs['preset_object'])

        if "preset_id" in kwargs:
            unused_args.remove("preset_id")
            _message.preset_id = kwargs['preset_id']

        if "overwrite" in kwargs:
            unused_args.remove("overwrite")
            _message.overwrite = kwargs['overwrite']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to store_preset: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.store_preset,
                              _message, _timeout,
                              [],
                              "minknow_api.ui.sequencing_run.presets.PresetsService")
    def delete_preset(self, _message=None, _timeout=None, **kwargs):
        """Delete a stored preset (limited to user presets). The given preset id will have its
        corresponding preset records erased fromd disc

        

        Args:
            _message (minknow_api.ui.sequencing_run.presets_pb2.DeletePresetRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            preset_id (str, optional): 

        Returns:
            minknow_api.ui.sequencing_run.presets_pb2.DeletePresetResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.delete_preset,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.ui.sequencing_run.presets.PresetsService")

        unused_args = set(kwargs.keys())

        _message = DeletePresetRequest()

        if "preset_id" in kwargs:
            unused_args.remove("preset_id")
            _message.preset_id = kwargs['preset_id']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to delete_preset: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.delete_preset,
                              _message, _timeout,
                              [],
                              "minknow_api.ui.sequencing_run.presets.PresetsService")
    def get_preset(self, _message=None, _timeout=None, **kwargs):
        """Returns a preset.
        The input can reference a stored preset file via its preset id, or can provide a preset object with the purpose
        of converting the type of the preset into either a protobuf or string.
        The preset return type should be specified in the request.

        

        Args:
            _message (minknow_api.ui.sequencing_run.presets_pb2.GetPresetRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            preset_type (minknow_api.ui.sequencing_run.presets_pb2.PresetType, optional): 
            return_type (minknow_api.ui.sequencing_run.presets_pb2.GetPresetRequest.ReturnType, optional): 

        Returns:
            minknow_api.ui.sequencing_run.presets_pb2.GetPresetResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_preset,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.ui.sequencing_run.presets.PresetsService")

        unused_args = set(kwargs.keys())

        _message = GetPresetRequest()

        if "preset_type" in kwargs:
            unused_args.remove("preset_type")
            _message.preset_type.CopyFrom(kwargs['preset_type'])

        if "return_type" in kwargs:
            unused_args.remove("return_type")
            _message.return_type = kwargs['return_type']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_preset: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_preset,
                              _message, _timeout,
                              [],
                              "minknow_api.ui.sequencing_run.presets.PresetsService")
    def list_presets(self, _message=None, _timeout=None, **kwargs):
        """Lists all stored presets. Returns a valid subset of preset ids and meta data

        

        Args:
            _message (minknow_api.ui.sequencing_run.presets_pb2.ListPresetsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.ui.sequencing_run.presets_pb2.ListPresetsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.list_presets,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.ui.sequencing_run.presets.PresetsService")

        unused_args = set(kwargs.keys())

        _message = ListPresetsRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to list_presets: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.list_presets,
                              _message, _timeout,
                              [],
                              "minknow_api.ui.sequencing_run.presets.PresetsService")
    def check_preset(self, _message=None, _timeout=None, **kwargs):
        """Check if a preset is valid. Validity is determined by if the preset can be successfully serialised into a Preset object.
        If given a preset id, then validity requires the corresponding preset file to be present and for the preset file itself to be a valid.
        If provided a preset string, then validity is determined.
        Finally, if a preset object is provided, then it is assumed valid.

        Returns preset meta data if it is valid, otherwise returns INVALID_ARGUMENT.

        

        Args:
            _message (minknow_api.ui.sequencing_run.presets_pb2.CheckPresetRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            preset_type (minknow_api.ui.sequencing_run.presets_pb2.PresetType, optional): 

        Returns:
            minknow_api.ui.sequencing_run.presets_pb2.CheckPresetResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.check_preset,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.ui.sequencing_run.presets.PresetsService")

        unused_args = set(kwargs.keys())

        _message = CheckPresetRequest()

        if "preset_type" in kwargs:
            unused_args.remove("preset_type")
            _message.preset_type.CopyFrom(kwargs['preset_type'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to check_preset: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.check_preset,
                              _message, _timeout,
                              [],
                              "minknow_api.ui.sequencing_run.presets.PresetsService")
    def get_start_protocol(self, _message=None, _timeout=None, **kwargs):
        """Gets a start request. Given an preset id, object or string, returns a valid corresponding start request

        

        Args:
            _message (minknow_api.ui.sequencing_run.presets_pb2.GetStartProtocolRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            preset_type (minknow_api.ui.sequencing_run.presets_pb2.PresetType, optional): 

        Returns:
            minknow_api.ui.sequencing_run.presets_pb2.GetStartProtocolResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_start_protocol,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.ui.sequencing_run.presets.PresetsService")

        unused_args = set(kwargs.keys())

        _message = GetStartProtocolRequest()

        if "preset_type" in kwargs:
            unused_args.remove("preset_type")
            _message.preset_type.CopyFrom(kwargs['preset_type'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_start_protocol: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_start_protocol,
                              _message, _timeout,
                              [],
                              "minknow_api.ui.sequencing_run.presets.PresetsService")
